#ifndef TXTPRIV_H
#define TXTPRIV_H
//
//                     TxWin, Textmode Windowing Library
//
//   Original code Copyright (c) 1995-2021 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   TxLib, released under MIT License
//
//   Copyright (c) 1995-2021  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on TxWin licensing can be directed to: info@dfsee.com
//
// ==========================================================================
//
// TX text library private interfaces
//
// Author: J. van Wijk
//
// Developed for LPTool/DFSee utilities
//
// JvW  28-02-2021 LICENSING: Changed from LGPL to the more liberal MIT license
// JvW  19-08-2005 Initial version, cleanup public interfaces


//============ TXCON
                                                // Hook control structures
extern  TXH_INFO   *txh_clean;                  // clean TxPrint handler
extern  TXH_INFO   *txh_raw;                    // raw ansi TxPrint handler

//============ TXPARSE

typedef struct txa_element                      // command parser element
{
   ULONG               signature;               // signature value
   int                 optc;                    // number of options
   TXA_OPTION          opt[TXA_SIZE];           // array of options
   int                 argc;                    // number of arguments
   char               *argv[TXA_ARGC +1];       // array of argv pointers
   TXLN                comment;                 // stripped comment
   struct txa_element *prev;                    // prev element on stack
} TXA_ELEMENT;                                  // end of struct "txa_element"

extern TXA_ELEMENT  *txacur;                    // current, top of stack
extern TXA_ELEMENT  *txa1st;                    // first, bottom of stack


// Take handle value and convert to element, validate signature
TXA_ELEMENT *txaHandle2Element                  // RET   element ptr or NULL
(
   TXHANDLE            txh                      // IN    TXA handle
);

// Create new TXA element, and attach it to the TXA stack
ULONG TxaNewParseElement                        // RET   result
(
   TXA_ELEMENT       **element                  // OUT   TXA element
);


// Read one item (option or argument) and store it in the txa element
ULONG txaReadAndStoreItem                       // RET   result
(
   char               *item,                    // IN    item string
   int                 len,                     // IN    length of item
   BOOL                freeform,                // IN    free format options
   BOOL                passthrough,             // IN    keep parameter quotes
   TXA_ELEMENT        *txa                      // INOUT TXA element
);


// Copy item in string, honor embedded strings
char *txaCopyItem                               // RET   copied string
(
   char               *destin,                  // OUT   destination buffer
   char               *start,                   // IN    start position
   int                 length                   // IN    max length to copy
);


// Drop the command-arguments at the current level, but KEEP level and options
BOOL TxaDropArgumentsOnly                       // RET   more instances left
(
   void
);


//============ TXTRACE

#define TXTHREADS                 0x10          // Shown with unique thread
#define TXTHREADID (TXCURTHREAD & 0x0f)         // indentation in trace
extern  ULONG       TxTrIndent[];               // trace indent per thread
extern  BOOL        TxTrTstamp;                 // timestamp in trace ?


//============ TXCRITE
extern ULONG        TxAutoFail;                 // AutoFail active flag
                                                // call to succeeed

#endif
