/*
distorm.c

:[diStorm64}: C Library Interface
The ultimate disassembler library (80x86, AMD64)
Copyright (C) 2003-2007 Gil Dabah, http://ragestorm.net/distorm/
This library is licensed under the BSD license. See the file COPYING.
*/


// 20180720 JvW Include TxLib to allow tracing
#include <txlib.h>

#include "decoder.h"
#include "x86defs.h"

/* C LIBRARY EXPORTS */
_DLLEXPORT_ _DecodeResult distorm_decode
(
   _OffsetType          codeOffset,             // IN    offset value for address display
   const unsigned char *code,                   // IN    BYTE array with code
   int                  codeLen,                // IN    length of code array
   _DecodeType          dt,                     // IN    bitness 16/32/64
   _DecodedInst         result[],               // OUT   array of disassembled instructions
   unsigned int         maxInstructions,        // IN    size of instruction array
   unsigned int        *usedInstructionsCount   // OUT   nr of instructions in array
)
{
   _DecodeResult       rc;

   ENTER();
   TRACES(("codeOffset: 0x%16.16llx  codeLen:%4d  maxResultCount:%4u\n", codeOffset, codeLen, maxInstructions));

   *usedInstructionsCount = 0;

   /* I use codeLen as a signed variable in order to ease detection of underflow... and besides - */
   if (codeLen < 0)
   {
      rc = DECRES_INPUTERR;
   }
   else if ((dt != Decode16Bits) && (dt != Decode32Bits) && (dt != Decode64Bits))
   {
      rc = DECRES_INPUTERR;
   }
   else if (code == NULL || result == NULL)
   {
      rc = DECRES_INPUTERR;
   }
   else if (codeLen == 0)
   {
      rc = DECRES_SUCCESS;
   }
   else if (maxInstructions < INST_MAXIMUM_SIZE)
   {
      //- We need to supply at least 15 entries so the internal_decoder could return anything possible.
      rc = DECRES_MEMORYERR;
   }
   else
   {
      rc = internal_decode(codeOffset, code, codeLen, dt, result, maxInstructions, usedInstructionsCount);
   }
   TRACES(("usedInstructionCount:%4u\n", *usedInstructionsCount));
   RETURN (rc);
}

