//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// XFS disk structure definitions
// Based on information from "Unix filesystems" by Steve D Pate
// other Internet info, and a lot of reverse-engineering with DFSee
//
// Author: J. van Wijk
//
// JvW  08-07-2019 Added SB fields and flag-values from structure-PDF
// JvW  04-03-2018 Update for LABEL and UUID edit, info from xfs.org
// JvW  15-07-2007 Initial version, derived from RSR
//
#ifndef    DFSXFS_H
   #define DFSXFS_H

// NOTE: ALL values ON-DISK are using BIG-ENDIAN format (comes from MIPS originally)
//       So values need to be byte-swapped on read and write  (see HFS for examples)

#define XFS_LSNSUP1        ((ULN64)  0x00)      // first superblock


#define XFS_SB_VERSION_1                1       // 5.3, 6.0.1, 6.1
#define XFS_SB_VERSION_2                2       // 6.2 - attributes
#define XFS_SB_VERSION_3                3       // 6.2 - new inode version
#define XFS_SB_VERSION_4                4       // 6.2+ - bitmask version
#define XFS_SB_VERSION_NUMBITS          0x000f
#define XFS_SB_VERSION_ALLFBITS         0xfff0
#define XFS_SB_VERSION_SASHFBITS        0xf000
#define XFS_SB_VERSION_REALFBITS        0x0ff0
#define XFS_SB_VERSION_ATTRBIT          0x0010
#define XFS_SB_VERSION_NLINKBIT         0x0020
#define XFS_SB_VERSION_QUOTABIT         0x0040
#define XFS_SB_VERSION_ALIGNBIT         0x0080
#define XFS_SB_VERSION_DALIGNBIT        0x0100
#define XFS_SB_VERSION_SHAREDBIT        0x0200
#define XFS_SB_VERSION_LOGV2BIT         0x0400
#define XFS_SB_VERSION_SECTORBIT        0x0800
#define XFS_SB_VERSION_EXTFLGBIT        0x1000
#define XFS_SB_VERSION_DIRV2BIT         0x2000
#define XFS_SB_VERSION_BORGBIT          0x4000  // ASCII only case-insens.
#define XFS_SB_VERSION_MOREBITSBIT      0x8000
#define XFS_SB_VERSION_OKSASHFBITS   \
       (XFS_SB_VERSION_EXTFLGBIT   | \
        XFS_SB_VERSION_DIRV2BIT    | \
        XFS_SB_VERSION_BORGBIT)
#define XFS_SB_VERSION_OKREALFBITS   \
       (XFS_SB_VERSION_ATTRBIT     | \
        XFS_SB_VERSION_NLINKBIT    | \
        XFS_SB_VERSION_QUOTABIT    | \
        XFS_SB_VERSION_ALIGNBIT    | \
        XFS_SB_VERSION_DALIGNBIT   | \
        XFS_SB_VERSION_SHAREDBIT   | \
        XFS_SB_VERSION_LOGV2BIT    | \
        XFS_SB_VERSION_SECTORBIT   | \
        XFS_SB_VERSION_MOREBITSBIT)
#define XFS_SB_VERSION_OKREALBITS    \
       (XFS_SB_VERSION_NUMBITS     | \
        XFS_SB_VERSION_OKREALFBITS | \
        XFS_SB_VERSION_OKSASHFBITS)

#define XFS_SB_VERSION2_REALFBITS       0x00ffffff      // Mask: features
#define XFS_SB_VERSION2_RESERVED1BIT    0x00000001
#define XFS_SB_VERSION2_LAZYSBCOUNTBIT  0x00000002      // Superblk counters
#define XFS_SB_VERSION2_RESERVED4BIT    0x00000004
#define XFS_SB_VERSION2_ATTR2BIT        0x00000008      // Inline attr rework
#define XFS_SB_VERSION2_PARENTBIT       0x00000010      // parent pointers


#define XFS_SB_VERSION2_OKREALFBITS      \
       (XFS_SB_VERSION2_LAZYSBCOUNTBIT | \
        XFS_SB_VERSION2_ATTR2BIT)
#define XFS_SB_VERSION2_OKSASHFBITS (0)
#define XFS_SB_VERSION2_OKREALBITS       \
       (XFS_SB_VERSION2_OKREALFBITS    | \
        XFS_SB_VERSION2_OKSASHFBITS )


#define SG_XFSSUP  4                            // "XFSB"          note: BIG ENDIAN!
#define SV_XFSSUP  (char)0x58,(char)0x46,(char)0x53,(char)0x42

#define                XFS_LEN_LBL      12

typedef struct s_xfs_super
{
   BYTE                Signature[4];            // 000 fs identification string
   ULONG               BlockSize;               // 004 blocksize in bytes typical 4096
   ULN64               DtotalBlocks;            // 008 total Data+Metadata blocks
   ULN64               RtReservedBlocks;        // 010 reserved 'realtime' blocks
   ULN64               RtExtentCount;           // 018 reserved 'realtime' extents
   BYTE                Uuid[16];                // 020 128-bit uuid (4-2-2-2-6) 0x20
   ULN64               LogStartBlock;           // 030 start of (internal) log
   ULN64               RootInode;               // 038 Inode number for Root, typ 128
   ULN64               RtBmInode;               // 040 RealTime extents bitmap  Inode
   ULN64               RtSmInode;               // 048 RealTime extents summary Inode
   ULONG               RtExtSize;               // 050 Realtime extents size in blocks
   ULONG               BlocksPerGroup;          // 054 Size AllocationGroups in blocks
   ULONG               NumberOfGroups;          // 058 Size AllocationGroups in blocks
   ULONG               RtBmBlocks;              // 05C RealTime extents bitmap  blocks
   ULONG               LogBlocks;               // 060 Size internal log in blocks
   USHORT              FsVersionFlags;          // 064 Filesystem version / features
   USHORT              SectorSize;              // 066 Sectorsize in bytes
   USHORT              InodeSize;               // 068 Inode size in bytes
   USHORT              InodesPerBlock;          // 06A Inodes per block
   char                VolumeName[XFS_LEN_LBL]; // 06C Name of the filesystem (LABEL)
   BYTE                bitsBlockSize;           // 078 log2 values for several sizes
   BYTE                bitsSectorSize;          // 079 like '9' bits for 512 bytes
   BYTE                bitsInodeSize;           // 07A
   BYTE                bitsInodesPerBlock;      // 07B
   BYTE                bitsBlocksPerGroup;      // 07C rounded UP
   BYTE                bitsRtExtentCount;       // 07D
   BYTE                FsBeingCreatedFlag;      // 07E Flag set while FS is created
   BYTE                FsInodePercentage;       // 07F Max FS percentage used for inodes
   ULN64               InodesAllocated;         // 080 Number of Inodes allocated
   ULN64               InodesFree;              // 088 Number of Inodes still free
   ULN64               DataBlocksFree;          // 090 Number of blocks still free
   ULN64               RtExtentsFree;           // 098 Realtime extents still free
   ULN64               UsrQuotaInode;           // 0A0 User  quotas Inode
   ULN64               GrpQuotaInode;           // 0A8 Group quotas Inode
   USHORT              QuotaFlags;              // 0B0 Quota flags
   BYTE                MiscFlags;               // 0B2 Miscellanious flags
   BYTE                SharedVN;                // 0B3 Shared Version Nr (reserved, 0)
   ULONG               InoAlignment;            // 0B4 Inode chunk alignment in blocks
   ULONG               RaidUnitBlocks;          // 0B8 Raid Unit  size in blocks
   ULONG               RaidWidthBlocks;         // 0BC Raid Width size in blocks
   BYTE                DirBlckLogSize;          // 0C0 Log-2 FS-blocks per dirBlock
   BYTE                LogSectLogSize;          // 0C1 Log-2 sectorsize log     (external)
   USHORT              LogSectSize;             // 0C2 Sectorsize log, in bytes (external)
   ULONG               LogRaidUnit;             // 0C4 log device raid unit size in blocks
   ULONG               Features2;               // 0C8 Extend VersionFlags if MOREBITSSET
   ULONG               BadFeatures2;            // 0CC Copy (kept in sync for kernel bug)

   BYTE                Filler[0x130];           // 0D0 remainder to be refined
} S_XFS_SUPER;


#endif
