//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee major functions: wiping
//
// Author: J. van Wijk
//
// JvW  27-07-2006   Initial version, split off from DFSMAJOR.H
//
#ifndef    DFSWIPE
   #define DFSWIPE


// High level WIPE command logic
ULONG dfsWipeCommand
(
   int                 cc,                      // IN    number of parameters
   char               *c1,                      // IN    parameter string 1
   char               *c2,                      // IN    parameter string 2
   char               *c3                       // IN    parameter string 3
);

// Wipe sectors with pattern using (delete) sectornumbers in the SN-table
ULONG dfsDelWipeList
(
   ULN64              *list,                    // IN    count + list of sn's
   BYTE               *pattern,                 // IN    pattern buffer
   USHORT              patsize,                 // IN    pattern size
   char               *select                   // IN    select wildcard or !
);

// Wipe (file/fnode) sector(s)s with specified pattern
ULONG dfsDelWipeSingle
(
   ULN64               fn,                      // IN    LSN
   BYTE               *pattern,                 // IN    pattern buffer
   USHORT              patsize,                 // IN    pattern size
   char               *accept                   // IN    select wildcard or !
);


// DFS write sectors to volume/partition using a fixed pattern (wipe)
ULONG dfsWipeArea
(
   ULN64               fn,                      // IN    start LSN
   ULN64               size,                    // IN    nr of sectors to write
   ULONG               progress,                // IN    progress options
   char               *reason,                  // IN    reason text for progress
   BOOL                verify,                  // IN    read-verify 1st sector
   BYTE               *pattern,                 // IN    pattern buffer
   USHORT              patsize                  // IN    pattern size
);


// DFS wipe area for FREESPACE only using a fixed pattern (wipefree)
ULONG dfsWipeFree
(
   ULN64               fn,                      // IN    start LSN
   ULN64               size,                    // IN    nr of sectors to write
   ULONG               progress,                // IN    display progress
   BYTE               *pattern,                 // IN    pattern buffer
   USHORT              patsize                  // IN    pattern size
);

#endif
