//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee windowed user interface
//
// Author: J. van Wijk
//
// 1.00 22-06-1999    Initial version
//
#ifndef    DFSWIN
   #define DFSWIN

#define DFSH_GENERIC  2000
#define DFSH_CONFIRM  5000
#define DFSH_FDISK    6000
#define DFSH_BROWSE   1000

//- help ID's for the generic helpfile 'dfsmain.hlp'
#define DFS_H_APPLIC   (DFSH_GENERIC + 300)    // help ID DFSee application
#define DFS_H_M_MENU   (DFSH_GENERIC + 310)    // help ID DFSee main menu
#define DFS_H_INTERF   (DFSH_GENERIC + 320)    // help ID DFSee interface
#define DFS_H_OUTWIN   (DFSH_GENERIC + 330)    // help ID DFSee output window
#define DFS_H_HEXED    (DFSH_GENERIC + 350)    // help ID DFSee hex-editor
#define DFS_H_DISASM   (DFSH_GENERIC + 355)    // help ID DFSee disasm plugin
#define DFS_H_TXVIEW   (DFSH_GENERIC + 360)    // help ID DFSee textview plugin
#define DFS_H_REGIST   (DFSH_GENERIC + 900)    // help ID DFSee registration

//- enable/disable dialog Widgets (make them visible/invisible)
#define dfsdShowWg(wg,cond)               \
        if (cond)                         \
        {                                 \
           wg.flags &= ~TXWI_DISABLED;    \
        }                                 \
        else                              \
        {                                 \
           wg.flags |=  TXWI_DISABLED;    \
        }



//- menu (equal to help) and accelerator codes
#define DFSH_MENUS     3000                     // menu help base
#define DFSM_MENUBAR   3010
#define DFSM_DEFAULT   3030                     // default menu, auto drop-down when set
#define DFSM_AUTODELAY 3040                     // default menu, but delayed auto drop-down

#define DFSM_FILE      3100
#define DFSC_BATCH     3101
#define DFSC_RDONLY    3102
#define DFSC_GEOCALC   3103
#define DFSC_GPTAUTO   3104
#define DFSC_LVMSYNC   3105
#define DFSC_IGNERR    3106
#define DFSC_VOLFLOP   3107
#define DFSC_PTYPE0    3108
#define DFSC_SHOWHID   3109
#define DFSC_FHIDDEN   3110
#define DFSC_LOGAUTO   3111
#define DFSC_LOGDATE   3112
#define DFSC_RMBMENU   3113
#define DFSC_LOGF      3114
#define DFSC_CYTRACE   3115
#define DFSC_QUERY     3116
#define DFSC_OPENOW    3118
#define DFSC_ODISK     3120
#define DFSC_OPART     3130
#define DFSC_VPART     3132
#define DFSC_OFPRI     3135
#define DFSC_OFLOG     3136
#define DFSC_OVOLM     3140
#define DFSC_VVOLM     3142
#define DFSC_OIMAG     3145
#define DFSC_VDIBRS    3150
#define DFSC_IMZBRS    3151
#define DFSC_MEDIAM    3152
#define DFSC_MEJECT    3154
#define DFSC_MREFRSH   3156
#define DFSC_UMEDIA    3159
#define DFSC_ATTACH    3160
#define DFSC_VIRT      3161
#define DFSC_VPDX      3162
#define DFSC_PHYS      3163
#define DFSC_IRAW      3164
#define DFSC_ICMP      3165
#define DFSC_IVDI      3166
#define DFSC_DETACH    3167
#define DFSC_DEVVOL    3170
#define DFSC_OSVOLS    3171
#define DFSC_DEVINF    3172
#define DFSC_SIPSTA    3173
#define DFSC_UMTVOL    3174
#define DFSC_MNTVOL    3175
#define DFSC_RUNS      3180
#define DFSC_CURDIR    3183
#define DFSC_SAVE      3185
#define DFSC_BMGR      3190
#define DFSC_BOOT      3192
#define DFSC_EXIT      3199

#define DFSM_EDIT      3200
#define DFSC_PTEDIT    3210
#define DFSC_LVMDLG    3220
#define DFSC_SHFILE    3222
#define DFSC_SHEXED    3223
#define DFSC_HEXASC    3224
#define DFSC_DISASM    3225
#define DFSC_TXTSTR    3226
#define DFSC_HEX16B    3227
#define DFSC_STREDT    3228
#define DFSC_SECHEX    3230
#define DFSC_SECASC    3231
#define DFSC_SECUNI    3232
#define DFSC_SEARCH    3235
#define DFSC_SBSRCH    3236
#define DFSC_SBGREP    3237
#define DFSC_SBEXEC    3238
#define DFSC_BMINST    3240
#define DFSC_BMCONF    3242
#define DFSC_BMDEFL    3244
#define DFSC_BMTIME    3245
#define DFSC_FIND00    3246
#define DFSC_FINDFE    3247
#define DFSC_FINDTC    3248
#define DFSC_FINDAG    3249
#define DFSC_FSMODE    3250
#define DFSC_FSFDISK   3251
#define DFSC_FSHPFS    3252
#define DFSC_FSNTFS    3253
#define DFSC_FSFAT     3254
#define DFSC_FSJFS     3255
#define DFSC_FSEXT     3256
#define DFSC_FSRSR     3257
#define DFSC_FSXFS     3258
#define DFSC_FSHFS     3259
#define DFSC_FSSWAP    3260
#define DFSC_FSAUX     3261
#define DFSC_FSDUMP    3262
#define DFSC_FSEXFT    3263
#define DFSC_FSAPFS    3264
#define DFSC_FSISO     3265
#define DFSC_EDITUID   3267
#define DFSC_FWIPEZ0   3270
#define DFSC_DWIPEZ0   3272
#define DFSC_EXPERT    3278
#define DFSC_SETPROP   3279
#define DFSC_UISPROP   3280
#define DFSC_INVSCR    3281
#define DFSC_BRTSCR    3282
#define DFSC_B2BSCR    3283
#define DFSC_ASCII7    3284
#define DFSC_COLTXT    3285
#define DFSC_PROMPT    3286
#define DFSC_AUTODR    3287
#define DFSC_DELAYDR   3288
#define DFSC_RIGHTMV   3289
#define DFSC_SIZWIN    3290
#define DFSC_NONWIN    3291
#define DFSC_SCHEME    3292
#define DFSC_PALET     3293
#define DFSC_XSCLIP    3295
#define DFSC_UICTEST   3296
#define DFSC_UICYCLE   3297
#define DFSC_UIKEYBT   3298

#define DFSM_ACTI      3300
#define DFSC_CLONING   3310
#define DFSC_CLONDLG   3311
#define DFSC_MOVECOP   3312
#define DFSC_RESIZIN   3320
#define DFSC_RESIZET   3321
#define DFSC_REXPAND   3322
#define DFSC_RESIMAX   3323
#define DFSC_MOVE2E    3325
#define DFSC_MOVE2B    3326
#define DFSC_MOVE2F    3327
#define DFSC_COPY2F    3328
#define DFSC_SCAN_RO   3331
#define DFSC_SCAN_RW   3332
#define DFSC_DFSFAST   3333
#define DFSC_FASTDLG   3334
#define DFSC_DFSDISK   3335
#define DFSC_DISKDLG   3336
#define DFSC_CHKPART   3337
#define DFSC_CLDDBAD   3339
#define DFSC_CLDDISK   3340
#define DFSC_CLPPART   3341
#define DFSC_CLVVOLD   3342
#define DFSC_CLCDISK   3345
#define DFSC_CLCPART   3346
#define DFSC_CLCVOLD   3347

#define DFSM_IMAG      3349
#define DFSC_IMAGING   3350
#define DFSC_IMAGDLG   3351
#define DFSC_SIMPART   3356
#define DFSC_SIMDISK   3357
#define DFSC_SIMVOL    3358
#define DFSC_SIMCUR    3359
#define DFSC_RAW2IMZ   3361
#define DFSC_IMZ2RAW   3362
#define DFSC_WRIMAGE   3364
#define DFSC_WRIMDLG   3365
#define DFSC_WRIPART   3366
#define DFSC_WRIDISK   3367
#define DFSC_WRIVOL    3368
#define DFSC_WRICUR    3369
#define DFSC_IMZINF    3371
#define DFSC_VERIFIM   3372
#define DFSC_MF32ST    3373
#define DFSC_MF16ST    3374
#define DFSC_MIFSTD    3375
#define DFSC_MJFS35    3376
#define DFSC_MPUP64    3377
#define DFSC_MPUP32    3378
#define DFSC_MPUPPY    3379
#define DFSC_MUSB32    3389
#define DFSC_WIPING    3390
#define DFSC_WIPETHS   3391
#define DFSC_WIPEZER   3392
#define DFSC_WIPESEC   3393
#define DFSC_ZERFREE   3394
#define DFSC_WIPEFSP   3395
#define DFSC_SECFREE   3396

#define DFSM_DISP      3500
#define DFSC_DISKLST   3503
#define DFSC_DISKMAP   3505
#define DFSC_PMEDMAP   3507
#define DFSC_ALLOCMP   3510
#define DFSC_GEOSTAT   3515
#define DFSC_VOLUMES   3520
#define DFSC_PARTSTD   3530
#define DFSC_PARTALT   3535
#define DFSC_PARTSUB   3536
#define DFSC_PARTWRN   3538
#define DFSC_PARTWNT   3539
#define DFSC_PARTEXT   3541
#define DFSC_PARTNUM   3542
#define DFSC_PARTNEX   3543
#define DFSC_PARTVER   3544
#define DFSC_PARTALL   3545
#define DFSC_PARTCHK   3546
#define DFSC_PARTSEC   3547
#define DFSC_PARTCSP   3549
#define DFSC_LVMINFO   3550
#define DFSC_BASEVAL   3551
#define DFSC_STOREVW   3552
#define DFSC_WALKRAW   3555
#define DFSC_SECPART   3557
#define DFSC_EBRPART   3558
#define DFSC_DISPLSN   3560
#define DFSC_DISPSEC   3565
#define DFSC_NEXTDEF   3570
#define DFSC_UPSNDEF   3572
#define DFSC_XTRADEF   3574
#define DFSC_THISDEF   3580
#define DFSC_THISPLS   3582
#define DFSC_THISMIN   3584
#define DFSC_THISHEX   3590
#define DFSC_THISASC   3595
#define DFSC_IOSPEED   3597
#define DFSC_IOSPRWR   3598
#define DFSC_IOSPLBF   3599

#define DFSM_HELP      3940
#define DFSC_UPDATE    3945
#define DFSC_DPUP64    3950
#define DFSC_DPUP32    3951
#define DFSC_DPUPPY    3953
#define DFSC_INSTAL    3955
#define DFSC_DSTABL    3957
#define DFSC_DEXPER    3958
#define DFSC_PREGREP   3960
#define DFSC_H_KEYBD   3961
#define DFSC_H_MOUSE   3962
#define DFSC_H_CLIPB   3963
#define DFSC_H_MENUS   3964
#define DFSC_HSCRIPT   3970
#define DFSC_HS_RUNU   3972
#define DFSC_HSYNTAX   3973
#define DFSC_HS_VARS   3975
#define DFSC_CMDLINE   3979
#define DFSC_OPTHELP   3980
#define DFSC_CMDHELP   3981
#define DFSC_FS_HELP   3982
#define DFSC_ST_MODE   3983
#define DFSC_SW_HELP   3984
#define DFSC_UIHELP    3985
#define DFSC_PT_HELP   3992
#define DFSC_TXCHELP   3993
#define DFSC_TXSHELP   3994
#define DFSC_H_LOAD    3996
#define DFSC_H_SECTS   3997
#define DFSC_H_GREP    3998
#define DFSC_ABOUT     3999

//- Submenus
#define DFSC_BSMENU    3800
#define DFSC_BSFIND    3801
#define DFSC_BSHPFSO   3802
#define DFSC_BSHPFSC   3803
#define DFSC_BSJFSO    3804
#define DFSC_BSJFSC    3805
#define DFSC_BSEXTO    3806
#define DFSC_BSEXTC    3807
#define DFSC_BSRSRO    3808
#define DFSC_BSRSRC    3809
#define DFSC_BSNTFSO   3810
#define DFSC_BSNTFSC   3811
#define DFSC_BSHFSO    3812
#define DFSC_BSHFSC    3813
#define DFSC_BSXFSO    3814
#define DFSC_BSXFSC    3815
#define DFSC_BSALLO    3816
#define DFSC_BSALLC    3817
#define DFSC_BSMENUS   3818
#define DFSC_BSMENUA   3819


#define DFSC_LVMBMGR   3820
#define DFSC_LVMBBR    3821
#define DFSC_LVMVCU    3822
#define DFSC_LVMRED    3823
#define DFSC_LVMPCL    3824
#define DFSC_LVMDNM    3825
#define DFSC_LVMRMV    3826
#define DFSC_LVMDEF    3827
#define DFSC_BMMENU    3828
#define DFSC_BMDELM    3829
#define DFSC_LVMGEO    3830

#define DFSC_FCHAIN    3831
#define DFSC_FIXEXT    3832
#define DFSC_FIXEXF    3833
#define DFSC_CLEANUP   3834
#define DFSC_ALIGND    3835
#define DFSC_ALIGNL    3836
#define DFSC_MBRUPD    3837
#define DFSC_PTCLNR    3838
#define DFSC_GPTFIX    3839
#define DFSC_GPT2MBR   3840
#define DFSC_MBR2GPT   3841

#define DFSC_FORMAT    3845
#define DFSC_FMTFAT    3846
#define DFSC_FMTOBJ    3847
#define DFSC_FMTLDR    3848

#define DFSC_JFIXBOS   3850
#define DFSC_JFIXBOB   3851
#define DFSC_IJFLDR    3853
#define DFSC_RJFLDR    3854
#define DFSC_JRECOV    3858
#define DFSC_JFINDD    3859
#define DFSC_JFINDF    3860
#define DFSC_JFINDA    3861
#define DFSC_JFIRSF    3865
#define DFSC_JFSIRS    3866
#define DFSC_JMAGIC    3867
#define DFSC_JDINOS    3868
#define DFSC_JSYSDMP   3869

#define DFSC_JDINOR    3870
#define DFSC_INONR1    3871
#define DFSC_INONR2    3872
#define DFSC_INONR3    3873
#define DFSC_INON59    3874
#define DFSC_INON5A    3876
#define DFSC_INON5C    3877
#define DFSC_INON68    3878
#define DFSC_JIAGRP    3879

#define DFSC_SECLIST   3880
#define DFSC_EXPLIST   3881
#define DFSC_IMPLIST   3882
#define DFSC_LVALUES   3883
#define DFSC_COMPACT   3884
#define DFSC_VERBOSE   3885
#define DFSC_LISTIDS   3887
#define DFSC_WIPELST   3888
#define DFSC_RECOVER   3889
#define DFSC_LISTFSC   3891
#define DFSC_LISTFSV   3892
#define DFSC_SLT2LST   3893
#define DFSC_CLRLIST   3894
#define DFSC_FSAVETO   3895


#define DFSC_NDMFTC    3898
#define DFSC_NDMFTR    3899
#define DFSC_MFTNR0    3900
#define DFSC_MFTNR1    3901
#define DFSC_MFTNR2    3902
#define DFSC_MFTNR3    3903
#define DFSC_MFTNR4    3904
#define DFSC_MFTNR5    3905
#define DFSC_MFTNR6    3906
#define DFSC_MFTNR7    3907
#define DFSC_MFTNR8    3908
#define DFSC_MFTNR9    3909
#define DFSC_MFTNRA    3910
#define DFSC_MFTNRB    3911
#define DFSC_NMFTDMP   3920

#define DFSC_FNDPATH   3930
#define DFSC_HEDPATH1  3931
#define DFSC_HEDPATH2  3932

#define DFSM_MODE      3400

//- FDISK specific menu
#define DFSC_MAPVMM    3401
#define DFSC_CREATE    3402
#define DFSC_GEODLG    3403
#define DFSC_SETPRT    3404
#define DFSC_SAVEPD    3405
#define DFSC_RESTPD    3406
#define DFSC_GENPDLG   3407
#define DFSC_DELTHIS   3408
#define DFSC_ACTIVE    3409
#define DFSC_NOTACT    3410
#define DFSC_ACTHIS    3411
#define DFSC_P_HIDE    3412
#define DFSC_UNHIDE    3413
#define DFSC_MULTIV    3414
#define DFSC_DELETE    3415
#define DFSC_CHTYPE    3416
#define DFSC_FIXCHS    3417
#define DFSC_NEWMBC    3418
#define DFSC_LVMCLN    3419
#define DFSC_NEWMBR    3420
#define DFSC_NEWMBI    3421
#define DFSC_SAVMBR    3422
#define DFSC_NTSIGN    3423
#define DFSC_WIPEST    3424
#define DFSC_WIPET1    3425
#define DFSC_WEBRT1    3426
#define DFSC_W2KBMG    3427

#define DFSC_FRECONE   3428
#define DFSC_XSETVS    3429
#define DFSC_XFIXHS    3430
#define DFSC_SUPERB    3431
#define DFSC_DUMPFSB   3432
#define DFSC_BOOTIND   3433
#define DFSC_BOOTINF   3434

#define DFSC_LVMCRC    3437

//- HPFS specific menu
#define DFSC_HVOLUM    3438
#define DFSC_HVLABEL   3439
#define DFSC_HRECOV    3440
#define DFSC_HFINDD    3441
#define DFSC_HFINDF    3442
#define DFSC_HFINDA    3443
#define DFSC_HSYSTF    3444
#define DFSC_HFINDR    3445
#define DFSC_HFINDC    3446
#define DFSC_HSYSDMP   3447
#define DFSC_HFIXBO    3448
#define DFSC_HFIXBI    3449
#define DFSC_HFIXSU    3450
#define DFSC_HFIXSP    3451
#define DFSC_HCLEAN    3452
#define DFSC_HDIRTY    3453
#define DFSC_HBOOTF    3454
#define DFSC_IHPLDR    3455
#define DFSC_RHPLDR    3456

//- NTFS specific menu
#define DFSC_NVOLUM    3458
#define DFSC_NVLABEL   3459
#define DFSC_NRECOV    3460
#define DFSC_NFINDD    3461
#define DFSC_NFINDF    3462
#define DFSC_NFINDA    3463
#define DFSC_NFINDR    3464
#define DFSC_NFIXBOV   3465
#define DFSC_NTLDRF    3466
#define DFSC_NTLDRV    3467
#define DFSC_NCLEAN    3468
#define DFSC_NDIRTY    3469
#define DFSC_NBOOTF    3470
#define DFSC_INTLDR    3471
#define DFSC_RNTLDR    3472
#define DFSC_NFIXBOS   3473
#define DFSC_NFIXBOX   3474
#define DFSC_NFNDMFT   3475
#define DFSC_NOBADS    3476

//- FAT specific menu
#define DFSC_FBOOTF    3477
#define DFSC_FVOLUM    3478
#define DFSC_FVLABEL   3479
#define DFSC_FRECOV    3480
#define DFSC_FFINDS    3481
#define DFSC_FFSUBS    3482
#define DFSC_FFSUBD    3483
#define DFSC_FFINDD    3484
#define DFSC_FFINDF    3485
#define DFSC_FFINDR    3486
#define DFSC_FFIXBO    3487
#define DFSC_FCLEAN    3488
#define DFSC_FDIRTY    3489

//- JFS specific menu
#define DFSC_JFIXBO    3490
#define DFSC_JVOLUM    3491
#define DFSC_JVLABEL   3492
#define DFSC_JVLILAB   3493
#define DFSC_JSBSIG    3494
#define DFSC_JCLEAN    3495
#define DFSC_JDIRTY    3496
#define DFSC_JMOUNT    3497
#define DFSC_JSBVER    3498
#define DFSC_UXUUID    3499

//- Range 4000 .. 4999 intended for new filesystems and new main-menu catagories
//- Note: HELP items must be numbered 1xxx instead of 0xxx (aka NNNN - 3000)!

//- Generic filesystem functions
#define DFSC_XSLTAB    4430
#define DFSC_FBROWSE   4431
#define DFSC_XBROWSE   4432
#define DFSC_LBROWSE   4433
#define DFSC_UBROWSE   4434
#define DFSC_XCHECK    4435
#define DFSC_XDISLT    4436
#define DFSC_XIDSLT    4437
#define DFSC_XIDLST    4438
#define DFSC_XRDISK    4439


//- EFAT specific menu (copy of FAT, moved up 1000)
#define DFSC_YBOOTF    4477
#define DFSC_YVOLUM    4478
#define DFSC_YVLABEL   4479
#define DFSC_YRECOV    4480
#define DFSC_YFINDS    4481
#define DFSC_YFSUBS    4482
#define DFSC_YFSUBD    4483
#define DFSC_YFINDD    4484
#define DFSC_YFINDF    4485
#define DFSC_YFINDR    4486
#define DFSC_YFIXBO    4487
#define DFSC_YCLEAN    4488
#define DFSC_YDIRTY    4489
#define DFSC_YCRCBO    4497


//- EXTn specific menu
#define DFSC_ERECOV    4505
#define DFSC_EFINDF    4507
#define DFSC_EALOCBG   4510
#define DFSC_EBACKUP   4515
#define DFSC_EBLKGRP   4520
#define DFSC_EDINOR    DFSC_JDINOR              // share the same Help-item
#define DFSC_EDINOS    4530
#define DFSC_EDINO1    4531
#define DFSC_EDINO2    4532
#define DFSC_EDINO3    4533
#define DFSC_EVOLUM    4535
#define DFSC_EVLABEL   4536

//- Reiser specific menu
#define DFSC_RRECOV    4540
#define DFSC_RVOLUM    4541
#define DFSC_RVLABEL   4542

//- XFS specific menu
#define DFSC_XRECOV    4560
#define DFSC_XVOLUM    4561
#define DFSC_XVLABEL   4562

//- BTRFS specific menu
#define DFSC_BRECOV    4580
#define DFSC_BVOLUM    4581
#define DFSC_BVLABEL   4582

//- HFS specific menu
#define DFSC_MRECOV    4600
#define DFSC_MVOLUM    4601
#define DFSC_MVLABEL   4602
#define DFSC_MHLINKS   4605
#define DFSC_MFALIAS   4606
#define DFSC_MCATIN    4608
#define DFSC_MFLDNR    4609
#define DFSC_MFLDR0    4610
#define DFSC_MFLDR1    4611
#define DFSC_MFLDR2    4612
#define DFSC_MCATNR    4615
#define DFSC_MCATN0    4616
#define DFSC_MCATNT    4617
#define DFSC_MCATNL    4618
#define DFSC_MCATNV    4619

//- APFS specific menu
#define DFSC_ARECOV    4620
#define DFSC_AVOLUM    4621
#define DFSC_AVLABEL   4622
#define DFSC_APFSVI    4623
#define DFSC_APFSCP    4624
#define DFSC_APFSTP    4625
#define DFSC_APFSDM    4626
#define DFSC_APFSTR    4627
#define DFSC_APFSIN    4628
#define DFSC_APFSDR    4629
#define DFSC_APFSSP    4630

//- ISO specific menu
#define DFSC_ISOVDI    4640


//- base command values for disk/part/volume/freespace selection lists
//- Note: disks need distance 24, volume 26  (will use   30)
//-       parts/freespace need distance 255  (will use 1000)
//-

//- disk/volume ranges
#define DFSB_ODISK     5000
#define DFSB_DFSFAST   5030
#define DFSB_DFSDISK   5060
#define DFSB_FIXCHS    5090
#define DFSB_FIXEXT    5120
#define DFSB_FIXEXF    5150
#define DFSB_NEWMBC    5180
#define DFSB_NEWMBR    5210
#define DFSB_NEWMBI    5240
#define DFSB_SAVMBR    5270
#define DFSB_NTSIGN    5300
#define DFSB_WIPEST    5330
#define DFSB_WALKRAW   5360
#define DFSB_W2KBMG    5390
#define DFSB_LVMVCU    5420
#define DFSB_LVMRED    5450
#define DFSB_LVMPCL    5480
#define DFSB_LVMDNM    5510
#define DFSB_LVMGEO    5540
#define DFSB_SAVEPD    5570
#define DFSB_DETACH    5600
#define DFSB_MEJECT    5630
#define DFSB_CLEANUP   5660
#define DFSB_WIPET1    5690
#define DFSB_MUSB32    5720
#define DFSB_MF32ST    5750
#define DFSB_MF16ST    5780
#define DFSB_MIFSTD    5810
#define DFSB_MJFS35    5840
#define DFSB_ALIGND    5870
#define DFSB_LVMCLN    5900
#define DFSB_LVMBBR    5930
#define DFSB_LVMCRC    5960
#define DFSB_MPUP64    5990
#define DFSB_MPUP32    6020
#define DFSB_MPUPPY    6050
#define DFSB_UMTVOL    6080
#define DFSB_MNTVOL    6110
#define DFSB_RESTPD    6140
#define DFSB_GENPDLG   6170

//- allow enough space here for color schemes (8) and max palette (256)
#define DFSB_PALET     7000
#define DFSB_SCHEME    7300
#define DFSB_nextfree  7400

//- part/freespace ranges, separation 1000, allowing 999 partitions
#define DFSB_OVOLM    10000
#define DFSB_OPART    11000
#define DFSB_OFPRI    12000
#define DFSB_OFLOG    13000
#define DFSB_ACTIVE   14000
#define DFSB_NOTACT   15000
#define DFSB_P_HIDE   16000
#define DFSB_UNHIDE   17000
#define DFSB_MULTIV   18000
#define DFSB_DELETE   19000
#define DFSB_CHTYPE   20000
#define DFSB_CREATE   21000
#define DFSB_BMGR     22000
#define DFSB_BMDEFL   23000
#define DFSB_WIPEFSP  24000
#define DFSB_MOVE2F   25000
#define DFSB_COPY2F   26000
#define DFSB_CHKPART  27000
#define DFSB_SECPART  28000
#define DFSB_EBRPART  29000
#define DFSB_LVMRMV   30000
#define DFSB_LVMDEF   31000
#define DFSB_BMMENU   32000
#define DFSB_BMDELM   33000
#define DFSB_FMTFAT   34000
#define DFSB_VVOLM    35000
#define DFSB_VPART    36000
#define DFSB_LVMINFO  37000
#define DFSB_BMINST   38000
#define DFSB_WEBRT1   39000
#define DFSB_ALIGNL   40000
#define DFSB_GEODLG   41000
#define DFSB_GPTFIX   42000
#define DFSB_GPT2MBR  43000
#define DFSB_MBR2GPT  44000
#define DFSB_ISOVDI   45000
#define DFSB_APFSVI   46000
#define DFSB_PTEDIT   47000
#define DFSB_LVMDLG   48000


// Start and maintain DFSee interactive text-based windowed user-interface
ULONG dfsWindowed
(
   char               *initial                  // IN    initial DFSee cmd
);


// Attach FS-specific pulldown-menu to the main menubar
void dfsAttachFsPulldown
(
   void
);


// Set application window title to a string (default is name+version info)
void dfsSetAppWindowTitle
(
   char               *newTitle                 // IN    new title string
);


// Return pointer to current main-menu (can be BASIC or EXPERT or ...)
TXS_MENUBAR *dfsGetMainMenu
(
   void
);


#if defined (USEWINDOWING)
// Check if dialog is wanted and possible, message otherwise
BOOL dfsDialogAppropriate
(
   void
);
#else
#define dfsDialogAppropriate() FALSE
#endif                                          // USEWINDOWING

#endif
