//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee windowed user interface
//
// Author: J. van Wijk
//
// 1.00 22-06-1999    Initial version
// 3.13 02-01-2000    Updated history handling, added more F-keys
// 4.03 22-08-2001    Use nicer window-borders on larger screens
// 5.15 01-03-2003    Changed Fkey text to be desktop-footer, not a window
// 5.15 09-03-2003    Made owner for entry-field the desktop, not sbview
// 5.50 05-09-2003    Added main menu, accelerators and so on
// 12.0 02-05-2014    Added a second main menu 'BASIC' and switching to it
// 12.1 26-08-2014    Added complete Mode=EFAT submenu
// 13.0 10-11-2015    Added GPT specific menu items in Mode=FDISK
// 15.0 24-01-2018    Added complete Mode=APFS submenu


#include <txlib.h>                              // TX library interface

#include <dfsver.h>                             // DFS version info
#include <dfsrgkey.h>                           // Registration interface
#include <dfsdisk.h>                            // FS disk structure defs
#include <dfspart.h>                            // FS partition info manager
#include <dfsmedia.h>                           // Partitionable Media manager
#include <dfsupart.h>                           // FS partition utilities
#include <dfstore.h>                            // Store and sector I/O
#include <dfsufdsk.h>                           // FS fdisk utilities
#include <dfsdflvm.h>                           // FDISK LVM dialog functions
#include <dfsdfmbr.h>                           // FDISK MBR CR dialog functions
#include <dfsdfgpt.h>                           // FDISK GPT CR dialog functions
#include <dfsmdisk.h>                           // memory disk interface
#include <dfsntfs.h>                            // NTFS definitions (NTLDR)
#include <dfshpfs.h>                            // HPFS definitions (HPFS LDR)
#include <dfsjfs.h>                             // JFS  definitions (JFS LDR)
#include <dfs.h>                                // command executor
#include <dfsagen.h>                            // generic commands
#include <dfsutil.h>                            // utility functions
#include <dfsspace.h>                           // DFS file-space interface
#include <dfstable.h>                           // SLT interface
#include <dfsdgen.h>                            // dfs generic Dialogs
#include <dfsimage.h>                           // imaging (large buffer size)
#include <dfsfat.h>                             // FAT16 size limit
#include <dfswin.h>                             // windowed entry point

// minimum scroll-buffer for memory constrained environments (mainly DOS)
#define DFS_SMALLB_L      5000                  // total  1 MB
#define DFS_SMALLB_W       100

#define DFS_WID_ENTRY      201                  // window id entry-field
#define DFS_WID_SCROLL     202                  // window id scroll-buffer

#define DFS_HIST_SIZE       96
#define DFS_HIST_LINE  TXMAXLN

static TXLN        filedirpath = "";            // persistent full-path  variable
                                                // for file find/recover/hexedit
static TXLN        filefindStr = "";            // persistent filefind/delfind string

static TXLN        entryftxt = "";
static TXHIST      cmd_history;                 // history buffer info

static TXWINDOW    entryfwin;
static TXWINDOW    scrbuffwin;
static TXWINDOW    desktopwin;

static TXWHANDLE   desktop = 0;
static TXWHANDLE   sbufwin = 0;
static TXWHANDLE   entrwin = 0;


static TXSBDATA    scrollBufData =
{
   20,                                          // dummy visible/real sizes
   80,                                          // will be filled in at INIT
   60,
   0,
   0,0,0,0,                                     // no marked area
   FALSE,                                       // no scrolling when in middle
   TRUE,                                        // wrap on write on long lines
   0,                                           // SB view handle
   NULL                                         // SB buffer memory
};


static  char       *mainwinhelp[] =
{
   #include <dfsmain.hlp>
   NULL
};

static  char       *confirmhelp[] =
{
   #include <dfsconf.hlp>
   NULL
};

static  char       *menusyshelp[] =
{
   #include <dfsmenu.hlp>
   NULL
};

static  TXLN app_Title;                         // versioned window title

static  char stattxt[] =
   "F1=help F3=quit F6=Part F7=search F8=Grep F9=Browse F10=menu F12=min Esc=abort";


//============================  Start static menu definition =======================================================

//============================  shared items  ======================================================================

//- Note these items are shared for several menus
TXSitem(mmsp,0            ,0,TXSF_DISABLED | TXSF_SEPARATOR,     0,""    ,"");
TXSitem(mmxl,DFSC_LBROWSE ,0,0             , 1,"Browse dir/files from list"    ,"Browse files/directories from the current sector list (like a FileManager)  ");
TXSitem(mmxp,DFSC_FBROWSE ,0,0             , 1,"Open partition, Browse    s-F9","Select and open a partition, then Browse its filesystems directories / files");
TXSitem(mmxb,DFSC_XBROWSE ,0,0             , 1,"Browse FS, directory/files  F9","Browse files/directories in a list from a single directory, or current list ");
TXSitem(mmxu,DFSC_UBROWSE ,0,0             , 0,"Browse/Recover Deleted Files"  ,"Find deleted files, then BROWSE the resulting list and copy files (UNDELETE)");
TXSitem(mmxr,DFSC_XRDISK  ,0,0             , 0,"Reselect whole disk, FDISK"    ,"Unselect filesystem, reselect the same/first disk;   enables Mode=FDISK menu");
TXSitem(mmhs,DFSC_XFIXHS  ,0,0             , 5,"Fix HiddenSectors/Geo value"   ,"Fix bootsector HiddenSectors and geometry fields to match partition tables  ");
TXSitem(mmvs,DFSC_XSETVS  ,0,0             ,12,"Set Volume Serial Number"      ,"Change the volume serial number, making this volume unique  (after clone :-)");
TXSitem(mmlf,DFSC_COMPACT ,0,0             ,20,"Display files from List   ..." ,"Display (selected) files from the list, using a PATH+FILENAME wildcard      ");
TXSitem(mmrf,DFSC_RECOVER ,0,0             , 1,"Recover files from list   ..." ,"Recover (selected) files from the list to a supplied recovery directory     ");
TXSitem(mmrs,DFSC_FSAVETO ,0,0             , 9,"Recover THIS  file        ..." ,"Recover the file associated with the CURRENT sector to a recovery directory ");
TXSitem(mmfp,DFSC_FNDPATH ,0,0             ,22,"Find ONE file/dir by Path   "  ,"Find info (FNODE/MFT-record etc) for ONE specified file/directory path      ");
TXSitem(mmh1,DFSC_HEDPATH1,0,0             ,19,"HEX edit file/dir Info (1)  "  ,"Find + edit FAT dir entry / HPFS fnode / JFS inode / NTFS MFTrec+small files");
TXSitem(mmh2,DFSC_HEDPATH2,0,0             ,19,"HEX edit file/dir Data (2)  "  ,"Find, then HEX edit most HPFS / JFS / NTFS file-data or directory contents  ");
TXSitem(mmof,DFSC_FRECONE ,0,0             ,18,"Find and Recover ONE file   "  ,"Find ONE file by full path+filename, and recover it to a recovery directory ");
TXSitem(mmwl,DFSC_WIPELST ,0,0             , 1,"Wipe all sectors in list"      ,"Wipe all sectors in the sectorlist to ZEROES   (as listed by 'list -w')     ");
TXSitem(mmfz,DFSC_FWIPEZ0 ,0,0             ,17,"Wipe filesystem Bootsector"    ,"Wipe the Bootsector, FIRST sector in a filesystem. Remove obsolete FS info  ");
TXSitem(mmdz,DFSC_DWIPEZ0 ,0,0             , 6,"Wipe MBR sector of a disk"     ,"Wipe Master Boot record (MBR) on a disk, delete bootcode and partition-table");
TXSitem(mmtd,DFSC_DELTHIS ,0,0             , 0,"Delete THIS partition"         ,"Delete the currently selected partition from the partition tables           ");
TXSitem(mmta,DFSC_ACTHIS  ,0,0             , 0,"Make THIS partition Active"    ,"Make the currently selected PRIMARY the 'active' partition for MBR/BIOS boot");
TXSitem(mmsb,DFSC_SUPERB  ,0,0             , 9,"Display Superblock"            ,"Display the SUPERBLOCK structure for the currently selected filesystem      ");
TXSitem(mmid,DFSC_BOOTIND ,0,0             , 1,"Display Windows BOOT.INI"      ,"Find (first) BOOT.INI, display the default line and partition-index to boot ");
TXSitem(mmif,DFSC_BOOTINF ,0,0             ,10,"Fix BOOT.INI partition index"  ,"Find (first) BOOT.INI, update default partition-index to fix a boot failure ");
TXSitem(mmal,DFSC_ALLOCMP ,0,0             , 0,"Allocation map display"        ,"Display a pseudo-graphical map of used versus free sectors in the filesystem");
TXSitem(mmui,DFSC_UXUUID  ,0,0             ,14,"Display/Edit UUID string"      ,"Display and optionally edit the (Linux) UUID string value in the superblock ");
TXSsubm(mmim,DFSC_BMINST  ,0,DFSB_BMINST,0 ,13,"Bootmanager Install        "  ,"Install IBM BootManager in a new primary partition in the selected freespace");
TXSitem(mmqm,DFSC_BMCONF  ,0,0             ,13,"Bootmanager Query config"      ,"Query and display the IBM Bootmanager configuration, including current menu ");
TXSsubm(mmam,DFSC_BMMENU  ,0,DFSB_BMMENU,0 ,18,"Bootmanager menu Add       "  ,"Add a partition to the  IBM Bootmanager menu  (setname and LVM 'on BM menu')");
TXSsubm(mmdm,DFSC_BMDELM  ,0,DFSB_BMDELM,0 , 0,"Bootmanager menu Delete    "  ,"Delete a partition from IBM Bootmanager menu  (setname and LVM 'on BM menu')");
TXSsubm(mmbm,DFSC_BMDEFL  ,0,DFSB_BMDEFL,0 ,13,"Bootmanager Default boot   "  ,"Set default selection for the IBM Bootmanager menu, including 'Last booted' ");
TXSitem(mmtm,DFSC_BMTIME  ,0,0             ,13,"Bootmanager Timeout  ..."      ,"Set timeout in seconds before the IBM Bootmanager default choice is made    ");
TXSsubm(mmfm,DFSC_W2KBMG  ,0,DFSB_W2KBMG,0 ,11,"BMGR W2K, CHS and I13X fix "  ,"Update BMGR for W2K CHKDSK, fix BMGR-CHS values, and (re)set I13X dependancy");
TXSitem(mmrb,DFSC_NOBADS  ,0,0             , 1,"Reset bad sectors"             ,"Reset the bad-sector administration to show ZERO bad-sectors or clusters    ");
TXSsubm(mmx5,DFSC_LVMINFO ,0,DFSB_LVMINFO,0, 1,"LVM info for partition(s)  "  ,"List the LVM information (DLAT and BBR areas) for selected partition(s)     ");


TXSitem(mmsl,DFSC_XDISLT  ,0,0             , 1,"Show object layout (SLT)"      ,"Show layout of current object by displaying parts of the Sector Lookup Table");
TXSitem(mmsi,DFSC_XIDSLT  ,0,0             , 1,"Identify specific sector"      ,"Show identification for specified (or current) sector, using the SLT        ");
TXSitem(mmli,DFSC_XIDLST  ,0,0             ,10,"Identify Last used sector"     ,"Show identification for the last sector used, dictating the minimum FS size ");
static TXS_ITEM *slt[] =
{
   &mmsl, &mmsi, &mmli
};
TXSlist(dfsslt,3,3,slt);
TXSsubm(mslt,DFSC_XSLTAB  ,&dfsslt,0,0     , 1,"Identify sectors (SLT)    "   ,"Create Sector Lookup Table (SLT) if needed, display as table or sector info ");

//============================  FILE  ==============================================================================

TXSsubm(s1o2,DFSC_ODISK   ,0,DFSB_ODISK,0  , 1,"Disk               "          ,"Open disk selected by submenu, to work on part-tables, LVMinfo or whole disk");
TXSsubm(s1o3,DFSC_OPART   ,0,DFSB_OPART,0  , 1,"Partition       F6 "          ,"Open partition selected by submenu, to work on the filesystem in a partition");
TXSsubm(s1o8,DFSC_VPART   ,0,DFSB_VPART,0  , 0,"Partition, verbose "          ,"Open partition selected by submenu, to work on, show more details on opening");
TXSsubm(s1of,DFSC_OFPRI   ,0,DFSB_OFPRI,0  , 1,"Freespace, Primary "          ,"Open freespace area from a submenu, align for primary partition (disk, base)");
TXSsubm(s1ol,DFSC_OFLOG   ,0,DFSB_OFLOG,0  ,12,"Freespace, Logical "          ,"Open freespace area from a submenu, align for logical partition (disk, base)");
#if defined (UNIX)
TXSsubm(s1o4,DFSC_OVOLM   ,0,DFSB_OVOLM,0  , 3,"Device             "          ,"Open device for analysis (<F7> refreshes submenu)   For HD, use 'Partition'!");
TXSsubm(s1o9,DFSC_VVOLM   ,0,DFSB_VVOLM,0  , 0,"Device, verbose    "          ,"Open device for analysis (<F7> refreshes submenu)   Show more FS details    ");
#else
TXSsubm(s1o4,DFSC_OVOLM   ,0,DFSB_OVOLM,0  , 1,"Volume             "          ,"Open volume for analysis (<F7> refreshes submenu)   For HD, use 'Partition'!");
TXSsubm(s1o9,DFSC_VVOLM   ,0,DFSB_VVOLM,0  , 0,"Volume,    verbose "          ,"Open volume for analysis (<F7> refreshes submenu)   Show more volume details");
#endif
TXSitem(s1o5,DFSC_OIMAG   ,0,0             , 1,"Imagefile        ..."          ,"Open Compressed or RAW imagefile FOR BROWSING or ANALYSIS ONLY, not Restore!");
static TXS_ITEM *s1o[] =
{
   &s1o2, &s1o3, &s1o4, &s1o5, &mmsp,
   &s1of, &s1ol, &mmsp,
   &s1o8, &s1o9
};
TXSlist(dfss1o,10,10,s1o);

TXSitem(s1m1,DFSC_VPDX    ,0,0             , 1,"MemDisk from .PDx Template ...","Create and attach a Memory disk, sized and initialized with a selected .PDx ");
TXSitem(s1m2,DFSC_VIRT    ,0,0             , 1,"Empty virtual disk"            ,"Create and attach a new Memory disk, size as specified or same as current   ");
TXSitem(s1m3,DFSC_PHYS    ,0,0             , 1,"Physical, accessible disk"     ,"Attach an existing and ACCESSIBLE physical disk, by disknr (Unix: /dev/name)");
TXSitem(s1m4,DFSC_IRAW    ,0,0             , 1,"Raw disk image    (.IMG)(.ISO)","Attach a RAW imagefile as a disk, like a DFSee .IMG file, ISO or many others");
TXSitem(s1m5,DFSC_ICMP    ,0,0             , 1,"Compressed disk image   (.IMZ)","Attach a COMPRESSED (disk) imagefile as a disk, supports DFSee .IMZ only!   ");
TXSitem(s1m6,DFSC_IVDI    ,0,0             , 1,"VirtualBox disk image   (.VDI)","Attach a VirtualBox (disk) imagefile as a disk, supports Base/Snapshot VDIs ");
static TXS_ITEM *s1m[] = {&s1m1, &s1m2, &s1m3, &s1m4, &s1m5, &s1m6};
TXSlist(dfss1m,6,6,s1m);

TXSitem(smm0,DFSC_UMEDIA  ,0,0             , 1,"Update DFSee disk-list   c-U " ,"Remove all, re-scan/attach all physical disks to disk list; then display all");
TXSsubm(smm1,DFSC_ATTACH  ,&dfss1m,0,0     , 1,"Attach  to  DFSee disk-list " ,"Attach TO DFSee disk-list,  media like a physical/virtual disk or RAW image ");
TXSsubm(smm2,DFSC_DETACH  ,0,DFSB_DETACH ,0, 0,"Detach from DFSee disk-list " ,"Detach FROM DFSee disk-list media like a physical/virtual disk or RAW image ");
TXSitem(smm3,DFSC_PMEDMAP ,0,0             , 1,"Display the DFSee disk-list  " ,"Display DFSee disk-list, mapping of disk-id to media like disks and devices ");
TXSsubm(smm4,DFSC_MEJECT  ,0,DFSB_MEJECT ,0, 1,"Eject a removable medium    " ,"OS: Eject removable medium selected from a list of known removable drives   ");
TXSitem(smm5,DFSC_MREFRSH ,0,0             , 1,"Refresh removable media"       ,"OS: Refresh the list of removable media, attempt rediscover new ones by OS  ");
static TXS_ITEM *smm[] =
{
   &smm0, &mmsp,
   &smm1, &smm2, &smm3, &mmsp,
   &smm4, &smm5
};
TXSlist(dfssmm,
#if defined (DEV32)
        8,8,
#else
        5,5,
#endif
        smm);


TXSitem(sdv1,DFSC_OSVOLS  ,0,0             , 9,"Display Volume information   " ,"Display volume information, 'vol' command, including 'df' when available   ");
#if   defined (DARWIN)
TXSitem(sdv2,DFSC_DEVINF  ,0,0             , 9,"Display OS device/disk info  " ,"Display low level disk/device information, using a macOS DISKUTIL LIST cmd ");
TXSitem(sdvs,DFSC_SIPSTA  ,0,0             ,15,"Display macOS SIP status     " ,"Display the macOS System Integrity Protection status (access to boot disk) ");
#elif defined (LINUX)
TXSitem(sdv2,DFSC_DEVINF  ,0,0             , 9,"Display OS device/disk info  " ,"Display low level disk/device information, using the Linux LSBLK command   ");
#elif defined (WIN32)
TXSitem(sdv2,DFSC_DEVINF  ,0,0             , 9,"Display OS device/disk info  " ,"Display low level disk/device information, using the Windows MOUNTVOL cmd  ");
#else
TXSitem(sdv2,DFSC_DEVINF  ,0,0             , 9,"Display OS device/disk info  " ,"Display low level disk/device information, NOT IMPLEMENTED for DOS or OS/2!");
#endif
TXSsubm(sdv3,DFSC_UMTVOL  ,0,DFSB_UMTVOL ,0, 1,"Unmount volumes from a disk " ,"Unmount all known volumes from a disk allowing low level WRITE DFSee access");
TXSsubm(sdv4,DFSC_MNTVOL  ,0,DFSB_MNTVOL ,0, 3,"reMount volumes for  a disk " ,"Mount/remount all volumes for a disk (automount) allowing user access again");
static TXS_ITEM *sdv[] =
{
   &sdv1, &sdv2,
#if defined (DARWIN)
   &sdvs,
#endif
   &mmsp,
   &sdv3, &sdv4
};
#if   defined (DARWIN)
   TXSlist(dfssdv, 6,6, sdv);
#elif defined (LINUX)
   TXSlist(dfssdv, 5,5, sdv);
#else
   TXSlist(dfssdv, 2,2, sdv);
#endif


TXSitem(s581,DFSC_NEXTDEF ,0,0             , 0,"Next likely sector      <Enter>","Display most likely desired   'next' sector (in hierarchy) in default format");
TXSitem(s582,DFSC_UPSNDEF ,0,0             , 1,"Up   linked sector             ","Display related, referencing, 'up'   sector (in hierarchy) in default format");
TXSitem(s583,DFSC_XTRADEF ,0,0             , 1,"Xtra linked sector             ","Display related (somehow :-)  'xtra' sector                in default format");
TXSitem(s584,DFSC_THISPLS ,0,0             , 6,"This +1 sector, go Forward  '>'","Display the sector just AFTER  'this' one   (sectornr +1)  in default format");
TXSitem(s585,DFSC_THISMIN ,0,0             , 6,"This -1 sector, go Backward '<'","Display the sector just BEFORE 'this' one   (sectornr -1)  in default format");
TXSitem(s587,DFSC_THISDEF ,0,0             , 0,"This sector, default fmt       ","Display the current 'this' sector in the default, best matching format      ");
TXSitem(s588,DFSC_THISHEX ,0,0             ,23,"This sector, Dump Hex/Bin   c-B","Display the current 'this' sector as HEX/BINARY  dump, including ASCII      ");
TXSitem(s589,DFSC_THISASC ,0,0             ,14,"This sector, Text as Ascii  c-T","Display the current 'this' sector as ASCII text (garbage for non-ASCII!)    ");
static TXS_ITEM *s58[] =
{
   &s581, &s582, &s583, &mmsp,
   &s584, &s585, &mmsp,
   &s587, &s588, &s589
};
TXSlist(dfss58,10,10,s58);



TXSitem(mm11,DFSC_LOGF    ,0,0             , 1,"Log new output to file      ...","Open a logfile for all screen output to come, append if file exists         ");
TXSitem(mm13,DFSC_CYTRACE ,0,0             , 1,"Trace to 9 cyclic files     ...","Functional trace program-flow to 9 one-MB cyclic files, for DFSee debugging ");
TXSitem(mm1q,DFSC_QUERY   ,0,0             ,10,"Create a QUERY report       ...","Generate an email/news friendly QUERY report with disk and partition info   ");
TXSitem(mm19,DFSC_SAVE    ,0,0             , 1,"Save screen to file          F4","Save all text in text Output-window to an ASCII file (could be large!)      ");
TXSitem(mm1w,DFSC_CURDIR  ,0,0             , 1,"Change current directory"       ,"Change the current directory, where files will be saved by default          ");
TXSsubm(mm1o,DFSC_OPENOW  ,&dfss1o,0,0     , 1,"Open object to work with      ","Open an object like a disk, partition or volume to analyse and work with    ");
#if defined (DEV32)
TXSsubm(mm1m,DFSC_MEDIAM  ,&dfssmm,0,0     , 1,"Attach/Detach/Display disks   ","Attach/Detach/Display partitionable media, Eject and Refresh Removable media");
#else
TXSsubm(mm1m,DFSC_MEDIAM  ,&dfssmm,0,0     , 1,"Attach/Detach/Display disks   ","Attach/Detach/Display partitionable media  (in DFSee partionable media list)");
#endif
#if defined (UNIX)
TXSsubm(mm1d,DFSC_DEVVOL  ,&dfssdv,0,0     , 1,"Device and Volume management  ","Display Device and Volume information, UNMOUNT volumes and (re)MOUNT them   ");
#else
TXSsubm(mm1d,DFSC_DEVVOL  ,&dfssdv,0,0     , 1,"Device and Volume management  ","Display (disk) Device and Volume info, as available for the operating system");
#endif
TXSsubm(mm1b,DFSC_BMGR    ,0,DFSB_BMGR   ,0,16,"Boot using IBM Bootmanager    ","Reboot to the a BMGR bootable partition selected from the list  (setboot)   ");
TXSitem(mm1c,DFSC_BOOT    ,0,0             ,17,"Boot the system Now            ","Reboot the system after confirmation, filesystems are flushed properly.     ");
TXSitem(mm1x,DFSC_EXIT    ,0,0             , 2,"Exit                        c-Q","Exit the DFSee program");
static TXS_ITEM *mm1[] =
{
   &s581, &s584, &s585, &mmsp,
   &mm11, &mm13, &mmsp,
   &mm1o, &mmsp,
   &mm1q, &mm19, &mm1w, &mmsp,
   &mm1m, &mm1d, &mmsp,
   &mm1b, &mm1c, &mm1x
};
TXSlist(dfsmm1,19,19,mm1);

// BASIC version of the above pull-down menu
TXSsubm(b1o2,DFSC_ODISK   ,0,DFSB_ODISK,0  ,14,"Open a whole Disk             ","Open disk selected by submenu, work on partition tables, LVM info and more  ");
TXSsubm(b1o3,DFSC_OPART   ,0,DFSB_OPART,0  , 1,"Open single partition     F6  ","Open a single partition selected by submenu, work on the filesystem inside  ");
static TXS_ITEM *mb1[] =
{
   &mm11, &mmsp,
   &b1o2, &b1o3, &mmsp,
   &mm1q, &mm19, &mm1w, &mmsp,
   &mm1x
};
TXSlist(dfsmb1,10,10,mb1);

//============================  EDIT ===============================================================================

TXSitem(s251,DFSC_FSFDISK ,0,0             , 0,"FDISK + LVM disk level Mode"    ,"Create, update, display, recover or fix partition-tables or LVM information ");
TXSitem(s25a,DFSC_FSAPFS  ,0,0             , 1,"APFS,  APFS Container    FS"    ,"Check, analyse, display or fix the APPLE-FS filesystem, APFS Container disks");
TXSitem(s25d,DFSC_FSDUMP  ,0,0             , 1,"DUMPFS OS/2 crash-dump   FS"    ,"Check, analyse, display or fix DUMPFS filesystem, IBM OS2/eCS/BlueLion      ");
TXSitem(s25y,DFSC_FSEXFT  ,0,0             , 0,"EFAT,  huge SD/removable FS"    ,"Check, analyse, display or fix Enhanced-FAT filesystems                     ");
TXSitem(s252,DFSC_FSEXT   ,0,0             , 1,"EXTn   Linux std/journld FS"    ,"Check, analyse, display or fix EXT2, EXT3 or EXT4 filesystem, used on Linux ");
TXSitem(s253,DFSC_FSFAT   ,0,0             , 1,"FAT12, FAT16 or FAT32    FS"    ,"Check, analyse, display or fix FAT12, FAT16 or FAT32 filesystems            ");
TXSitem(s254,DFSC_FSHFS   ,0,0             , 8,"HFS+,  macOS journaled   FS"    ,"Check, analyse, display or fix the HFS+, journaled filesystem for the MAC   ");
TXSitem(s255,DFSC_FSHPFS  ,0,0             , 1,"HPFS,  OS/2 std native   FS"    ,"Check, analyse, display or fix HPFS/HPFS386 filesystems (OS2, eCS, BlueLion)");
TXSitem(s25i,DFSC_FSISO   ,0,0             , 1,"ISO    ISO9660 CDROM/DVD FS"    ,"Analyse, display and Browse ISO9660 CDROM, DVD or .iso imagefiles           ");
TXSitem(s256,DFSC_FSJFS   ,0,0             , 1,"JFS,   OS/2 journaled    FS"    ,"Check, analyse, display or fix JFS filesystem, IBM OS2/eCS or Linux flavour ");
TXSitem(s257,DFSC_FSNTFS  ,0,0             , 1,"NTFS,  Win-NT/XP/7/8/10  FS"    ,"Check, analyse, display or fix NTFS filesystem (Win-NT/2000/XP/7/8/10)      ");
TXSitem(s258,DFSC_FSRSR   ,0,0             , 1,"Reiser Linux journaled   FS"    ,"Check, analyse, display or fix ReiserFS, journaled filesystem on Linux      ");
TXSitem(s25s,DFSC_FSSWAP  ,0,0             , 1,"Swap   Linux SWAP space    "    ,"Check, analyse, display a Linux SWAP space area, enabling 'smart' imaging   ");
TXSitem(s259,DFSC_FSXFS   ,0,0             , 1,"XFS,   Linux journaled   FS"    ,"Check, analyse, display or fix the XFS,  journaled filesystem on Linux      ");
TXSitem(s25x,DFSC_FSAUX   ,0,0             , 0,"Auxiliary mode unknown   FS"    ,"Generic analysis and display for any filesystem unknown to DFSee            ");
static TXS_ITEM *s25[] =
{
   &s251, &mmsp,
   &s25a, &s25d, &s25y, &s252, &s253, &s254, &s255, &s25i, &s256, &s257, &s258, &s25s, &s259,
   &mmsp, &s25x
};
TXSlist(dfss25,17,17,s25);

TXSitem(s2e1,DFSC_SECHEX  ,0,0             ,11,"Sector in HEX       ...     "  ,"Replace some data in the current sector with supplied offset and HEX   pairs");
TXSitem(s2e2,DFSC_SECASC  ,0,0             ,11,"Sector in ASCII     ...     "  ,"Replace some data in the current sector with supplied offset and ASCII   str");
TXSitem(s2e3,DFSC_SECUNI  ,0,0             ,11,"Sector in UNICODE   ...     "  ,"Replace some data in the current sector with supplied offset and UNICODE str");
static TXS_ITEM *s2e[] = {&s2e1, &s2e2, &s2e3};
TXSlist(dfss2e,3,3,s2e);


TXSitem(s2s1,DFSC_FINDTC  ,0,0             , 1,"Search in sector data  ... a-S","Search for Ascii/Unicode/Hex data in all sectors for currently open object  ");
TXSitem(s2s2,DFSC_FINDAG  ,0,0             , 1,"Repeat sector search   ... a-R","Repeat the last search specified through the dialog, exact same arguments   ");
TXSitem(s2s0,DFSC_FIND00  ,0,0             ,17,"Search for 0x00 EMPTY sectors ","Search for sectortype 0, containing 0x00 byte values only, EMPTY sectors    ");
TXSitem(s2sf,DFSC_FINDFE  ,0,0             ,17,"Search for 0xFE BAD   sectors ","Search for sectortype 5, containing 0xFE byte values only, DFSee BAD-SECTOR ");
TXSitem(s2s3,DFSC_SBSRCH  ,0,0             , 8,"Search Output text     ...  F7","Search for an Ascii phrase in the output text window, highlight search-hit  ");
TXSitem(s2s4,DFSC_SBGREP  ,0,0             , 1,"Grep   Output text     ...  F7","Search for an Ascii phrase in the output text window, present in result list");
TXSitem(s2s5,DFSC_SBEXEC  ,0,0             , 1,"List all executed commands    ","Search Output-window for 'Executing:' and show found lines in result list   ");
static TXS_ITEM *s2s[] =
{
   &s2s1, &s2s2, &mmsp,
   &s2s0, &s2sf, &mmsp,
   &s2s3, &s2s4, &mmsp,
   &s2s5,
};
TXSlist(dfss2s,10,10,s2s);

TXSsubm(mm21,DFSC_PTEDIT  ,0,DFSB_PTEDIT,0 , 6,"Edit Partition tables        ","Edit a partition table in an MBR/EBR sector using the P-Table-Editor dialog ");
TXSsubm(mm22,DFSC_LVMDLG  ,0,DFSB_LVMDLG,0 , 6,"Edit LVM information         ","Edit LVM information related to disk partitions, LVM-volumes and BMGR-menu  ");
TXSitem(mm2b,DFSC_SHFILE  ,0,0             , 9,"File in Binary editor"         ,"Start interactive sector-editor on the selected file,  allow HEX/ASCII edit ");
TXSitem(mm2h,DFSC_SHEXED  ,0,0             , 9,"Sector, Automatic view    a-F2","Start interactive sector-editor on the current sector, auto view selection  ");
TXSitem(mm2i,DFSC_HEXASC  ,0,0             , 9,"Sector, HEX/ASCII           F2","Start interactive sector-editor on the current sector, HEX/ASCII view       ");
TXSitem(mm2x,DFSC_HEX16B  ,0,0             , 9,"Sector, HEX 16x32     a_T/c-F2","Start interactive sector-editor on the current sector, HEX, 16 bytes per row");
TXSitem(mm2d,DFSC_DISASM  ,0,0             , 9,"Sector, Disassembler   ..."    ,"Start interactive sector-viewer on the current sector, Disassembler view    ");
TXSitem(mm2t,DFSC_TXTSTR  ,0,0             , 9,"Sector, Text/Strings   ..."    ,"Start interactive sector-viewer on the current sector, Text/strings view    ");
TXSsubm(mm2a,DFSC_STREDT  ,&dfss2e,0,0     , 0,"Sector, String replacement   ","Replace data in current sector using HEX/ASCII/UNICODE replacement strings  ");
TXSsubm(mm2s,DFSC_SEARCH  ,&dfss2s,0,0     , 0,"Search sectors and output    ","Search functions to search (disk) sectors and the output text window        ");
TXSsubm(mm2m,DFSC_FSMODE  ,&dfss25,0,0     ,17,"Force operation Mode=xxx     ","Force specific Mode=xxx (Fdisk or FS) Can be dangerous, for expert use only!");
TXSitem(mm28,DFSC_EXPERT  ,0,0             , 0,"UI, switch to Expert mode  a-3","Activate the EXPERT user interface, giving access to ALL functionality      ");
TXSitem(mm29,DFSC_EXPERT  ,0,0             , 0,"UI, switch to Basic mode   a-3","Activate the BASIC user interface, limited to the most used functions only  ");
static TXS_ITEM *mm2[] =
{
   &mm29, &mmsp,
   &mm21, &mm22, &mmsp,
   &mm2b, &mm2h, &mm2i, &mm2x, &mm2d, &mm2t, &mm2a, &mmsp,
   &mm2s, &mmsp,
   &mm2m
};
TXSlist(dfsmm2,16,16,mm2);

// BASIC version of the above pull-down menu
static TXS_ITEM *mb2[] =
{
   &mm28, &mmsp,
   &mm22
};
TXSlist(dfsmb2,3,3,mb2);

//============================  SET and PROPERTIES =================================================================

TXSsubm(s26p,DFSC_PALET   ,0,DFSB_PALET ,0 , 0,"Select #colors, Palette    "  ,"Select and set number of available colors, B/W or 16 from a larger palette  ");
TXSsubm(s26s,DFSC_SCHEME  ,0,DFSB_SCHEME,0 , 1,"Select window color Scheme "  ,"Select and activate any of the available window-color schemes               ");
TXSitem(s268,DFSC_SIZWIN  ,0,0             ,14,"Adapt to new Window-size"      ,"Re-initialize the DFSee windowing system to use the full (resized) window   ");
TXSitem(s269,DFSC_NONWIN  ,0,0             ,11,"Change to Non-windowed UI"     ,"Re-initialize DFSee, using a simple command-driven non-windowed interface   ");
TXSitem(s26f,DFSC_UICYCLE ,0,0             , 0,"UI cycle colorscheme/lines"    ,"Cycling of color-scheme/line-styles using arrow keys, terminated with ENTER ");
TXSitem(s26c,DFSC_UICTEST ,0,0             , 0,"UI test, Color, Char, Box"     ,"Test UI, displaying ANSI color-set, character-set and Box-drawing characters");
TXSitem(s26k,DFSC_UIKEYBT ,0,0             , 0,"UI test, Keyboard + Mouse"     ,"Test UI, detection of keyboard and mouse activity incl Esc-sequences on UNIX");

static TXS_ITEM *sui[] =
{
   &s26p, &s26s, &mmsp,
   &s268, &s269, &mmsp,
   &s26f, &s26c, &s26k
};
TXSlist(dfssui, 9, 9,sui);


TXSitem(mmsh,DFSC_SHOWHID ,0,0             , 1,"Browse show hidden Dirs/Files" ,"Browser shows HIDDEN items (Name starts with '.' or SYSTEM/HIDDEN attribute)");
TXSitem(mm2y,DFSC_BATCH   ,0,0             , 0,"Set Batch, no confirmations"   ,"NO questions asked, automatic YES to confirmations. See 'batch' command help");
TXSitem(mm2r,DFSC_RDONLY  ,0,0             , 0,"Set Read-Only, no writes"      ,"NO writing to opened objects for safety, do allow writing log or image-files");
TXSitem(mm2e,DFSC_IGNERR  ,0,0             , 0,"Ignore any (R/W) errors"       ,"Ignore read/write and other errors, continue operation with next sector(s)  ");
TXSitem(mm2p,DFSC_GPTAUTO ,0,0             , 1,"Auto GPT partition handling"   ,"Automatic interpretation of GPT-style disks, hiding the 0xEE protective MBR ");
TXSitem(mm2g,DFSC_GEOCALC ,0,0             , 5,"Set Geometry contents based"   ,"Get disk geometry from disk contents (tables and LVM) instead of the OS/BIOS");
#if defined (DEV32)
TXSitem(mm2o,DFSC_LVMSYNC ,0,0             ,10,"Keep LVM Engine synchronised"  ,"Always sync LVM Driveletters to LVM Engine; Avoids reboot, may cause traps!!");
#endif
TXSitem(mm2f,DFSC_VOLFLOP ,0,0             , 0,"Incl. Floppies in vol. lists"  ,"Include diskettes, Floppy A: or B: in volumelists, used in menus and dialogs");
TXSitem(mm2l,DFSC_LOGAUTO ,0,0             ,18,"Auto logfilename Numbering"    ,"Automatically number logfiles as name001..999, added to filename from dialog");
TXSitem(mm2q,DFSC_LOGDATE ,0,0             ,18,"Auto logfilename Date postfix" ,"Automatically add '-YYYMMDD' DATE postfix string to log filename from dialog");
TXSitem(mm20,DFSC_PTYPE0  ,0,0             , 5,"Show type 0x00 as Partition"   ,"Handle primary partition table type 0x00 as a valid partition, not freespace");

TXSsubm(mmcu,DFSC_UISPROP ,&dfssui,0,0     , 7,"Size, Colors, Kbd/Mouse test ","Adapt window size, Set color-scheme/palette; Show Kbd/Mouse generated codes ");

TXSitem(mrmb,DFSC_RMBMENU ,0,0             , 1,"Mouse RMB click opens Menu"    ,"Right-Mouse-Button click opens main/popup menu by simulating <F10> key press");
TXSitem(mmsf,DFSC_FHIDDEN ,0,0             , 1,"Fdlgs, show hidden Dirs/Files" ,"File dialogs show HIDDEN items (Name starts with '.' or SYSTEM/HIDDEN attr) ");
TXSitem(s261,DFSC_INVSCR  ,0,0             , 1,"Inverted output-screen"        ,"Use inverted colors on the scrollable output screen                         ");
TXSitem(s262,DFSC_BRTSCR  ,0,0             , 8,"Bright Foreground-text"        ,"Use bright foreground colors only on the scrollable output screen           ");
TXSitem(s263,DFSC_B2BSCR  ,0,0             , 0,"Blue/Brown background"         ,"Use blue (or brown inverted) background instead of classic black or white   ");
TXSitem(s264,DFSC_ASCII7  ,0,0             , 5,"Use 7-bit ASCII only"          ,"Use 7-bit ASCII character only, avoid non-standard 'drawing chars'          ");
TXSitem(s265,DFSC_COLTXT  ,0,0             , 0,"ANSI colored texts"            ,"Use ANSI-like colored text string on the scrollable output screen           ");
#if defined (LINUX)
TXSitem(s26x,DFSC_XSCLIP  ,0,0             , 1,"Use X selection CLIPBOARD"     ,"Use CLIPBOARD not PRIMARY X-selection as Paste source   (Copy goes to BOTH!)");
#endif
TXSitem(s266,DFSC_PROMPT  ,0,0             , 8,"Status Prompt after each CMD"  ,"Display two-line status prompt after all command-line and most menu commands");
TXSitem(s267,DFSC_AUTODR  ,0,0             , 0,"Automatic Menu Dropdown"       ,"Automatically open menu pulldown on selecting menu-heading in the MenuBar   ");
TXSitem(s26d,DFSC_DELAYDR ,0,0             , 0,"Delayed (auto) Dropdown"       ,"Only automatically Drop-down on MOVING between menus, not <F10> activation  ");
TXSitem(s26r,DFSC_RIGHTMV ,0,0             , 0,"Right moves to next Dropdown"  ,"Right-arrow moves to next Dropdown menu, open submenu requires an <Enter>   ");

static TXS_ITEM *mmc[] =
{
   &mmsh, &mm2y, &mm2r, &mm2e, &mm2p, &mm2g,
   #if defined (DEV32)
          &mm2o,
   #endif
   &mm2f, &mm2l, &mm2q, &mm20, &mmsp,

   &mmcu, &mmsp,

   &mrmb, &mmsf, &s261, &s262, &s263, &s264, &s265,
   #if defined (LINUX)
          &s26x,
   #endif
   &s266, &s267, &s26d, &s26r
};
#if   defined (LINUX)
   TXSlist(dfsmmc,23,23,mmc);
#elif defined (DEV32)
   TXSlist(dfsmmc,25,25,mmc);
#else
   TXSlist(dfsmmc,24,24,mmc);
#endif

// BASIC version of the above pull-down menu
static TXS_ITEM *mbc[] =
{
   &mmsh, &mm2y, &mm2r, &mmsp,
   &mmsf, &s267, &s26d, &s26r
};
TXSlist(dfsmbc,8,8,mbc);



//============================  ACTIONS ============================================================================

TXSitem(s350,DFSC_CLDDBAD ,0,0             , 1,"Disk, skip BAD-SECTORS ..."    ,"Clone Disk to Disk, skip 16 MiB on BAD-sector, generate an Area-Retry script");
TXSitem(s351,DFSC_CLDDISK ,0,0             , 1,"Disk to Disk,  regular ..."    ,"Clone a to-be-selected Disk to another to-be-selected Disk (copy whole disk)");
TXSitem(s352,DFSC_CLPPART ,0,0             , 1,"Partition to Partition ..."    ,"Clone a to-be-selected Partition to another to-be-selected Partition, backup");
#if defined (UNIX)
TXSitem(s353,DFSC_CLVVOLD ,0,0             , 1,"Device    to Device    ..."    ,"Clone a to-be-selected Device to another to-be-selected Device    (diskette)");
#else
TXSitem(s353,DFSC_CLVVOLD ,0,0             , 1,"Volume    to Volume    ..."    ,"Clone a to-be-selected Volume to another to-be-selected Volume    (diskette)");
#endif
TXSitem(s354,DFSC_CLCDISK ,0,0             , 0,"Disk      to Current object"   ,"Clone a to-be-selected Disk      to the currently opened object (dangerous!)");
TXSitem(s355,DFSC_CLCPART ,0,0             , 0,"Partition to Current object"   ,"Clone a to-be-selected Partition to the currently opened object (dangerous!)");
#if defined (UNIX)
TXSitem(s356,DFSC_CLCVOLD ,0,0             ,14,"Device    to Current object"   ,"Clone a to-be-selected Device    to the currently opened object (dangerous!)");
#else
TXSitem(s356,DFSC_CLCVOLD ,0,0             ,14,"Volume    to Current object"   ,"Clone a to-be-selected Volume    to the currently opened object (dangerous!)");
#endif
static TXS_ITEM *s35[] =
{
   &s350, &s351, &s352, &s353, &mmsp,
   &s354, &s355, &s356
};
TXSlist(dfss35,8,8,s35);

TXSitem(s3a0,DFSC_WIPETHS ,0,0             ,14,"Erase, wipe 'This' sector(s)"  ,"Wipe one or more sectors to ZEROES at the 'this' sector in current object   ");
TXSitem(s3a1,DFSC_WIPEZER ,0,0             , 1,"Erase, wipe current object"    ,"Wipe object (disk/part/vol) completely clean with zeroes.   (ALL DATA LOST!)");
TXSitem(s3a2,DFSC_WIPESEC ,0,0             , 1,"SECURE wipe current object"    ,"Wipe object (disk/part/vol) in DoD SECURE way.     (slow and UNRECOVERABLE!)");
TXSsubm(s3a3,DFSC_WIPEFSP ,0,DFSB_WIPEFSP,0,13,"Erase, wipe Freespace-area "  ,"Wipe all sectors in the area of freespace to be selected (clean old garbage)");
TXSitem(s3a4,DFSC_ZERFREE ,0,0             , 1,"Zero freespace in filesystem"  ,"Wipe all   FREE sectors/clusters in the filesystem to ZERO. (.IMZ optimizer)");
TXSitem(s3a5,DFSC_SECFREE ,0,0             , 0,"SECUREWIPE freespace in FS"    ,"SECUREWIPE FREE sectors/clusters in the filesystem, SLOW! (DoD 5520.22 spec)");
static TXS_ITEM *s3a[] = {&s3a0, &s3a1, &s3a2, &mmsp, &s3a3, &mmsp, &mmwl, &mmsp, &s3a4, &s3a5};
TXSlist(dfss3a,10,10,s3a);

TXSsubm(s3f1,DFSC_FMTFAT  ,0,DFSB_FMTFAT ,0, 3,"A Partition to be selected   ","FORMAT a partition to an EMPTY FAT or FAT32 filesystem   (all data is LOST!)");
TXSitem(s3f2,DFSC_FMTOBJ  ,0,0             , 1,"Currently opened object   ..." ,"Format the CURRENT opened object with a FAT filesystem specified in a dialog");
TXSitem(s3f3,DFSC_FMTLDR  ,0,0             ,10,"Current, OS2LDR.SEK Bootable"  ,"Format CURRENT object as FAT16 + OS2LDR code    (Bootable USB, Large Floppy)");
static TXS_ITEM *s3f[] =
{
   &s3f1, &s3f2, &mmsp, &s3f3
};
TXSlist(dfss3f,4,4,s3f);

TXSsubm(s3m1,DFSC_COPY2F  ,0,DFSB_COPY2F ,0, 1,"Copy Part to freespace area  ","Copy current partition to a different freespace area, do NOT delete original");
TXSsubm(s3m2,DFSC_MOVE2F  ,0,DFSB_MOVE2F ,0, 1,"Move Part to freespace area  ","Move current partition to a different freespace area (deleting the original)");
TXSitem(s3m3,DFSC_MOVE2E  ,0,0             ,14,"Move towards END of freespace" ,"Move current partition towards the END of freespace (higher cylinder-number)");
TXSitem(s3m4,DFSC_MOVE2B  ,0,0             ,14,"Move towards BEGIN freespace"  ,"Move current partition towards  BEGIN  of freespace (lower  cylinder-number)");
static TXS_ITEM *s3m[] =
{
   &s3m1, &s3m2, &mmsp,
   &s3m3, &s3m4
};
TXSlist(dfss3m,5,5,s3m);

TXSitem(s3r1,DFSC_RESIZET ,0,0             , 1,"Resize, make partition smaller","Resize the current partition, making it smaller (truncating, make freespace)");
TXSitem(s3r2,DFSC_REXPAND ,0,0             , 2,"Expand, make partition larger" ,"Resize the current partition, making it larger  (expanding, using freespace)");
TXSitem(s3r3,DFSC_RESIMAX ,0,0             , 1,"Adjust FS to partition size"   ,"Resize the filesystem in current partition to use the WHOLE partition size  ");
static TXS_ITEM *s3r[] =
{
   &s3r1, &s3r2, &s3r3
};
TXSlist(dfss3r,3,3,s3r);

TXSitem(s3l1,DFSC_EXPLIST ,0,0             , 1,"Export sector-list       ..."  ,"Export the list of sectors to an ASCII file for later use    (or for import)");
TXSitem(s3l2,DFSC_IMPLIST ,0,0             , 1,"Import sector-list       ..."  ,"Import ASCII file with sectornumbers to the DFSee sector list     (exported)");
TXSitem(s3l0,DFSC_CLRLIST ,0,0             , 1,"Clear  sector-list, empty"     ,"Clear all entries from the DFSee sector list, making it completely empty    ");
TXSitem(s3l3,DFSC_LVALUES ,0,0             , 1,"Show sectornumbers only"       ,"Show values in the list with sector numbers in the most compact format      ");
TXSitem(s3l4,DFSC_COMPACT ,0,0             , 1,"Compact show list, numeric "   ,"Show values in the list with sector numbers in a default compact format     ");
TXSitem(s3l5,DFSC_VERBOSE ,0,0             , 1,"Verbose show list, contents"   ,"Show contents of the sectors in the list in verbose-data or filename format ");
TXSitem(s3la,DFSC_LISTIDS ,0,0             , 1,"Allocation and SLT identify"   ,"Show allocation status, path+filename/sectortype + related info from the SLT");
TXSitem(s3lc,DFSC_LISTFSC ,0,0             , 1,"FS-mode aware list 1-liners"   ,"Show list with sector numbers as 1-liners, using a recorded filesystem-mode ");
TXSitem(s3lv,DFSC_LISTFSV ,0,0             , 0,"FS-mode aware list contents"   ,"Show contents of the sectors in the list, using a recorded filesystem-mode  ");
TXSitem(s3ls,DFSC_SLT2LST ,0,0             , 0,"SLT errors to sector-list"     ,"Copy sectors marked with errors in the SLT, to the sector-list for analysis ");
static TXS_ITEM *s3l[] =
{
   &s3l1, &s3l2, &s3l0, &mmsp,
   &s3l3, &s3l4, &mmxl, &s3l5, &s3la, &mmsp,
   &s3lc, &s3lv, &mmsp,
   &mmrf, &mmsp, &mmwl, &mmsp,
   &s3ls
};
TXSlist(dfss3l,18,18,s3l);

TXSitem(mm31,DFSC_SCAN_RO ,0,0             , 0,"Bad-sector scan, read only"    ,"Scan for bad-sectors using Read-Only (fast); It shows the disk-speed as well");
TXSitem(mm32,DFSC_SCAN_RW ,0,0             , 0,"Full read/write/verify Scan"   ,"Scan for bad-sectors using Read/Invert/Write/R/I/W, NON-DESTRUCTIVE but slow");
TXSsubm(mm3a,DFSC_WIPING  ,&dfss3a,0,0     , 1,"Erase, wipe selected areas   ","Erase or wipe selected object, freespace areas or unused filesystem sectors ");
TXSsubm(mm3f,DFSC_FORMAT  ,&dfss3f,0,0     , 1,"Format with FAT filesystem   ","FORMAT a partition to be selected from a list, selecting options in a dialog");
TXSsubm(mm3r,DFSC_RESIZIN ,&dfss3r,0,0     , 0,"Resize partition and FS      ","Resize partition (-tables) and the filesystem structures in that partition  ");
TXSsubm(mm3m,DFSC_MOVECOP ,&dfss3m,0,0     , 1,"Move or Copy a partition     ","Move or Copy the CURRENT open partition; You MUST select a partition first! ");
TXSsubm(mm35,DFSC_CLONING ,&dfss35,0,0     , 1,"Clone or Compare objects     ","Clone or compare an object to the CURRENT open or another selected object   ");
TXSsubm(mm3l,DFSC_SECLIST ,&dfss3l,0,0     ,17,"File and sector List         ","Operate on the list of files/sectors, including display and file-recovery   ");
static TXS_ITEM *mm3[] =
{
   &mmxp, &mmxb, &mmsp,
   &mm31, &mm32, &mmsp,
   &mm3a, &mm3f, &mmsp,
   &mm3r, &mmsp,
   &mm3m, &mm35, &mmsp,
   &mm3l
};
TXSlist(dfsmm3,15,15,mm3);

// BASIC version of the above pull-down menu
TXSsubm(b3f1,DFSC_FMTFAT  ,0,DFSB_FMTFAT ,0, 1,"Format partition as FAT(32)  ","FORMAT a partition to an EMPTY FAT or FAT32 filesystem   (all data is LOST!)");
TXSitem(b351,DFSC_CLDDISK ,0,0             , 1,"Clone Disk to Disk         ...","Clone a to-be-selected Disk to another to-be-selected Disk (copy whole disk)");
TXSitem(b352,DFSC_CLPPART ,0,0             , 7,"Clone Partition to other P ...","Clone a to-be-selected Partition to another to-be-selected Partition, backup");
static TXS_ITEM *mb3[] =
{
   &mmxp, &mmxb, &mmsp,
   &mm31, &mm32, &mmsp,
   &s3a1, &b3f1, &mmsp,
   &mm3r, &mmsp,
   &s3m1, &mmsp,
   &b351, &b352,
};
TXSlist(dfsmb3,15,15,mb3);

//============================  IMAGE  =============================================================================

TXSitem(s491,DFSC_SIMDISK ,0,0             , 8,"from a Disk"                   ,"Create RAW or Compressed imagefile from current or to-be-selected Disk      ");
TXSitem(s492,DFSC_SIMPART ,0,0             , 8,"from a Partition"              ,"Create RAW or Compressed imagefile from current or to-be-selected Partition ");
#if defined (UNIX)
TXSitem(s493,DFSC_SIMVOL  ,0,0             , 8,"from a Device (diskette)"      ,"Create RAW or Compressed imagefile from current or to-be-selected Device    ");
#else
TXSitem(s493,DFSC_SIMVOL  ,0,0             , 8,"from a Volume (diskette)"      ,"Create RAW or Compressed imagefile from current or to-be-selected Volume    ");
#endif
TXSitem(s494,DFSC_SIMCUR  ,0,0             , 6,"from Current object"           ,"Create RAW or Compressed imagefile from currently opened object, of any type");
TXSitem(s495,DFSC_RAW2IMZ ,0,0             , 1,"IMZ from a  RAW imagefile"     ,"Create IMZ compressed imagefile from an existing RAW image (.IMG, .HDD etc) ");
TXSitem(s496,DFSC_IMZ2RAW ,0,0             , 1,"RAW from an IMZ imagefile"     ,"Create RAW uncompressed imagefile from an existing IMZ compressed image     ");
static TXS_ITEM *s49[] =
{
   &s491, &s492, &s493, &mmsp,
   &s494, &mmsp,
   &s495, &s496
};
TXSlist(dfss49,8,8,s49);
TXSlist(dfsb49,2,2,s49);                //- Basic version of the same submenu (just 2 entries)

TXSitem(s4w1,DFSC_WRIDISK ,0,0             , 6,"to a Disk"                     ,"Restore RAW or Compressed imagefile to current or to-be-selected Disk       ");
TXSitem(s4w2,DFSC_WRIPART ,0,0             , 6,"to a Partition"                ,"Restore RAW or Compressed imagefile to current or to-be-selected Partition  ");
TXSitem(s4w3,DFSC_WRIVOL  ,0,0             , 6,"to a Volume (diskette)"        ,"Restore RAW or Compressed imagefile to current or to-be-selected Volume     ");
TXSitem(s4w4,DFSC_WRICUR  ,0,0             , 4,"to Current object"             ,"Restore RAW or Compressed imagefile to currently opened object, of any type ");
static TXS_ITEM *s4w[] =
{
   &s4w1, &s4w2, &s4w3, &mmsp,
   &s4w4
};
TXSlist(dfss4w,5,5,s4w);
TXSlist(dfsb4w,2,2,s4w);                //- Basic version of the same submenu (just 2 entries)

//- Attaching of IMAGE type objects (Partial copy of File -> Attach ...)
static TXS_ITEM *s4m[] = {&s1m4, &s1m5, &s1m6};
TXSlist(dfss4m,3,3,s4m);

TXSsubm(mm4m,DFSC_ATTACH  ,&dfss4m,0,0     , 1,"Attach Image-file as a disk   ","Attach TO DFSee disk-list, media like a RAW, Compressed or MemDisk diskimage");

TXSitem(mm4z,DFSC_IMZBRS  ,0,0             , 1,"Browse IMZ compressed image ...","Open a compressed (IMZ) image, and start BROWSE for file viewing or copying ");
TXSitem(mm4o,DFSC_OIMAG   ,0,0             , 1,"Open dsk/part/ISO imagefile ...","Open IMZ, RAW or ISO imagefile for analysis and browsing only, no restore!  ");
TXSsubm(mm49,DFSC_IMAGING ,&dfss49,0,0     , 1,"Create new imagefile(s)       ","Save RAW or compressed IMAGE-files, incl. size-limited files/removable media");
TXSsubm(mm4w,DFSC_WRIMAGE ,&dfss4w,0,0     , 1,"Restore/Compare imagefile(s)  ","Restore or Compare/Verify imagefiles to current or to-be-selected object    ");
TXSitem(mm4v,DFSC_VERIFIM ,0,0             , 1,"Verify compressed image     ...","Verify the integrity of a (DFSee) compressed imagefile with verbose report  ");
TXSitem(mm4i,DFSC_IMZINF  ,0,0             , 1,"Show info for an  image     ...","Show embedded header information for an IMZ compressed image, or size of RAW");
TXSitem(mm4x,DFSC_VDIBRS  ,0,0             , 8,"Open a VDI (VBox) diskimage ...","Open a VirtualBox (VDI) image, creating a new DISK, or add snapshot to DISK ");
static TXS_ITEM *mm4[] =
{
   &mm4z, &mmsp,
   &mm4o, &mmsp,
   &mm49, &mm4w, &mm4v, &mm4i, &mmsp,
   &mm4m
};
TXSlist(dfsmm4,10,10,mm4);

// BASIC version of the above pull-down menu
TXSsubm(mb49,DFSC_IMAGING ,&dfsb49,0,0     , 1,"Create new imagefile(s)      ","Save disk/partition contents to compressed IMAGE-files, supports removables ");
TXSsubm(mb4w,DFSC_WRIMAGE ,&dfsb4w,0,0     , 1,"Restore    imagefile(s)      ","Restore (or Compare/Verify) compressed imagefiles to a disk or partition    ");
static TXS_ITEM *mb4[] =
{
   &mm4z, &mmsp,
   &mm4o, &mmsp,
   &mb49, &mb4w, &mm4i, &mmsp,
   &mm4x
};
TXSlist(dfsmb4,9,9,mb4);

//============================  DISPLAY  ===========================================================================

TXSitem(s541,DFSC_PARTEXT ,0,0             , 6,"Part extended view"            ,"Compact table with partitions and ext-containers               (part -r -e )");
#if defined (UNIX)
TXSitem(s54d,DFSC_PARTALT ,0,0             , 6,"Part labeled  view   s-F5"     ,"Compact table with labels, format info and size                (part -b-   )");
#else
TXSitem(s54d,DFSC_PARTALT ,0,0             , 6,"Part decimal  view   s-F5"     ,"Compact table with decimal cylinders, begin/end/size           (part -b:1  )");
#endif
TXSitem(s542,DFSC_PARTNUM ,0,0             , 6,"Part numeric  view   a-F5"     ,"Compact table with partitions, numeric cyls/sizes      94 cols (part -n    )");
TXSitem(s543,DFSC_PARTNEX ,0,0             , 6,"Part combined view   c-F5"     ,"Compact table with numeric info plus ext-containers    94 cols (part -n -e )");
TXSitem(s54s,DFSC_PARTCSP ,0,0             , 1,"Part complete view,  CS  "     ,"One line per partition, many fields, comma separated  242 cols (part -r -s )");
TXSitem(s54w,DFSC_PARTWRN ,0,0             , 1,"ALL warnings, no table   "     ,"Display ALL warnings for all partitions, no table    80 cols (part -w   -t-)");
TXSitem(s54t,DFSC_PARTWNT ,0,0             , 1,"Non-trivial warnings only"     ,"Display non-trivial warnings (major + some minor)    80 cols (part -w:t -t-)");
TXSitem(s544,DFSC_PARTVER ,0,0             , 6,"Part verbose  view"            ,"Verbose list of basic partition info for all partitions        (part -r -v )");
TXSitem(s545,DFSC_PARTALL ,0,0             , 6,"Part allocation view"          ,"Verbose list of partition info, allocation-maps, contents      (part -a -V )");
TXSitem(s547,DFSC_PARTSEC ,0,0             , 6,"Part sector(s) view"           ,"Verbose list of MBR/EBR, PBR, LVM sectors on all partitions (pt * -related )");
TXSitem(s546,DFSC_PARTCHK ,0,0             , 1,"FS-check all partitions"       ,"Perform filesystem check on all partitions, verbose display    (part -r -c )");
static TXS_ITEM *s54[] =
{
   &s541, &s54d, &s542, &s543, &mmsp,
   &s54s, &mmsp,
   &s54w, &s54t, &mmsp,
   &s544, &s545, &s547, &mmsp,
   &s546
};
TXSlist(dfss54,15,15,s54);

TXSitem(mm5i,DFSC_DISKLST ,0,0             , 1,"Disk information list"         ,"Compact, one line per disk, info on size, name, vendor/product and more     ");
TXSitem(mm50,DFSC_DISKMAP ,0,0             , 1,"Partition/Disk overview map"   ,"Compact map display of all partitionable media, showing the partitions      ");
TXSitem(mm51,DFSC_ALLOCMP ,0,0             ,17,"Disk/filesystem Usage"         ,"Screen-size map of disk or filesystem usage, allocated versus freespace info");
TXSitem(mm5g,DFSC_GEOSTAT ,0,0             , 0,"Object Geometry+Status"        ,"Show (disk) geometry for currently opened object, including some status info");
#if defined (UNIX)
#if defined (DARWIN)
TXSitem(mm52,DFSC_VOLUMES ,0,0             , 3,"Device overview"               ,"Show mounted devices using 'df -h -i -m'      (updates submenu DEV list too)");
#else
TXSitem(mm52,DFSC_VOLUMES ,0,0             , 3,"Device overview"               ,"Show mounted devices with 'df' and '/proc/mounts' (updates submenu DEV list)");
#endif
#else
TXSitem(mm52,DFSC_VOLUMES ,0,0             , 1,"Volume overview"               ,"Show list of available volumes/driveletters   (updates submenu VOL list too)");
#endif
TXSitem(mm53,DFSC_PARTSTD ,0,0             , 1,"Partition overview        F5"  ,"Display a compact table with the most important partition information       ");
TXSsubm(mm54,DFSC_PARTSUB ,&dfss54,0,0     , 1,"Other partition views      "  ,"Submenu with several partition views and check-actions on the current object");
TXSitem(mm5b,DFSC_BASEVAL ,0,0             , 1,"Base, LSN first..last"         ,"Show the 'Base' values, corresponding to the first LSN (0) and the last one ");
TXSitem(mm5c,DFSC_STOREVW ,0,0             , 1,"Currently open object(s)"      ,"Show what object (disk/partition ...) is currently open for working with it ");
TXSitem(mm5d,DFSC_PMEDMAP ,0,0             ,15,"Partitionable Media"           ,"Show mapping of DFSee disk-id to Partitionable Media like disks and devices ");
TXSsubm(mm56,DFSC_WALKRAW ,0,DFSB_WALKRAW,0, 0,"Show RAW partition tables  "  ,"List all partition-table info for a disk, in raw format. Walk MBR/EBR or GPT");
TXSsubm(mm5s,DFSC_SECPART ,0,DFSB_SECPART,0, 1,"Sectors for partition      "  ,"Show part-table (MBR/EBR), bootsector (PBR) and LVM-info for one partition  ");
TXSsubm(mm5e,DFSC_EBRPART ,0,DFSB_EBRPART,0,11,"Partition Table sector     "  ,"Show just the partition-table sector (MBR/EBR) for one partition            ");
TXSitem(mm57,DFSC_DISPLSN ,0,0             , 1,"GoTo sector (nr) ...     c-G"  ,"Display sector with specified sectornumber; LSN default 0 (bootsect/MBR)    ");
TXSsubm(mm58,DFSC_DISPSEC ,&dfss58,0,0     , 1,"Related sectors            "  ,"Display some related sectors (up,xtra,next) or 'this' in HEX/ASCII format   ");
TXSitem(mm5r,DFSC_IOSPEED ,0,0             , 0,"I/O speed Read-only"           ,"Measure and display the RAW I/O speed for 10 seconds Read-only access       ");
TXSitem(mm5w,DFSC_IOSPRWR ,0,0             ,16,"I/O speed Read/Write"          ,"Measure and display the RAW I/O speed for 10 seconds Read-Write access      ");
TXSitem(mm5l,DFSC_IOSPLBF ,0,0             , 0,"I/O speed Larger Buffer"       ,"Measure RAW I/O speed using a larger buffer, default for compressed IMAGING ");
static TXS_ITEM *mm5[] =
{
   &mm5i, &mm50, &mm51, &mm5g, &mm52, &mm53, &mm54, &mmsp,
   &mm5b, &mm5c, &mm5d, &mmx5, &mm56, &mm5s, &mm5e, &mmsp,
   &mm57, &mm58, &mmsp,
   &mm5r, &mm5w, &mm5l
};
TXSlist(dfsmm5,22,22,mm5);

// BASIC version of the above pull-down menu
static TXS_ITEM *mb5[] =
{
   &mm5i, &mm50, &mm51, &mm5g, &mm53, &mmsp,
   &mm5s, &mmsp,
   &mm5r, &mm5w, &mm5l
};
TXSlist(dfsmb5,11,11,mb5);

TXSitem(mm7r,DFSC_RUNS    ,0,0             , 1,"Run DFSee script ..."          ,"Run a DFSee script from a '*.DFS' file, like a recovery scenario            ");
#if !defined (DOS32)
TXSsubm(mm7x,DFSC_MPUP64  ,0,DFSB_MPUP64, 0,11,"Make Puppy64 boot (USB) disk ","Create a bootable USB-stick (or disk) with DFSPUP64 64bit UEFI-capable Linux");
TXSsubm(mm7b,DFSC_MPUP32  ,0,DFSB_MPUP32, 0,11,"Make Puppy32 boot (USB) disk ","Create a bootable USB-stick (or disk) with DFSPUP32 32bit BIOS-based   Linux");
TXSsubm(mm7p,DFSC_MPUPPY  ,0,DFSB_MPUPPY, 0, 6,"Make Puppy   boot (USB) disk ","Create a bootable USB-stick (or disk) with DFSPUPPY 32bit BIOS-only    Linux");
TXSsubm(mm7u,DFSC_MUSB32  ,0,DFSB_MUSB32, 0, 6,"Make ISO dualboot (USB) disk ","Create a bootable USB-stick (or disk) multi-ISO with DFSee FreeDOS or Linux ");
TXSsubm(mm73,DFSC_MF32ST  ,0,DFSB_MF32ST, 0, 9,"Make FAT32   Data (USB) disk ","Partition +format USB-stick (or disk) with a FAT32 data partition/filesystem");
TXSsubm(mm76,DFSC_MF16ST  ,0,DFSB_MF16ST, 0, 9,"Make FAT16   Data (USB) disk ","Partition +format USB-stick with FAT16 filesystem (size limited to 2GB max!)");
TXSsubm(mm7i,DFSC_MIFSTD  ,0,DFSB_MIFSTD, 0, 9,"Make 0x07 HPFS/JFS/NTFS disk ","Partition a USB-stick with type 0x07 for HPFS/JFS/NTFS   (excluding FORMAT!)");
TXSsubm(mm7j,DFSC_MJFS35  ,0,DFSB_MJFS35, 0, 9,"Make 0x35 classic JFS   disk ","Partition a USB-stick with type 0x35 for a JFS partition (excluding FORMAT!)");
#endif
TXSsubm(mm7c,DFSC_CHKPART ,0,DFSB_CHKPART,0, 1,"Analyse filesystems  (CHECK) ","Create DFSCHECK analysis files, checking for most filesystem related issues ");
TXSsubm(mm7d,DFSC_DFSDISK ,0,DFSB_DFSDISK,0, 0,"Full Analyse disks (support) ","Create DFSDISK analysis for MISSING  partitions (real SLOW, on request only)");
TXSsubm(mm7f,DFSC_DFSFAST ,0,DFSB_DFSFAST,0, 1,"Fast Analyse disks (support) ","Create DFSFAST analysis for EXISTING partitions (required for email support)");
static TXS_ITEM *mm7[] =
{
   &mm7r, &mmsp,
#if !defined (DOS32)
   &mm7x, &mm7b, &mm7p, &mm7u, &mmsp,
   &mm73, &mm76, &mm7i, &mm7j, &mmsp,
#endif
   &mm7c, &mm7d, &mm7f
};
#if !defined (DOS32)
TXSlist(dfsmm7, 15, 15, mm7);
#else
TXSlist(dfsmm7, 5, 5, mm7);
#endif

// BASIC version of the above pull-down menu
static TXS_ITEM *mb7[] =
{
   &mm7r, &mmsp,
#if !defined (DOS32)
   &mm7x, &mm7b, &mm7p, &mmsp,
   &mm73, &mm76, &mmsp,
#endif
   &mm7c, &mm7d, &mm7f
};
#if !defined (DOS32)
TXSlist(dfsmb7,12,12,mb7);
#else
TXSlist(dfsmb7,5,5,mb7);
#endif

//============================  HELP  ==============================================================================

#if !defined (DOS32)
TXSitem(m9u0,DFSC_DPUP64  ,0,0             ,14,"Get DFSPUP64 UEFI capable IMZ" ,"Download DFSPUP64.IMZ to make a 64-bit UEFI based  Ubuntu 18.04 bootable USB");
TXSitem(m9u1,DFSC_DPUP32  ,0,0             ,14,"Get DFSPUP32 BIOS based   IMZ" ,"Download DFSPUP32.IMZ to make a 32-bit BIOS based  Ubuntu 18.04 bootable USB");
TXSitem(m9u2,DFSC_DPUPPY  ,0,0             , 0,"Get DFSPUPPY BIOS-only    IMZ" ,"Download DFSPUPPY.IMZ to make a 32-bit BIOS-ONLY   Slacko 6.3.2 bootable USB");
TXSitem(m9u3,DFSC_INSTAL  ,0,0             , 1,"Install DFSee program update"  ,"Install a downloaded or copied dfsee_install.zip from the install-directory ");
TXSitem(m9u4,DFSC_DSTABL  ,0,0             ,12,"Get latest STABLE update"      ,"Download the latest STABLE release  to the install-directory, and INSTALL it");
TXSitem(m9u5,DFSC_DEXPER  ,0,0             ,12,"Get latest Experimental/Beta"  ,"Download latest EXPERIMENTAL / BETA to the install-directory, and INSTALL it");
static TXS_ITEM *m9u[] =
{
   &m9u0, &m9u1, &m9u2, &mmsp,
   &m9u3, &mmsp,
   &m9u4, &m9u5
};
TXSlist(dfsm9u,8,8,m9u);
#endif

TXSitem(m9g1,DFSC_H_KEYBD ,0,0             , 1,"Keyboard usage, overviews"     ,"Select an item from the list to get Keyboard usage help for that module     ");
TXSitem(m9g2,DFSC_H_MOUSE ,0,0             , 1,"Mouse    usage, overviews"     ,"Select an item from the list to get Mouse    usage help for that module     ");
TXSitem(m9g3,DFSC_H_CLIPB ,0,0             , 1,"Clipboard, all references"     ,"Select an item from the list to get Clipboard infomation from any help file ");
TXSitem(m9g4,DFSC_H_MENUS ,0,0             , 6,"Menu Pull-down references"     ,"Select an item from the list to get Menu pull-down info  from any help file ");
static TXS_ITEM *m9g[] =
{
   &m9g1, &m9g2, &m9g3, &m9g4
};
TXSlist(dfsm9g,4,4,m9g);

TXSitem(m9c1,DFSC_UIHELP  ,0,0             , 1,"Command entry and text output" ,"Help on the DFSee application use of the commandline and text output window ");
TXSitem(m9c2,DFSC_OPTHELP ,0,0             ,19,"DFSee   command   Options"     ,"Descriptions for the generic command options that work for ANY command      ");
TXSitem(m9c3,DFSC_CMDHELP ,0,0             , 1,"DFSee   generic   commands"    ,"Descriptions for the generic DFSee commands that work for every FS (mode=..)");
TXSitem(m9c4,DFSC_TXCHELP ,0,0             , 1,"TXlib   generic   commands"    ,"Descriptions for the standard TX library commands, mainly user interface    ");
TXSitem(m9c5,DFSC_FS_HELP ,0,0             , 1,"Mode=FS specific  commands"    ,"Descriptions for the current filesystem (mode=..) with specific commands    ");
TXSitem(m9c7,DFSC_SW_HELP ,0,0             ,19,"Startup switches, Application" ,"Descriptions for executable startup switches, DFSee application specific    ");
TXSitem(m9c8,DFSC_TXSHELP ,0,0             ,19,"Startup switches, UI library"  ,"Descriptions for executable startup switches, TxWin UI library specific     ");
static TXS_ITEM *m9c[] =
{
   &m9c1, &mmsp,
   &m9c2, &m9c3, &m9c4, &m9c5, &mmsp,
   &m9c7, &m9c8
};
TXSlist(dfsm9c,9,9,m9c);

TXSitem(m9s1,DFSC_HS_RUNU ,0,0             , 1,"Usage on script RUN command"   ,"Shows the details on the 'run' command with parameters and option switches  ");
TXSitem(m9s2,DFSC_HSYNTAX ,0,0             , 8,"Script Syntax and parameters"  ,"Help on script Syntax, control structures, operators, pragmas and functions ");
TXSitem(m9s3,DFSC_HS_VARS ,0,0             , 8,"Script Variables/constants"    ,"Help on script variables and constants, incl. DFSee specific host variables ");
static TXS_ITEM *m9s[] =
{
   &m9s1, &m9s2, &m9s3
};
TXSlist(dfsm9s,3,3,m9s);


TXSsubm(mm9g,DFSC_PREGREP ,&dfsm9g,0,0     , 1,"User Interface, kbd, mouse  " ,"Present HELP item-list for one of several user-interface aspects            ");
TXSsubm(mm9c,DFSC_CMDLINE ,&dfsm9c,0,0     , 1,"Command overviews and usage " ,"Overviews of most commands, and usage for the commandline and output window ");
TXSitem(mm93,DFSC_ST_MODE ,0,0             , 8,"Sector Types      recognized"  ,"Overview for all generic plus the current filesystem-specific sector types  ");
TXSitem(mm9p,DFSC_PT_HELP ,0,0             , 0,"Partition Types   recognized"  ,"Overview of common partition types recognized by DFSee, incl. symbolic names");
TXSsubm(mm9s,DFSC_HSCRIPT ,&dfsm9s,0,0     , 1,"Script language information " ,"Infomation on the TXScript language syntax and the DFSee specific variables ");
TXSitem(mm97,DFSC_H_SECTS ,0,0             , 1,"Select from all help sections" ,"Present list of builtin or loaded help-sections to select from, for reading.");
TXSitem(mm98,DFSC_H_GREP  ,0,0             ,17,"Find a phrase  (Grep) in help" ,"Present help 'find' dialog to specify a phrase to search the help texts for.");
TXSitem(mm9l,DFSC_H_LOAD  ,0,0             , 1,"Load additional Help file"     ,"Select a file with additional help information, and load it as help section.");
#if !defined (DOS32)
TXSsubm(mm9u,DFSC_UPDATE  ,&dfsm9u,0,0     , 1,"Program Updates / Downloads " ,"Install program update, download stable/experimental updates or DFSPUPPY.IMZ");
#else
TXSsubm(mm9u,DFSC_UPDATE  ,NULL   ,0,0     , 1,"Program Updates / Downloads " ,"DISABLED: Install program update/download NON FUNCTIONAL ON THE DOS VERSION!");
#endif
TXSitem(mm96,DFSC_ABOUT   ,0,0             , 1,"About ...                s-F4" ,"Show DFSee program version details and copyright notices for used components");
static TXS_ITEM *mm9[] =
{
   &mm9g, &mm9c, &mmsp,
   &mm93, &mm9p, &mmsp,
   &mm9s, &mmsp,
   &mm97, &mm98, &mm9l, &mmsp,
   &mm9u,
   &mm96
};
TXSlist(dfsmm9,14,14,mm9);

// BASIC version of the above pull-down menu
static TXS_ITEM *mb9[] =
{
   &mm9g, &mm9c, &mmsp,
   &mm93, &mmsp,
   &mm97, &mm98, &mmsp,
   &mm9u,
   &mm96
};
TXSlist(dfsmb9,10,10,mb9);

//============================  Mode=HPFS  =========================================================================

TXSitem(shh1,DFSC_HFINDD  ,0,0             , 8,"Search Deleted files  => list" ,"Search for deleted files anywhere (SLOW),    'Recover from list' is UNDELETE");
TXSitem(shha,DFSC_HFINDA  ,0,0             , 8,"Search Any/all files  => list" ,"Search for deleted/non-deleted files anywhere    (SLOW),   for 'Recover ...'");
TXSitem(shh2,DFSC_HFINDF  ,0,0             , 8,"Search Normal  files  => list" ,"Search non-deleted files in existing directories (FAST),   for 'Recover ...'");
static TXS_ITEM *shr[] =
{
   &mmxu, &mmsp,
   &shh1, &shha, &shh2, &mmsp,
   &mmxb, &mmlf, &mmrf, &mmsp,
   &mmrs, &mmfp, &mmof, &mmsp,
   &mmh1, &mmh2
};
TXSlist(dfsshr,16,16,shr);

TXSitem(shb1,DFSC_HFIXBO  ,0,0             , 5,"Fix Bootsector, no I13X check" ,"Fix bootsector; No  explicit I13X check, works with bootmanagers like GRUB  ");
TXSitem(shb2,DFSC_HFIXBI  ,0,0             , 1,"Fix Bootsector, explicit I13X" ,"Fix bootsector; Use explicit I13X check, requires I13X capable MBR and BMGR!");
TXSitem(shb3,DFSC_IHPLDR  ,0,0             , 1,"Create  HPFS LDR imagefile"    ,"Create compressed imagefile with the HPFS LDR sectors for this partition    ");
TXSitem(shb4,DFSC_RHPLDR  ,0,0             , 1,"Restore HPFS LDR imagefile"    ,"Restore imagefile with a 'known good' HPFS LDR to current partition         ");
static TXS_ITEM *shb[] =
{
   &shb1, &shb2, &mmsp,
   &mmfz, &mmsp,
   &shb3, &shb4, &mmsp,
   &mmhs
};
TXSlist(dfsshb,9,9,shb);

TXSitem(shf1,DFSC_HFINDR  ,0,0             , 6,"Find Root directory"           ,"Find the sector containing the FNODE for the root directory                 ");
TXSitem(shf2,DFSC_HFIXSU  ,0,0             , 6,"Fix  Superblock values"        ,"Update superblock using found rootdirectory location and partition-info     ");
TXSitem(shf3,DFSC_HFINDC  ,0,0             , 6,"Find Codepage info"            ,"Find the sector containing the codepage information and data                ");
TXSitem(shf4,DFSC_HFIXSP  ,0,0             , 7,"Fix  spareblock values"        ,"Update spareblock using found codepage LSN and superblock values            ");
static TXS_ITEM *shf[] =
{
   &shf1, &shf2, &mmsp,
   &shf3, &shf4
};
TXSlist(dfsshf,5,5,shf);

TXSitem(mmho,DFSC_HVLABEL ,0,0             , 0,"Set Standard Volume Label"     ,"Display/Edit the standard 11-character label located in the bootsector      ");
TXSitem(mmh8,DFSC_HCLEAN  ,0,0             ,17,"Set HPFS status Clean"         ,"Update spareblock status flags to indicate filesystem is CLEAN              ");
TXSitem(mmh9,DFSC_HDIRTY  ,0,0             ,17,"Set HPFS status Dirty"         ,"Update spareblock status flags to indicate filesystem is DIRTY              ");
static TXS_ITEM *shs[] =
{
   &mmho, &mmvs, &mmsp,
   &mmh8, &mmh9
};
TXSlist(dfsshs,5,5,shs);

TXSsubm(mmhr,DFSC_HRECOV  ,&dfsshr,0,0     , 0,"File Find/Recover/HEXedit "   ,"Find deleted/normal files, list and possibly recover them. HEX edit dir/file");
TXSsubm(mmhv,DFSC_HVOLUM  ,&dfsshs,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label, Serial-nr and dirty/clean status       ");
TXSsubm(mmhb,DFSC_HBOOTF  ,&dfsshb,0,0     , 1,"Boot area fixes/updates   "   ,"Fix bootsector, HiddenSectors/GEO, and HPFS LDR imaging and fixing          ");
TXSsubm(mmhf,DFSC_HSYSTF  ,&dfsshf,0,0     , 1,"FS structural fixes       "   ,"Find and Fix some of the HPFS specific filesystem structures                ");
TXSitem(mmhd,DFSC_HSYSDMP ,0,0             , 1,"Dump FS area to file  ..."     ,"Dump the HPFS super/spare, codepage etc to a file for analysis by support   ");
TXSitem(mmha,DFSC_XCHECK  ,0,0             , 1,"Analyse HPFS filesystem"       ,"Check filesystem for inconsistencies and errors (Readonly, no fixing!)      ");
static TXS_ITEM *mmh[] =
{
   &mmal, &mmhr, &mmsp,
   &mmhv, &mmhb, &mmsp,
   &mmrb, &mmsp,
   &mmhf, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmhd, &mmsp,
   &mmsb, &mmha, &mslt, &mmsp,
   &mmxr
};
TXSlist(dfsmmh,20,20,mmh);
TXSmenu(dfsmh,&dfsmmh,DFSM_MENUBAR,0, 1,'m'," Mode=HPFS ",
        "Menu: [OS/2 and eCS High Performance File System]  "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbh[] =
{
   &mmal, &mmsp,
   &mmho, &mmvs, &mmsp,
   &shb1, &mmhs, &mmsp,
   &mmrb, &mmsp,
   &mmh8, &mmh9, &mmsp,
   &mmsb, &mmha, &mmsp,
   &mmxr
};
TXSlist(dfsmbh,17,17,mbh);
TXSmenu(dfsbh,&dfsmbh,DFSM_MENUBAR,0, 1,'m'," Mode=HPFS ",
        "Menu: [OS/2 and eCS High Performance File System]  "
        "   Enter=menu Esc=commandline");

//============================  Mode=NTFS  =========================================================================

TXSitem(shn1,DFSC_NFINDD  ,0,0             , 8,"Search Deleted files  => list" ,"Search MFT records for deleted files, 'Recover from list' will UNDELETE them");
TXSitem(shna,DFSC_NFINDA  ,0,0             , 9,"Search Any/all files  => list" ,"Search MFT records for deleted or non-deleted files, for 'Recover from list'");
TXSitem(shn2,DFSC_NFINDF  ,0,0             , 8,"Search Normal  files  => list" ,"Search MFT area for records for non-deleted files, for 'Recover from list'  ");
static TXS_ITEM *snr[] =
{
   &mmxu, &mmsp,
   &shn1, &shna, &shn2, &mmsp,
   &mmxb, &mmlf, &mmrf, &mmsp,
   &mmrs, &mmfp, &mmof, &mmsp,
   &mmh1, &mmh2
};
TXSlist(dfssnr,16,16,snr);

TXSitem(snb1,DFSC_NFIXBOS ,0,0             , 1,"Fix  Bootsector from SPARE"    ,"Fix bootsector by replacing it by the the spare-one, when found at end      ");
TXSitem(snbf,DFSC_NFNDMFT ,0,0             , 6,"Find MFT area for Fix Boot.."  ,"Find MFT area needed by Fixboot (non-SPARE) by locating the $AttrDef record ");
TXSitem(snbv,DFSC_NFIXBOV ,0,0             , 6,"Fix  Bootsector, for W7/8/10"  ,"Fix bootsector by creating a new one using Windows-7/8/10 template code     ");
TXSitem(snbx,DFSC_NFIXBOX ,0,0             , 0,"Fix  Bootsector, for   NT/XP"  ,"Fix bootsector by creating a new one using Windows-NT/XP  template code     ");
TXSitem(snb2,DFSC_NTLDRF  ,0,0             , 0,"Fix 1st NTLDR sector   NT/XP"  ,"Fix first NTLDR sectory, directly after the bootsector, using a builtin copy");
TXSitem(snb3,DFSC_NTLDRV  ,0,0             , 9,"Fix 1st NTLDR sector W7/8/10"  ,"Fix first NTLDR sectory, with Vista/Win7/Win8 'BOOTMGR' using a builtin copy");
TXSitem(snb4,DFSC_INTLDR  ,0,0             , 1,"Create  NTLDR imagefile"       ,"Create compressed imagefile with the NTLDR sectors for this partition       ");
TXSitem(snb5,DFSC_RNTLDR  ,0,0             , 1,"Restore NTLDR imagefile"       ,"Restore imagefile with a 'known good' NTLDR to current partition            ");
static TXS_ITEM *snb[] =
{
   &snb1, &mmsp,
   &snbf, &snbv, &snbx, &mmsp,
   &mmfz, &mmsp,
   &snb2, &snb3, &snb4, &snb5, &mmsp,
   &mmid, &mmif, &mmsp,
   &mmhs
};
TXSlist(dfssnb,17,17,snb);

TXSitem(sn5x,DFSC_NDMFTR  ,0,0             ,11,"Specified MFT number ..."      ,"Display any MFT record, by specifying the MFT-index (record number)         ");
TXSitem(sn50,DFSC_MFTNR0  ,0,0             , 1,"0 - $MFT, Master File Table"   ,"$MFT     special file, Master File Table itself, full allocation            ");
TXSitem(sn51,DFSC_MFTNR1  ,0,0             , 1,"1 - $MFTMirr, Backup table"    ,"$MFTMirr special file, Master File Table, duplicate, first 4 records only   ");
TXSitem(sn52,DFSC_MFTNR2  ,0,0             , 1,"2 - $LogFile, Journal file"    ,"$LogFile special file, the NTFS transaction log, used in CHKDSK recovery    ");
TXSitem(sn53,DFSC_MFTNR3  ,0,0             , 1,"3 - $Volume,  Volume info"     ,"$Volume  special file, holds the volume LABEL and NTFS version information  ");
TXSitem(sn54,DFSC_MFTNR4  ,0,0             , 1,"4 - $AttrDef, Attributes"      ,"$AttrDef special file, holds a list of supported attributes for the volume  ");
TXSitem(sn55,DFSC_MFTNR5  ,0,0             , 1,"5 -    \\      Root directory" ,"RootDir, main index to the volumes regular files and directories            ");
TXSitem(sn56,DFSC_MFTNR6  ,0,0             , 1,"6 - $Bitmap,  Allocation map"  ,"$Bitmap  special file, cluster-level allocation information; used/un-used   ");
TXSitem(sn57,DFSC_MFTNR7  ,0,0             , 1,"7 - $Boot,    Boot + NTLDR"    ,"$Boot    special file, Boot sector plus 1st stage of the NTLDR (15 sectors) ");
TXSitem(sn58,DFSC_MFTNR8  ,0,0             , 1,"8 - $BadClus  Bad clusters"    ,"$BadClus special file, Bad Cluster list using SPARSE file, non-sparse == BAD");
TXSitem(sn59,DFSC_MFTNR9  ,0,0             , 1,"9 - $Secure   Security info"   ,"$Secure  special file, index to centralized security info for the volume    ");
TXSitem(sn5a,DFSC_MFTNRA  ,0,0             , 1,"a - $UpCase   Collating/Sort"  ,"$UpCase  special file, table of uppercase characters used for collating/sort");
TXSitem(sn5b,DFSC_MFTNRB  ,0,0             , 1,"b - $Extend   NTFS 3.0 extras" ,"$Extend  special file, index to more special files: $ObjId, $Quota, $Reparse");
static TXS_ITEM *sn5[] =
{
   &sn5x, &mmsp,
   &sn50, &sn51, &sn52, &sn53, &sn54, &mmsp,
   &sn55, &mmsp,
   &sn56, &sn57, &sn58, &sn59, &sn5a, &sn5b
};
TXSlist(dfssn5,16,16,sn5);

TXSitem(mmno,DFSC_NVLABEL ,0,0             , 0,"Set Standard Volume Label"     ,"Display/Edit the 32-character volume label located in the $Volume MFT record");
TXSitem(mmn8,DFSC_NCLEAN  ,0,0             ,15,"Set FS status Normal"          ,"Update $Volume special file flags to indicate filesystem is in NORMAL state ");
TXSitem(mmn9,DFSC_NDIRTY  ,0,0             ,15,"Set FS status Dirty"           ,"Update $Volume special file flags to indicate filesystem needs CHKDSK to run");
static TXS_ITEM *sns[] =
{
   &mmno, &mmvs, &mmsp,
   &mmn8, &mmn9
};
TXSlist(dfssns,5,5,sns);

TXSsubm(mmnr,DFSC_NRECOV  ,&dfssnr,0,0     , 0,"File Find/Recover/HEXedit "   ,"Find deleted/normal files, list and possibly recover them. HEX edit dir/file");
TXSsubm(mmns,DFSC_NVOLUM  ,&dfssns,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label, Serial-nr and dirty/clean status       ");
TXSsubm(mmnb,DFSC_NBOOTF  ,&dfssnb,0,0     , 1,"Boot area fixes/updates   "   ,"Fix bootsector, HiddenSectors/GEO, BOOT.INI and NTLDR imaging and fixing    ");
TXSitem(mmn3,DFSC_NFINDR  ,0,0             , 0,"Find Root directory"           ,"Find the MFT record for the root directory                                  ");
TXSsubm(mmn5,DFSC_NDMFTC  ,&dfssn5,0,0     , 9,"Display an MFT record     "   ,"Display MFT record for specified MFT-index or a selected special file $xxx  ");
TXSitem(mmn6,DFSC_NMFTDMP ,0,0             , 1,"Dump MFT records to file"      ,"Dump the system MFT records to an imagefile for later analysis by support   ");
TXSitem(mmna,DFSC_XCHECK  ,0,0             , 1,"Analyse NTFS filesystem"       ,"Check filesystem for inconsistencies and errors (Readonly, no fixing!)      ");
static TXS_ITEM *mmn[] =
{
   &mmal, &mmnr, &mmsp,
   &mmns, &mmnb, &mmrb, &mmsp,
   &mmn3, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmn5, &mmn6, &mmsp,
   &mmna, &mslt, &mmsp,
   &mmxr
};
TXSlist(dfsmmn,19,19,mmn);
TXSmenu(dfsmn,&dfsmmn,DFSM_MENUBAR,0, 1,'m'," Mode=NTFS ",
        "Menu: [Windows-NT/W2K/XP/W7/W8 native File System] "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbn[] =
{
   &mmal, &mmsp,
   &mmno, &mmvs, &mmsp,
   &snb1, &mmif, &mmhs, &mmsp,
   &mmrb, &mmsp,
   &mmn8, &mmn9, &mmsp,
   &mmna, &mmsp,
   &mmxr
};
TXSlist(dfsmbn,17,17,mbn);
TXSmenu(dfsbn,&dfsmbn,DFSM_MENUBAR,0, 1,'m'," Mode=NTFS ",
        "Menu: [Windows-NT/W2K/XP/W7/W8 native File System] "
        "   Enter=menu Esc=commandline");


//============================  Mode=FATx  =========================================================================

TXSitem(sfb1,DFSC_FFIXBO  ,0,0             , 9,"Fix the Bootsector"            ,"Fix bootsector by replacing from spare (FAT32) or create new                ");
static TXS_ITEM *sfb[] =
{
   &sfb1, &mmsp,
   &mmfz, &mmsp,
   &mmid, &mmif, &mmsp,
   &mmhs
};
TXSlist(dfssfb, 8, 8,sfb);

TXSitem(sffs,DFSC_FFINDS  ,0,0             , 0,"Find sub-directories  => list" ,"Search data area for any sub-directory sectors with the '..' entry          ");
TXSitem(sffr,DFSC_FFSUBS  ,0,0             , 1,"Find subdirs in  ROOT => list" ,"Search data area for subdirs with '..' entry cluster 0 => subdir from ROOT  ");
TXSitem(sffn,DFSC_FFSUBD  ,0,0             , 0,"Find subdirs non ROOT => list" ,"Search data area for subdirs with '..' entry non-zero, => subdir, non ROOT  ");
TXSitem(sff1,DFSC_FFINDD  ,0,0             , 8,"Search Deleted files  => list" ,"Search DIR SPACE for deleted files ('Recover from list' NOT POSSIBLE YET)   ");
TXSitem(sff2,DFSC_FFINDF  ,0,0             , 8,"Search Normal  files  => list" ,"Search all directory SPACE for non-deleted files, for 'Recover from list'   ");
static TXS_ITEM *sfr[] =
{
   &sffs, &sffr, &sffn, &mmsp,
   &sff1, &sff2, &mmsp,
   &mmxb, &mmlf, &mmrf, &mmsp,
   &mmfp, &mmof, &mmsp,
   &mmh1, &mmh2
};
TXSlist(dfssfr,16,16,sfr);

TXSitem(mmfo,DFSC_FVLABEL ,0,0             , 0,"Set Standard Volume Label"     ,"Display/Edit the standard 11-character label (in bootsector and ROOT DIR)   ");
TXSitem(mmf8,DFSC_FCLEAN  ,0,0             ,16,"Set FAT status Clean"          ,"Update FAT status field in the bootsector to indicate filesystem is CLEAN   ");
TXSitem(mmf9,DFSC_FDIRTY  ,0,0             ,16,"Set FAT status Dirty"          ,"Update FAT status field in the bootsector to indicate filesystem is DIRTY   ");
static TXS_ITEM *sfs[] =
{
   &mmfo, &mmvs, &mmsp,
   &mmf8, &mmf9
};
TXSlist(dfssfs,5,5,sfs);

TXSsubm(mmfr,DFSC_FRECOV  ,&dfssfr,0,0     , 0,"File Find/Recover/HEXedit "   ,"Find deleted/normal files, list and possibly recover them. HEX edit dir/file");
TXSsubm(mmfs,DFSC_FVOLUM  ,&dfssfs,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label, Serial-nr and dirty/clean status       ");
TXSitem(mmf3,DFSC_FFINDR  ,0,0             ,17,"Find FAT32 Root directory"     ,"Find and list possible FAT32 Rootdirectory clusters/sectors                 ");
TXSsubm(mmfb,DFSC_FBOOTF  ,&dfssfb,0,0     , 1,"Boot area fixes/updates   "   ,"Fix bootsector, HiddenSectors/GEO, BOOT.INI and NTLDR imaging and fixing    ");
TXSitem(mmfa,DFSC_XCHECK  ,0,0             , 1,"Analyse FAT filesystem"        ,"Check filesystem for inconsistencies and errors (Readonly, no fixing!)      ");
static TXS_ITEM *mmf[] =
{
   &mmal, &mmfr, &mmsp,
   &mmfs, &mmfb, &mmrb, &mmsp,
   &mmf3, &mmsp,
   &mmta, &mmtd, &mmf8, &mmf9, &mmsp,
   &mmfa, &mslt, &mmsp,
   &mmxr
};
TXSlist(dfsmmf,18,18,mmf);
TXSmenu(dfsmf,&dfsmmf,DFSM_MENUBAR,0, 1,'m'," Mode=FAT ",
        "Menu: [Generic FAT12/FAT16/FAT32 File System]      "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbf[] =
{
   &mmal, &mmsp,
   &mmfo, &mmvs, &mmsp,
   &sfb1, &mmhs, &mmsp,
   &mmrb, &mmsp,
   &mmf8, &mmf9, &mmsp,
   &mmfa, &mmsp,
   &mmxr
};
TXSlist(dfsmbf,16,16,mbf);
TXSmenu(dfsbf,&dfsmbf,DFSM_MENUBAR,0, 1,'m'," Mode=FAT ",
        "Menu: [Generic FAT12/FAT16/FAT32 File System]      "
        "   Enter=menu Esc=commandline");


//============================  Mode=EFAT   ========================================================================

TXSitem(syb1,DFSC_YFIXBO  ,0,0             , 1,"Fix Bootsector from Spare"     ,"Fix bootsector area (LSN 0..11) by replacing it from spare area (LSN 12..23)");
TXSitem(syb2,DFSC_YCRCBO  ,0,0             ,16,"Fix Bootsector CRC and Sync"   ,"Fix CRC for bootsector area (LSN 0..11) then sync to spare area (LSN 12..23)");
static TXS_ITEM *syb[] =
{
   &syb1, &syb2, &mmsp,
   &mmfz
};
TXSlist(dfssyb, 4, 4,syb);

TXSitem(syf1,DFSC_YFINDD  ,0,0             , 8,"Search Deleted files  => list" ,"Search for deleted (or renamed) files ('Recover from list' NOT POSSIBLE YET)");
TXSitem(syf2,DFSC_YFINDF  ,0,0             , 8,"Search Normal  files  => list" ,"Search data area for non-deleted files/directories, for 'Recover from list' ");
static TXS_ITEM *syr[] =
{
   &syf1, &syf2, &mmsp,
   &mmxb, &mmlf, &mmrf, &mmsp,
   &mmfp, &mmof, &mmsp,
   &mmh1, &mmh2
};
TXSlist(dfssyr, 12, 12,syr);

TXSitem(mmyo,DFSC_YVLABEL ,0,0             , 0,"Set Standard Volume Label"     ,"Display/Edit the standard 11-character label (in bootsector and ROOT DIR)   ");
TXSitem(mmy8,DFSC_YCLEAN  ,0,0             ,18,"Set EFAT status Clean"         ,"Update EFAT status in BOTH bootsector areas to indicate filesystem is CLEAN ");
TXSitem(mmy9,DFSC_YDIRTY  ,0,0             ,18,"Set EFAT status Dirty"         ,"Update EFAT status in BOTH bootsector areas to indicate filesystem is DIRTY ");
static TXS_ITEM *sys[] =
{
   &mmyo, &mmvs, &mmsp,
   &mmy8, &mmy9
};
TXSlist(dfssys,5,5,sys);

TXSsubm(mmyr,DFSC_YRECOV  ,&dfssyr,0,0     , 0,"File Find/Recover/HEXedit "   ,"Find deleted/normal files, list and possibly recover them. HEX edit dir/file");
TXSsubm(mmys,DFSC_YVOLUM  ,&dfssys,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label, Serial-nr and dirty/clean status       ");
TXSitem(mmy3,DFSC_YFINDR  ,0,0             , 0,"Find EFAT Root directory"      ,"Find and list possible EFAT Rootdirectory (using bitmap/upcase entries)     ");
TXSsubm(mmyb,DFSC_YBOOTF  ,&dfssyb,0,0     , 1,"Boot area fixes/updates   "   ,"Fix bootsector, HiddenSectors/GEO, ging and fixing    ");
TXSitem(mmya,DFSC_XCHECK  ,0,0             , 1,"Analyse EFAT filesystem"       ,"Check filesystem for inconsistencies and errors (Readonly, no fixing!)      ");
static TXS_ITEM *mmy[] =
{
   &mmal, &mmyr, &mmsp,
   &mmys, &mmyb, &mmrb, &mmsp,
   &mmy3, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmya, &mslt, &mmsp,
   &mmxr
};
TXSlist(dfsmmy,16,16,mmy);
TXSmenu(dfsmy,&dfsmmy,DFSM_MENUBAR,0, 1,'m'," Mode=EFAT  ",
        "Menu: [Enhanced-FAT, huge SD/removables]           "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mby[] =
{
   &mmal, &mmsp,
   &mmyo, &mmvs, &mmsp,
   &syb1, &mmsp,
   &mmrb, &mmsp,
   &mmy8, &mmy9, &mmsp,
   &mmya, &mmsp,
   &mmxr
};
TXSlist(dfsmby,15,15,mby);
TXSmenu(dfsby,&dfsmby,DFSM_MENUBAR,0, 1,'m'," Mode=EFAT  ",
        "Menu: [Enhanced-FAT, huge SD/removables]           "
        "   Enter=menu Esc=commandline");


//============================  Mode=JFS  ==========================================================================

TXSitem(shj1,DFSC_JFINDD  ,0,0             , 1,"Search  Deleted files => list" ,"Search for INODEs for deleted files, 'Recover from list' will UNDELETE them ");
TXSitem(shja,DFSC_JFINDA  ,0,0             , 9,"Search  Any/all files => list" ,"Search for INODEs for deleted or non-deleted files, for 'Recover from list' ");
TXSitem(shj2,DFSC_JFINDF  ,0,0             , 9,"Search  Normal  files => list" ,"Search data area for INODEs for non-deleted files, for 'Recover from list'  ");
TXSitem(shj6,DFSC_JFIRSF  ,0,0             ,16,"Find ANY after FORMAT => list" ,"Find ANY file (Inode) even after (quick) formatting   (slow, as last resort)");
TXSitem(shji,DFSC_JFSIRS  ,0,0             ,10,"Show ANY Inode after a FORMAT" ,"Recognize ANY  Inode  even after (quick) formatting, allowing any signature ");
TXSitem(shj7,DFSC_JMAGIC  ,0,0             , 1,"Add/Update recovery filenames" ,"Add/Update filenames in the FS, for recovery/undelete (FS must be UNMOUNTED)");
static TXS_ITEM *sjr[] =
{
   &mmxu, &mmsp,
   &shj1, &shja, &shj2, &shj6, &mmsp,
   &shji, &mmsp,
   &mmxb, &mmlf, &mmrf, &mmsp,
   &shj7, &mmsp,
   &mmrs, &mmfp, &mmof, &mmsp,
   &mmh1, &mmh2
};
TXSlist(dfssjr,21,21,sjr);


TXSitem(sf11,DFSC_JFIXBOS ,0,0             , 0,"Fix Standard IBM Bootsector"   ,"Write STANDARD (classic IBM) JFS Bootsector from partition+superblock-info");
TXSitem(sf12,DFSC_JFIXBOB ,0,0             , 0,"Fix ArcaOS / eCS Bootsector"   ,"Write BOOTABLE (ArcaOSn/eCS) JFS Bootsector from partition+superblock-info");
TXSitem(sf13,DFSC_IJFLDR  ,0,0             , 1,"Create  JFS LDR imagefile"     ,"Create compressed imagefile with the JFS LDR sectors for this partition   ");
TXSitem(sf14,DFSC_RJFLDR  ,0,0             , 1,"Restore JFS LDR imagefile"     ,"Restore the imagefile with a 'known good' JFS LDR to current partition    ");
static TXS_ITEM *sf1[] =
{
   &sf11, &sf12, &mmsp,
   &mmfz, &mmsp,
   &sf13, &sf14, &mmsp,
   &mmhs
};
TXSlist(dfssf1,9,9,sf1);

TXSitem(sj5x,DFSC_JDINOR  ,0,0             ,11,"Specified Inode number ..."    ,"Display any Inode sector, by specifying the Inode-number                    ");
TXSitem(sj51,DFSC_INONR1  ,0,0             , 1,"1 - Fs1, alloc map extension"  ,"Extension area for the filesystem1 super-inode   (Aggregate inode at LSN 68)");
TXSitem(sj52,DFSC_INONR2  ,0,0             , 1,"2 -    \\      Root directory" ,"RootDir, main index to the volumes regular files and directories in fileset1");
TXSitem(sj53,DFSC_INONR3  ,0,0             , 1,"3 - Fs1, ACL file for fileset" ,"Special data file with consolidated Access Control List for the fileset     ");
TXSitem(sj59,DFSC_INON59  ,0,0             , 6,"Agg 59,  Aggregate self inode" ,"Aggregate super or 'self' inode, describing the Aggregate Inode Map blocks  ");
TXSitem(sj5a,DFSC_INON5A  ,0,0             , 6,"Agg 5a,  Block Allocation Map" ,"Aggregate inode with the bitmap structures that map the whole aggregate     ");
TXSitem(sj5c,DFSC_INON5C  ,0,0             , 6,"Agg 5c,  Bad block mapping"    ,"Aggregate inode with blocks allocated to areas detected as 'bad' on format  ");
TXSitem(sj68,DFSC_INON68  ,0,0             ,10,"Agg 68,  Fileset1 super inode" ,"Aggregate inode with the Fileset1 Allocation Map, mapping the Inode extents ");
TXSitem(sj5i,DFSC_JIAGRP  ,0,0             , 3,"IAG, Inode Allocation Group"   ,"Display summary info on all IAG's, or detailed info on a specified IAG nr   ");
static TXS_ITEM *sj5[] =
{
   &sj5x, &mmsp,
   &sj51, &sj52, &sj53, &mmsp,
   &sj59, &sj5a, &sj5c, &sj68, &mmsp,
   &sj5i
};
TXSlist(dfssj5,12,12,sj5);

TXSitem(mmjo,DFSC_JVLABEL ,0,0             , 0,"Set Standard Volume Label"     ,"Display/Edit the standard 11-character label, as used by OS/2 and variants  ");
TXSitem(mmjl,DFSC_JVLILAB ,0,0             , 5,"Set LinuxMnt Volume Label"     ,"Display/Edit the Linux    16-character label, as used with mounting the FS  ");
TXSitem(mmju,DFSC_JCLEAN  ,0,0             ,20,"Set FS Unmounted - Clean"      ,"Update superblock status to indicate filesystem is UNMOUNTED and CLEAN      ");
TXSitem(mmjm,DFSC_JDIRTY  ,0,0             ,20,"Set FS Mounted   - Dirty"      ,"Update superblock status to indicate filesystem is DIRTY                    ");
TXSitem(mmjc,DFSC_JMOUNT  ,0,0             , 8,"Set FS Mounted   - Clean"      ,"Update superblock status to indicate filesystem is MOUNTED and CLEAN        ");
TXSitem(mmjv,DFSC_JSBVER  ,0,0             , 8,"Set FS Version number  ..."    ,"Update superblock version-nr to IBM/eCS/Linux or explicit numeric value     ");
TXSitem(mmjg,DFSC_JSBSIG  ,0,0             , 8,"Set FS Signature to 'JFS1'"    ,"Update superblock signature string to the default required 'JFS1' value     ");
static TXS_ITEM *sjs[] =
{
   &mmjo, &mmjl, &mmui, &mmvs, &mmsp,
   &mmju, &mmjm, &mmjc, &mmsp,
   &mmjv, &mmjg
};
TXSlist(dfssjs,11,11,sjs);

TXSsubm(mmjr,DFSC_JRECOV  ,&dfssjr,0,0     ,11,"File Find/Recover/HEXedit "   ,"Find deleted/normal files, list and possibly recover them. HEX edit dir/file");
TXSsubm(mmjs,DFSC_JVOLUM  ,&dfssjs,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label, UUID, Serial-nr and dirty/clean status ");
TXSsubm(mmj1,DFSC_JFIXBO  ,&dfssf1,0,0     , 1,"Boot area fixes/updates   "   ,"Fix bootsector standard/bootable, HiddenSectors/GEO and JFS LDR sectors     ");
TXSsubm(mmj5,DFSC_JDINOS  ,&dfssj5,0,0     , 9,"Display Inode info        "   ,"Display specified Inode sectors or Inode allocation information (IAG)       ");
TXSitem(mmjd,DFSC_JSYSDMP ,0,0             , 1,"Dump FS area to file   ..."    ,"Dump the JFS system areas, Aggr/Fs1 inodes to file for analysis by support  ");
TXSitem(mmja,DFSC_XCHECK  ,0,0             , 1,"Analyse JFS filesystem"        ,"Check filesystem for inconsistencies and errors (Readonly, no fixing!)      ");
static TXS_ITEM *mmj[] =
{
   &mmal, &mmjr, &mmsp,
   &mmjs, &mmj1, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmj5, &mmjd, &mmsp,
   &mmsb, &mmja, &mslt, &mmsp,
   &mmxr
};
TXSlist(dfsmmj,17,17,mmj);
TXSmenu(dfsmj,&dfsmmj,DFSM_MENUBAR,0, 1,'m'," Mode=JFS ",
        "Menu: [OS/2 and eCS Journaled File System]         "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbj[] =
{
   &mmal, &mmsp,
   &mmjo, &mmvs, &mmsp,
   &sf11, &sf12, &mmhs, &mmsp,
   &mmju, &mmjm, &mmjc, &mmsp,
   &mmsb, &mmja, &mmsp,
   &mmxr
};
TXSlist(dfsmbj,17,17,mbj);
TXSmenu(dfsbj,&dfsmbj,DFSM_MENUBAR,0, 1,'m'," Mode=JFS ",
        "Menu: [OS/2 and eCS Journaled File System]         "
        "   Enter=menu Esc=commandline");


//============================  Mode=EXTn  =========================================================================

TXSitem(se5x,DFSC_EDINOR  ,0,0             ,11,"Specified Inode number ..."    ,"Display any Inode sector, by specifying the Inode-number                    ");
TXSitem(se51,DFSC_EDINO1  ,0,0             , 1,"2 -  \\     Root directory"    ,"RootDir, main index to the volumes regular files and directories for the FS ");
TXSitem(se52,DFSC_EDINO2  ,0,0             , 1,"7 - System Inode, Resize-FS"   ,"Special Inode used to track information for filesystem RESIZE reserved areas");
TXSitem(se53,DFSC_EDINO3  ,0,0             , 1,"8 - System Inode, Journal"     ,"Special Inode for the JOURNAL, with records of (metadata) changes to the FS ");
static TXS_ITEM *se5[] =
{
   &se5x, &mmsp,
   &se51, &se52, &se53
};
TXSlist(dfsse5,5,5,se5);


TXSitem(she1,DFSC_EFINDF  ,0,0             , 8,"Search Normal  files  => list" ,"Search non-deleted files in existing directories (FAST),   for 'Recover ...'");
static TXS_ITEM *ser[] =
{
   &she1, &mmsp,
   &mmxb, &mmlf, &mmrf, &mmsp,
   &mmrs, &mmfp, &mmof, &mmsp,
   &mmh1, &mmh2
};
TXSlist(dfsser,12,12,ser);

TXSitem(mmeo,DFSC_EVLABEL ,0,0             , 0,"Set LinuxMnt Volume Label"     ,"Display/Edit the standard 16-character label in the superblock (for mount)  ");
static TXS_ITEM *ses[] =
{
   &mmeo, &mmui
};
TXSlist(dfsses,2,2,ses);

TXSitem(mmeb,DFSC_EALOCBG ,0,0             , 0,"Alloc map, by Blockgroup  "    ,"Show allocation map, with exactly one line per Blockgroup in an aligned view");
TXSsubm(mmer,DFSC_ERECOV  ,&dfsser,0,0     ,11,"File Find/Recover/HEXedit "   ,"Find files or directories, list and possibly recover them. HEX edit dir/file");
TXSsubm(mmev,DFSC_EVOLUM  ,&dfsses,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label and UUID to be used with mount          ");
TXSitem(mmes,DFSC_EBACKUP ,0,0             , 1,"List BACKUP Superblocks   "    ,"List group#, block# and sector# for BACKUP Superblock and Group Descriptors ");
TXSitem(mmeg,DFSC_EBLKGRP ,0,0             ,11,"Show BlockGroup Summary   "    ,"List group#, Super/UNINIT/ZEROED flag, Used blocks BM/Descriptor (Dirtyness)");
TXSsubm(mme5,DFSC_EDINOS  ,&dfsse5,0,0     , 9,"Display Inode info        "   ,"Display specified Inode sectors or one of the special ones (Journal, Resize)");
TXSitem(mmea,DFSC_XCHECK  ,0,0             , 1,"Analyse EXT filesystem"        ,"Check filesystem for inconsistencies and errors (Readonly, no fixing!)      ");
static TXS_ITEM *mme[] =
{
   &mmal, &mmeb, &mmsp,
   &mmer, &mmev, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmeg, &mmsp,
   &mme5, &mmsp,
   &mmsb, &mmes, &mmea, &mslt, &mmsp,
   &mmxr
};
TXSlist(dfsmme,19,19,mme);
TXSmenu(dfsme,&dfsmme,DFSM_MENUBAR,0, 1,'m'," Mode=EXTn ",
        "Menu: [Linux EXT2 or EXT3/4 jrnl File System]      "
        "   Enter=menu Esc=commandline");


// BASIC version of the above pull-down menu
static TXS_ITEM *mbe[] =
{
   &mmal, &mmeb, &mmsp,
   &mmeo, &mmsp,
   &mmsb, &mmea, &mmsp,
   &mmxr
};
TXSlist(dfsmbe,9,9,mbe);
TXSmenu(dfsbe,&dfsmbe,DFSM_MENUBAR,0, 1,'m'," Mode=EXTn ",
        "Menu: [Linux EXT2 or EXT3/4 jrnl File System]      "
        "   Enter=menu Esc=commandline");


//============================  Mode=REISER  =======================================================================


TXSitem(mmro,DFSC_RVLABEL ,0,0             , 0,"Set LinuxMnt Volume Label"     ,"Display/Edit the standard 16-character label in the superblock (for mount)  ");
static TXS_ITEM *srs[] =
{
   &mmro, &mmui
};
TXSlist(dfssrs,2,2,srs);

TXSsubm(mmrv,DFSC_RVOLUM  ,&dfssrs,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label and UUID to be used with mount          ");
static TXS_ITEM *mmr[] =
{
   &mmal, &mmsp,
   &mmrv, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmmr,10,10,mmr);
TXSmenu(dfsmr,&dfsmmr,DFSM_MENUBAR,0, 1,'m'," Mode=REISER ",
        "Menu: [Linux Reiser journaled File System]         "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbr[] =
{
   &mmal, &mmsp,
   &mmro, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmbr,7,7,mbr);
TXSmenu(dfsbr,&dfsmbr,DFSM_MENUBAR,0, 1,'m'," Mode=REISER ",
        "Menu: [Linux Reiser journaled File System]         "
        "   Enter=menu Esc=commandline");


//============================  Mode=ISO  ==========================================================================

TXSsubm(mmii,DFSC_ISOVDI  ,0,DFSB_ISOVDI,0 , 6,"Select Volume Descriptor   "   ,"Select active volume descriptor including its Directory-treee etc. from list");

static TXS_ITEM *mmi[] =
{
   &mmii, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmmi, 5, 5,mmi);
TXSmenu(dfsmi,&dfsmmi,DFSM_MENUBAR,0, 1,'m'," Mode=ISO ",
        "Menu: [ISO9660 CDROM/DVD .iso image File System]   "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbi[] =
{
   &mmii, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmbi,5,5,mbi);
TXSmenu(dfsbi,&dfsmbi,DFSM_MENUBAR,0, 1,'m'," Mode=ISO ",
        "Menu: [ISO9660 CDROM/DVD .iso image File System]   "
        "   Enter=menu Esc=commandline");


//============================  Mode=HFS  ==========================================================================


TXSitem(mmcx,DFSC_MFLDNR  ,0,0             ,11,"Specified Folder CnID ..."     ,"Display directory information for any folder, given a folder-mumber (CnID)  ");
TXSitem(mmc0,DFSC_MFLDR0  ,0,0             , 6,"Fldr-0, ALL folders/files"     ,"FOLDER 0, ALL folders/files in the filesystem, could be millions of lines!  ");
TXSitem(mmc1,DFSC_MFLDR1  ,0,0             , 6,"Fldr-1, Volume name/label"     ,"FOLDER 1, Invisible 'folder' containing the Volume name as used when mounted");
TXSitem(mmc2,DFSC_MFLDR2  ,0,0             , 6,"Fldr-2, Root directory"        ,"FOLDER 2, The ROOT directory for volume, can navigate from listed entries   ");
TXSitem(mmnx,DFSC_MCATNR  ,0,0             ,11,"Specified Node number ..."     ,"Display Header, Map, Index or Leaf-node information for specified nodenumber");
TXSitem(mmn0,DFSC_MCATN0  ,0,0             ,18,"Node  0, Catalog Header"       ,"Header node for the Catalog-file Btree, shows root- and first/last leafnodes");
TXSitem(mmnt,DFSC_MCATNT  ,0,0             , 1,"Thread info, all records"      ,"Display ALL thread records in the leaf-nodes, with cnid / parent / name info");
TXSitem(mmnl,DFSC_MCATNL  ,0,0             , 1,"Leaf   info, all records"      ,"Display ALL records in the leaf-nodes, with thread and directory / file info");
TXSitem(mmnv,DFSC_MCATNV  ,0,0             , 1,"Verbose info all records"      ,"Display ALL records in the leaf-nodes, including HEX-dump of record contents");
static TXS_ITEM *smc[] =
{
   &mmcx, &mmc0, &mmc1, &mmc2, &mmsp,
   &mmnx, &mmn0, &mmsp,
   &mmnt, &mmnl, &mmnv
};
TXSlist(dfssmc,11,11,smc);


TXSitem(mmml,DFSC_MVLABEL ,0,0             , 0,"Set Standard Volume Label"     ,"Display/Edit the 255-character volume label located in the Catalog file tree");
static TXS_ITEM *sms[] =
{
   &mmml
};
TXSlist(dfssms,1,1,sms);

TXSsubm(mmmv,DFSC_MVOLUM  ,&dfssms,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label                                         ");
TXSsubm(mmmc,DFSC_MCATIN  ,&dfssmc,0,0     , 9,"Display Catalog  info     "   ,"Display Catalog information, for specied or pre-defined Nodes or Folders    ");
TXSitem(mmmh,DFSC_MHLINKS ,0,0             , 1,"Hardlinks   Auto Resolve"      ,"Resolve hardlinks   to actual file contents (needed for TimeMachine restore)");
TXSitem(mmmf,DFSC_MFALIAS ,0,0             , 1,"FolderAlias Auto Resolve"      ,"Resolve folderAlias to actual DIR  contents (needed for TimeMachine restore)");
static TXS_ITEM *mmm[] =
{
   &mmal, &mmsp,
   &mmmv, &mmsp,
   &mmtd, &mmsp,
   &mmmc, &mmsp,
   &mmsb, &mmsp,
   &mmmh, &mmmf, &mmsp,
   &mmxr
};
TXSlist(dfsmmm, 14,14,mmm);
TXSmenu(dfsmm,&dfsmmm,DFSM_MENUBAR,0, 1,'m'," Mode=HFS ",
        "Menu: [Apple MAC HFS+ journaled File System]       "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbm[] =
{
   &mmal, &mmsp,
   &mmml, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmbm, 7, 7,mbm);
TXSmenu(dfsbm,&dfsmbm,DFSM_MENUBAR,0, 1,'m'," Mode=HFS ",
        "Menu: [Apple MAC HFS+ journaled File System]       "
        "   Enter=menu Esc=commandline");


//============================  Mode=APFS  =========================================================================

TXSsubm(mmpv,DFSC_APFSVI  ,0,DFSB_APFSVI,0 ,18,"Select container Volume     "  ,"Select one of the Volumes present in the APFS container, by number or name  ");
TXSitem(mmpc,DFSC_APFSCP  ,0,0             , 1,"Refresh to last checkpoint"     ,"Refresh by finding the latest checkpoint and superblock (highest Xid value) ");
TXSitem(mmpt,DFSC_APFSTP  ,0,0             ,15,"Describe (sub) Type  Records"   ,"Show APFS block types/subtypes with select char, and the Btree RECORD types ");
TXSitem(mmpd,DFSC_APFSDM  ,0,0             , 1,"Dump most important  Blocks"    ,"Search and dump the most important APFS blocks for the CURRENT checkpoint   ");
TXSitem(mmpf,DFSC_APFSTR  ,0,0             ,13,"Display ALL FS-tree  records"   ,"Display ALL RECORDS from the FS-tree using a single line per record (leaves)");
TXSitem(mmpr,DFSC_APFSDR  ,0,0             ,18,"Display selected DIR-records"   ,"Display DIR-RECORDS from the FS-tree matching specified wildcard    (leaves)");
TXSitem(mmpi,DFSC_APFSIN  ,0,0             ,18,"Display selected INO-records"   ,"Display INO-RECORDS from the FS-tree matching specified wildcard    (leaves)");
TXSitem(mmps,DFSC_APFSSP  ,0,0             ,14,"Display SpaceManager info"      ,"Display the current Spacemanager object, with container allocation/freespace");

static TXS_ITEM *mmp[] =
{
   &mmpv, &mmsp,
   &mmpc, &mmsp,
   &mmsb, &mmps, &mmsp,
   &mmpt, &mmpd, &mmpf, &mmpi, &mmpr, &mmsp,
   &mmtd, &mmsp,
   &mmxr
};
TXSlist(dfsmmp,16,16,mmp);
TXSmenu(dfsmp,&dfsmmp,DFSM_MENUBAR,0, 1,'m'," Mode=APFS ",
        "Menu: [APFS container File System]                 "
        "   Enter=menu Esc=commandline");


// BASIC version of the above pull-down menu
static TXS_ITEM *mbp[] =
{
   &mmpv, &mmsp,
   &mmpc, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmbp, 7, 7,mbp);
TXSmenu(dfsbp,&dfsmbp,DFSM_MENUBAR,0, 1,'m'," Mode=APFS ",
        "Menu: [APFS container File System]                 "
        "   Enter=menu Esc=commandline");


//============================  Mode=XFS  ==========================================================================

TXSitem(mmxo,DFSC_XVLABEL ,0,0             , 0,"Set LinuxMnt Volume Label"     ,"Display/Edit the standard 16-character label in the superblock (for mount)  ");
static TXS_ITEM *sxs[] =
{
   &mmxo, &mmui
};
TXSlist(dfssxs,2,2,sxs);

TXSsubm(mmxv,DFSC_XVOLUM  ,&dfssxs,0,0     , 5,"Set Volume info/status    "   ,"Display/Edit Volume info like label and UUID to be used with mount          ");
static TXS_ITEM *mmx[] =
{
   &mmxv, &mmsp,
   &mmta, &mmtd, &mmsp,
   &mmsb, &mmsp,
   &mmfz, &mmsp,
   &mmxr
};
TXSlist(dfsmmx,10,10,mmx);
TXSmenu(dfsmx,&dfsmmx,DFSM_MENUBAR,0, 1,'m'," Mode=XFS ",
        "Menu: [XFS journaled File System]                  "
        "   Enter=menu Esc=commandline");


// BASIC version of the above pull-down menu
static TXS_ITEM *mbx[] =
{
   &mmxo, &mmsp,
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmbx, 5, 5,mbx);
TXSmenu(dfsbx,&dfsmbx,DFSM_MENUBAR,0, 1,'m'," Mode=XFS ",
        "Menu: [XFS journaled File System]                  "
        "   Enter=menu Esc=commandline");


//============================  Mode=SWAP  =========================================================================

static TXS_ITEM *mms[] =
{
   &mmta, &mmtd, &mmsp,
   &mmsb, &mmsp,
   &mmfz, &mmsp,
   &mmxr
};
TXSlist(dfsmms, 8, 8,mms);
TXSmenu(dfsms,&dfsmms,DFSM_MENUBAR,0, 1,'m'," Mode=SWAP ",
        "Menu: [Linux SWAP partition]                       "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbs[] =
{
   &mmsb, &mmsp,
   &mmxr
};
TXSlist(dfsmbs, 3, 3,mbs);
TXSmenu(dfsbs,&dfsmbs,DFSM_MENUBAR,0, 1,'m'," Mode=SWAP ",
        "Menu: [Linux SWAP partition]                       "
        "   Enter=menu Esc=commandline");


//============================  Mode=DUMPFS  =======================================================================


TXSitem(mmob,DFSC_DUMPFSB ,0,0             , 9,"Display DUMPFS overview"       ,"Display the main DUMPFS information sector, showing dumpfile specifics      ");
static TXS_ITEM *mmo[] =
{
   &mmta, &mmtd, &mmsp,
   &mmob, &mmsp,
   &mmfz, &mmsp,
   &mmxr
};
TXSlist(dfsmmo, 8, 8,mmo);
TXSmenu(dfsmo,&dfsmmo,DFSM_MENUBAR,0, 1,'m'," Mode=DUMPFS ",
        "Menu: [OS/2 debug DUMP partition]                  "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mbo[] =
{
   &mmob, &mmsp,
   &mmxr
};
TXSlist(dfsmbo, 3, 3,mbo);
TXSmenu(dfsbo,&dfsmbo,DFSM_MENUBAR,0, 1,'m'," Mode=DUMPFS ",
        "Menu: [OS/2 debug DUMP partition]                  "
        "   Enter=menu Esc=commandline");


//============================  Mode=AUX  ==========================================================================

static TXS_ITEM *mma[] =
{
   &mmta, &mmtd, &mmsp,
   &mmfz, &mmsp,
   &mmxr
};
TXSlist(dfsmma, 6, 6,mma);
TXSmenu(dfsma,&dfsmma,DFSM_MENUBAR,0, 1,'m'," Mode=AUX ",
        "Menu: [Unknown/Unsupported File System]            "
        "   Enter=menu Esc=commandline");

// BASIC version of the above pull-down menu
static TXS_ITEM *mba[] =
{
   &mmxr
};
TXSlist(dfsmba, 1, 1,mba);
TXSmenu(dfsba,&dfsmba,DFSM_MENUBAR,0, 1,'m'," Mode=AUX ",
        "Menu: [Unknown/Unsupported File System]            "
        "   Enter=menu Esc=commandline");


//============================  Mode=FDISK  ========================================================================

TXSitem(sd31,DFSC_BSALLC  ,0,0             , 1,"ANY   FS"                      ,"Find -any-  superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd32,DFSC_BSHPFSC ,0,0             , 1,"HPFS"                          ,"Find HPFS   superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd33,DFSC_BSJFSC  ,0,0             , 1,"JFS"                           ,"Find JFS    superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd34,DFSC_BSHFSC  ,0,0             , 6,"HFS+ MAC"                      ,"Find HFS+   superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd35,DFSC_BSEXTC  ,0,0             , 1,"EXT"                           ,"Find EXTn   superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd36,DFSC_BSXFSC  ,0,0             , 1,"XFS"                           ,"Find XFS    superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd37,DFSC_BSRSRC  ,0,0             , 1,"ReiserFS"                      ,"Find Reiser superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd38,DFSC_BSNTFSC ,0,0             , 1,"NTFS LDR"                      ,"Find NTFS NTLDR sectors, partitioning+LVM+bootsectors on cylinder boundaries");
static TXS_ITEM *sda[] =
{
   &sd31, &mmsp,
   &sd32, &sd33, &sd34,
   &sd35, &sd36, &sd37, &sd38
};
TXSlist(dfssda, 9, 9,sda);

TXSitem(sd11,DFSC_BSALLO  ,0,0             , 1,"ANY   FS"                      ,"Find superblocks for ANY supported FS on current disk on cylinder boundaries");
TXSitem(sd12,DFSC_BSHPFSO ,0,0             , 1,"HPFS"                          ,"Find HPFS   superblocks only, on the current disk and on cylinder boundaries");
TXSitem(sd13,DFSC_BSJFSO  ,0,0             , 1,"JFS"                           ,"Find JFS    superblocks only, on the current disk and on cylinder boundaries");
TXSitem(sd14,DFSC_BSHFSO  ,0,0             , 6,"HFS+ MAC"                      ,"Find HFS+   superblocks only, on the current disk and on cylinder boundaries");
TXSitem(sd15,DFSC_BSEXTO  ,0,0             , 1,"EXTn"                          ,"Find EXTn   superblocks only, on the current disk and on cylinder boundaries");
TXSitem(sd16,DFSC_BSXFSO  ,0,0             , 1,"XFS"                           ,"Find XFS    superblocks only, on the current disk and on cylinder boundaries");
TXSitem(sd17,DFSC_BSRSRO  ,0,0             , 1,"ReiserFS"                      ,"Find Reiser superblocks only, on the current disk and on cylinder boundaries");
TXSitem(sd18,DFSC_BSNTFSO ,0,0             , 1,"NTFS LDR"                      ,"Find NTFS NTLDR sectors only, on the current disk and on cylinder boundaries");
static TXS_ITEM *sds[] =
{
   &sd11, &mmsp,
   &sd12, &sd13, &sd14,
   &sd15, &sd16, &sd17, &sd18
};
TXSlist(dfssds, 9, 9,sds);

TXSitem(sd1o,DFSC_BSFIND  ,0,0             , 1,"Partition tables + LVM  only"  ,"Find all partitiong (MBR, EBR), LVM and bootsectors,  on cylinder boundaries");
TXSsubm(sd1s,DFSC_BSMENUS ,&dfssds,0,0     , 8,"Search FS superblocks only "  ,"Find all superblocks for ANY or selected filesystem,  on cylinder boundaries");
TXSsubm(sd1a,DFSC_BSMENUA ,&dfssda,0,0     , 1,"Superblocks + partitioning "  ,"Find all FS superblocks, partitioning+LVM+bootsectors on cylinder boundaries");
TXSitem(sd58,DFSC_LISTFSC ,0,0             , 9,"Display List of sectors"       ,"Show list with sector numbers as 1-liners, using a recorded filesystem-mode ");
TXSitem(sd59,DFSC_LISTFSV ,0,0             ,16,"Display Sector Contents"       ,"Show contents of the sectors in the list,  using a recorded filesystem-mode ");
static TXS_ITEM *sd1[] =
{
   &sd1o, &mmsp,
   &sd1s, &sd1a, &mmsp,
   &sd58, &sd59
};
TXSlist(dfssd1, 7, 7,sd1);

TXSsubm(sd41,DFSC_ACTIVE  ,0,DFSB_ACTIVE,0 , 1,"Active, BIOS-startable  "     ,"Make partition the ACTIVE (startable) one, started by default by the BIOS   ");
TXSsubm(sd42,DFSC_NOTACT  ,0,DFSB_NOTACT,0 , 1,"Not active, clear flag  "     ,"Make partition NOT ACTIVE, clearing the status flag, NOT booted by the BIOS ");
TXSsubm(sd43,DFSC_P_HIDE  ,0,DFSB_P_HIDE,0 , 1,"Hidden, using part-type "     ,"Make partition HIDDEN by manipulating the partition-type    (non-LVM method)");
TXSsubm(sd44,DFSC_UNHIDE  ,0,DFSB_UNHIDE,0 , 1,"Visible, allow just one "     ,"Make partition VISIBLE by manipulating the partition-type   (non-LVM method)");
TXSsubm(sd45,DFSC_MULTIV  ,0,DFSB_MULTIV,0 ,16,"Visible, allow Multiple "     ,"Make partition VISIBLE, allow multiple visible primaries    (non-LVM method)");
static TXS_ITEM *sd4[] =
{
   &sd41, &sd42, &mmsp,
   &sd43, &sd44, &sd45
};
TXSlist(dfssd4, 6, 6,sd4);

TXSsubm(sd71,DFSC_LVMDLG  ,0,DFSB_LVMDLG,0 , 6,"Edit LVM information       "  ,"Edit LVM information related to disk partitions, LVM-volumes and BMGR-menu  ");
TXSsubm(sd72,DFSC_LVMRMV  ,0,DFSB_LVMRMV,0 , 0,"Delete LVM Volume (letter) "  ,"Delete volumename and driveletter from an LVM-volume, but KEEP the partition");
TXSsubm(sd73,DFSC_LVMDEF  ,0,DFSB_LVMDEF,0 , 1,"Recover/Init LVM DLAT info "  ,"Initialize LVM info (DLAT) to empty, and for type 35 recover from BBR sector");
TXSsubm(sd74,DFSC_LVMVCU  ,0,DFSB_LVMVCU,0 ,23,"Add default LVM-info (VCU) "  ,"Add default LVM-information to the selected disk(s), making it LVM-enabled  ");
TXSsubm(sd7r,DFSC_LVMRED  ,0,DFSB_LVMRED,0 , 0,"Refresh LVM-info (LVMREDO) "  ,"Refresh all LVM info (DLAT), keep names and driveletters; JFS: recover BBR  ");
TXSsubm(sd75,DFSC_LVMPCL  ,0,DFSB_LVMPCL,0 , 0,"Remove LVM-info from disk  "  ,"Remove ALL LVM info (DLAT) and signature sectors (BBR) from selected disk(s)");
TXSsubm(sd76,DFSC_LVMDNM  ,0,DFSB_LVMDNM,0 ,21,"Change the LVM disk Name   "  ,"Change the name used by LVM for a complete disk (LVM-info must be present)  ");
TXSsubm(sd7l,DFSC_LVMCLN  ,0,DFSB_LVMCLN,0 , 0,"Wipe LVM sectors MBR-area  "  ,"Wipe obsolete LVM DLAT sectors (for other/previous GEO) in sectors 1 .. 254 ");
TXSsubm(sd7c,DFSC_LVMCRC  ,0,DFSB_LVMCRC,0 , 0,"LVM-CRC, remove obsoletes  "  ,"Remove obsolete entries from LVM DLAT sectors and fixup all CRC values      ");
TXSsubm(sd77,DFSC_LVMGEO  ,0,DFSB_LVMGEO,0 , 9,"Set LVM-Geo to DFSee L-Geo "  ,"Force the disk-geometry in LVM to match the current DFSee logical geometry  ");
TXSsubm(sd78,DFSC_LVMBBR  ,0,DFSB_LVMBBR,0 , 7,"Clear BBR on non-LVM parts "  ,"Clear obsolete LVM-signature sectors (BBR) on all non 0x35 type partitions  ");
static TXS_ITEM *sd7[] =
{
   &sd71, &mmx5, &sd72, &sd73, &mmsp,
   &sd74, &sd7r, &sd75, &sd76, &sd7l, &sd7c, &sd77, &sd78, &mmsp,
   &mmim, &mmqm, &mmam, &mmdm, &mmbm, &mmtm, &mmfm
};
TXSlist(dfssd7,21,21,sd7);

TXSsubm(sd91,DFSC_FIXEXT  ,0,DFSB_FIXEXT, 0,25,"Make logical EXT types 05  "  ,"Change all extended partitions types to be 0x05    (Industry-standard value)");
TXSsubm(sd92,DFSC_FIXEXF  ,0,DFSB_FIXEXF, 0,25,"Make logical EXT types 0F  "  ,"Change all extended partitions types to be 0x0f    (Windows-9x  requirement)");
static TXS_ITEM *sd9[] =
{
   &sd91, &sd92
};
TXSlist(dfssd9,2,2,sd9);

TXSsubm(sdb0,DFSC_PTEDIT  ,0,DFSB_PTEDIT,0 , 6,"Edit Partition tables      "  ,"Edit a partition table in an MBR/EBR sector using the P-Table-Editor dialog ");
TXSsubm(sdb2,DFSC_NEWMBR  ,0,DFSB_NEWMBR ,0,15,"New MBR code, KEEP  tables "  ,"Write new MBR bootcode to selected disk(s), but KEEP all partitions intact  ");
TXSsubm(sdb1,DFSC_NEWMBC  ,0,DFSB_NEWMBC ,0, 0,"New MBR code, ERASE tables "  ,"Write new MBR bootcode to selected disk(s) and DELETING all the partitions  ");
TXSsubm(sdb3,DFSC_NEWMBI  ,0,DFSB_NEWMBI ,0,22,"New MBR code from an IMAGE "  ,"Write new MBR bootcode from a RAW imagefile to a disk, KEEP all partitions  ");
TXSsubm(sdb4,DFSC_SAVMBR  ,0,DFSB_SAVMBR ,0, 1,"Save MBR code, to an IMAGE "  ,"Save MBR bootcode from a disk to a 1-sector RAW imagefile, for later restore");
TXSsubm(sdb5,DFSC_NTSIGN  ,0,DFSB_NTSIGN ,0, 8,"Update NT-signature in MBR "  ,"Display and optionally update the value for the Windows NT signature value  ");
TXSsubm(sdb6,DFSC_WIPEST  ,0,DFSB_WIPEST ,0, 1,"Wipe start of disk to ZERO "  ,"Wipe the start (10 MiB) of the selected disk completely clean to all ZEROES ");
TXSsubm(sdb7,DFSC_WIPET1  ,0,DFSB_WIPET1 ,0,12,"Wipe  MBR  TRACK-1 sectors "  ,"Wipe reserved sectors for disk in MBR track, keep first (MBR) and last (LVM)");
TXSsubm(sdbe,DFSC_WEBRT1  ,0,DFSB_WEBRT1 ,0, 7,"Wipe (EBR) TRACK-1 sectors "  ,"Wipe reserved sectors for partition, in EBR for logical. Keep table and LVM.");
TXSsubm(sdbg,DFSC_MBR2GPT ,0,DFSB_MBR2GPT,0, 1,"Convert an MBR disk to GPT "  ,"Convert an MBR-style disk to an EMPTY GPT one: NEWMBR, create GPT guard part");
TXSsubm(sdbm,DFSC_GPT2MBR ,0,DFSB_GPT2MBR,0,12,"Convert a  GPT disk to MBR "  ,"Convert a  GPT-style disk to an EMPTY MBR one: NEWMBR  (GPT info untouched!)");
static TXS_ITEM *sdb[] =
{
   &sdb0, &mmsp,
   &sdb2, &sdb1, &mmsp,
   &sdb3, &sdb4, &mmsp,
   &mmdz, &mmsp,
   &sdb5, &mmsp,
   &sdb6, &sd7l, &sdb7, &mmsp,
   &sdbe, &mmsp,
   &sdbg, &sdbm
};
TXSlist(dfssdb,20,20,sdb);

TXSsubm(sdc1,DFSC_CLEANUP ,0,DFSB_CLEANUP,0, 1,"Cleanup partition tables   "  ,"Cleanup multiple/incorrect ACTIVE flags and EXT container sizes and offsets ");
TXSsubm(sdc2,DFSC_FIXCHS  ,0,DFSB_FIXCHS,0 , 1,"Fix CHS values to Geometry "  ,"Update CHS values in partition-tables to match disk-geometry and CHS-style  ");
TXSsubm(sdc3,DFSC_FCHAIN  ,&dfssd9,0,0     ,22,"Fix   EXT container  Type  "  ,"Fix type of EXT containers to be 0x05 (standard) or  0x0F (Windows specific)");
TXSsubm(sdc4,DFSC_ALIGND  ,0,DFSB_ALIGND,0 ,22,"Align EXT container, Disk  "  ,"Align extended container (ALIGNEXT on first logical) for one or ALL disks   ");
TXSsubm(sdc5,DFSC_ALIGNL  ,0,DFSB_ALIGNL,0 ,22,"Align EXT container, Part  "  ,"Align extended container (ALIGNEXT) for selected single LOGICAL partition   ");
TXSsubm(sdc6,DFSC_GPTFIX  ,0,DFSB_GPTFIX,0 , 7,"Fix+Sort GPT Header/Tables "  ,"Fix on-disk GPT info by recovery from alternate, SORT and fixup CRC values  ");
static TXS_ITEM *sdc[] =
{
   &sdc1, &sdc2, &sdc3, &mmsp,
   &sdc4, &sdc5, &mmsp,
   &sdc6
};
TXSlist(dfssdc,8,8,sdc);

TXSitem(mmd1,DFSC_MAPVMM  ,0,0             , 0,"Disk and media overview"       ,"Display of attached partitionable media, disk geometry and partition maps   ");
TXSsubm(mmdg,DFSC_GEODLG  ,0,DFSB_GEODLG,0 ,15,"Show/Set disk Geometry     "  ,"Display and optionaly set a new geometry to be used for the selected disk   ");
TXSsubm(mmdi,DFSC_BSMENU  ,&dfssd1,0,0     , 0,"Search partition + FS info "  ,"Search partition-tables, LVM or FS-superblocks on cylinder boundaries (FAST)");
TXSsubm(mmd2,DFSC_CREATE  ,0,DFSB_CREATE,0 , 1,"Create new partition       "  ,"Create a new partition defined by freespace selection and prompted values   ");
TXSsubm(mmd3,DFSC_DELETE  ,0,DFSB_DELETE,0 , 0,"Delete partition           "  ,"Delete a partition from the partition-tables and (primary) LVM-information  ");
TXSsubm(mmdt,DFSC_CHTYPE  ,0,DFSB_CHTYPE,0 ,18,"Change partition Type      "  ,"Change type for a partition from a list or custom value  (NO FS CONVERSION!)");
TXSsubm(mmd4,DFSC_SETPRT  ,&dfssd4,0,0     ,15,"Set partition Status to    "  ,"Set partition properties: ACTIVE, HIDDEN, VISIBLE, MULTIPLE-VISIBLE-PRIMARY ");
TXSsubm(mmdp,DFSC_OPART   ,0,DFSB_OPART,0  , 6,"Open single partition   F6 "  ,"Open partition selected by submenu, to work on the filesystem in a partition");
TXSsubm(mmdd,DFSC_ODISK   ,0,DFSB_ODISK,0  ,12,"Open whole Disk to work on "  ,"Open disk selected by submenu, to work on part-tables, LVMinfo or whole disk");
TXSsubm(mmd5,DFSC_SAVEPD  ,0,DFSB_SAVEPD,0 , 1,"BACKUP  partition info     "  ,"Save all partitioning information, including LVM to binary .PDx backup file ");
TXSsubm(mmd6,DFSC_RESTPD  ,0,DFSB_RESTPD,0 , 1,"RESTORE partition info     "  ,"Restore all partitioning info, including LVM from a binary .PDx backup file ");
TXSsubm(mmds,DFSC_GENPDLG ,0,DFSB_GENPDLG,0, 0,"Make partition scripts     "  ,"Generate DFSee partitioning script(s) to recreate partitions as they are now");
TXSsubm(mmdb,DFSC_MBRUPD  ,&dfssdb,0,0     , 1,"Partition-table operations "  ,"Operations like NEWMBR, wipe disk-start, edit NT-signature, Convert MBR<>GPT");
TXSsubm(mmdc,DFSC_PTCLNR  ,&dfssdc,0,0     , 0,"Part-table cleanup/repair  "  ,"Cleanup and repair operations on MBR or GPT partition tables, CHS, Alignment");
TXSsubm(mmdl,DFSC_LVMBMGR ,&dfssd7,0,0     , 1,"OS/2 LVM and BootManager   "  ,"Manage all OS/2 LVM and Bootmanager information, Add, Remove, Delete, Change");
static TXS_ITEM *mmd[] =
{
   &mmd1, &mmdg, &mmdi, &mmsp,
   &mmd2, &mmd3, &mmdt, &mmd4, &mmdp, &mmdd, &mmsp,
   &mmd5, &mmd6, &mmds, &mmsp,
   &mmdb, &mmdc, &mmsp,
   &mmdl
};
TXSlist(dfsmmd,19,19,mmd);

// BASIC version of the above pull-down menu
static TXS_ITEM *mbd[] =
{
   &mmd1, &mmsp,
   &mmd2, &mmd3, &mmd4, &mmsp,
   &sdb2, &sdb6, &mmsp,
   &sdc1, &sdc2
};
TXSlist(dfsmbd,11,11,mbd);


//============================  Menu-Headings  =====================================================================


// Expert (dfsm.) and Basic (dfsb.) menu pull-down definitions
TXSmenu(dfsmd,&dfsmmd,DFSM_MENUBAR,0, 1,'m'," Mode=FDISK ",
        "Menu: [FDISK style and LVM partition management]   "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsbd,&dfsmbd,DFSM_MENUBAR,0, 1,'m'," Mode=FDISK ",
        "Menu: [FDISK style basic partition management]     "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm1,&dfsmm1,DFSM_MENUBAR,0, 1,'f'," File ",
        "Menu: [File operations and open disk/partitions]   "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb1,&dfsmb1,DFSM_MENUBAR,0, 1,'f'," File ",
        "Menu: [File operations and open disk/partitions]   "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm2,&dfsmm2,DFSM_MENUBAR,0, 1,'e'," Edit ",
        "Menu: [Edit partition-tables, LVM info, sectors]   "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb2,&dfsmb2,DFSM_MENUBAR,0, 1,'e'," Edit ",
        "Menu: [Edit partition-tables, LVM info (BASIC!)]   "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm3,&dfsmm3,DFSM_MENUBAR,0, 1,'a'," Actions ",
        "Menu: [Actions like erasing, cloning and resizing] "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb3,&dfsmb3,DFSM_MENUBAR,0, 1,'a'," Actions ",
        "Menu: [Actions like erasing, cloning and resizing] "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm4,&dfsmm4,DFSM_MENUBAR,0, 1,'i'," Image ",
        "Menu: [Image operations, create, restore, browse]  "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb4,&dfsmb4,DFSM_MENUBAR,0, 1,'i'," Image ",
        "Menu: [Image operations, create, restore, browse]  "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm5,&dfsmm5,DFSM_MENUBAR,0, 1,'v'," View ",
        "Menu: [View partitions, disks, LVM-info, lists]    "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb5,&dfsmb5,DFSM_MENUBAR,0, 1,'v'," View ",
        "Menu: [View partitions, disks, performance-info]   "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm7,&dfsmm7,DFSM_MENUBAR,0, 1,'s'," Scripts ",
        "Menu: [Run analysis, recovery or standard scripts] "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb7,&dfsmb7,DFSM_MENUBAR,0, 1,'s'," Scripts ",
        "Menu: [Run analysis, recovery or standard scripts] "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsmc,&dfsmmc,DFSM_MENUBAR,0, 1,'p'," Set ",
        "Menu: [Settings and Properties for DFSee and UI']     "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsbc,&dfsmbc,DFSM_MENUBAR,0, 1,'p'," Set ",
        "Menu: [Settings and Properties for DFSee and UI']     "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsm9,&dfsmm9,DFSM_MENUBAR,0, 1,'h'," Help ",
        "Menu: [Help on menu and commands plus 'about']     "
        "   Enter=menu Esc=commandline");

TXSmenu(dfsb9,&dfsmb9,DFSM_MENUBAR,0, 1,'h'," Help ",
        "Menu: [Help on menu and commands plus 'about']     "
        "   Enter=menu Esc=commandline");


//============================  Menu-Bars  =========================================================================


#define DFS_FS_MENU   2                         // index of FS specific expert menu
#define DFS_FSBASIC   2                         // index of FS specific basic menu

static TXS_MENUBAR basic_menu =
{
   9,                                           // max number of menus present
   0,                                           // index of 1st default menu
   {&dfsb1, &dfsb2,                             // menu pointers
    NULL,                                       // FS-specific one
    &dfsb3, &dfsb4, &dfsb5, &dfsb7, &dfsbc, &dfsb9},
    DFS_N " " DFS_V "; " DFS_C,                 // application description
    "Basic"                                     // menu indicator/toggle-button name
};

static TXS_MENUBAR expertmenu =
{
   9,                                           // max number of menus present
   0,                                           // index of 1st default menu
   {&dfsm1, &dfsm2,                             // menu pointers
    NULL,                                       // FS-specific one
    &dfsm3, &dfsm4, &dfsm5, &dfsm7, &dfsmc, &dfsm9},
    DFS_N " " DFS_V "; " DFS_C,                 // application description
    "Expert"                                    // menu indicator/toggle-button name
};


//============================  End static menu definitions  =======================================================


// Generate PHP menu-documentation for all known submenus
static void dfsGeneratePhpMenuDoc
(
   void
);


static int slVolumes_count = 0;                 // #volumes in slVolumes list


//- enable or mark menu-items by ID
#define dfsMiEnable(i,c,r) txwMiEnable(dfsGetMainMenu(),(i),(c),(r))
#define dfsMiMarked(i,c)   txwMiMarked(dfsGetMainMenu(),(i),(c),NULL)


// Standard window procedure, for any window-class
static ULONG dfsStdWindowProc                   // RET   result
(
   TXWHANDLE           hwnd,                    // IN    current window
   ULONG               msg,                     // IN    message id
   TXWMPARAM           mp1,                     // IN    msg param 1
   TXWMPARAM           mp2                      // IN    msg param 2
);

// Execute command (End/Silent), reopen SAME menu dropdown (option toggle etc)
static ULONG dfsExecReopenMenu
(
   BOOL                silent,                  // IN    Execute in silent mode
   char               *command                  // IN    Command to execute
);

// DFSee window procedure, for entry-field, includes automatic value-echo
static ULONG dfsEntryWindowProc                 // RET   result
(
   TXWHANDLE           hwnd,                    // IN    current window
   ULONG               msg,                     // IN    message id
   TXWMPARAM           mp1,                     // IN    msg param 1
   TXWMPARAM           mp2                      // IN    msg param 2
);


/*****************************************************************************/
// Start and maintain DFSee interactive text-based windowed user-interface
/*****************************************************************************/
ULONG dfsWindowed
(
   char               *initial                  // IN    initial DFSee cmd
)
{
   ULONG               rc = NO_ERROR;
   ULONG               bm;                      // border mode
   BOOL                vborder;                 // vertical borders
   BOOL                hborder;                 // horizontal borders
   BOOL                borders   = FALSE;       // forced borders, NO
   BOOL                noborders = FALSE;       // forced no-borders, NO
   TXLN                s0;

   ENTER();

   txwRegisterHelpText( DFSH_GENERIC, "dfsmainhelp",     "DFSee main help items",    mainwinhelp);
   txwRegisterHelpText( DFSH_MENUS,   "dfsmenusystem",   "DFSee menu system help",   menusyshelp);
   txwRegisterHelpText( DFSH_CONFIRM, "dfsconfirmation", "DFSee confirmation items", confirmhelp);

   //- load a few of the DFSee documentation files into the online help
   txwLoadRegisterHelpFile( "dfscmds",       "DFSee Command Reference",                 0, FALSE);
   txwLoadRegisterHelpFile( "dfsfdisk",      "FDISK related Commands",                  0, FALSE);
   txwLoadRegisterHelpFile( "dfscript",      "DFSee scripting overview",                0, FALSE);
   txwLoadRegisterHelpFile( "dfsterms",      "DFSee terminology explained",             0, FALSE);
   txwLoadRegisterHelpFile( "dfshowto",      "DFSee example scenarios",                 0, FALSE);

   //- load help from the most used DFSee SCRIPT files into the online help
   txwLoadRegisterHelpFile( "dfspuppy.dfs",  "Create DFSee USB PUPPY Linux stick",  81000,  TRUE);
   txwLoadRegisterHelpFile( "dfsusb32.dfs",  "Create DFSee USB FreeDOS bootstick",  82000,  TRUE);
   txwLoadRegisterHelpFile( "dfsinstl.dfs",  "Install a DFSee program update",      84000,  TRUE);
   txwLoadRegisterHelpFile( "dfsgetup.dfs",  "Download and install DFSee update",   85000,  TRUE);
   txwLoadRegisterHelpFile( "dfsgetpy.dfs",  "Download DFSPUPPY image file",        86000,  TRUE);
   txwLoadRegisterHelpFile( "dfsf32st.dfs",  "Create (OS/2)  FAT32 data stick",     87000,  TRUE);
   txwLoadRegisterHelpFile( "dfsf16st.dfs",  "Create (OS/2)  FAT16 data stick",     88000,  TRUE);
   txwLoadRegisterHelpFile( "dfsifstd.dfs",  "Create JFS/HPFS/NTFS data stick",     89000,  TRUE);

   if (TxaExeSwitchSet('f'))                    // frame switch specified
   {
      borders   = TxaExeSwitch('f');
      noborders = !borders;
   }
   TRACES(("borders:%u  noborders:%u\n", borders, noborders));

   vborder = (borders || ((TxScreenCols() > 84) && !noborders));
   hborder = (borders || ((TxScreenRows() > 27) && !noborders));

   sprintf( app_Title, "%s: %s %s", DFS_N, DFS_V, DFS_C);
   bm = TXWS_STDWINDOW | TXWS_FOOTRBORDER | TXWS_MOVEABLE;
   if (vborder)
   {
      bm |= TXWS_SIDEBORDERS;                   // add side borders
   }
   if (hborder)
   {
      bm |= TXWS_TITLEBORDER;                   // add title border
   }
   txwSetupWindowData(
      0, 0 ,                                    // upper left corner
      TxScreenRows(), TxScreenCols(),           // vert/hor size
      bm, DFS_H_APPLIC,                         // style / helpid
      ' ', ' ',
      cSchemeColor,    cSchemeColor,
      cDskTitleStand,  cDskTitleFocus,
      cDskFooterStand, cDskFooterFocus,
      app_Title, "",
      &desktopwin);

   if ((desktop = txwInitializeDesktop( &desktopwin, dfsStdWindowProc )) != 0)
   {
      TXRECT           dtsize;                  // desktop client size

      txwQueryWindowRect( desktop, FALSE, &dtsize); // get client area
      txwEnableWindow(    desktop, FALSE);      // no focus on desktop

      scrollBufData.length = DFS_SCROLL_L;
      scrollBufData.width  = max( DFS_SCROLL_W, TxScreenCols());
      scrollBufData.vsize  = dtsize.bottom -2;  // entryfield and sbstatus
      if (hborder)
      {
         scrollBufData.vsize--;                 // subtract SB title line
      }
      rc = txwInitPrintfSBHook( &scrollBufData);
      if (rc == TX_ALLOC_ERROR)                 // try smaller scroll-buffer
      {
         scrollBufData.length = DFS_SMALLB_L;
         scrollBufData.width  = DFS_SMALLB_W;
         rc = txwInitPrintfSBHook( &scrollBufData);
      }
      if (rc == NO_ERROR)
      {
         TXRECT   sbsize;                       // scrollbuf client size

         bm = TXWS_CHILDWINDOW | TXWS_MOVEABLE | TXWS_SAVEBITS |
              TXWS_HCHILD_SIZE | TXWS_VCHILD_SIZE;
         if (vborder)
         {
            bm |= TXWS_SIDEBORDERS;             // add side borders
         }
         if (hborder)
         {
            bm |= TXWS_TITLEBORDER;             // add title border only
         }                                      // (status replaces footer)
         txwSetupWindowData(
            0, 0 ,                              // upper left corner
            dtsize.bottom -1,                   // vertical size
            dtsize.right,                       // horizontal size
            bm, DFS_H_OUTWIN,                   // style & help
            ' ', ' ', TXWSCHEME_COLORS,
            " Output-window (click title to toggle menu, right-border to scroll up/down) ",
            "", &scrbuffwin);
         scrbuffwin.sb.topline = scrollBufData.firstline;
         scrbuffwin.sb.leftcol = 0;
         scrbuffwin.sb.sbdata  = &scrollBufData;
         scrbuffwin.sb.scolor  = cSchemeColor;
         scrbuffwin.sb.altcol  = 0;             // set in scheme! (txwdraw.h)
         sbufwin = txwCreateWindow( desktop, TXW_SBVIEW, desktop, 0,
                                    &scrbuffwin, dfsStdWindowProc);
         scrollBufData.view = sbufwin;          // register view for update
         txwQueryWindowRect( sbufwin, FALSE, &sbsize);
         dfsa->sbWidth  = sbsize.right;
         dfsa->sbLength = sbsize.bottom;
         TRACES(("sbW: %hu  sbL: %hu\n", dfsa->sbWidth, dfsa->sbLength));
         txwSetWindowUShort(  sbufwin, TXQWS_ID, DFS_WID_SCROLL);
         txwInvalidateWindow( sbufwin, TRUE, TRUE);

         dfsa->sbwindow = sbufwin;              // make handle available

         //- commandline entryfield
         bm = TXWS_CHILDWINDOW | TXWS_SIDEBORDERS | TXES_MAIN_CMDLINE |
              TXWS_HCHILD_SIZE | TXWS_VCHILD_MOVE;

         txwSetupWindowData(
            dtsize.bottom -1, 0,                // upper left corner
            1, dtsize.right,                    // vert + hor size
            bm, DFS_H_INTERF,                   // style & helpid
            ' ', ' ',
            cSchemeColor, cEntrBorder_top,
            cSchemeColor, cSchemeColor,
            cSchemeColor, cSchemeColor,
            "", "",
            &entryfwin);
         entryfwin.ef.leftcol  = 0;
         entryfwin.ef.maxcol   = TXW_INVALID;
         entryfwin.ef.curpos   = 0;
         entryfwin.ef.markCol  = 0;
         entryfwin.ef.markSize = 0;
         entryfwin.ef.rsize    = TXMAXLN;
         entryfwin.ef.buf      = entryftxt;
         entryfwin.ef.history  = &cmd_history;

         entrwin = txwCreateWindow( desktop, TXW_ENTRYFIELD, sbufwin, 0,
                                   &entryfwin, dfsEntryWindowProc);

         txwInitializeHistory( entryfwin.ef.history, DFS_HIST_SIZE, DFS_HIST_LINE);
         txwSetWindowUShort(   entrwin, TXQWS_ID, DFS_WID_ENTRY);
         txwSetFocus(          entrwin);
         txwInvalidateWindow(  entrwin, TRUE, TRUE);

         dfsa->cmdwindow = entrwin;             // make handle available

         sprintf( s0, "Reading partition-information ...");
         txwSendMsg( dfsa->sbwindow, TXWM_STATUS, (TXWMPARAM) s0, (TXWMPARAM) cSchemeColor);

         if (dfsPartitions() == 0)
         {
            dfsReadDiskInfo( FDSK_QUIET);       // re-read all partition info
         }                                      // including selection-lists

         strcpy( s0, "");
         if (!TxaExeSwitchUnSet(TXA_O_MENU))    // automatic menu activation
         {
            char     *open   = TxaExeSwAsString( TXA_O_MENU, TXMAXLN, s0);

            dfsa->automenu   = TRUE;
            dfsa->menuOwner  = entrwin;
            if (*open != 0)
            {
               dfsa->menuopen   = (ULONG) tolower(open[0]);
            }
         }

         bm = TxaExeSwitchNum( 'M', NULL, 0);   // init from EXE switch, or default 0
         dfsa->rightmove = ((bm & 0x1) != 0);   // default is rightmove OFF
         dfsa->autodrop  = ((bm & 0x2) == 0);   // default is auto-drop ON
         dfsa->delaydrop = ((bm & 0x4) != 0);   // default is delaydrop OFF

         TRACES(("bm:%u autodrop: %s  delaydrop: %s  rightmove: %s\n",
                  bm, (dfsa->autodrop)  ? "YES" : "NO",
                      (dfsa->delaydrop) ? "YES" : "NO",
                      (dfsa->rightmove) ? "YES" : "NO"));

         if (TxaExeSwitch('S'))                 // Shell mode, define as accel
         {                                      // avoids low-level processing
            txwSetAccelerator( entrwin, TXa_F3,  DFSC_EXIT);
         }
         txwSetAccelerator( entrwin, TXk_F2,     DFSC_HEXASC);
         txwSetAccelerator( entrwin, TXa_F2,     DFSC_SHEXED);
         txwSetAccelerator( entrwin, TXc_F2,     DFSC_HEX16B);
         txwSetAccelerator( entrwin, TXa_T,      DFSC_HEX16B);
         txwSetAccelerator( entrwin, TXk_F3,     DFSC_EXIT);
         txwSetAccelerator( entrwin, TXk_F4,     DFSC_SAVE);
         txwSetAccelerator( entrwin, TXk_F5,     DFSC_PARTSTD);
         txwSetAccelerator( entrwin, TXs_F5,     DFSC_PARTALT);
         txwSetAccelerator( entrwin, TXa_F5,     DFSC_PARTNUM);
         txwSetAccelerator( entrwin, TXc_F5,     DFSC_PARTNEX);
         txwSetAccelerator( entrwin, TXk_F6,     DFSC_OPART);
         txwSetAccelerator( entrwin, TXs_F9,     DFSC_FBROWSE);
         txwSetAccelerator( entrwin, TXk_F9,     DFSC_XBROWSE);
         txwSetAccelerator( entrwin, TXk_F10,    DFSM_DEFAULT);
         txwSetAccelerator( entrwin, TXs_F10,    DFSM_DEFAULT);
         txwSetAccelerator( entrwin, TXk_MENU,   DFSM_DEFAULT);
         txwSetAccelerator( entrwin, TXs_F11,    DFSC_ABOUT);
         txwSetAccelerator( entrwin, TXs_F4,     DFSC_ABOUT); // will be _F6 on Linux console
         txwSetAccelerator( entrwin, TXs_F6,     DFSC_ABOUT); // will be _F6 on xterm and rest
         txwSetAccelerator( entrwin, TXk_LWIN,   DFSM_FILE);
         txwSetAccelerator( entrwin, TXk_RWIN,   DFSM_ACTI);

         txwSetAccelerator( entrwin, TXa_A,      DFSM_ACTI);
         txwSetAccelerator( entrwin, TXa_D,      DFSM_DISP);
         txwSetAccelerator( entrwin, TXa_E,      DFSM_EDIT);
         txwSetAccelerator( entrwin, TXa_F,      DFSM_FILE);
         txwSetAccelerator( entrwin, TXa_H,      DFSM_HELP);
         txwSetAccelerator( entrwin, TXa_I,      DFSM_IMAG);
         txwSetAccelerator( entrwin, TXa_M,      DFSM_MODE);
         txwSetAccelerator( entrwin, TXa_R,      DFSC_FINDAG);
         txwSetAccelerator( entrwin, TXa_S,      DFSC_FINDTC);

         txwSetAccelerator( entrwin, TXa_3,      DFSC_EXPERT);
         txwSetAccelerator( entrwin, TXc_B,      DFSC_THISHEX);
         txwSetAccelerator( entrwin, TXc_G,      DFSC_DISPLSN);
         txwSetAccelerator( entrwin, TXc_Q,      DFSC_EXIT);
         txwSetAccelerator( entrwin, TXc_T,      DFSC_THISASC);
         txwSetAccelerator( entrwin, TXc_U,      DFSC_UMEDIA);
         txwSetAccelerator( entrwin,   '>',      DFSC_THISPLS);
         txwSetAccelerator( entrwin,   '<',      DFSC_THISMIN);

         if (((dfsStartupLogo( initial) & DFS_QUIT) != DFS_QUIT) && !dfsa->autoquit)
         {
            TXWQMSG             qmsg;

            while (txwGetMsg(  &qmsg))
            {
               txwDispatchMsg( &qmsg);
            }
            if (qmsg.msg == TXWM_SCREENRESIZE)
            {
               dfsa->retc = TX_DISPLAY_CHANGE;  // signal restart UI needed
            }
            TRACES(("End msg-loop dfsa->retc = %u\n", dfsa->retc));
            #if defined (REGISTRATION)
               if (dfsa->retc != TX_DISPLAY_CHANGE)
               {
                  dfsRegistrationInfo( DFSRG_CONFIRM_ONLY, DFS_V, dfsa->regconfirm);
               }
            #endif
         }
         txwTerminateHistory( &cmd_history);
         txwTermPrintfSBHook();
      }
      else
      {
         TxPrint("SBuf init error %u, failed to initialize desktop!\n", rc);
         TRACES(("Setting retc to: %u = 0x%X\n", rc, rc));
         dfsa->retc = rc;
      }
      txwTerminateHelpManager();
      txwTerminateDesktop();

      if (dfsa->retc == TX_DISPLAY_CHANGE)      // re-init TXWIN after desktop close!
      {
         TxScreenTerminate();
         TxScreenInitialize();                  // reinit at new windowsize
      }
   }
   else
   {
      TxPrint("Failed to initialize desktop\n");
   }
   RETURN (dfsa->retc);
}                                               // end 'dfsWindowed'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// DFSee standard window procedure, for any window-class
/*****************************************************************************/
static ULONG dfsStdWindowProc                   // RET   result
(
   TXWHANDLE           hwnd,                    // IN    current window
   ULONG               msg,                     // IN    message id
   TXWMPARAM           mp1,                     // IN    msg param 1
   TXWMPARAM           mp2                      // IN    msg param 2
)
{
   ULONG               rc = NO_ERROR;
   TXWINDOW           *win;
   ULONG               lp1 = (ULONG) mp1;
   ULONG               lp2 = (ULONG) mp2;
   TXLN                s0, s1, s2;
   ULN64               lsn;
   ULONG               nr;
   ULONG               flag = 0;
   DFSPARTINFO        *p    = NULL;
   DFSDISKINFO        *d    = NULL;
   static BOOL         ffVerbose = FALSE;       // list while searching
   static BOOL         ffOption1 = FALSE;       // command option 1
   static BOOL         ffOption2 = FALSE;       // command option 2
   static BOOL         ffOption3 = FALSE;       // command option 3
   static BOOL         ffOption4 = FALSE;       // command option 4

   ENTER();
   TRCMSG( hwnd, msg, mp1, mp2);
   if (hwnd != 0)
   {
      TRCLAS( "DFS std - ", hwnd);
      win = txwWindowData( hwnd);
      switch (msg)
      {
         case TXWM_COMMAND:
            switch (lp1)                // unique command code
            {
               case DFSM_FILE:
               case DFSM_EDIT:
               case DFSM_DISP:
               case DFSM_ACTI:
               case DFSM_HELP:
               case DFSM_MODE:
               case DFSM_DEFAULT:
               case DFSM_AUTODELAY:
                  {
                     ULONG       menuopen;
                     DFSTORETYPE storeType = dfstStoreType(DFSTORE);
                     ULONG       psize   = (SINF->p) ? SINF->p->sectors : 0;
                     BYTE        st = dfsIdentifySector( nav.this, nav.this_sninfo, rbuf);
                     ULONG       kmgAlign = dfsAlignmentSectors(((SINF->p) &&
                                (SINF->p->tablenr == GPT_STYLE)) ? 'G' : 'P', SINF->p);


                     //- Refresh the Volumelist for the submenus when needed
                     if (slVolumes_count == 0)  // only when #drives changed
                     {
                        ULONG       volumeTypes = TXFSV_HD | TXFSV_CD;

                        if (dfsa->volFloppy)
                        {
                           volumeTypes |= TXFSV_FLOP;
                        }
                        sprintf( s1, "Updating volume info and dynamic menus ...");
                        txwSendMsg( dfsa->sbwindow, TXWM_STATUS, (TXWMPARAM) s1, (TXWMPARAM) cSchemeColor);

                        slVolumes_count = TxFsVolumes( volumeTypes, s1);
                        txSelDestroy( &(dfsa->slVolumes)); // remove volume list
                        dfsa->slVolumes = TxFsDriveSelist( volumeTypes, FALSE);

                        txSelDestroy(  &(dfsa->slReMedia)); // remove rem list
                        dfsa->slReMedia = TxFsDriveSelist( TXFSV_REM | volumeTypes, FALSE);

                        txwSendMsg( dfsa->sbwindow, TXWM_STATUS, (TXWMPARAM) "", (TXWMPARAM) cSchemeColor);
                     }
                     txSelDestroy(          &(dfsa->slSchemes)); // remove scheme list
                     TxSelistColorSchemes(  &(dfsa->slSchemes)); // and refresh it
                     txSelDestroy(          &(dfsa->slPalette)); // remove palette list
                     TxSelistColorPalettes( &(dfsa->slPalette)); // and refresh it

                     //- refresh enabled-items in filtered-freespace Selists
                     if (SINF->partid == 0)     // no partition, CREATE mode
                     {
                        dfsa->nrFreeMBm = dfsFreeSlEnable( dfsa->slFreeMBm,
                           L64_NULL,            // minimum is 1 track size
                           FALSE, 0, 'P');      // of PRIMARY, for BM-install
                        dfsa->nrFreeCCr = dfsFreeSlEnable( dfsa->slFreeCCr,
                           L64_NULL,            // minimum is 1 track size
                           TRUE, 0, '*');       // for CREATE partition
                     }
                     else                       // partition, MOVE/COPY
                     {
                        dfsa->nrFreeMBm = dfsFreeSlEnable( dfsa->slFreeMBm,
                           SINF->p->sectors,    // minimum is part size
                           FALSE, SINF->p->disknr,
                           (SINF->p->tablenr == GPT_STYLE) ? 'G' :
                           (SINF->p->primary)              ? 'P' : 'L');
                        dfsa->nrFreeCCr = dfsFreeSlEnable( dfsa->slFreeCCr,
                           SINF->p->sectors,    // minimum is part size
                           FALSE, 0,
                           (SINF->p->tablenr == GPT_STYLE) ? 'G' :
                           (SINF->p->primary)              ? 'P' : 'L');
                     }
                     dfsa->nrFreeGPr = dfsFreeSlEnable( dfsa->slFreeGPr,
                        1, FALSE,               // minimum is 1 sector, no CR
                        FDSK_ANY, 'P');         // of PRIMARY alignment (P, G)
                     dfsa->nrFreeLog = dfsFreeSlEnable( dfsa->slFreeLog,
                        1, FALSE,               // minimum is 1 sector, no CR
                        0, 'L');                // of PRIMARY alignment (P, G)

                     //- (re) attach the FS specific menu
                     dfsAttachFsPulldown();

                     //- Attach the FS-specific selist to each of the implemented items
                     mmii.userdata = dfsa->FsModeSelist; // DFSB_ISOVDI
                     mmpv.userdata = dfsa->FsModeSelist; // DFSB_APFSVI

                     //- (re) attach the dynamic submenus
                     sdb0.userdata = dfsa->slPartOne; // DFSB_PTEDIT in Fdisk
                     mm21.userdata = dfsa->slPartOne; // DFSB_PTEDIT in EDIT
                     mm22.userdata = dfsa->slPartOne; // DFSB_LVMDLG in Fdisk
                     sd71.userdata = dfsa->slPartOne; // DFSB_LVMDLG in EDIT
                     mmdg.userdata = dfsa->slDiskOne; // DFSB_GEODLG in FDISK
                     mmdd.userdata = dfsa->slDiskOne; // DFSB_ODISK  in FDISK
                     s1o2.userdata = dfsa->slDiskOne; // DFSB_ODISK  in FILE
                     s1o3.userdata = dfsa->slPartOne; // DFSB_OPART
                     b1o2.userdata = dfsa->slDiskOne; // DFSB_ODISK  in FILE (BASIC)
                     b1o3.userdata = dfsa->slPartOne; // DFSB_OPART          (BASIC)
                     s1o8.userdata = dfsa->slPartOne; // DFSB_VPART
                     s1of.userdata = dfsa->slFreeGPr; // DFSB_OFPRI
                     s1ol.userdata = dfsa->slFreeLog; // DFSB_OFLOG
                     s1o4.userdata = dfsa->slVolumes; // DFSB_OVOLM
                     s1o9.userdata = dfsa->slVolumes; // DFSB_VVOLM
                     smm2.userdata = dfsa->slDiskMnt; // DFSB_DETACH
                     smm4.userdata = dfsa->slReMedia; // DFSB_MEJECT
                     mm1b.userdata = dfsa->slBootabl; // DFSB_BMGR
                     mmbm.userdata = dfsa->slBootabl; // DFSB_BMDEFL
                     s26s.userdata = dfsa->slSchemes; // DFSB_SCHEME
                     s26p.userdata = dfsa->slPalette; // DFSB_PALET

                     sdv3.userdata = dfsa->slDiskOne; // DFSB_UMTVOL
                     sdv4.userdata = dfsa->slDiskOne; // DFSB_MNTVOL

#if !defined (DOS32)
                     mm7x.userdata = dfsa->slDiskOne; // DFSB_MPUP64
                     mm7b.userdata = dfsa->slDiskOne; // DFSB_MPUP32
                     mm7p.userdata = dfsa->slDiskOne; // DFSB_MPUPPY
                     mm7u.userdata = dfsa->slDiskOne; // DFSB_MUSB32
                     mm73.userdata = dfsa->slDiskOne; // DFSB_MF32ST
                     mm76.userdata = dfsa->slDiskOne; // DFSB_MF16ST
                     mm7i.userdata = dfsa->slDiskOne; // DFSB_MIFSTD
                     mm7j.userdata = dfsa->slDiskOne; // DFSB_MJFS35
#endif
                     mm7f.userdata = dfsa->slDiskAll; // DFSB_DFSFAST
                     mm7d.userdata = dfsa->slDiskAll; // DFSB_DFSDISK
                     mm7c.userdata = dfsa->slPartAll; // DFSB_CHKPART

                     s3a3.userdata = dfsa->slFreeAll; // DFSB_WIPEFSP
                     s3m1.userdata = dfsa->slFreeCCr; // DFSB_COPY2F
                     s3m2.userdata = dfsa->slFreeMBm; // DFSB_MOVE2F
                     mmx5.userdata = dfsa->slPartAll; // DFSB_LVMINFO
                     mm56.userdata = dfsa->slDiskOne; // DFSB_WALKRAW
                     mm5s.userdata = dfsa->slPartOne; // DFSB_SECPART
                     mm5e.userdata = dfsa->slPartOne; // DFSB_EBRPART
                     s3f1.userdata = dfsa->slPartOne; // DFSB_FMTFAT
                     b3f1.userdata = dfsa->slPartOne; // DFSB_FMTFAT

                     mmd2.userdata = dfsa->slFreeCCr; // DFSB_CREATE
                     mmd3.userdata = dfsa->slPartOne; // DFSB_DELETE
                     mmdt.userdata = dfsa->slPartOne; // DFSB_CHTYPE
                     sd41.userdata = dfsa->slPartOne; // DFSB_ACTIVE
                     sd42.userdata = dfsa->slPartOne; // DFSB_NOTACT
                     sd43.userdata = dfsa->slPartOne; // DFSB_P_HIDE
                     sd44.userdata = dfsa->slPartOne; // DFSB_UNHIDE
                     sd45.userdata = dfsa->slPartOne; // DFSB_MULTIV
                     mmdp.userdata = dfsa->slPartOne; // DFSB_OPART
                     mmd5.userdata = dfsa->slDiskAll; // DFSC_SAVEPD
                     mmd6.userdata = dfsa->slDiskSam; // DFSC_RESTPD
                     mmds.userdata = dfsa->slDiskAll; // DFSC_GENPDLG
                     sdc2.userdata = dfsa->slDiskAll; // DFSB_FIXCHS
                     sd91.userdata = dfsa->slDiskAll; // DFSB_FIXEXT
                     sd92.userdata = dfsa->slDiskAll; // DFSB_FIXEXF
                     sdc1.userdata = dfsa->slDiskAll; // DFSB_CLEANUP
                     sdc4.userdata = dfsa->slDiskAll; // DFSB_ALIGND
                     sdc5.userdata = dfsa->slPartLog; // DFSB_ALIGNL
                     sdc6.userdata = dfsa->slDiskOne; // DFSB_GPTFIX
                     sdbg.userdata = dfsa->slDiskOne; // DFSB_MBR2GPT
                     sdbm.userdata = dfsa->slDiskOne; // DFSB_GPT2MBR
                     sdb1.userdata = dfsa->slDiskOne; // DFSB_NEWMBC
                     sdb2.userdata = dfsa->slDiskAll; // DFSB_NEWMBR
                     sdb3.userdata = dfsa->slDiskAll; // DFSB_NEWMBI
                     sdb4.userdata = dfsa->slDiskOne; // DFSB_SAVMBR
                     sdb5.userdata = dfsa->slDiskAll; // DFSB_NTSIGN
                     sdb6.userdata = dfsa->slDiskOne; // DFSB_WIPEST
                     sdb7.userdata = dfsa->slDiskOne; // DFSB_WIPET1
                     sd7l.userdata = dfsa->slDiskOne; // DFSB_LVMCLN
                     sd7c.userdata = dfsa->slDiskAll; // DFSB_LVMCRC
                     sdbe.userdata = dfsa->slPartOne; // DFSB_WEBRT1
                     mmfm.userdata = dfsa->slDiskOne; // DFSB_W2KBMG
                     mmim.userdata = dfsa->slFreeMBm; // DFSB_BMINST
                     mmam.userdata = dfsa->slPartOne; // DFSB_BMMENU
                     mmdm.userdata = dfsa->slPartOne; // DFSB_BMDELM
                     sd72.userdata = dfsa->slPartOne; // DFSB_LVMRMV
                     sd73.userdata = dfsa->slPartOne; // DFSB_LVMDEF
                     sd74.userdata = dfsa->slDiskAll; // DFSB_LVMVCU
                     sd7r.userdata = dfsa->slDiskAll; // DFSB_LVMRED
                     sd75.userdata = dfsa->slDiskAll; // DFSB_LVMPCL
                     sd76.userdata = dfsa->slDiskOne; // DFSB_LVMDNM
                     sd77.userdata = dfsa->slDiskAll; // DFSB_LVMGEO
                     sd78.userdata = dfsa->slDiskAll; // DFSB_LVMBBR

                  #if defined (DOS32)
                     dfsMiEnable( DFSC_UPDATE,   FALSE                                                , "Downloading and installing program updates or DFSPUPPY images "
                                                                                                        "is NOT POSSIBLE in the (Free)DOS version, no internet access!");
                  #endif

                     dfsMiEnable( DFSC_FMTLDR,   dfsGetLogicalSize()  <= FAT16_LIMIT                  , "Object is too large for a FAT16 filesystem (limit is 2GB)");
                     dfsMiEnable( DFSB_BMGR,     dfsa->slBootabl      != NULL                         , "There are no partitions marked as 'bootable' for the IBM bootmanager");
                     dfsMiEnable( DFSB_BMDEFL,   dfsa->slBootabl      != NULL                         , "There are no partitions marked as 'bootable' for the IBM bootmanager");
                     dfsMiEnable( DFSB_BMDELM,   dfsa->slBootabl      != NULL                         , "There are no partitions marked as 'bootable' for the IBM bootmanager");
                     dfsMiEnable( DFSC_EXIT,     TxaExeSwitch('S')    == FALSE                        , "Startup switch '-S' for Shell-mode was specified");
                     dfsMiEnable( DFSC_ALLOCMP,  dfsa->FsAllocDisplay != NULL                         , "The active 'Mode=xxx' has no capability provide an allocation overview");
                     dfsMiEnable( DFSC_LVMINFO,  dfsa->lvmPresent                                     , "No LVM information sectors (DLAT) where found on any disk");
                     dfsMiEnable( DFSC_JMAGIC,   dfsa->FsDirtyStatus != DFSTAT_DIRTY                  , "The current selected JFS filesystem is marked 'Dirty',\nit should be 'Unmounted-Clean'. You could:\n"
                                                                                                        "\n - Force this from the 'Mode=JFS' menu "
                                                                                                        #if defined (DEV32)
                                                                                                          "(not recommended)"
                                                                                                          "\n - Remove its driveletter from the LVM info and reboot");
                                                                                                        #elif defined (UNIX)
                                                                                                          "(not recommended)"
                                                                                                          "\n - Unmount the partition explicitly using 'umount' or a disk utility"
                                                                                                          "\n - Remove the partition from the /etc/fstab file, and reboot");
                                                                                                        #else
                                                                                                           );
                                                                                                        #endif
                     dfsMiEnable( DFSC_CLRLIST,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_EXPLIST,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_LVALUES,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_COMPACT,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_LBROWSE,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_VERBOSE,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_RECOVER,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_WIPELST,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_LISTIDS,  dfsa->snlist[0] != 0                                 , "The DFSee sector list is empty, you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_LISTFSC, (dfsa->snlist[0] != 0) && (strlen(dfsa->snifsmode))   , "No filesystem (Mode=xxx) was recorded with the list, or\n"
                                                                                                        "the DFSee sector list is empty, and you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_LISTFSV, (dfsa->snlist[0] != 0) && (strlen(dfsa->snifsmode))   , "No filesystem (Mode=xxx) was recorded with the list, or\n"
                                                                                                        "the DFSee sector list is empty, and you need to perform a search operation, a directory display or IMPORT from a file first");
                     dfsMiEnable( DFSC_FSAVETO, (st == 'f') || (st == 'z')                            , "The current sector is not of a type that allows file-recovery,\nyou would need a type 'f' or 'z', which are:\n"
                                                                                                        "\n - for HPFS: an FNODE for a regular or deleted file"
                                                                                                        "\n - for JFS:  an INODE for a regular or deleted file"
                                                                                                        "\n - for EXTn: an INODE for a regular (not deleted) file"
                                                                                                        "\n - for NTFS: an MFT record for a regular or deleted file"
                                                                                                        "\n\nOther filesystems do not support recovering files this way at all.");

                     dfsMiEnable( DFSC_XFIXHS,    SINF->partid != 0                                   , "The currently selected object is NOT a partition");
                     dfsMiEnable( DFSC_DELTHIS,   SINF->partid != 0                                   , "The currently selected object is NOT a partition");
                     dfsMiEnable( DFSC_ACTHIS,   (SINF->partid != 0) && (SINF->p->primary)            , "The currently selected object is NOT a PRIMARY partition");

                     dfsMiEnable( DFSC_FWIPEZ0,   SINF->partid != 0                                   , "The currently selected object is NOT a partition");
                     dfsMiEnable( DFSC_DWIPEZ0,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_XBROWSE,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_FMTOBJ,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_SIMCUR,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");

                     dfsMiEnable( DFSC_SHEXED,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_HEXASC,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_DISASM,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_TXTSTR,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_STREDT,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_FINDTC,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_FINDAG,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_FIND00,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_FINDFE,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_HEX16B,   storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_SCAN_RO,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_SCAN_RW,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_WRIMAGE,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_WIPETHS,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_WIPEZER,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_WIPESEC,  storeType != DFST_UNUSED                             , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_ZERFREE, (dfsa->FsModeId != DFS_FS_FDISK) && (dfsa->FsLsnAllocated)    , "The currently selected object does NOT contain a filesystem with allocation information");
                     dfsMiEnable( DFSC_SECFREE, (dfsa->FsModeId != DFS_FS_FDISK) && (dfsa->FsLsnAllocated)    , "The currently selected object does NOT contain a filesystem with allocation information");


                     dfsMiEnable( DFSC_MOVECOP,   SINF->partid != 0                                   , "The currently selected object is NOT a partition, Copy/Move not supported");
                     dfsMiEnable( DFSC_RESIZIN,  dfsa->FsTruncateSize != NULL                         , "The current filesystem (Mode=xxx) does NOT support resizing with DFSee."
                                                                                                        "\nYou need to select an HPFS, NTFS or FAT partition first, or force the"
                                                                                                        "\nMode=AUX to allow expanding the partition only, not the filesystem.");

                     //- Note the the resize/expand menu-items are NOT REACHABLE at all for non-supported filesystems
                     //- since these do not enable the top-level submenu for resizing (see above)
                     if (dfsa->FsModeId == DFS_FS_FAT) // expand possible for ANY filesystem, if freespace AFTER
                     {
                        dfsMiEnable( DFSC_REXPAND, (psize != 0)      &&
                                      (dfsa->FsExpandSize >= psize + kmgAlign)                        , "Expanding a FAT filesystem will NOT change the clustersize!"
                                                                                                        "\nExpanding FAT16/32 is possible only when:"
                                                                                                        "\n - Size of FAT areas is not at the maximum yet (FAT32 always OK)."
                                                                                                        "\n   FAT16 size can at most be doubled, unless previously made smaller."
                                                                                                        "\n - There is sufficient freespace directly AFTER this partition.");
                     }
                     else
                     {
                        dfsMiEnable( DFSC_REXPAND, (psize != 0)      &&
                                      (dfsa->FsExpandSize >= psize + kmgAlign)                        , "The maximum calculated size for this partition is too close to the current size to allow making it larger. ");
                     }

                     dfsMiEnable( DFSC_RESIZET, (psize != 0)      &&
                                   (dfsa->FsTruncPoint != 0)      &&
                                   (dfsa->FsTruncPoint <= psize - kmgAlign)                           , "The minimum calculated size for this partition is too close to the current size to allow making it smaller. "
                                                                                                        "Rearanging data inside the filesystem, using tools like defragmenters may help");
                     if (dfsa->FsModeId == DFS_FS_FAT)
                     {
                        dfsMiEnable( DFSC_RESIMAX, (psize != 0)      &&
                                     ((dfsa->FsExpandSize == 0) ||
                                      (dfsa->FsExpandSize >  psize)) &&
                                      (dfsa->FsTruncPoint != 0)      &&
                                      (dfsa->FsTruncPoint <= psize - kmgAlign)                        , "Expanding a FAT filesystem will NOT change the clustersize!"
                                                                                                        "\nExpanding FAT16/32 is possible only when:"
                                                                                                        "\n - Size of FAT areas is not at the maximum yet (FAT32 always OK)."
                                                                                                        "\n   FAT16 size can at most be doubled, unless previously made smaller.");
                     }
                     else
                     {
                        dfsMiEnable( DFSC_RESIMAX, (psize != 0)      &&
                                     ((dfsa->FsExpandSize == 0) ||
                                      (dfsa->FsExpandSize >  psize)) &&
                                      (dfsa->FsTruncPoint != 0)      &&
                                      (dfsa->FsTruncPoint <= psize - kmgAlign)                        , "The resizing limits are not set yet (use 'part PID -a') or the current size for the FS already is too close to the partition size.");
                     }

                     dfsMiEnable( DFSC_MOVE2E, (SINF->partid           != 0)   &&
                                               (SINF->p->lvmDriveLinks <= 1)   &&
                                               (SINF->p->fspAfter      != NULL)                       , "The current object is NOT a partition, "
                                                                                                        "or it is part of a multi-partition volume (LVM/JFS), "
                                                                                                        "or there is no freespace directly AFTER this partition");
                     dfsMiEnable( DFSC_MOVE2B, (SINF->partid           != 0)   &&
                                               (SINF->p->lvmDriveLinks <= 1)   &&
                                               (SINF->p->fspChain      != NULL)                       , "The current object is NOT a partition, "
                                                                                                        "or it is part of a multi-partition volume (LVM/JFS), "
                                                                                                        "or there is no freespace directly BEFORE this partition");

                     TRACES(("SINF->partid: %2.2hu  nrFreeMBm: %u   nrFreeCCr: %u\n",
                              SINF->partid,   dfsa->nrFreeMBm, dfsa->nrFreeCCr));

                     dfsMiEnable( DFSB_CREATE, (SINF->partid           == 0) &&
                                               (dfsa->nrFreeCCr        != 0)                          , "The current object is NOT a partitionable disk, "
                                                                                                        "or there is no freespace available on any disk large enough for a new partition");
                     dfsMiEnable( DFSB_BMINST, (SINF->partid           == 0) &&
                                               (dfsa->nrFreeMBm        != 0)                          , "There is no PRIMARY freespace available on any partitionable disk large enough for the Bootmanager");
                     dfsMiEnable( DFSB_MOVE2F, (SINF->partid           != 0) &&
                                               (SINF->p->lvmDriveLinks <= 1) &&
                                               (dfsa->nrFreeMBm        != 0)                          , "The current object is NOT a partition, "
                                                                                                        "or it is part of a multi-partition volume (LVM/JFS), "
                                                                                                        "or there is no suitable (PRI/LOG) freespace available on this SAME DISK large enough to move it to");
                     dfsMiEnable( DFSB_COPY2F, (SINF->partid           != 0) &&
                                               (SINF->p->lvmDriveLinks <= 1) &&
                                               (dfsa->nrFreeCCr        != 0)                          , "The current object is NOT a partition, "
                                                                                                        "or it is part of a multi-partition volume (LVM/JFS), "
                                                                                                        "or there is no suitable (PRI/LOG) freespace available large enough to hold a copy");

                     dfsMiEnable( DFSB_W2KBMG,  dfsa->bmgrDisk != 0                                   , "The IBM bootmanager is NOT installed on any disk");
                     dfsMiEnable( DFSC_BMCONF,  dfsa->bmgrDisk != 0                                   , "The IBM bootmanager is NOT installed on any disk");
                     dfsMiEnable( DFSB_BMMENU,  dfsa->bmgrDisk != 0                                   , "The IBM bootmanager is NOT installed on any disk");
                     dfsMiEnable( DFSB_BMDELM,  dfsa->bmgrDisk != 0                                   , "The IBM bootmanager is NOT installed on any disk");
                     dfsMiEnable( DFSB_BMDEFL,  dfsa->bmgrDisk != 0                                   , "The IBM bootmanager is NOT installed on any disk");
                     dfsMiEnable( DFSC_BMTIME,  dfsa->bmgrDisk != 0                                   , "The IBM bootmanager is NOT installed on any disk");
                     dfsMiEnable( DFSC_DISPLSN, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_DISPSEC, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_THISPLS, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_THISMIN, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_NEXTDEF, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_BASEVAL, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_IOSPEED, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_IOSPRWR, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");
                     dfsMiEnable( DFSC_IOSPLBF, storeType != DFST_UNUSED                              , "There is no object to work with. You first need to select a disk, partition, volume or an image");

                     dfsMiEnable( DFSC_FS_HELP, dfsa->FsCmdHelp != NULL                               , "The active 'Mode=xxx' has no specific commands defined");

                     #if defined (DEV32)
                        dfsMiMarked( DFSC_LVMSYNC, dfsa->lvmSyncApi);
                     #endif
                     dfsMiMarked( DFSC_MHLINKS, dfsa->FsToggleOption1);
                     dfsMiMarked( DFSC_MFALIAS, dfsa->FsToggleOption2);
                     dfsMiMarked( DFSC_SHOWHID, dfsa->browseShowHidden);
                     dfsMiMarked( DFSC_FHIDDEN, TxGetFdlgShowHidden());
                     dfsMiMarked( DFSC_RMBMENU, TxGetRmb2MenuKey());
                     dfsMiMarked( DFSC_GEOCALC, dfsa->geoCalc);
                     dfsMiMarked( DFSC_PTYPE0,  dfsa->pt0Show);
                     dfsMiMarked( DFSC_GPTAUTO, dfsa->gptAuto);
                     dfsMiMarked( DFSC_VOLFLOP, dfsa->volFloppy);
                     dfsMiMarked( DFSC_LOGAUTO, dfsa->logAuto);
                     dfsMiMarked( DFSC_LOGDATE, dfsa->logDate);
                     dfsMiMarked( DFSC_IGNERR, (dfsa->eStrategy == TXAE_IGNORE));
                     dfsMiMarked( DFSC_RDONLY,  dfsa->ReadOnly);
                     dfsMiMarked( DFSC_BATCH,   dfsa->batch);

                     dfsMiMarked( DFSC_INVSCR,  txwSbColorStyle(TXSB_COLOR_INVERT));
                     dfsMiMarked( DFSC_BRTSCR,  txwSbColorStyle(TXSB_COLOR_BRIGHT) ^
                                                txwSbColorStyle(TXSB_COLOR_INVERT));
                     dfsMiMarked( DFSC_B2BSCR,  txwSbColorStyle(TXSB_COLOR_B2BLUE));
                     dfsMiMarked( DFSC_ASCII7,  TxGetAscii7Mode());
                     dfsMiMarked( DFSC_COLTXT,  TxGetAnsiMode() == A_ON);
                     dfsMiMarked( DFSC_PROMPT,  dfsa->cmdprompt);
                     dfsMiMarked( DFSC_AUTODR,  dfsa->autodrop);
                     dfsMiMarked( DFSC_DELAYDR, dfsa->delaydrop);
                     dfsMiMarked( DFSC_RIGHTMV, dfsa->rightmove);
                  #if defined (LINUX)
                     dfsMiMarked( DFSC_XSCLIP,  TxGetXselClipboard());
                  #endif

                     switch (lp1)
                     {
                        case DFSM_FILE: menuopen = 'f';  break;
                        case DFSM_EDIT: menuopen = 'e';  break;
                        case DFSM_DISP: menuopen = 'd';  break;
                        case DFSM_ACTI: menuopen = 'a';  break;
                        case DFSM_IMAG: menuopen = 'a';  break;
                        case DFSM_HELP: menuopen = 'h';  break;
                        case DFSM_MODE: menuopen = 'm';  break;
                        default:        menuopen = dfsa->menuopen;
                           dfsa->menuopen = 0;  // one time default !
                           break;
                     }
                     dfsa->automenu  = TRUE;    // make menu sticky
                     dfsa->menuOwner = entrwin; // for help and msg delegation

                     flag = TXMN_MAIN_MENU;     // signal main-menu will be up
                     if (dfsa->rightmove)       // want RIGHT_MOVE on right-arrow
                     {
                        TRACES(("MenuBar - right-move\n"));
                        flag |= TXMN_RIGHT_MOVE;
                     }
                     if ((dfsa->delaydrop) ||        //- delayed drop style SET
                         (lp1 == DFSM_AUTODELAY))    //- automatic menu after command
                     {                               //- completion, so delay drop
                        flag |= TXMN_DELAY_AUTODROP;
                        TRACES(("MenuBar - delayed autodrop\n"));
                     }
                     if (dfsa->autodrop == FALSE)
                     {
                        TRACES(("MenuBar - no autodrop\n"));
                        flag |= TXMN_NO_AUTODROP;
                     }

                     if (txwMenuBar( TXHWND_DESKTOP, hwnd, NULL,
                                     menuopen, DFS_H_APPLIC, // submenus have menu-help!
                                     flag, dfsGetMainMenu()) == TXDID_CANCEL)
                     {
                        TRACES(("End automatic menubar for now ...\n"));
                        dfsa->menuOwner = 0;    // quit automatic menuBar
                     }
                  }
                  break;

               case DFSC_SHOWHID:
                  sprintf( s2, "set showhid %s", (dfsa->browseShowHidden) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_FHIDDEN:
                  sprintf( s2, "set hidden %s", (TxGetFdlgShowHidden()) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_RMBMENU:
                  sprintf( s2, "set rmbmenu %s", (TxGetRmb2MenuKey()) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_GEOCALC:
                  sprintf( s2, "set geocalc %s", (dfsa->geoCalc) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_PTYPE0:
                  sprintf( s2, "set pt0 %s", (dfsa->pt0Show) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               #if defined (DEV32)
               case DFSC_LVMSYNC:
                  sprintf( s2, "set synclvm %s", (dfsa->lvmSyncApi) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;
               #endif

               case DFSC_VOLFLOP:
                  sprintf( s2, "set floppy %s", (dfsa->volFloppy) ? "off" : "on");
                  slVolumes_count = 0;          // force list-update on menu
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_GPTAUTO:
                  sprintf( s2, "set gptauto %s", (dfsa->gptAuto) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_LOGAUTO:
                  sprintf( s2, "set logauto %s", (dfsa->logAuto) ? "off" : "num");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_LOGDATE:
                  sprintf( s2, "set logauto %s", (dfsa->logDate) ? "off" : "date");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case TXCMD_MENU_CYCLE:           // click on menu-bar menu-name
               case DFSC_EXPERT:
                  rc = dfsExecReopenMenu( FALSE, "set expert toggle");
                  break;

               case DFSC_RDONLY:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     if (dfsa->ReadOnly)
                     {
                        dfstSwitch2ReadOnly( NULL, TRUE, FALSE);
                     }
                     else
                     {
                        dfstSwitch2ReadOnly( "Requested by user.", TRUE, TRUE);
                     }
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

               case DFSC_IGNERR:
                  sprintf( s2, "set error %s", (dfsa->eStrategy == TXAE_IGNORE ) ? "confirm"  : "ignore");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_BATCH:
                  sprintf( s2, "batch %s", (dfsa->batch) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_QUERY:
                  dfsBEGINWORK();
                  strcpy( s1, "*.log");
                  if (txwSaveAsFileDialog( s1, NULL, "dfsquery", DFSC_QUERY, NULL, NULL,
                      " Specify filename for QUERY result (append) ", s1))
                  {
                     if (TxQueryLogName() != NULL)
                     {
                        strcpy( s2, TxQueryLogName()); // remember current name
                        TxPrint( "Switch to logfile : '%s' for QUERY ...\n", s1);
                     }
                     else
                     {
                        strcpy( s2, "");
                     }
                     TxAppendToLogFile( s1, TRUE);
                     dfsExecEnd( "about -P-#query");
                     TxAppendToLogFile( s2, TRUE); // close log, reopen old
                  }
                  dfsENDWORK();
                  break;

               case DFSC_IMZINF:
                  dfsBEGINWORK();
                  strcpy( s1, "*.i*");

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_IMZINF, NULL, NULL,
                      " Select an image file to show information for ", s1))
                  {
                     sprintf( s2, "imzinfo \"%s\"", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_RAW2IMZ:
                  dfsBEGINWORK();
                  strcpy( s1, "*.img;*.hdd;*.fdd");

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_RAW2IMZ, NULL, NULL,
                      " Select a RAW image file to create a compressed .IMZ from ", s1))
                  {
                     sprintf( s2, "raw2imz \"%s\" -!", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_IMZ2RAW:
                  dfsBEGINWORK();
                  strcpy( s1, "*.im?;*.hdd;*.fdd");

                  if (txwSaveAsFileDialog( s1, NULL, NULL, DFSC_IMZ2RAW, NULL, NULL,
                      " Select or specify the RAW imagefile name to be created ", s1))
                  {
                     strcpy(  s0, TxGetBaseName( s1)); //- no path (from dest)
                     TxStripExtension( s0);            //- remove extension too

                     sprintf( s2, "imz2raw \"%s\" %s -!", s0, s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_SAVE:
                  dfsBEGINWORK();
                  strcpy( s1, "*.log");
                  if (txwSaveAsFileDialog( s1, NULL, "dfscreen", DFSC_SAVE, NULL, NULL,
                      " Specify file for saving the screen to ", s1))
                  {
                     sprintf( s2, "scrfile \"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_CURDIR:
                  dfsBEGINWORK();
                  getcwd( s1, TXMAXLN);         // get current drive/directory

                  if (txwSelDirFileDialog(s1, DFSC_CURDIR, NULL, NULL,
                      " Select new working directory ", s1))
                  {
                     TxStrip( s1, s1, '-', '\\');// strip trailing backslash
                     sprintf( s2, "cd %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_VIRT:
                  dfsBEGINWORK();
                  strcpy( s1, "");              // default same as current
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify:  size[,m|g|c]   [Heads]   [Sects]\n\n"
                        " size     = size in MiB, GiB or cylinders\n"
                        " Heads    = nr of heads,  default 255\n"
                        " Sects    = nr of sectors, default 63\n\n"
                        "or leave blank to mimic the default disk",
                        " New virtual disk properties ", DFSC_VIRT,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        50, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "virt %s", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_VPDX:
                  dfsBEGINWORK();
                  strcpy( s1, "*.pd?");
                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_VPDX, NULL, NULL,
                      " Select .PDx file to base the virtual disk on ", s1))
                  {
                     sprintf( s2, "virt \"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_PHYS:
                  dfsBEGINWORK();
                  #if defined (UNIX)
                     #if defined (LINUX)
                        strcpy( s1, "/dev/hda");
                     #else
                        strcpy( s1, "/dev/rdisk0");
                     #endif
                     if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                           "Specify a devicename (disk) or filename (RAW image) to "
                           "be attached as another partitionable medium.\n"
                           "Attaching the same disk multiple times is "
                           "possible but not recommended.",
                           " Specify physical disk devicename ", DFSC_PHYS,
                           TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                           20, s1) != TXDID_CANCEL)
                     {
                        //- no name check here, let 'attach' validate it
                        sprintf( s2, "attach -p:%s", s1);
                        dfsExecCmd( s2);
                     }
                  #else
                     strcpy( s1, "1");
                     if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                           "Specify the number of the physical disk to "
                           "be attach as another partitionable medium.\n"
                           "Attaching the same disk multiple times is "
                           "possible but not recommended.",
                           " Specify physical disk number 1..n ", DFSC_PHYS,
                           TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                           10, s1) != TXDID_CANCEL)
                     {
                        if (atoi(s1) != 0)      // not numeric
                        {
                           sprintf( s2, "attach -p:%s", s1);
                           dfsExecCmd( s2);
                        }
                        else
                        {
                           TxPrint( "\n'%s' is not a valid physical disk number.\n", s1);
                        }
                     }
                  #endif
                  dfsENDWORK();
                  break;

               case DFSC_ICMP:
                  dfsBEGINWORK();
                  strcpy( s1, "*.imz");

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_ICMP, NULL, NULL,
                      " Select COMPRESSED imagefile to be attached ", s1))
                  {
                     sprintf( s2, "attach -i:\"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_IVDI:
                  dfsBEGINWORK();
                  strcpy( s1, "*.vdi");

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_ICMP, NULL, NULL,
                      " Select VirtualBox diskimage file to be attached ", s1))
                  {
                     sprintf( s2, "attach -i:\"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_IRAW:
                  dfsBEGINWORK();
                  strcpy( s1, "*.*");

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_IRAW, NULL, NULL,
                      " Select RAW imagefile to be attached ", s1))
                  {
                     sprintf( s2, "attach -i:\"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;


               case DFSC_RUNS:
                  dfsBEGINWORK();
                  TxCancelAbort();
                  rc = dfsMultiCommand("run", 0, TRUE, dfsa->cmdprompt, TRUE);
                  dfsENDWORK();
                  break;

               case DFSC_BOOT:
                  dfsBEGINWORK();
                  if ((dfsa->batch) ||          // forced or confirmed
                      (TxConfirm( 5053,
                     "Are you sure you want to reboot now, without closing "
                     "applications or explicitly saving any data ? [Y/N]: ")))
                  {
                     dfsExecEnd( "setboot -B -b");
                  }
                  dfsENDWORK();
                  break;

               case DFSC_EXIT:
                  dfsBEGINWORK();
                  if (TxaExeSwitch('S'))
                  {
                     TxNamedMessage( TRUE, 5014, " ERROR: Quit not allowed ",
                                "DFSee is running in SHELL mode,\nquit is not allowed ...");
                  }
                  else
                  {
                     txwPostMsg( hwnd, TXWM_CLOSE, 0, 0);
                  }
                  #if defined (DEV32)
                     txwInvalidateAll();        // avoid VIO64K bug
                  #endif
                  dfsENDWORK();
                  break;

               case DFSC_DELTHIS:               // delete THIS partition
                  dfsBEGINWORK();
                  if (SINF->p != NULL)
                  {
                     sprintf( s2, "fdisk delete %2.2d", SINF->partid);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_ACTHIS:                // make THIS partition active
                  dfsBEGINWORK();
                  if (SINF->p != NULL)
                  {
                     sprintf( s2, "fdisk startable %2.2d #part -O:q %2.2d",
                                              SINF->partid, SINF->partid);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_DPUP64: dfsExecEnd( "runscript dfsgetpy dfspup64");                 break;
               case DFSC_DPUP32: dfsExecEnd( "runscript dfsgetpy dfspup32");                 break;
               case DFSC_DPUPPY: dfsExecEnd( "runscript dfsgetpy");                          break;
               case DFSC_INSTAL: dfsExecEnd( "runscript dfsinstl");                          break;
               case DFSC_DSTABL: dfsExecEnd( "runscript dfsgetup s");                        break;
               case DFSC_DEXPER: dfsExecEnd( "runscript dfsgetup e");                        break;

               case DFSC_APFSCP:   dfsExecEnd( "cp");                                        break;
               case DFSC_APFSTP:   dfsExecEnd( "desc");                                      break;
               case DFSC_APFSSP:   dfsExecEnd( "super -Q -echo-#u -Q -echo-#d -echo-#d");    break;
               case DFSC_APFSDM:   dfsExecEnd( "dump * 0 scDBMSim -X -x -y -z");             break;
               case DFSC_APFSTR:   dfsExecEnd( "leaves * 0 -header- -node-");                break;

               case DFSC_APFSDR:                // dump DIR-RECORDS with optional name filter
               case DFSC_APFSIN:                // dump INO-RECORDS with optional name filter
                  {
                     static TXTM   wildcard = "*";

                     dfsBEGINWORK();
                     if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                           "Specify a WILDCARD that Directory or Filenames should match\n"
                           "to be included in the APFS FS-Tree RECORD list display\n\n"
                           "Use '?' for single, and '*' for multi-character fragments\n\n"
                           "Default is to show ALL RECORDS in the FS-tree, using '*'",
                           " Dir/File name wildcard selection ", DFSC_APFSDR,
                           TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                           66, wildcard) != TXDID_CANCEL)
                     {
                        sprintf( s2, "leaves * 0 -header- -node- -list -r:%u -name:'%s'",
                                                (lp1 == DFSC_APFSIN) ? 3 : 9, wildcard);
                        dfsExecCmd( s2);
                     }
                     dfsENDWORK();
                  }
                  break;


               case DFSC_SECHEX:   dfsExecEnd( "t#edit -P -h#t");                            break;
               case DFSC_SECASC:   dfsExecEnd( "t#edit -P -a#t");                            break;
               case DFSC_SECUNI:   dfsExecEnd( "t#edit -P -u#t");                            break;
               case DFSC_BMCONF:   dfsExecEnd( "setboot -list -q");                          break;

               case DFSC_HEX16B:   dfsExecCmd( "edit . -v:0 -r:32 -c:16");                   break;
               case DFSC_HEXASC:   dfsExecCmd( "edit . -v:0");                               break;
               case DFSC_DISASM:   dfsExecEnd( "edit . -v:1");                               break;
               case DFSC_TXTSTR:   dfsExecEnd( "edit . -v:2");                               break;
               case DFSC_SHEXED:   dfsExecEnd( "edit . -v:9");                               break;
               case DFSC_SHFILE:   dfsExecEnd( "edit   -dir");                               break;
               case DFSC_BMTIME:
                  dfsBEGINWORK();
                  sprintf( s1, "%hu", dfsa->bmgrTimeout);
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the time in seconds before the IBM Bootmanager "
                        "menu will activate the default selection.\n\n"
                        "Use 0 for no timeout (menu stays up)",
                        " Timeout in seconds ", DFSC_BMTIME,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        9, s1) != TXDID_CANCEL)
                  {
                     nr = atol( s1);
                     sprintf( s2, "setboot -t:%d", nr);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_FSFDISK:
               case DFSC_FSEXT:
               case DFSC_FSFAT:
               case DFSC_FSEXFT:
               case DFSC_FSHFS:
               case DFSC_FSAPFS:
               case DFSC_FSHPFS:
               case DFSC_FSJFS:
               case DFSC_FSNTFS:
               case DFSC_FSDUMP:
               case DFSC_FSRSR:
               case DFSC_FSSWAP:
               case DFSC_FSXFS:
               case DFSC_FSISO:
               case DFSC_FSAUX:
                  if ((dfsa->batch) ||          // forced or confirmed
                      (TxConfirm( 5057,
                     "You should only FORCE a specific analysis mode if you "
                     "know what you are doing, or are instructed to do so!\n\n"
                     "Are you sure you want to FORCE a specific mode ? [Y/N]: ")))
                  {
                     switch (lp1)       // unique command code
                     {
                        case DFSC_FSFDISK:  dfsExecEnd( "fs fdisk");     break;
                        case DFSC_FSEXT:    dfsExecEnd( "fs ext");       break;
                        case DFSC_FSFAT:    dfsExecEnd( "fs fat");       break;
                        case DFSC_FSEXFT:   dfsExecEnd( "fs efat");      break;
                        case DFSC_FSHFS:    dfsExecEnd( "fs hfs");       break;
                        case DFSC_FSAPFS:   dfsExecEnd( "fs apfs");      break;
                        case DFSC_FSHPFS:   dfsExecEnd( "fs hpfs");      break;
                        case DFSC_FSJFS:    dfsExecEnd( "fs jfs");       break;
                        case DFSC_FSDUMP:   dfsExecEnd( "fs dumpfs");    break;
                        case DFSC_FSNTFS:   dfsExecEnd( "fs ntfs");      break;
                        case DFSC_FSRSR:    dfsExecEnd( "fs reiser");    break;
                        case DFSC_FSISO:    dfsExecEnd( "fs iso");       break;
                        case DFSC_FSSWAP:   dfsExecEnd( "fs swap");      break;
                        case DFSC_FSXFS:    dfsExecEnd( "fs xfs");       break;
                        case DFSC_FSAUX:    dfsExecEnd( "fs aux -P-");   break;
                     }
                  }
                  break;

               // Force E:i on scan to always retry with single sectors
               case DFSC_SCAN_RO:  dfsExecEnd( "scan -E:i");             break;
               case DFSC_SCAN_RW:  dfsExecEnd( "scan -E:i -w");          break;

               case DFSC_WIPETHS:
                  dfsBEGINWORK();
                  sprintf( s2,
                     "Specify the number of sectors to erase using a ZERO pattern,\n"
                     "starting at the current 'this' sectornumber: 0x0%llx\n\n"
                     "This is an mcs-number, defaulting to a single sector,\n"
                     "add the ,m unit for megabytes or ,c for cylinders ...", nav.this);
                  strcpy(  s1, "1");            // use default, 1 sector
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL, s2,
                      " Number of sectors to ERASE ", DFSC_WIPETHS,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        50, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "wipe z . %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_FINDTC:                // Find, dialog
               case DFSC_FINDAG:                // Find again, no dialog
                  dfsBEGINWORK();
                  dfsFindDialog( FALSE, FALSE, (lp1 == DFSC_FINDAG), L64_NULL, 0);
                  dfsENDWORK();
                  break;

               case DFSC_SBSRCH:
                  txwSbViewFindRequest( TXWS_REQ_FINDDIALOG, "");
                  dfsa->menuOwner = 0;          // quit automatic menuBar
                  break;

               case DFSC_SBGREP:
                  txwSbViewFindRequest( TXWS_REQ_GREPDIALOG, "");
                  dfsa->menuOwner = 0;          // quit automatic menuBar
                  break;

               case DFSC_SBEXEC:
                  txwSbViewFindRequest( TXWS_REQ_GREPDIALOG, "Executing:");
                  dfsa->menuOwner = 0;          // quit automatic menuBar
                  break;

               case DFSC_FIND00:  dfsExecEnd( "find -t:0 -o:%*");                      break;
               case DFSC_FINDFE:  dfsExecEnd( "find -t:5 -o:%*");                      break;
               case DFSC_FWIPEZ0:
               case DFSC_DWIPEZ0: dfsExecEnd( "wipe z 0 1");                           break;
               case DFSC_WIPEZER: dfsExecEnd( "wipe -z");                              break;
               case DFSC_WIPESEC: dfsExecEnd( "wipesecure");                           break;
               case DFSC_SECFREE: dfsExecEnd( "wipesecure -f");                        break;
               case DFSC_ZERFREE: dfsExecEnd( "wipefree");                             break;
               case DFSC_LVALUES: dfsExecEnd( "list -w");                              break;
               case DFSC_RESIZET: dfsExecEnd( "resize");                               break;
               case DFSC_REXPAND: dfsExecEnd( "expand");                               break;
               case DFSC_RESIMAX: dfsExecEnd( "resize -m");                            break;
               case DFSC_MOVE2E:  dfsExecEnd( "move  -e -P");                          break;
               case DFSC_MOVE2B:  dfsExecEnd( "move  -b -P");                          break;
               case DFSC_RECOVER: dfsExecEnd( "recover -P");                           break;
               case DFSC_FSAVETO: dfsExecEnd( "saveto  -P");                           break;
               case DFSC_SLT2LST: dfsExecEnd( "slt2list");                             break;
               case DFSC_CLRLIST: dfsExecEnd( "listset -c");                           break;
               case DFSC_EXPLIST: dfsExportDialog();                                   break;
               case DFSC_IMPLIST: dfsImportDialog();                                   break;
               case DFSC_OIMAG  : dfsImageSelectDialog( "",       DFSD_IRAW, "i*");    break;
               case DFSC_IMZBRS : dfsImageSelectDialog( "*.imz",  DFSD_IMZD, "imz");   break;
               case DFSC_VDIBRS : dfsImageSelectDialog( "*.vdi",  DFSD_VBOX, "vdi");   break;
               case DFSC_SIMPART: dfsImageDialog(   DFSO_PART, NULL, FALSE, 0, 0, 0);  break;
               case DFSC_SIMDISK: dfsImageDialog(   DFSO_DISK, NULL, FALSE, 0, 0, 0);  break;
               case DFSC_SIMVOL : dfsImageDialog(   DFSO_VOLD, NULL, FALSE, 0, 0, 0);  break;
               case DFSC_SIMCUR : dfsImageDialog(   DFSO_NONE, NULL, FALSE, 0, 0, 0);  break;
               case DFSC_WRIPART: dfsRestoreDialog( DFSO_PART, NULL, FALSE, 0, 0);     break;
               case DFSC_WRIDISK: dfsRestoreDialog( DFSO_DISK, NULL, FALSE, 0, 0);     break;
               case DFSC_WRIVOL : dfsRestoreDialog( DFSO_VOLD, NULL, FALSE, 0, 0);     break;
               case DFSC_WRICUR : dfsRestoreDialog( DFSO_NONE, NULL, FALSE, 0, 0);     break;
               case DFSC_VERIFIM: dfsRestoreDialog( DFSO_PART, NULL, TRUE,  0, 0);     break;

               case DFSC_LOGF:    dfsLogDialog(  (dfsa->logDate) ? "dfsee-~" :
                                                 (dfsa->logAuto) ? "dfsee^" :
                                                                   "dfsee",
                    DFSC_LOGF,    FALSE, "Append to, or start a new logfile ...");     break;

               case DFSC_CYTRACE: dfsLogDialog(  (dfsa->logDate) ? "dfstr-~" :
                                                 (dfsa->logAuto) ? "dfstr^" :
                                                                   "dfstrace",
                    DFSC_CYTRACE, FALSE, "Start cyclic TRACE to 9 one-MB files ...");  break;

               case DFSC_CLDDBAD: dfsCloneDialog(TRUE, DFSO_DISK, 0, DFSO_DISK, 0, 0, 0x8000); break;
               case DFSC_CLDDISK: dfsCloneDialog(TRUE, DFSO_DISK, 0, DFSO_DISK, 0, 0, 0);      break;
               case DFSC_CLPPART: dfsCloneDialog(TRUE, DFSO_PART, 0, DFSO_PART, 0, 0, 0);      break;
               case DFSC_CLVVOLD: dfsCloneDialog(TRUE, DFSO_VOLD, 0, DFSO_VOLD, 0, 0, 0);      break;
               case DFSC_CLCDISK: dfsCloneDialog(TRUE, DFSO_DISK, 0, DFSO_NONE, 0, 0, 0);      break;
               case DFSC_CLCPART: dfsCloneDialog(TRUE, DFSO_PART, 0, DFSO_NONE, 0, 0, 0);      break;
               case DFSC_CLCVOLD: dfsCloneDialog(TRUE, DFSO_VOLD, 0, DFSO_NONE, 0, 0, 0);      break;

               case DFSC_BSALLO:               // ALL/ANY superblocks only
               case DFSC_BSALLC:               // ALL/ANY superblocks + partitioning
                  dfsBEGINWORK();
                  sprintf( s2, "bsfind %s ;mode=FDISK (any)", (lp1 == DFSC_BSALLO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSALLO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  dfsENDWORK();
                  break;

               case DFSC_BSHPFSO:               // HPFS superblocks only
               case DFSC_BSHPFSC:               // HPFS super + partitioning
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "HPFS");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=HPFS", (lp1 == DFSC_BSHPFSO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSHPFSO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_BSJFSO:                // JFS superblocks only
               case DFSC_BSJFSC:                // JFS super + partitioning
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "JFS");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=JFS", (lp1 == DFSC_BSJFSO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSJFSO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_BSHFSO:                // HFS superblocks only
               case DFSC_BSHFSC:                // HFS super + partitioning
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "HFS");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=HFS", (lp1 == DFSC_BSHFSO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSHFSO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_BSXFSO:                // XFS superblocks only
               case DFSC_BSXFSC:                // XFS super + partitioning
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "XFS");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=XFS", (lp1 == DFSC_BSXFSO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSXFSO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_BSEXTO:                // EXTn superblocks only
               case DFSC_BSEXTC:                // EXTn super + partitioning
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "EXT2");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=EXTn", (lp1 == DFSC_BSEXTO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSEXTO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_BSRSRO:                // Reiser superblocks only
               case DFSC_BSRSRC:                // Reiser super + partitioning
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "REISER");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=Reiser", (lp1 == DFSC_BSRSRO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSRSRO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_BSNTFSO:               // NTFS NTLDR 1st sectors only
               case DFSC_BSNTFSC:               // NTFS NTLDR sect + partitions
                  dfsBEGINWORK();
                  sprintf( s1, "fs %s", SINF->afsys);
                  sprintf( s2, "fs %s", "NTFS");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                  sprintf( s2, "bsfind %s ;mode=NTFS", (lp1 == DFSC_BSNTFSO) ? "s" : "");
                  txwAdd2History( dfsa->cmdwindow, s2);
                  dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                  TxCancelAbort();              // reset pending abort status
                  if (lp1 == DFSC_BSNTFSO)
                  {
                     strcpy( dfsa->snverbose, "-d");
                  }
                  txwAdd2History( dfsa->cmdwindow, s1);
                  dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                  dfsENDWORK();
                  break;

               case DFSC_LISTFSC:               // list in original FsModeId
                  if (strcasecmp( dfsa->snifsmode, SINF->afsys) != 0)
                  {
                     dfsBEGINWORK();
                     sprintf( s1, "fs %s", SINF->afsys);
                     sprintf( s2, "fs %s", dfsa->snifsmode);
                     txwAdd2History( dfsa->cmdwindow, s2);
                     dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                     sprintf( s2, "list %s ;Mode=%s", dfsa->sncompact, dfsa->snifsmode);
                     txwAdd2History( dfsa->cmdwindow, s2);
                     dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);

                     txwAdd2History( dfsa->cmdwindow, s1);
                     dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                     dfsENDWORK();
                     break;
                  }                             // fall through, FS is the same
               case DFSC_COMPACT:
                  sprintf( s2, "list %s", dfsa->sncompact);
                  dfsExecEnd( s2);
                  break;

               case DFSC_LISTFSV:               // list in original FsModeId
                  if (strcasecmp( dfsa->snifsmode, SINF->afsys) != 0)
                  {
                     dfsBEGINWORK();
                     sprintf( s1, "fs %s", SINF->afsys);
                     sprintf( s2, "fs %s", dfsa->snifsmode);
                     txwAdd2History( dfsa->cmdwindow, s2);
                     dfsMultiCommand( s2, 0, FALSE, FALSE, FALSE);

                     sprintf( s2, "list %s ;Mode=%s", dfsa->snverbose, dfsa->snifsmode);
                     txwAdd2History( dfsa->cmdwindow, s2);
                     dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);

                     txwAdd2History( dfsa->cmdwindow, s1);
                     dfsMultiCommand( s1, 0, FALSE, TRUE, FALSE);
                     dfsENDWORK();
                     break;
                  }                             // fall through, FS is the same
               case DFSC_VERBOSE:
                  sprintf( s2, "list %s", dfsa->snverbose);
                  dfsExecEnd( s2);
                  break;

               case DFSC_LISTIDS:                 //- show allocation for each,
                  sprintf( s2, "list -f -c id");  //- and SLT info if available
                  dfsExecEnd( s2);
                  break;

               case DFSC_WIPELST:
                  dfsBEGINWORK();
                  strcpy( s1, "");              // use default
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify file-selection wildcard if the list contains file\n"
                        "references (default: *%-100 = ALL except 100% recoverable)\n\n"
                        "Format:  wildcard%threshold\n"
                        " wildcard   =  wildcard selection for files to be wiped\n"
                        " threshold  =  +nn = Minimum allocation-OK percentage\n"
                        "           or  -nn = Maximum allocation-OK percentage\n\n"
                        "    To wipe ALL sectors, of any type, specify '!'",
                        " Sector or File-selection wildcard%percentage ", DFSC_WIPELST,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        50, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "wipelist %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_INVSCR:
                  dfsExecReopenMenu( TRUE, "set screen i#set screen b"); // invert & bright
                  txwInvalidateAll();
                  break;

               case DFSC_BRTSCR:
                  dfsExecReopenMenu( TRUE, "set screen b");
                  txwInvalidateAll();
                  break;

               case DFSC_B2BSCR:
                  dfsExecReopenMenu( TRUE, "set screen s");
                  txwInvalidateAll();
                  break;

               case DFSC_ASCII7:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     TxSetAscii7Mode(!TxGetAscii7Mode());
                     txwRefreshScreen();        // flush, redraw everything
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

               case DFSC_COLTXT:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     if (TxGetAnsiMode() == A_ON)
                     {
                        TxSetAnsiMode( A_OFF);
                     }
                     else
                     {
                        TxSetAnsiMode( A_ON);
                     }
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

              #if defined (LINUX)
               case DFSC_XSCLIP:                // toggle XCLIP selection setting
                  dfsBEGINWORK();
                  if (TxGetXselClipboard())
                  {
                     dfsExecReopenMenu( TRUE, "set selclip off");
                  }
                  else
                  {
                     dfsExecReopenMenu( TRUE, "set selclip on");
                  }
                  dfsENDWORK();
                  break;
              #endif

               case DFSC_AUTODR:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     dfsa->autodrop  = !(dfsa->autodrop);
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

               case DFSC_DELAYDR:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     dfsa->delaydrop = !(dfsa->delaydrop);
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

               case DFSC_RIGHTMV:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     dfsa->rightmove = !(dfsa->rightmove);
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

               case DFSC_PROMPT:
                  {
                     TXS_MENUBAR *dfsmenu = dfsGetMainMenu();
                     dfsBEGINWORK();
                     dfsa->cmdprompt  = !(dfsa->cmdprompt);
                     dfsa->menuOwner = entrwin; // Reopen the same menu
                     dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
                     dfsENDWORK();
                  }
                  break;

               case DFSC_SIZWIN:
                  dfsExecCmd( "mode -w");
                  txwPostMsg( hwnd, TXWM_CLOSE, 0, 0);
                  break;

               case DFSC_NONWIN:
                  dfsExecCmd( "mode -w-");
                  txwPostMsg( hwnd, TXWM_CLOSE, 0, 0);
                  break;

               case DFSC_MREFRSH:
                  #if defined (DEV32)
                     dfsExecEnd( "synclvm");    // refresh removable media
                  #endif
                  slVolumes_count = 0;          // force list-update on menu
                  break;

               case DFSC_DEVINF:                // device information
                  #if   defined (DARWIN)
                     sprintf( s1, "diskutil list");
                  #elif defined (LINUX)
                     sprintf( s1, "lsblk -i -o NAME,LABEL,LOG-SEC,RM,MODEL,SIZE,MOUNTPOINT");
                  #elif defined (WIN32)
                     sprintf( s1, "cmd mountvol");
                  #elif defined (DEV32)
                     sprintf( s1, "cmd type os2ahci$#cmd type ibms506$");
                  #else
                     sprintf( s1, "confirm Not supported on the $_platform platform yet!");
                  #endif
                  dfsExecEnd( s1);
                  break;

               case DFSC_SIPSTA:
                  #if   defined (DARWIN)
                     dfsBEGINWORK();
                     TxPrint( "\n'System Integrity Protection' (SIP) will make the BOOT-DISK invisible to\n"
                                " DFSee when enabled (starting with macOS version 10.13 aka High Sierra)\n\n");

                     TxPrint( "Boot from ANOTHER (external) disk to work on the primary system-disk, OR\n"
                              "(temporarily) disable SIP, either completely or just the disk-protection:\n\n"
                              "    csrutil disable                       # disable SIP completely\n"
                              "    csrutil enable                        # enable  SIP again (when done)\n"
                              "    csrutil enable --without fs           # enable, keep BOOT-DISK accessible\n\n");

                     TxPrint( "The csrutil commands MUST be executed from a RECOVERY BOOT to work, so restart\n"
                              "and hold the 'Command' and 'R' keys pressed, then in the recovery screen select\n"
                              "the Terminal from the Utility menu, execute a csrutil command, and reboot again.\n");

                     if (TxOsVersion( NULL) >= TXVER_MACOS_EL_CAPITAN)
                     {
                        sprintf( s1, "cmd csrutil status");
                        dfsExecEnd( s1);
                     }
                     else
                     {
                        TxPrint( "There is NO csrutil program, and no SIP in this version of macOS!\n");
                     }
                     dfsENDWORK();
                  #endif
                  break;

               case DFSC_OSVOLS:                // Alias for VOLUMES
               case DFSC_VOLUMES:
                  #if defined (UNIX)
                     dfsExecEnd( "dev");        // show devices on screen
                  #else
                     dfsExecEnd( "vol");        // show volumes on screen
                     slVolumes_count = 0;       // force list-update on menu
                  #endif
                  break;

               case DFSC_UICYCLE:               // force colorscheme cycling s_F12
                  txwPostMsg( dfsa->sbwindow, TXWM_CHAR, 0, (TXWMPARAM) TXs_F12);
                  break;
               case DFSC_UIKEYBT:   dfsExecEnd( "uikeys");                       break;
               case DFSC_UICTEST:   dfsExecEnd( "uictest");                      break;
               case DFSC_GEOSTAT:   dfsExecEnd( "geo");                          break;
               case DFSC_MAPVMM:    dfsExecEnd( "map * + -m -M");                break;
               case DFSC_DISKLST:   dfsExecEnd( "disklist");                     break;
               case DFSC_DISKMAP:   dfsExecEnd( "map -r");                       break;
               case DFSC_UMEDIA:    dfsExecEnd( "media -update -v");             break;
               case DFSC_PMEDMAP:   dfsExecEnd( "media");                        break;
               case DFSC_ALLOCMP:   dfsExecEnd( "alloc");                        break;
               case DFSC_PARTSTD:   dfsExecEnd( "part -r");                      break;
               case DFSC_PARTEXT:   dfsExecEnd( "part -r -e");                   break;
            #if defined (UNIX)
               case DFSC_PARTALT:   dfsExecEnd( "part -b-");                     break;
            #else
               case DFSC_PARTALT:   dfsExecEnd( "part -b:1");                    break;
            #endif
               case DFSC_PARTNUM:   dfsExecEnd( "part -r -n");                   break;
               case DFSC_PARTNEX:   dfsExecEnd( "part -r -n -e");                break;
               case DFSC_PARTCSP:   dfsExecEnd( "part -r -s");                   break;
               case DFSC_PARTWRN:   dfsExecEnd( "part -w -t-");                  break;
               case DFSC_PARTWNT:   dfsExecEnd( "part -w:t -t-");                break;
               case DFSC_PARTVER:   dfsExecEnd( "part -r -v");                   break;
               case DFSC_PARTALL:   dfsExecEnd( "part -r -V -a");                break;
               case DFSC_PARTCHK:   dfsExecEnd( "part -r -c");                   break;
               case DFSC_PARTSEC:   dfsExecEnd( "pt * -r");                      break;
               case DFSC_BASEVAL:   dfsExecEnd( "base");                         break;
               case DFSC_STOREVW:   dfsExecEnd( "store");                        break;
               case DFSC_NEXTDEF:   dfsExecEnd( "d");                            break;
               case DFSC_XTRADEF:   dfsExecEnd( "x");                            break;
               case DFSC_UPSNDEF:   dfsExecEnd( "u");                            break;
               case DFSC_THISDEF:   dfsExecEnd( "t");                            break;
               case DFSC_THISPLS:   dfsExecEnd( "gf");                           break;
               case DFSC_THISMIN:   dfsExecEnd( "gb");                           break;
               case DFSC_THISHEX:   dfsExecEnd( "t Hex");                        break;
               case DFSC_THISASC:   dfsExecEnd( "t text");                       break;
               case DFSC_IOSPEED:   dfsExecEnd( "speed");                        break;
               case DFSC_IOSPRWR:   dfsExecEnd( "speed -w");                     break;
               case DFSC_IOSPLBF:
                  sprintf( s1, "speed -b:%u", DFSMAXBUFIMZ);
                  dfsExecEnd( s1);
                  break;


               case DFSC_FFINDS:    dfsExecEnd( "subfind");                      break;
               case DFSC_FFSUBS:    dfsExecEnd( "subfind s");                    break;
               case DFSC_FFSUBD:    dfsExecEnd( "subfind d");                    break;
               case DFSC_XCHECK:    dfsExecEnd( "check");                        break;
               case DFSC_XFIXHS:    dfsExecEnd( "fixpbr -!");                    break;
               case DFSC_XSETVS:    dfsExecEnd( "serial -!");                    break;
               case DFSC_XRDISK:    dfsExecEnd( "fdisk -r- -Q");                 break;
               case DFSC_OPART:     dfsExecEnd( "part -P -a");                   break;
               case DFSC_FBROWSE:   dfsExecEnd( "fs -echo- fdisk#browse");       break;
               case DFSC_XBROWSE:   dfsExecEnd( "browse -P");                    break;
               case DFSC_LBROWSE:   dfsExecEnd( "browse . -f");                  break;
               case DFSC_UBROWSE:   dfsExecEnd( "undelete");                     break;
               case DFSC_BOOTIND:   dfsExecCmd( "bootini");                      break;
               case DFSC_BOOTINF:
                  dfsBEGINWORK();
                  strcpy( s1, "");              // default same as current
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify '*' or 'fix' to use the DFSee calculated "
                        "value or a numeric value for other values.\n\n"
                        "Add a ' -2' after this value to force BOTH "
                        "occurences in BOOT.INI to be updated.\n\n",
                        " BOOT.INI partition-index fix value ", DFSC_BOOTINF,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        50, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "bootini %s", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_DISPLSN:
                  dfsBEGINWORK();
                  nr = 0;
                  rc = dfsGetGotoLsnValue( "Goto new LSN, default display", &lsn);
                  if (rc == NO_ERROR)
                  {
                     sprintf( s2, "0x%llx", lsn);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_CMDHELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee generic command summary",
                               dfsGenericHelp);
                  dfsENDWORK();
                  break;

               case DFSC_OPTHELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee generic command options",
                               dfsGenericOpts);
                  dfsENDWORK();
                  break;

               case DFSC_FS_HELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee Mode=FS specific command summary",
                               dfsa->FsCmdHelp);
                  dfsENDWORK();
                  break;

               case DFSC_TXCHELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "TX library standard command summary",
                               TxGetStdCmdHelp());
                  dfsENDWORK();
                  break;

               case DFSC_ST_MODE:
                  {
                     char **dfsSectorTypeDescriptions = dfsSectorTypes2Text();

                     if (dfsSectorTypeDescriptions != NULL)
                     {
                        dfsBEGINWORK();
                        txwViewText( TXHWND_DESKTOP, 0, 0,
                                    "DFSee recognized sector types",
                                     dfsSectorTypeDescriptions);
                        dfsENDWORK();
                        txFreeText( dfsSectorTypeDescriptions);
                     }
                  }
                  break;

               case DFSC_SW_HELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee application startup switches summary",
                               DFSeeSwitchhelp);
                  dfsENDWORK();
                  break;

               case DFSC_TXSHELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "TX library user-interface startup switches summary",
                               TxGetSwitchhelp());
                  dfsENDWORK();
                  break;

               case DFSC_PT_HELP:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee numeric and symbolic partition-types",
                               partypehelp);
                  dfsENDWORK();
                  break;

               case DFSC_HS_RUNU:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee TXScript RUN command usage",
                               txScriptRunHelp);
                  dfsENDWORK();
                  break;

               case DFSC_HSYNTAX:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee TXScript syntax and layout",
                               txScriptSyntaxHelp);
                  dfsENDWORK();
                  break;

               case DFSC_HS_VARS:
                  dfsBEGINWORK();
                  txwViewText( TXHWND_DESKTOP, 0, 0,
                              "DFSee TXScript host-variable definitions",
                               hostvarhelp);
                  dfsENDWORK();
                  break;

               case DFSC_UIHELP:
                  dfsBEGINWORK();
                  txwSendMsg( entrwin, TXWM_HELP, 0, 0);
                  dfsENDWORK();
                  break;

               case DFSC_H_LOAD:    dfsLoadHelpDialog();                        break;
               case DFSC_H_SECTS:   dfsExecSilent( "help s");                   break;
               case DFSC_H_GREP:    dfsExecSilent( "help");                     break;
               case DFSC_H_KEYBD:   dfsExecSilent( "help keyboard usage");      break;
               case DFSC_H_MOUSE:   dfsExecSilent( "help mouse usage");         break;
               case DFSC_H_CLIPB:   dfsExecSilent( "help clipboard");           break;
               case DFSC_H_MENUS:   dfsExecSilent( "help pull-down");           break;
               case DFSC_ABOUT:     dfsExecSilent( "about -r");                 break;

               case DFSC_JFIRSF:    dfsExecEnd( "irs -!#find -t:f -o:*$%!Q");   break;
               case DFSC_JFSIRS:    dfsExecEnd( "irs -!");                      break;
               case DFSC_JMAGIC:    dfsExecEnd( "check -r -M");                 break;
               case DFSC_JIAGRP:
                  dfsBEGINWORK();
                  strcpy( s1, "");
                  if ((dfsPromptOptDialog( " Inode Allocation Group number ",
                                           " Leave empty for summary information,\n"
                                           " or specify '*' to show all groups",
                                             lp1, 15, s1,
                                             &ffVerbose, "Verbose display, verify header",
                                             &ffOption1, "Show aggregate IAG, not Fileset",
                                             NULL, NULL, NULL, NULL,
                                             NULL, NULL)) == NO_ERROR)
                  {
                     sprintf( s2, "iag %s", s1);
                     if (ffOption1)
                     {
                        strcat( s2, " -a");
                     }
                     if (ffVerbose)
                     {
                        strcat( s2, " -v");
                     }
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;


               case DFSC_HFINDD:                // HPFS
               case DFSC_HFINDF:
               case DFSC_HFINDA:
               case DFSC_JFINDD:                // JFS
               case DFSC_JFINDF:
               case DFSC_JFINDA:
               case DFSC_NFINDD:                // NTFS
               case DFSC_NFINDF:
               case DFSC_NFINDA:
               case DFSC_FFINDD:                // FAT/FAT32
               case DFSC_FFINDF:
               case DFSC_EFINDF:                // EXTn
               case DFSC_YFINDD:                // EFAT
               case DFSC_YFINDF:
                  dfsBEGINWORK();
                  strcpy( s2, "Specify part of the filenames to be found (not path!)\n");
                  switch (lp1)
                  {
                     case DFSC_HFINDD:          // HPFS
                     case DFSC_HFINDF:
                     case DFSC_HFINDA:
                        strcat( s2, "The (partial) name should be from the first 15 positions.\n\n"
                                    "No '*' or '?' wildcard characters allowed");
                        break;

                     case DFSC_JFINDD:          // JFS
                     case DFSC_JFINDF:
                     case DFSC_JFINDA:
                        strcat( s2, "The (partial) name is only useful if the DFSee recovery\n"
                                    "filenames have been added, .LONGNAME EA's are present,\n"
                                    "or the Sector Lookup Table has been built (SLT/CHECK),\n\n"
                                    "No '*' or '?' wildcard characters allowed");
                        break;

                     case DFSC_NFINDD:          // NTFS
                     case DFSC_NFINDF:
                     case DFSC_NFINDA:
                        strcat( s2, "The (partial) name should be from the LONG filename.\n\n"
                                    "No '*' or '?' wildcard characters allowed");
                        break;

                     case DFSC_FFINDD:          // FAT/FAT32
                     case DFSC_FFINDF:
                        strcat( s2, "The (partial) name should be from the 8.3 (short) name.\n\n"
                                    "No '*' or '?' wildcard characters allowed");
                        if (lp1 == DFSC_FFINDF)
                        {
                           strcat( s2, "\n(use '.xxx' to select a file extension 'xxx')");
                        }
                        break;

                     case DFSC_EFINDF:          // EXTn
                        strcat( s2, "The (partial) name is only useful if the DFSee\n"
                                    "Sector Lookup Table has been built (SLT/CHECK)\n\n"
                                    "No '*' or '?' wildcard characters allowed");
                        break;

                     case DFSC_YFINDD:          // EFAT
                     case DFSC_YFINDF:
                        strcat( s2, "The (partial) name should be 15 characters at most, and "
                                    "not span any 15 character boundary in the full name\n\n"
                                    "No '*' or '?' wildcard characters allowed");
                        break;
                  }
                  strcat( s2, ".\n\nLeave blank to find ALL files");
                  ffOption4 = TRUE;             // default ignore errors (like bad sectors)

                  do
                  {
                     if ((dfsPromptOptDialog( " Partial filename to find ", s2, lp1, 15, filefindStr,
                          &ffVerbose, "Verbose path/filename display while searching, will be MUCH slower!",
                          &ffOption1, "Start from the CURRENT sector, not the filesystem default location",
                          &ffOption2, "Search OUTSIDE the known DIR/MFT/INODE/FNODE areas too (SLOW!)",
                          &ffOption3, "Search for DIRECTORIES only, instead of files and directories",
                          &ffOption4, "Ignore errors while searching, avoids prompt at each bad sector")) == NO_ERROR)
                     {
                        TxRepl( filefindStr, FS_PALT_SEP, FS_PATH_SEP); // fixup ALT separators
                        if ((strchr( filefindStr, FS_PATH_SEP) != NULL) || // invalid characters in partial name
                            (strchr( filefindStr, '*'        ) != NULL) ||
                            (strchr( filefindStr, '?'        ) != NULL)  )
                        {
                           TxNamedMessage( TRUE, 5933, " ERROR: Invalid filename character ",
                                      "The (partial) name for pre-selection should NOT contain any\n"
                                      "wildcard ('*', '?') or path-separator ('%c') characters!\n\n"
                                      "Remove these characters, or leave the field EMPTY ...", FS_PATH_SEP);
                        }
                        else
                        {
                           switch (lp1)
                           {
                              case DFSC_HFINDD:
                              case DFSC_JFINDD:
                              case DFSC_NFINDD:
                              case DFSC_FFINDD:
                              case DFSC_YFINDD:
                                 sprintf( s2, "delfind  \"%s\"", filefindStr);
                                 break;

                              case DFSC_HFINDA:
                              case DFSC_JFINDA:
                              case DFSC_NFINDA:
                                 sprintf( s2, "filefind -a \"%s\"", filefindStr);
                                 break;

                              default:
                                 sprintf( s2, "filefind \"%s\"", filefindStr);
                                 break;
                           }
                           if (ffVerbose)
                           {
                              strcat( s2, " -v");
                           }
                           if (ffOption1)
                           {
                              strcat( s2, " -c");
                           }
                           if (ffOption2)
                           {
                              strcat( s2, " -d-");
                           }
                           if (ffOption3)
                           {
                              strcat( s2, " -D");
                           }
                           if (ffOption4)
                           {
                              strcat( s2, " -E:i");
                           }
                           dfsExecEnd( s2);
                        }
                     }
                  } while ((strchr( filefindStr, FS_PATH_SEP) != NULL) ||
                           (strchr( filefindStr, '*'        ) != NULL) ||
                           (strchr( filefindStr, '?'        ) != NULL)  );

                  dfsENDWORK();
                  break;

               case DFSC_FRECONE:
                  dfsBEGINWORK();
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the full path and filename for the file you want to find\n"
                        "and recover, starting from the ROOT directory of THIS filesystem\n"
                        "(but WITHOUT the leading / or \\)\n\n"
                        "The path may contain spaces.",
                        " Specify file path+filename ", DFSC_FRECONE,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        120, filedirpath) != TXDID_CANCEL)
                  {
                     TxRepl( filedirpath, FS_PALT_SEP, FS_PATH_SEP); // fixup ALT separators
                     sprintf(     s2, "\"%s%s\"",
                                 (filedirpath[0] != FS_PATH_SEP) ? FS_PATH_STR : "",
                                 (filedirpath[1] == ':') ? filedirpath+3 : filedirpath);
                     dfsExecEnd(  s2);

                     txwSendMsg( dfsa->sbwindow, TXWM_CHAR, 0, (TXWMPARAM) TXc_END);
                     TxCancelAbort();
                     txwAdd2History( dfsa->cmdwindow, s2);
                     if (dfsMultiCommand( s2, 0, TRUE, TRUE, TRUE) == NO_ERROR)
                     {
                        //- retain known filename (without the path here!)
                        sprintf( s1, "saveto -P . . \"%s", TxGetBaseName(s2 +1));
                        dfsMultiCommand( s1, 0, TRUE, TRUE, TRUE);
                     }
                     else
                     {
                        TxNamedMessage( TRUE, DFSC_FRECONE, " ERROR: File not found ",
                                   "The specified file was not found\nrecovery is not possible");
                     }
                  }
                  dfsENDWORK();
                  break;

               case DFSC_FNDPATH:
                  dfsBEGINWORK();
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the full path and filename for the file/directory you want\n"
                        "to find information for, starting from the ROOT of THIS filesystem\n"
                        "(but WITHOUT the leading / or \\)\n\n"
                        "The path may contain spaces.",
                        " Specify file/directory path ", DFSC_FNDPATH,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        120, filedirpath) != TXDID_CANCEL)
                  {
                     TxRepl( filedirpath, FS_PALT_SEP, FS_PATH_SEP); // fixup ALT separators
                     sprintf(     s2, "\"%s%s\"",
                                 (filedirpath[0] != FS_PATH_SEP) ? FS_PATH_STR : "",
                                 (filedirpath[1] == ':') ? filedirpath+3 : filedirpath);
                     dfsExecEnd(  s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_HEDPATH1:
                  dfsBEGINWORK();
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the full path and filename for the file/directory you want\n"
                        "to be HEX edited, starting from the ROOT directory of THIS filesystem\n"
                        "(but WITHOUT the leading / or \\)\n\n"
                        "The path may contain spaces.",
                        " Specify file/directory path ", DFSC_HEDPATH1,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        120, filedirpath) != TXDID_CANCEL)
                  {
                     TxRepl( filedirpath, FS_PALT_SEP, FS_PATH_SEP); // fixup ALT separators
                     sprintf(     s2, "\"%s%s\"#edit",
                                 (filedirpath[0] != FS_PATH_SEP) ? FS_PATH_STR : "",
                                 (filedirpath[1] == ':') ? filedirpath+3 : filedirpath);
                     dfsExecEnd(  s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_HEDPATH2:
                  dfsBEGINWORK();
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the full path and filename for the file or directory you want\n"
                        "to be HEX edited, starting from the ROOT directory of THIS filesystem\n"
                        "(but WITHOUT the leading / or \\)\n\n"
                        "The path may contain spaces.",
                        " Specify file/directory path ", DFSC_HEDPATH2,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        120, filedirpath) != TXDID_CANCEL)
                  {
                     TxRepl( filedirpath, FS_PALT_SEP, FS_PATH_SEP); // fixup ALT separators
                     sprintf(     s2, "\"%s%s\"#d#edit",
                                 (filedirpath[0] != FS_PATH_SEP) ? FS_PATH_STR : "",
                                 (filedirpath[1] == ':') ? filedirpath+3 : filedirpath);
                     dfsExecEnd(  s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_FMTLDR:
                  dfsBEGINWORK();
                  if      (SINF->p)             // a partition
                  {
                     sprintf( s1, "BootableP%2.2hu", SINF->p->id);
                  }
                  else if (SINF->disknr)        // whole disk, large floppy
                  {
                     sprintf( s1, "LargeFlopD%hu", SINF->disknr);
                  }
                  else                          // volume or image
                  {
                     sprintf( s1, "BootableOn%c", SINF->drive[0]);
                  }
                  sprintf( s2, "fs fat -2- -Q -O:q#0#format -o:V -v:%s", s1);
                  dfsExecEnd( s2);
                  dfsENDWORK();
                  break;

               case DFSC_FMTOBJ:  dfsExecEnd( "fs fat -2- -Q -O:q#0#format -!");  break;
               case DFSC_HSYSDMP: dfsExecEnd( "image hpfsdump 0 768 -z -!");      break;
               case DFSC_NMFTDMP: dfsExecEnd( "mft 0#image mftdump . 768 -z -!"); break;
               case DFSC_JSYSDMP: dfsExecEnd( "image jfsdump 0 768 -z -!");       break;

               case DFSC_JSBSIG:
                  dfsBEGINWORK();
                  strcpy( s1, "1");          // default numeric '1'
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify JFS numeric part of Signature string\n"
                        "Should be '1' for IBM OS/2 or eCs or Linux,\n"
                        "but may change for future implementations.",
                        " JFS signature digit ", lp1,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        5, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "sbsig %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_JSBVER:
                  dfsBEGINWORK();
                  strcpy( s1, "IBM (1)");    // default sector 0
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify JFS version as 'IBM'/'eCS', as\n"
                        "'Linux' for the Open Source version,\n"
                        "or as an explicit numeric value",
                        " JFS version number ", lp1,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        9, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "sbver %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_AVLABEL:
               case DFSC_BVLABEL:
               case DFSC_EVLABEL:
               case DFSC_FVLABEL:
               case DFSC_HVLABEL:
               case DFSC_MVLABEL:
               case DFSC_NVLABEL:
               case DFSC_RVLABEL:
               case DFSC_XVLABEL:
               case DFSC_YVLABEL:
               case DFSC_JVLABEL: dfsExecEnd( "label");                           break;
               case DFSC_JVLILAB: dfsExecEnd( "label -l");                        break;
               case DFSC_UXUUID:  dfsExecEnd( "uuid  -u");                        break;
               case DFSC_JMOUNT:  dfsExecEnd( "dirty mount");                     break;
               case DFSC_HCLEAN:
               case DFSC_NCLEAN:
               case DFSC_YCLEAN:
               case DFSC_FCLEAN:
               case DFSC_JCLEAN:  dfsExecEnd( "dirty clean");                     break;
               case DFSC_HDIRTY:
               case DFSC_NDIRTY:
               case DFSC_FDIRTY:
               case DFSC_YDIRTY:
               case DFSC_JDIRTY:  dfsExecEnd( "dirty dirty");                     break;
               case DFSC_BSFIND:  dfsExecEnd( "bsfind");                          break;
               case DFSC_HFINDC:  dfsExecEnd( "findcp");                          break;
               case DFSC_HFIXSU:  dfsExecEnd( "fixsuper");                        break;
               case DFSC_HFIXSP:  dfsExecEnd( "fixspare");                        break;
               case DFSC_DUMPFSB:
               case DFSC_SUPERB:  dfsExecEnd( "super");                           break;
               case DFSC_HFINDR:
               case DFSC_NFINDR:
               case DFSC_YFINDR:
               case DFSC_FFINDR:  dfsExecEnd( "findroot");                        break;

               case DFSC_HFIXBO:
               case DFSC_HFIXBI:
               case DFSC_JFIXBOB:
                  dfsBEGINWORK();
                  strcpy( s1, "");          // default sector 0
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the boot driveletter for the partition "
                        "if it is a bootable one, leave empty otherwise",
                        " Boot driveletter ", lp1,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        5, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "fixboot %c", toupper( s1[0]));
                     if ( lp1 == DFSC_HFIXBI)
                     {
                        strcat( s2, " -I13X");
                     }
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               //- to be refined, add a TxConfirm on these two actions, or in the command?
               case DFSC_YFIXBO:  dfsExecEnd( "bootsync -s");                     break;
               case DFSC_YCRCBO:  dfsExecEnd( "bootsync");                        break;

               case DFSC_NTLDRF:  dfsExecEnd( "fixntldr -V-");                    break;
               case DFSC_NTLDRV:  dfsExecEnd( "fixntldr -V");                     break;
               case DFSC_NFNDMFT: dfsExecEnd( "findmft");                         break;
               case DFSC_NFIXBOV: dfsExecEnd( "fixboot -s- -V");                  break;
               case DFSC_NFIXBOX: dfsExecEnd( "fixboot -s- -V-");                 break;
               case DFSC_NFIXBOS:
               case DFSC_JFIXBOS: dfsExecEnd( "fixboot -s");                      break;
               case DFSC_FFIXBO:  dfsExecSilent( "fixboot -!");                   break;
               case DFSC_NOBADS:  dfsExecEnd( "bsclear");                         break;
               case DFSC_XIDLST:  dfsExecEnd( "id -L");                           break;
               case DFSC_XDISLT:  dfsExecSilent( "slt -P");                       break;

               case DFSC_XIDSLT:
                  dfsBEGINWORK();
                  sprintf( s1, "0x0%llx", nav.this);
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the sector-number for the sector "
                        "you want to be identified.",
                        " Specify sectornumber ", DFSC_XIDSLT,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        13, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "id %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_NDMFTR:
                  dfsBEGINWORK();
                  strcpy( s1, "0");             // default MFT 0
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the MFT-number for the file you "
                        "want to display the MFT-record for.",
                        " Hexadecimal MFT-number ", DFSC_NDMFTR,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        9, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "mft %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_MFTNR0:  dfsExecEnd( "mft 0x0");           break;
               case DFSC_MFTNR1:  dfsExecEnd( "mft 0x1");           break;
               case DFSC_MFTNR2:  dfsExecEnd( "mft 0x2");           break;
               case DFSC_MFTNR3:  dfsExecEnd( "mft 0x3");           break;
               case DFSC_MFTNR4:  dfsExecEnd( "mft 0x4");           break;
               case DFSC_MFTNR5:  dfsExecEnd( "mft 0x5");           break;
               case DFSC_MFTNR6:  dfsExecEnd( "mft 0x6");           break;
               case DFSC_MFTNR7:  dfsExecEnd( "mft 0x7");           break;
               case DFSC_MFTNR8:  dfsExecEnd( "mft 0x8");           break;
               case DFSC_MFTNR9:  dfsExecEnd( "mft 0x9");           break;
               case DFSC_MFTNRA:  dfsExecEnd( "mft 0xA");           break;
               case DFSC_MFTNRB:  dfsExecEnd( "mft 0xB");           break;

               case DFSC_MCATNR:
                  dfsBEGINWORK();
                  strcpy( s1, "0");             // default node 0, header
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the node-number for the Catalog-file node you "
                        "want to display the contents for.",
                        " Hexadecimal node-number ", DFSC_MCATNR,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        9, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "node %s -r:0", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_MFLDNR:
                  dfsBEGINWORK();
                  strcpy( s1, "2");             // default folder 2, root
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the folder-number (CnID) for the folder you "
                        "want to display the directory contents for.",
                        " Hexadecimal folder-number ", DFSC_MFLDNR,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        9, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "folder %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_MFLDR1:  dfsExecEnd( "folder 1");                break;
               case DFSC_MFLDR2:  dfsExecEnd( "folder 2");                break;
               case DFSC_MFLDR0:  dfsExecEnd( "folder 0 -r:5");           break;
               case DFSC_MCATN0:  dfsExecEnd( "node 0");                  break;
               case DFSC_MCATNT:  dfsExecEnd( "folder 0 -r:6");           break;
               case DFSC_MCATNL:  dfsExecEnd( "folder 0 -r:0 -trace");    break;
               case DFSC_MCATNV:  dfsExecEnd( "folder 0 -r:0 -trace -v"); break;

               case DFSC_MHLINKS:
                  sprintf( s2, "hlinks %s", (dfsa->FsToggleOption1) ? "off" : "on");
                  dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_MFALIAS:
                  sprintf( s2, "fdalias %s", (dfsa->FsToggleOption2) ? "off" : "on");
                  rc = dfsExecReopenMenu( FALSE, s2);
                  break;

               case DFSC_JDINOR:                // JFS display Inode
               //   DFSC_EDINOR:                // EXT display Inode (same value)
                  dfsBEGINWORK();
                  strcpy( s1, "0");             // default sector 0
                  if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL,
                        "Specify the Inode-number for the file you "
                        "want to display the Inode-sector for.",
                        " Hexadecimal Inode-number ", DFSC_JDINOR,
                        TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                        9, s1) != TXDID_CANCEL)
                  {
                     sprintf( s2, "ino %s", s1);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_INONR1:  dfsExecEnd( "ino 1");             break;
               case DFSC_INONR2:  dfsExecEnd( "ino 2");             break;
               case DFSC_INONR3:  dfsExecEnd( "ino 3");             break;
               case DFSC_INON59:  dfsExecEnd( "0x59");              break;
               case DFSC_INON5A:  dfsExecEnd( "0x5a");              break;
               case DFSC_INON5C:  dfsExecEnd( "0x5c");              break;
               case DFSC_INON68:  dfsExecEnd( "0x68");              break;

               case DFSC_EDINO1:  dfsExecEnd( "ino 2");             break;
               case DFSC_EDINO2:  dfsExecEnd( "ino 7");             break;
               case DFSC_EDINO3:  dfsExecEnd( "ino 8");             break;
               case DFSC_EALOCBG: dfsExecEnd( "abg");               break;
               case DFSC_EBACKUP: dfsExecEnd( "bsl");               break;
               case DFSC_EBLKGRP: dfsExecEnd( "bg *");              break;

               case DFSC_INTLDR:
                  dfsBEGINWORK();
                  if (txwSelDirFileDialog( NULL, DFSC_INTLDR, NULL, NULL,
                      " Select writable directory for NTLDR image file ", s1))
                  {
                     sprintf( s2, "dfsntldr \"%s%s\"", s1, NTLDR_IMGNAME);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_RNTLDR:
                  dfsBEGINWORK();
                  sprintf( s1, "%s.im?", NTLDR_IMGNAME);

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_RNTLDR, NULL, NULL,
                      " Select the NTLDR imagefile to be restored ", s1))
                  {
                     sprintf( s2, "fixntldr -I:\"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_IHPLDR:
                  dfsBEGINWORK();
                  if (txwSelDirFileDialog( NULL, DFSC_IHPLDR, NULL, NULL,
                      " Select writable directory for HPLDR image file ", s1))
                  {
                     sprintf( s2, "dfshpldr \"%s%s\"", s1, HPLDR_IMGNAME);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_RHPLDR:
                  dfsBEGINWORK();
                  sprintf( s1, "%s.im?", HPLDR_IMGNAME);

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_RHPLDR, NULL, NULL,
                      " Select the HPFS LDR imagefile to be restored ", s1))
                  {
                     sprintf( s2, "fixhpldr \"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_IJFLDR:
                  dfsBEGINWORK();
                  if (txwSelDirFileDialog( NULL, DFSC_IJFLDR, NULL, NULL,
                      " Select writable directory for JFS LDR image file ", s1))
                  {
                     sprintf( s2, "dfsjfldr \"%s%s\"", s1, JFLDR_IMGNAME);
                     dfsExecEnd( s2);
                  }
                  dfsENDWORK();
                  break;

               case DFSC_RJFLDR:
                  dfsBEGINWORK();
                  sprintf( s1, "%s.im?", JFLDR_IMGNAME);

                  if (txwOpenFileDialog( s1, NULL, NULL, DFSC_RJFLDR, NULL, NULL,
                      " Select the JFS LDR imagefile to be restored ", s1))
                  {
                     sprintf( s2, "fixjfldr \"%s\"", s1);
                     dfsExecCmd( s2);
                  }
                  dfsENDWORK();
                  break;

               default:
                  if      (txwMiRange( DFSB_ODISK, DFS_MAX_DISK))
                  {
                     sprintf( s2, "disk %u", txwMiValue( DFSB_ODISK));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_OPART, DFS_MAX_PART))
                  {
                     sprintf( s2, "part -O:q -a %u", txwMiValue( DFSB_OPART));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_VPART, DFS_MAX_PART))
                  {
                     sprintf( s2, "part -O:v -a %u", txwMiValue( DFSB_VPART));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_OFPRI, DFS_MAX_PART))
                  {
                     sprintf( s2, "base -f:%u", txwMiValue( DFSB_OFPRI));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_OFLOG, DFS_MAX_PART))
                  {
                     sprintf( s2, "base -f:%u -l", txwMiValue( DFSB_OFLOG));
                     dfsExecEnd( s2);
                  }

#if defined (LINUX)
                  else if (txwMiRange( DFSB_OVOLM, DFS_MAX_VOLS))
                  {
                     if (dfsa->slVolumes != NULL)
                     {
                        sprintf( s2, "dev %s", dfsa->slVolumes->items[txwMiValue( DFSB_OVOLM)]->text);
                        dfsExecEnd( s2);
                     }
                  }
#else
                  else if (txwMiRange( DFSB_OVOLM, DFS_MAX_VOLS))
                  {
                     sprintf( s0, "%c:", (char) (txwMiValue( DFSB_OVOLM) +'A'));

                     if ((nr = dfsDrive2PartId( s0)) != 0) // is a partition
                     {
                        TxNamedMessage( TRUE, DFSC_OVOLM, " INFO: Partition access recommended ",
                                   "The selected volume '%s' corresponds to "
                                   "partition %02.2u.  For many operations it "
                                   "may be more reliable and faster to open it "
                                   "as a partition instead of a volume ...", s0, nr);
                     }
                     sprintf( s2, "vol %s", s0);
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_VVOLM, DFS_MAX_VOLS))
                  {
                     sprintf( s2, "vol %c: -v", (char) (txwMiValue( DFSB_VVOLM) +'A'));
                     dfsExecEnd( s2);
                  }
#endif
                  else if (txwMiRange( DFSB_MEJECT, DFS_MAX_VOLS))
                  {
                     sprintf( s2, "eject %c:", (char) (txwMiValue( DFSB_MEJECT) +'A'));
                     dfsExecEnd( s2);
                     slVolumes_count = 0;       // force list-update on menu
                  }
                  else if (txwMiRange( DFSB_DETACH, DFS_MAX_DISK))
                  {
                     sprintf( s2, "detach %u", txwMiValue( DFSB_DETACH));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_BMGR, DFS_MAX_PART))
                  {
                     nr = txwMiValue( DFSB_BMGR);
                     if (nr != 0)
                     {
                        p = dfsGetPartInfo( (USHORT) nr);
                        if (p != NULL)
                        {
                           sprintf( s2, "setboot -B -iba:\"%s\"", p->blabel);
                           dfsExecEnd( s2);
                        }
                     }
                     else                       // just reboot (BM default)
                     {
                        sprintf( s2, "setboot -B -b");
                        dfsExecEnd( s2);
                     }
                  }
                  else if (txwMiRange( DFSB_ISOVDI, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "vdi %u", txwMiValue( DFSB_ISOVDI));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_APFSVI, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "vi %u", txwMiValue( DFSB_APFSVI));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_PTEDIT, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "pte %u", txwMiValue( DFSB_PTEDIT));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_LVMDLG, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "lvm %u", txwMiValue( DFSB_LVMDLG));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_SCHEME, TXWCS_LAST_SCHEME + 1))
                  {
                     dfsBEGINWORK();
                     txwColorScheme( txwMiValue( DFSB_SCHEME), NULL);
                     txwInvalidateAll();        // redraw everything
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_PALET, TXWMAX_PALETTE + 1))
                  {
                     dfsBEGINWORK();
                     TxSwitchAnsiPalette( txwMiValue( DFSB_PALET)); // Set the palette
                     txwRefreshScreen();        // flush, redraw everything
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_BMDEFL, DFS_MAX_PART))
                  {
                     if ((nr = txwMiValue( DFSB_BMDEFL)) != 0)
                     {
                        if ((p = dfsGetPartInfo( (USHORT) nr)) != NULL)
                        {
                           sprintf( s2, "setboot -0:\"%s\"", p->blabel);
                           dfsExecEnd( s2);
                        }
                     }
                     else                       // Set to 'last booted'
                     {
                        sprintf( s2, "setboot -0:");
                        dfsExecEnd( s2);
                     }
                  }
                  else if (txwMiRange( DFSB_DFSFAST, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "dfsfast %u -!", txwMiValue( DFSB_DFSFAST));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_DFSDISK, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "dfsdisk %u -!", txwMiValue( DFSB_DFSDISK));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_CHKPART, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();

                     if (txwSelDirFileDialog( NULL, DFSC_CHKPART, NULL, NULL,
                         " Select writable directory for DFSC*.P* files ", s1))
                     {
                        TxStrip( s1, s1, '-', '\\'); // strip trailing backslash
                        sprintf( s2, "cd %s", s1);
                        dfsExecEnd( s2);

                        sprintf( s2, "dfscheck %u", txwMiValue( DFSB_CHKPART));
                        dfsExecEnd( s2);
                     }
                     dfsENDWORK();
                  }
#if defined (UNIX)
                  else if (txwMiRange( DFSB_UMTVOL, DFS_MAX_DISK)) // unmount volumes from disk
                  {
                     dfsBEGINWORK();
                     nr = txwMiValue( DFSB_UMTVOL);
                     if ((nr != 0) && ((d = dfsGetDiskInfo((USHORT) nr)) != NULL))
                     {
                        TxPrint( "UNMOUNT volumes from disk: %u = '%s%s%s', and open for Read/Write access\n",
                                                              nr, CBY,               d->UnixDeviceDisk, CNN);
                        #if   defined (DARWIN)
                           sprintf( s1, "close#diskutil unmountdisk %s#disk %u -O:q", d->UnixDeviceDisk, nr);
                        #else
                           sprintf( s1, "close#umount %s?#disk %u",                   d->UnixDeviceDisk, nr);
                        #endif
                        dfsExecEnd( s1);
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MNTVOL, DFS_MAX_DISK)) // mount volumes for disk
                  {
                     dfsBEGINWORK();
                     nr = txwMiValue( DFSB_MNTVOL);
                     if ((nr != 0) && ((d = dfsGetDiskInfo((USHORT) nr)) != NULL))
                     {
                        TxPrint( "(auto) MOUNT volumes for disk: %u = '%s%s%s', and open for Read access\n",
                                                                  nr, CBY,         d->UnixDeviceDisk, CNN);
                        #if   defined (DARWIN)
                           sprintf( s1, "close#diskutil mountdisk %s#disk %u -O:q", d->UnixDeviceDisk, nr);
                        #else
                           sprintf( s1, "close#mount %s?#disk %u",                  d->UnixDeviceDisk, nr);
                        #endif
                        dfsExecEnd( s1);
                     }
                     dfsENDWORK();
                  }
#endif

#if !defined (DOS32)
                  else if (txwMiRange( DFSB_MPUP64, DFS_MAX_DISK))
                  {
                     strcpy( s1, DFS_PUP64_LOCAL_IMZ);
                     #if defined (LINUX)
                        if (TxFileExists( DFS_PUP64_STICK_IMZ))
                        {
                           //- use alternate location, outside the containerfiles
                           strcpy( s1,    DFS_PUP64_STICK_IMZ);
                        }
                     #endif
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfspuppy %u %s %d %d", txwMiValue( DFSB_MPUP64),
                                      s1, DFS_PUP64_ISIZE_IMZ, DFS_PUP64_TRACKSIZE);
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MPUP32, DFS_MAX_DISK))
                  {
                     strcpy( s1, DFS_PUP32_LOCAL_IMZ);
                     #if defined (LINUX)
                        if (TxFileExists( DFS_PUP32_STICK_IMZ))
                        {
                           //- use alternate location, outside the containerfiles
                           strcpy( s1,    DFS_PUP32_STICK_IMZ);
                        }
                     #endif
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfspuppy %u %s %d %d", txwMiValue( DFSB_MPUP32),
                                      s1, DFS_PUP32_ISIZE_IMZ, DFS_PUP32_TRACKSIZE);
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MPUPPY, DFS_MAX_DISK))
                  {
                     strcpy( s1, DFS_PUPPY_LOCAL_IMZ);
                     #if defined (LINUX)
                        if (TxFileExists( DFS_PUPPY_STICK_IMZ))
                        {
                           //- use alternate location, outside the containerfiles
                           strcpy( s1,    DFS_PUPPY_STICK_IMZ);
                        }
                     #endif
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfspuppy %u %s %d %d", txwMiValue( DFSB_MPUPPY),
                                      s1, DFS_PUPPY_ISIZE_IMZ, DFS_PUPPY_TRACKSIZE);
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MUSB32, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfsusb32 %u", txwMiValue( DFSB_MUSB32));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MF32ST, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfsf32st %u", txwMiValue( DFSB_MF32ST));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MF16ST, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfsf16st %u", txwMiValue( DFSB_MF16ST));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MIFSTD, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfsifstd %u", txwMiValue( DFSB_MIFSTD));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_MJFS35, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "runscript -Q dfsjfs35 %u", txwMiValue( DFSB_MJFS35));
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
#endif
                  else if (txwMiRange( DFSB_FMTFAT, DFS_MAX_PART))
                  {
                     sprintf( s2, "part -Q -2- %u#fs fat -2- -Q -O:q#0#format -!",
                                           txwMiValue( DFSB_FMTFAT));
                     dfsExecSilent( s2);
                  }
                  else if (txwMiRange( DFSB_WIPEFSP, DFS_MAX_PART))
                  {
                     sprintf( s2, "base -f:%u#wipe z", txwMiValue( DFSB_WIPEFSP));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_MOVE2F, DFS_MAX_PART))
                  {
                     sprintf( s2, "move -a -f:%u -P", txwMiValue( DFSB_MOVE2F));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_COPY2F, DFS_MAX_PART))
                  {
                     sprintf( s2, "move -c -a -f:%u -P", txwMiValue( DFSB_COPY2F));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMINFO, DFS_MAX_PART))
                  {
                     sprintf( s2, "lvmshow %u", txwMiValue( DFSB_LVMINFO));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_WALKRAW, DFS_MAX_DISK))
                  {
                     sprintf( s2, "walk %u", txwMiValue( DFSB_WALKRAW));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_SECPART, DFS_MAX_PART))
                  {
                     sprintf( s2, "pt %u -r", txwMiValue( DFSB_SECPART));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_EBRPART, DFS_MAX_PART))
                  {
                     sprintf( s2, "pt %u", txwMiValue( DFSB_EBRPART));
                     dfsExecEnd( s2);
                  }

                  //- FDISK specific functionality
                  else if (txwMiRange( DFSB_SAVEPD, DFS_MAX_DISK))
                  {
                     dfsPsaveDialog( txwMiValue( DFSB_SAVEPD));
                  }
                  else if (txwMiRange( DFSB_RESTPD, DFS_MAX_DISK))
                  {
                     dfsPrestoreDialog( txwMiValue( DFSB_RESTPD));
                  }
                  else if (txwMiRange( DFSB_GENPDLG, DFS_MAX_DISK))
                  {
                     dfsGenPartDialog( txwMiValue( DFSB_GENPDLG), NULL, "From 'Make partition scripts' menu item", TX_UNKNOWN, TX_UNKNOWN);
                  }
                  else if (txwMiRange( DFSB_GEODLG, DFS_MAX_DISK))
                  {
                     sprintf( s2, "geo -! -d:%u", txwMiValue( DFSB_GEODLG));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_FIXCHS, DFS_MAX_DISK))
                  {
                     sprintf( s2, "fixchs %u -c", txwMiValue( DFSB_FIXCHS));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_FIXEXT, DFS_MAX_DISK))
                  {
                     sprintf( s2, "fixext %u 05", txwMiValue( DFSB_FIXEXT));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_FIXEXF, DFS_MAX_DISK))
                  {
                     sprintf( s2, "fixext -all %u 0f", txwMiValue( DFSB_FIXEXF));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_CLEANUP, DFS_MAX_DISK))
                  {
                     sprintf( s2, "cleanup %u -c", txwMiValue( DFSB_CLEANUP));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_ALIGND, DFS_MAX_DISK))
                  {
                     sprintf( s2, "alignext %u", txwMiValue( DFSB_ALIGND));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_ALIGNL, DFS_MAX_PART))
                  {
                     sprintf( s2, "alignext -p:%u", txwMiValue( DFSB_ALIGNL));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_GPTFIX, DFS_MAX_DISK))
                  {
                     sprintf( s2, "gpt %u -fix", txwMiValue( DFSB_GPTFIX));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_MBR2GPT, DFS_MAX_DISK))
                  {
                     sprintf( s2, "mbr2gpt %u", txwMiValue( DFSB_MBR2GPT));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_GPT2MBR, DFS_MAX_DISK))
                  {
                     sprintf( s2, "gpt2mbr %u", txwMiValue( DFSB_GPT2MBR));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_NEWMBC, DFS_MAX_DISK))
                  {
                     sprintf( s2, "newmbr %u -c", txwMiValue( DFSB_NEWMBC));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_NEWMBR, DFS_MAX_DISK))
                  {
                     sprintf( s2, "newmbr %u", txwMiValue( DFSB_NEWMBR));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_NEWMBI, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     strcpy(  s1, "*.img");
                     if (txwOpenFileDialog( s1, NULL, NULL, DFSC_NEWMBI, NULL, NULL,
                         " Select the MBR code imagefile to be restored ", s1))
                     {
                        sprintf( s2, "newmbr %u -I:\"%s\"", txwMiValue( DFSB_NEWMBI), s1);
                        dfsExecCmd( s2);
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_SAVMBR, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "disk%umbr", txwMiValue( DFSB_SAVMBR));
                     strcpy(  s1, "*.img");
                     if (txwSaveAsFileDialog( s1, NULL, s2, DFSC_SAVMBR, NULL, NULL,
                         " Specify file for saving the MBR code to ", s1))
                     {
                        sprintf( s2, "disk %u#image \"%s\" 0 1", txwMiValue( DFSB_SAVMBR), s1);
                        dfsExecCmd( s2);
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_NTSIGN, DFS_MAX_DISK))
                  {
                     sprintf( s2, "ntsign %u", txwMiValue( DFSB_NTSIGN));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_WIPEST, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();
                     sprintf( s2, "disk %u#wipe z 0 -s:32,m", txwMiValue( DFSB_WIPEST));
                     dfsExecEnd( s2);
                     TxNamedMessage( TRUE, DFSC_WIPEST, " INFO: Reboot recommended ",
                                "It is strongly advised to REBOOT the system now to allow "
                                "it to determine the correct disk geometry and size. "
                                "This may be required to 'see' the full capacity of the disk. "
                                "For removable media like memory sticks an eject/reinsert "
                                "should be enough."
                              );
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_LVMCLN, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();

                     nr = txwMiValue( DFSB_LVMCLN);
                     if ((nr != 0) && ((d = dfsGetDiskInfo((USHORT) nr)) != NULL))
                     {
                        TRACES(( "lvmcln disk %u, geoSecs: %u\n", nr, d->geoSecs));

                        sprintf( s2, "lvmclean %u", nr);
                        dfsExecEnd( s2);
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_LVMCRC, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();

                     nr = txwMiValue( DFSB_LVMCRC);
                     if (nr != 0)
                     {
                        sprintf( s2, "lvm -c -d:%u", nr);
                     }
                     else                       // all disks
                     {
                        strcpy(  s2, "lvm -c");
                     }
                     dfsExecEnd( s2);
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_WIPET1, DFS_MAX_DISK))
                  {
                     dfsBEGINWORK();

                     nr = txwMiValue( DFSB_WIPET1);
                     if ((nr != 0) && ((d = dfsGetDiskInfo((USHORT) nr)) != NULL))
                     {
                        TRACES(( "wipet1 disk %u, geoSecs: %u\n", nr, d->geoSecs));

                        sprintf( s2, "disk %u#wipe z 1 %u",
                                      nr, (ULONG)  (d->geoSecs -
                                          (ULONG) ((d->lvmPartitions != 0) ? 2 : 1)));
                        dfsExecEnd( s2);
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_WEBRT1, DFS_MAX_PART))
                  {
                     nr = txwMiValue( DFSB_WEBRT1);
                     if (nr != 0)
                     {
                        p = dfsGetPartInfo( (USHORT) nr);
                        if (p != NULL)
                        {
                           ULONG        wipeSize;
                           ULONG        startSec;

                           if (p->partPsn == 0) // Primary partition
                           {
                              startSec = 1;
                              wipeSize = p->geoSecs;
                           }
                           else
                           {
                              startSec = p->partPsn + 1;
                              wipeSize = p->basePsn - startSec +1;
                           }
                           TRACES(( "webrt1 part %u, start: %8.8x size: %u\n",
                                     nr, startSec, wipeSize));

                           if (wipeSize > (ULONG) ((p->lvmPresent) ? 2 : 1))
                           {
                              wipeSize -= (ULONG) ((p->lvmPresent) ? 2 : 1);

                              TxPrint( "\nWipe %u reserved sectors in %sBR track for %s partition %hu\n",
                                        wipeSize, (startSec == 1) ? "M" : "E",
                                                  (startSec == 1) ? "PRIMARY" : "LOGICAL", p->id);

                              sprintf( s2, "disk %hu -O:q#wipe z %u %u", p->disknr, startSec, wipeSize);
                              dfsExecEnd( s2);
                           }
                           else
                           {
                              TxNamedMessage( TRUE, DFSC_WEBRT1, " ERROR: No sectors to wipe ",
                                         "There are NO reserved sectors in the "
                                         "MBR/EBR track for this partition!");
                           }
                        }
                     }
                  }
                  else if (txwMiRange( DFSB_W2KBMG, DFS_MAX_DISK))
                  {
                     sprintf( s2, "bmfix %u", txwMiValue( DFSB_W2KBMG));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMVCU, DFS_MAX_DISK))
                  {
                     sprintf( s2, "vcu %u", txwMiValue( DFSB_LVMVCU));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMRED, DFS_MAX_DISK))
                  {
                     sprintf( s2, "lvmredo %u", txwMiValue( DFSB_LVMRED));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMPCL, DFS_MAX_DISK))
                  {
                     sprintf( s2, "pclear %u ls", txwMiValue( DFSB_LVMPCL));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMDNM, DFS_MAX_DISK))
                  {
                     sprintf( s2, "lvm -d:%u -n", txwMiValue( DFSB_LVMDNM));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMGEO, DFS_MAX_DISK))
                  {
                     sprintf( s2, "lvm -d:%u -G", txwMiValue( DFSB_LVMGEO));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMBBR, DFS_MAX_DISK))
                  {
                     sprintf( s2, "lvm -d:%u -C", txwMiValue( DFSB_LVMBBR));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMRMV, DFS_MAX_PART))
                  {
                     sprintf( s2, "lvm %u -v- -l-", txwMiValue( DFSB_LVMRMV));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_LVMDEF, DFS_MAX_PART))
                  {
                     sprintf( s2, "lvm %u -D", txwMiValue( DFSB_LVMDEF));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_BMINST, DFS_MAX_PART))
                  {
                     DFSPARTINFO       *f = dfsGetFreeInfo( txwMiValue( DFSB_BMINST));

                     dfsBEGINWORK();
                     if (f != NULL)
                     {
                        sprintf( s2, "cr pri bmgr 1,c -L -F -f:%u", txwMiValue( DFSB_BMINST));

                        TxCancelAbort();        // reset pending abort status
                        if ((f->sectors > f->cSC) && // more than one cylinder
                            (!dfsa->batch))     // and not forced in batch mode
                        {
                           if (!TxConfirm( DFSC_BMINST, // default "Yes" is 'at start'
                              "The selected freespace area (%u MiB) is larger "
                              "than one disk cylinder, the default Bootmanager size. "
                              "It can be installed at the start or the end of that area.\n\n"
                              "Do you want to install Bootmanager at the start "
                              "of the freespace area ? [Y/N]: ",
                               DFSECT2MIB( f->sectors, f->bpsector) ))
                           {
                              strcat( s2, " -e"); // not start, put it 'at end'
                           }
                        }
                        if (!TxAbort())
                        {
                           dfsExecEnd( s2);
                        }
                        else
                        {
                           rc = DFS_USER_ABORT;
                        }
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_BMMENU, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     if ((nr = txwMiValue( DFSB_BMMENU)) != 0)
                     {
                        if ((p = dfsGetPartInfo( (USHORT) nr)) != NULL)
                        {
                           if (p->tablenr != GPT_STYLE)
                           {
                              strcpy( s1, p->blabel); // current BM name or ""
                              strcpy( s2, "Specify the name to be used on the Bootmanager "
                                          "menu for this partition.\n\n");
                              if (dfsa->lvmPresent) // any LVM present ?
                              {
                                 strcat( s2, "This will become the LVM volume name too.");
                              }
                              if (txwPromptBox( TXHWND_DESKTOP, TXHWND_DESKTOP, NULL, s2,
                                    " Partition name on the menu ", DFSC_BMMENU,
                                    TXPB_MOVEABLE | TXPB_HCENTER | TXPB_VCENTER,
                                    (dfsa->lvmPresent) ? LVM_NAME_L : 9, s1) != TXDID_CANCEL)
                              {
                                 if (dfsa->lvmPresent) // any LVM present ?
                                 {
                                    sprintf( s2, "lvm %u -P- -m -v:'%s'", nr, s1);
                                    dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                                 }
                                 sprintf( s2, "setname %u -B '%s'", nr, s1);
                                 dfsMultiCommand( s2, 0, TRUE, FALSE, FALSE);
                              }
                           }
                           else
                           {
                              TxNamedMessage( TRUE, 0, " ERROR: Invalid partition style ",
                                              "GPT style partitions can not be added to Bootmanager");
                           }
                        }
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_BMDELM, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     if ((nr = txwMiValue( DFSB_BMDELM)) != 0)
                     {
                        if ((p = dfsGetPartInfo( (USHORT) nr)) != NULL)
                        {
                           if (p->lvmPresent)   // does it have LVM ?
                           {
                              sprintf( s2, "lvm %u -P- -m-", nr);
                              dfsMultiCommand( s2, 0, TRUE, FALSE, TRUE);
                           }
                           sprintf( s2, "setname %u -B", nr);
                           dfsMultiCommand( s2, 0, TRUE, FALSE, FALSE);
                        }
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_ACTIVE, DFS_MAX_PART))
                  {
                     sprintf( s2, "startable %u multi", txwMiValue( DFSB_ACTIVE));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_NOTACT, DFS_MAX_PART))
                  {
                     sprintf( s2, "startable %u clear", txwMiValue( DFSB_NOTACT));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_P_HIDE, DFS_MAX_PART))
                  {
                     sprintf( s2, "setacces %u hidden", txwMiValue( DFSB_P_HIDE));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_UNHIDE, DFS_MAX_PART))
                  {
                     sprintf( s2, "setacces %u visible", txwMiValue( DFSB_UNHIDE));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_MULTIV, DFS_MAX_PART))
                  {
                     sprintf( s2, "setacces %u multi", txwMiValue( DFSB_MULTIV));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_DELETE, DFS_MAX_PART))
                  {
                     sprintf( s2, "delete %u", txwMiValue( DFSB_DELETE));
                     dfsExecEnd( s2);
                  }
                  else if (txwMiRange( DFSB_CHTYPE, DFS_MAX_PART))
                  {
                     dfsBEGINWORK();
                     p = dfsGetPartInfo(txwMiValue( DFSB_CHTYPE));
                     if (p != NULL)
                     {
                        if (p->tablenr != GPT_STYLE)
                        {
                           sprintf( s1, "New type for MBR partition %2.2hu", p->id);
                           if (dfsPromptMbrPartitionType( s1, 5901, &nr))
                           {
                              sprintf( s2, "settype %hu %hu ", p->id, p->disknr);
                              if (nr == DFS_PTYPE_AUTOFAT)
                              {
                                 strcat(  s2, "FAT");
                              }
                              else
                              {
                                 sprintf( s1, "0x%x", nr);
                                 strcat(  s2,  s1);
                              }
                              dfsExecEnd( s2);
                           }
                        }
                        else
                        {
                           sprintf( s1, "New type for GPT partition %2.2hu", p->id);
                           if (dfsPromptGptPartitionType( s1, 5902, s0))
                           {
                              sprintf( s2, "settype %hu %hu -t:'%36.36s'", p->id, p->disknr, s0 +1);
                              dfsExecEnd( s2);
                           }
                        }
                     }
                     dfsENDWORK();
                  }
                  else if (txwMiRange( DFSB_CREATE, DFS_MAX_PART))
                  {
                     DFSPARTINFO        *freeSpace = dfsGetFreeInfo( txwMiValue( DFSB_CREATE));
                     BOOL                haveCommand;

                     dfsBEGINWORK();
                     if (freeSpace->partent.PartitionType > DFS_FSP_GPT_STYLE)
                     {
                        haveCommand = txwCreateMbrPartDialog( freeSpace, s2);
                     }
                     else
                     {
                        haveCommand = txwCreateGptPartDialog( freeSpace, s2);
                     }
                     if (haveCommand)
                     {
                        dfsExecEnd( s2);
                     }
                     dfsENDWORK();
                  }
                  else
                  {
                     dfsBEGINWORK();
                     TxNamedMessage( TRUE, 5001, " ERROR: Invalid menu code ",
                                "Unknown menu command-code %u,\nthis is a program bug.\n\n"
                                "Please report this to your support contact for this software", lp1);
                     dfsENDWORK();
                  }
                  break;
            }

            // When ANY command (script or otherwise) returned a 'quit' RC, makeit exit!
            if ((rc & DFS_QUIT) == DFS_QUIT)
            {
               txwPostMsg( hwnd, TXWM_CLOSE, 0, 0);
            }
            break;


         case TXWM_CHAR:
            if ((win->class != TXW_SBVIEW) &&   // when not in scrollbuffer,
                (txwIsAccelCandidate(lp2))  )   // menu will be closed, allow
            {                                   // automenu to restart it.
               dfsBEGINWORK();
               if (lp2 == TXc_2)
               {
                  //- dfsExecEnd( "menu2html");
                  dfsGeneratePhpMenuDoc();      // fixed PHP, hardcoded, all menus
               }
               else if ((lp2 >= 0x20) && (lp2 <= 0x80) && // disable accel like
                        (win->class == TXW_ENTRYFIELD) && // <> when not at the
                        (win->ef.curpos > 0))   // beginning of an entryfield
               {
                  rc = txwDefWindowProc( hwnd, msg, mp1, mp2);
               }
               else
               {
                  TRACES(("Unrecognized accelerator candidate - no action\n"));
               }
               dfsENDWORK();
            }
            else
            {
               rc = txwDefWindowProc( hwnd, msg, mp1, mp2);
            }
            break;

         default:
            rc = txwDefWindowProc( hwnd, msg, mp1, mp2);
            break;
      }
   }
   else
   {
      rc = TX_INVALID_HANDLE;
   }
   RETURN( rc);
}                                               // end 'dfsStdWindowProc'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Execute command (End/Silent), reopen SAME menu dropdown (option toggle etc)
/*****************************************************************************/
static ULONG dfsExecReopenMenu
(
   BOOL                silent,                  // IN    Execute in silent mode
   char               *command                  // IN    Command to execute
)
{
   ULONG               rc;                      // function return
   TXS_MENUBAR        *dfsmenu = dfsGetMainMenu();

   ENTER();

   dfsBEGINWORK();
   if (silent)
   {
      dfsExecSilent( command);                  // includes set of 'rc'
   }
   else
   {
      dfsExecEnd( command);                     // includes set of 'rc'
   }
   dfsa->menuOwner = entrwin;                   // Reopen the same menu
   dfsa->menuopen  = dfsmenu->menu[ dfsmenu->defopen]->ident;
   dfsENDWORK();

   RETURN (rc);
}                                               // end 'dfsExecReopenMenu'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// DFSee window procedure, for entry-field, includes automatic value-echo
/*****************************************************************************/
static ULONG dfsEntryWindowProc                 // RET   result
(
   TXWHANDLE           hwnd,                    // IN    current window
   ULONG               msg,                     // IN    message id
   TXWMPARAM           mp1,                     // IN    msg param 1
   TXWMPARAM           mp2                      // IN    msg param 2
)
{
   ULONG               rc   = NO_ERROR;
   ULONG               dr;
   ULONG               key;
   TXWINDOW           *win;

   ENTER();
   TRCMSG( hwnd, msg, mp1, mp2);
   if (hwnd != 0)
   {
      TRCLAS( "DFS entry - ", hwnd);
      win = txwWindowData( hwnd);
      switch (msg)
      {
         case TXWM_CHAR:
            switch ((ULONG) mp2)
            {
               case TXk_ENTER:                  // execute as DFSee command
                  txwSendMsg( dfsa->sbwindow, TXWM_CHAR, 0, (TXWMPARAM) TXc_END);
               case TXc_ENTER:                  // execute, no auto-scroll
                  txwSendMsg( hwnd,  TXWM_CURSORVISIBLE, (TXWMPARAM) FALSE, 0);

                  TxCancelAbort();              // reset pending abort status
                  dr = dfsMultiCommand( win->ef.buf, 0, TRUE, dfsa->cmdprompt, TRUE);
                  if (((dr & DFS_QUIT) == DFS_QUIT) || ( dfsa->autoquit))
                  {
                     txwPostMsg( hwnd, TXWM_CLOSE, 0, 0);
                  }
                  else                          // update history etc
                  {
                     rc = txwDefWindowProc( hwnd, msg, mp1, mp2);

                     txwSendMsg( hwnd,  TXWM_CURSORVISIBLE, (TXWMPARAM) TRUE, 0);

                     #if defined (DEV32)
                        txwInvalidateAll();     // avoid VIO64K bug
                     #endif
                  }
                  break;

               case TXk_PGUP  :                 // redirect to scroll-buf
               case TXk_PGDN  :
               case TXc_UP    :
               case TXc_DOWN  :
               case TXc_PGUP  :
               case TXc_PGDN  :
               case TXc_HOME  :
               case TXc_END   :
               case TXs_UP    :
               case TXs_DOWN  :
               case TXs_LEFT  :
               case TXs_RIGHT :
               case TXs_PGDN  :
               case TXa_PGUP  :
               case TXs_HOME  :
               case TXs_END   :
               case TXa_PGDN  :
               case TXa_COMMA :
               case TXa_DOT   :
               case TXa_LEFT  :
               case TXa_RIGHT :
               case TXk_F7:
               case TXk_F8:
               case TXk_F12:
               case TXa_1:
               case TXa_2:
               case TXa_3:
               case TXa_4:
               case TXc_R:                      // Reverse search (again)
               case TXc_F:                      // Find (again)
               case TXc_N:
                  switch ((ULONG) mp2)          // translate some Ctrl-xxx
                  {                             // to normal UP/DN movement keys
                     case TXs_UP  :
                     case TXc_UP  : key = TXk_UP;      break;
                     case TXs_DOWN:
                     case TXc_DOWN: key = TXk_DOWN;    break;
                     default:       key = (ULONG) mp2; break;
                  }
                  txwSendMsg( dfsa->sbwindow, msg, mp1, (TXWMPARAM) key);
                  break;

               default:
                  rc = dfsStdWindowProc( hwnd, msg, mp1, mp2);
                  break;
            }
            break;

         case TXWM_SETFOCUS:
            if ((BOOL) mp1)                     // Entryfield got focus ?
            {
               txwPostMsg( TXHWND_DESKTOP, TXWM_SETFOOTER, (TXWMPARAM) stattxt, 0); // Fkey help
            }
            else
            {
               txwPostMsg( TXHWND_DESKTOP, TXWM_SETFOOTER, 0, 0); // reset Fkey help
            }
            rc = dfsStdWindowProc( hwnd, msg, mp1, mp2); // default stuff too! (auto insert)
            break;

         default:
            rc = dfsStdWindowProc( hwnd, msg, mp1, mp2);
            break;
      }
   }
   else
   {
      rc = TX_INVALID_HANDLE;
   }
   RETURN( rc);
}                                               // end 'dfsEntryWindowProc'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Check if dialog is wanted and possible, message otherwise
/*****************************************************************************/
BOOL dfsDialogAppropriate
(
   void
)
{
   BOOL                rc = FALSE;              // function return

   ENTER();

   if (dfsa->dialogs)                           // -P switch or option set
   {
      if (desktop)                              // desktop present ?
      {
         rc = TRUE;                             // allow dialog
      }
   }
   BRETURN (rc);
}                                               // end 'dfsDialogAppropriate'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Attach FS-specific pulldown-menu to the main menubar
/*****************************************************************************/
void dfsAttachFsPulldown
(
   void
)
{
   TXS_MENUBAR *dfsmenu = dfsGetMainMenu();

   ENTER();

   if (dfsa->expertui)
   {
      switch (dfsa->FsModeId)
      {
         case DFS_FS_FDISK: dfsmenu->menu[DFS_FS_MENU] = &dfsmd; break;
         case DFS_FS_EXT:   dfsmenu->menu[DFS_FS_MENU] = &dfsme; break;
         case DFS_FS_FAT:   dfsmenu->menu[DFS_FS_MENU] = &dfsmf; break;
         case DFS_FS_HFS:   dfsmenu->menu[DFS_FS_MENU] = &dfsmm; break;
         case DFS_FS_APFS:  dfsmenu->menu[DFS_FS_MENU] = &dfsmp; break;
         case DFS_FS_HPFS:  dfsmenu->menu[DFS_FS_MENU] = &dfsmh; break;
         case DFS_FS_ISO:   dfsmenu->menu[DFS_FS_MENU] = &dfsmi; break;
         case DFS_FS_JFS:   dfsmenu->menu[DFS_FS_MENU] = &dfsmj; break;
         case DFS_FS_NTFS:  dfsmenu->menu[DFS_FS_MENU] = &dfsmn; break;
         case DFS_FS_RSR:   dfsmenu->menu[DFS_FS_MENU] = &dfsmr; break;
         case DFS_FS_XFS:   dfsmenu->menu[DFS_FS_MENU] = &dfsmx; break;
         case DFS_FS_SWAP:  dfsmenu->menu[DFS_FS_MENU] = &dfsms; break;
         case DFS_FS_DUMP:  dfsmenu->menu[DFS_FS_MENU] = &dfsmo; break;
         case DFS_FS_E_FAT: dfsmenu->menu[DFS_FS_MENU] = &dfsmy; break;
         default:           dfsmenu->menu[DFS_FS_MENU] = &dfsma; break;
      }
   }
   else
   {
      switch (dfsa->FsModeId)
      {
         case DFS_FS_FDISK: dfsmenu->menu[DFS_FSBASIC] = &dfsbd; break;
         case DFS_FS_EXT:   dfsmenu->menu[DFS_FSBASIC] = &dfsbe; break;
         case DFS_FS_FAT:   dfsmenu->menu[DFS_FSBASIC] = &dfsbf; break;
         case DFS_FS_HFS:   dfsmenu->menu[DFS_FSBASIC] = &dfsbm; break;
         case DFS_FS_APFS:  dfsmenu->menu[DFS_FSBASIC] = &dfsbp; break;
         case DFS_FS_HPFS:  dfsmenu->menu[DFS_FSBASIC] = &dfsbh; break;
         case DFS_FS_ISO:   dfsmenu->menu[DFS_FSBASIC] = &dfsbi; break;
         case DFS_FS_JFS:   dfsmenu->menu[DFS_FSBASIC] = &dfsbj; break;
         case DFS_FS_NTFS:  dfsmenu->menu[DFS_FSBASIC] = &dfsbn; break;
         case DFS_FS_RSR:   dfsmenu->menu[DFS_FSBASIC] = &dfsbr; break;
         case DFS_FS_XFS:   dfsmenu->menu[DFS_FSBASIC] = &dfsbx; break;
         case DFS_FS_SWAP:  dfsmenu->menu[DFS_FSBASIC] = &dfsbs; break;
         case DFS_FS_DUMP:  dfsmenu->menu[DFS_FSBASIC] = &dfsbo; break;
         case DFS_FS_E_FAT: dfsmenu->menu[DFS_FSBASIC] = &dfsby; break;
         default:           dfsmenu->menu[DFS_FSBASIC] = &dfsba; break;
      }
   }
   VRETURN ();
}                                               // end 'dfsAttachFsPulldown'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Generate PHP menu-documentation for all known submenus
/*****************************************************************************/
static void dfsGeneratePhpMenuDoc
(
   void
)
{
   TXTM                desc;
   TXTM                btni;
   TXTM                pfix;

   ENTER();


   if (TxConfirm( 0, "Generate PHP menu documentation for all submenus ? [Y/N]: "))
   {
      TxPrint( "\n");
      strcpy( desc, expertmenu.appDesc);
      strcpy( btni, expertmenu.btnName);
      strcpy( pfix,  "dfsmenu-expert" );
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm1, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm2, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm3, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm4, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm5, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm7, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsm9, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsma, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmc, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmd, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsme, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmf, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmh, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmi, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmj, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmm, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmn, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmo, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmp, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmr, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsms, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmx, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsmy, NULL, NULL, pfix, 2);

      TxPrint( "\n");
      strcpy( desc, basic_menu.appDesc);
      strcpy( btni, expertmenu.btnName);
      strcpy( pfix,  "dfsmenu-basic"  );
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb1, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb2, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb3, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb4, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb5, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb7, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsb9, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsba, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbc, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbd, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbe, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbf, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbh, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbi, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbj, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbm, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbn, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbo, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbp, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbr, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbs, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsbx, NULL, NULL, pfix, 2);
      txPullDownMenu2Html( DFS_REG_NAME, desc, btni, &dfsby, NULL, NULL, pfix, 2);
   }
   VRETURN ();
}                                               // end 'dfsGeneratePhpMenuDoc'
/*---------------------------------------------------------------------------*/

#if defined (DEV32)
   APIRET16 APIENTRY16 WinSetTitle( PSZ szTitle);
#endif
/*****************************************************************************/
// Set application window title to a string (default is name+version info)
// 20170909 JvW Add code to also set it as the console title, when supported
// 20180610 JvW Moved actual 'set' code to TXLIB, with OS specific stuff
// 20180611 JvW Support 'magic' title contents to restore original title
/*****************************************************************************/
void dfsSetAppWindowTitle
(
   char               *newTitle                 // IN    title, may contain
)                                               //       TX_APPWIN_TRESTORE
{
   TxCopy( app_Title, newTitle, TXMAXLN);       // update our own title too

   TxSetAppWindowTitle( newTitle);              // to terminal/console/window
}                                               // end 'dfsSetAppWindowTitle'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Return pointer to current main-menu (can be BASIC or EXPERT or ...)
/*****************************************************************************/
TXS_MENUBAR *dfsGetMainMenu
(
   void
)
{
   TXS_MENUBAR *dfsmenu = (dfsa->expertui) ? &expertmenu : &basic_menu;

   return dfsmenu;
}                                               // end 'dfsGetMainMenu'
/*---------------------------------------------------------------------------*/


