//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// DFS display and analysis, auxiliary analysis definitions (VRAID)
//
// Author: Vitus Jensen, modifications by J. van Wijk
//
// JvW  12-03-2000 Derived from VRAID include file, made portable
//
/*
 * $Source: R:/source/driver/raid/RCS/dsklayout.h,v $
 * $Revision: 1.8 $
 * $Date: 1999/06/21 02:34:17 $
 * $Locker:  $
 *
 *      Describes layout of administrative disk sectors.
 *
 * $Log: dsklayout.h,v $
 * Revision 1.8  1999/06/21 02:34:17  vitus
 * - corrected my english (spelling)
 *
 * Revision 1.7  1999/05/12 01:38:06  vitus
 * - SEC_VRDEV2: new layout
 * - moved RDFLAGS_* from driver specific header
 *
 * Revision 1.6  1999/01/22 02:54:08  vitus
 * - added VRAIDEVICE2 sectors (preliminary)
 *
 * Revision 1.5  1998/12/22 00:03:10  vitus
 * - added missing "#pragma pack()".  Silly bug.
 *
 * Revision 1.4  1998/06/26 22:11:22  vitus
 * - removed flags from SEC_PHYSDEV
 *
 * Revision 1.3  1998/05/29 01:39:53  vitus
 * - changed definition of STRIPE,CHAIN
 * - SINGLE is now valid type of VRAIDDEVICE sector
 *
 * Revision 1.2  1998/04/08 01:05:01  vitus
 * - changed unnamed to named structures (IBM Compiler)
 * - added size to child definition
 * - removed bitfield usage (probs with different compilers)
 *
 * Revision 1.1  1998/03/10 02:25:09  vitus
 * Initial revision
 * -------------------------------------------
 * This code is Copyright Vitus Jensen 1997-99
 */

#ifndef _DSKSLAYOUT_H
#define _DSKSLAYOUT_H
#pragma pack(1)

/*
 * Relative sectors 1 to n in partition are used for administrative data.
 * May become variable in non-alpha versions...
 */
#define VRAID_ADMINSECTORS      32

/*
 * All devices are marked with an unique ID.
 * This could be build from two byte host ID (sum of BIOS image) and
 * a time stamp (UNIX time = seconds since 1.1.1970) at creation of device.
 */
typedef BYTE            DEVID[6];

/*
 * First configuration sector defines this physical device.  Currently
 * only an ID is defined.
 * Sector type: "PHYSDEVICE      "
 */
typedef struct _SEC_PHYSDEV {
    BYTE        sectype[16];                    /* R: type of sector */
    ULONG       timestamp;                      /* R: when written */
    union {
        char            dummy[490];
        struct {
            DEVID       id;
            USHORT      adminspace;             /* will be VRAID_ADMINSECTORS */
            ULONG       size;                   /* user size [sectors]} */
        } s;
    } u;
    USHORT              crc;                    /* CRC16 */
} SEC_PHYSDEV;


/*
 * Second and all further configuration sectors define
 * the VRDEVICES build upon this disk.
 * Sector type: "VRAIDDEVICE     ":
 */
typedef struct _SEC_VRDEV {
    BYTE        sectype[16];                    /* R: type of sector */
    ULONG       timestamp;                      /* R: when written */
    union {
        char            dummy[490];
        struct {
            DEVID       id;
            BYTE        type;                   /* RDTYPE_* */
            BYTE        flags;                  /* RDFLAG_* */
            USHORT      children;               /* entries in following table */
            struct {
                DEVID   id;
                ULONG   size;                   /* [sectors] */
            } child[1];
        } s;
    } u;
    USHORT              crc;                    /* CRC16 */
} SEC_VRDEV;


/* Sector type: "VRAIDDEVICE2    " */
typedef struct _SEC_VRDEV2 {
    BYTE        sectype[16];                    /* R: type of sector */
    ULONG       timestamp;                      /* R: when written */
    union {
        char            dummy[490];
        struct {
            DEVID       id;
            BYTE        type;                   /* RDTYPE_* */
            BYTE        flags;                  /* RDFLAG_* */
            USHORT      children;               /* entries in following table */
            struct {
                DEVID   id;
                BYTE    flags;                  /* bit 0: valid */
                BYTE    reserved;               /* to be defined */
                ULONG   valid;                  /* valid sector if(flags & 0x01)=0 */
                ULONG   size;                   /* [sectors] */
            } child[1];
        } s;
    } u;
    USHORT              crc;                    /* CRC16 */
} SEC_VRDEV2;

#define RDTYPE_SINGLE   1
#define RDTYPE_CHAIN    2
#define RDTYPE_STRIPE   3
#define RDTYPE_MIRROR   4
#define RDTYPE_RAID4    5
#define RDTYPE_RAID5    6

#define RDFLAG_BUILDING         0x01            /* build or rebuild */
#define RDFLAG_ERROR            0x02            /* array in ERROR state,
                                                   no more I/Os possible */
#define RDFLAG_FAIL             0x04            /* redundancy lost */

#define RDFLAG_HOSTDRIVE        0x80            /* a hostdrive, stop scanning */

#pragma pack()
#endif /* _DSKSLAYOUT_H */
