//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS version and name definitions
//
// Author: J. van Wijk
//
#ifndef    DFSVER_H
   #define DFSVER_H

#define DFS_REG_NAME "DFSee"    // product name used in registration

#define DFS_INTROD   20220907L  // introduction date (oldest 17.x key, even when not used)
#define DFS_EXPIRE        185L  // nr of days from compile until unregistered expiry
#define DFS_COMPILE  __DATE__   // compile date, as base for _EXPIRE
#define DFS_V_EYE   0xDF5ee171  // Eye catcher with DFSee version
#define DFS_VLABEL  "DFSe17.x"  // 8 byte label, used in JFS and FAT format (needs dot!)

#define DFS_BT " "              // Space / Soft beta status; use '.b' in _VN 10.b for popup

#define DFS_VN "17.1"           // Version used in reporting and regkey checks
#define DFS_VD "2025-03-13"     // Added MIT inspired open-source headers to all DFSee sources

//efine DFS_VN "17.0"           // Version used in reporting and regkey checks
//efine DFS_VD "2022-10-25"     // SPEED Fixed usage text display (mangled text)
//efine DFS_VD "2022-10-22"     // VER   Warpstock release build
//efine DFS_VD "2022-09-10"     // LABEL Add REBOOT hint to menu help en LABEL command itself
//efine DFS_VD "2022-09-09"     // MENU  Fix Set Geometry Dialog for 255/255 Radio Button
//efine DFS_VD "2022-09-08"     // MENU  Fix Force Operation mode ExFAT
//efine DFS_VD "2022-09-08"     // DUMP  Minor fix to display DUMPFILE size correctly

//efine DFS_VN "16.10"                  // Version used in reporting and regkey checks
//efine DFS_VD "2021-12-16"     // VER   Check behaviour for 2 digit minor versions numbers

//efine DFS_VN "16.9"                   // Version used in reporting and regkey checks
//efine DFS_VD "2021-10-06"    // PART  Fixed possible crash (string overflow) in certain displays
//efine DFS_VD "2021-10-06"    // RECOVER ExFAT add warning hint when ASSUMING files are contiguous
//efine DFS_VD "2021-04-21"    // D or DOWN: Correctly go to FS-entry sector, even if bootsec empty
//efine DFS_VD "2021-04-10"    // EXPORT/IMPORT sector list, fixed displayed the filename used
//efine DFS_VD "2021-04-09"    // RECOVER/SAVETO/BROWSE streamlined WARNING/ERROR reporting texts
//efine DFS_VD "2021-04-08"    // CMD_WARNING on FileSaveAs alloc fail, is OK, so set timestamps!

//efine DFS_VN "16.8"                   // Version used in reporting and regkey checks
//efine DFS_VD "2021-02-28"    // Added OS2 ArcaOS Type 1 partition to CR help on GPT symbolic types
//efine DFS_VD "2021-02-28"    // Rebuilt with MIT-licensed open source TxLib (no functional change)

//efine DFS_VN "16.7"                   // Version used in reporting and regkey checks
//efine DFS_VD "2020-11-11"   // GPT:   New 'OS2 ArcaOS Type 1' GUID as allowed GPT partition type
//efine DFS_VD "2020-06-22"   // Map:   Avoid <> characters in output to avoid HTML quoting errors
//efine DFS_VD "2020-06-22"   // PART:  Avoid <> characters in output to avoid HTML quoting errors
//efine DFS_VD "2020-06-22"   // EXFAT: Recover: Contiguous file save after FORMAT, FAT-entries 0
//efine DFS_VD "2020-03-28"   // LOG: Fix for sequencenumber substitution to allow both @ and ^
//efine DFS_VD "2020-02-15"   // FORMAT: Added numeric RC value display on a format verify error

//efine DFS_VN "16.6"                   // Version used in reporting and regkey checks
//efine DFS_VD "2020-02-02"   // PALINDROME date release, minor release with just a few bug fixes :)
//efine DFS_VD "2019-12-27"   // GPT:  Fixed crash when using the -name:'newname' option (16.6 beta)
//efine DFS_VD "2019-12-14"   // Disp: Fixed spurious crash when displaying nearly empty bootsectors
//efine DFS_VD "2019-11-06"   // MENU: Create partition: Freespace list correctly display size > 2Tb
//efine DFS_VD "2019-11-06"   // GPT: Fix creation of partitions larger than 2Tb (avoid truncation)

//efine DFS_VN "16.5"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-10-25"   // WARPSTOCK release, no functional change, minor documentation fix
//efine DFS_VD "2019-10-15"   // LIST: Fix display format for decimal numbers over 12 positions
//efine DFS_VD "2019-10-14"   // DOS version: Fix crash (or hang) when selecting the Scripts menu
//efine DFS_VD "2019-10-11"   // JFS CHECK: Fix bogus errors reported on Inode allocation (0x200)

//efine DFS_VN "16.4"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-10-10"   // Official first complete build on the new development macBook PRO
//efine DFS_VD "2019-10-06"   // MENU: Added Mode=Fdisk->Partition Table Operations -> Edit Tables
//efine DFS_VD "2019-10-06"   // STARTABLE: Allow CLEAR of active logical; and FORCE active option
//efine DFS_VD "2019-10-05"   // PART: Fix PartitionSelect build bug if no partitions (macOS SIP)
//efine DFS_VD "2019-08-19"   // IMAGE: Fixed option handling, make sure '-S' always implies '-z'
//efine DFS_VD "2019-08-14"   // PART: Recognize Linux native FS in a GPT Windows-BasicData type
//efine DFS_VD "2019-08-13"   // PART: Update Windows 'administrator required' message for Win-10
//efine DFS_VD "2019-08-12"   // STORE/Confirm: Use InsFS as AUX alias on unformatted type 0x07
//efine DFS_VD "2019-08-11"   // PRESTORE: Fixed restore to a SPECIFIED disknumber, not SAME
//efine DFS_VD "2019-08-10"   // FileDialogs: Removed extra check on returned wildcard/directory
//efine DFS_VD "2019-08-06"   // SCAN: Add extra confirmation, with object-identification (store)

//efine DFS_VN "16.3"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-08-03"   // PUPPY: Fixed disk-number passed to DFSPUPPY for DFSPUP32 stick
//efine DFS_VD "2019-08-01"   // PUPPY: Updated the DFSPUP32 startup scripts (older urxvt used)
//efine DFS_VD "2019-07-31"   // PART: Presence of type 0xEF UEFI-syst does NOT imply GPT style!
//efine DFS_VD "2019-07-30"   // CR: Numbers allow an 0t or 0T prefix to force a decimal value
//efine DFS_VD "2019-07-30"   // FIXEXT: Fixed crash on caused by 64-bit sector number display
//efine DFS_VD "2019-07-29"   // LINUX: Not UPX compressed anymore (corrupt ELF header, may fail)

//efine DFS_VN "16.2"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-07-25"   // IMAGE/CLONE: SMART protect MBR-area full cylinder for bootloader
//efine DFS_VD "2019-07-24"   // MENU: GET DFSPUPPY IMZ and MAKE DFSPUPPY stick text made generic
//efine DFS_VD "2019-07-13"   // CR dlg (GPT/MBR) popup type-list menu on <F10> or mouse button 2
//efine DFS_VD "2019-07-13"   // PTE dialog (GPT) popup type-list menu on <F10> or mouse button 2
//efine DFS_VD "2019-07-12"   // UI: Right mouse button opens (popup) menu when RMBMENU is set ON
//efine DFS_VD "2019-07-12"   // SET: 'RMBMENU on/off' sets RMB to menu-open key <F10> translation
//efine DFS_VD "2019-07-08"   // XFS: Add more field definitions for the superblock, and display
//efine DFS_VD "2019-06-27"   // BROWSE: Add a hint to file RENAME dialog to keep the SAME length
//efine DFS_VD "2019-06-22"   // PART: No display corruption from unprintable characters in labels
//efine DFS_VD "2019-06-22"   // MENU: 'Change partition Type', new hints to FS-conversion in HELP
//efine DFS_VD "2019-06-21"   // GENPART: Create log on current dir; Use explicit -t: / -s: values
//efine DFS_VD "2019-06-21"   // CR/mcs-numbers: Allow hex/oct prefix/postfix on positional params
//efine DFS_VD "2019-06-17"   // HPFS: SaveAs/Recover function uses same generic code as other FS
//efine DFS_VD "2019-06-14"   // BROWSE: Cleaned up the context-popup-menu for single file select
//efine DFS_VD "2019-06-12"   // EXT: Minor updates, add TRACE to find whole-disk area alloc crash
//efine DFS_VD "2019-06-04"   // FAT: New 'FATSYNC' command directly copies one FAT area to other
//efine DFS_VD "2019-06-04"   // FAT: PATH command fixed for specified LFN directory entry numbers
//efine DFS_VD "2019-06-04"   // FAT: Added usage with '-?' for FATSIM, FATWRIM, FINDROOT and PATH
//efine DFS_VD "2019-05-31"   // APFS: Show just file/dirname when Inode not found in BROWSE/Show
//efine DFS_VD "2019-05-31"   // BROWSE: Keep same file/dir selected, on Hide/Show items (<F11>)
//efine DFS_VD "2019-05-30"   // NTFS: Hide or Show $xxx root systemfiles like $MFT in the BROWSER
//efine DFS_VD "2019-05-30"   // BROWSE: Do NOT show HIDDEN (by attribute or .filename) by default
//efine DFS_VD "2019-05-29"   // MENU: Renamed 'Display' heading to 'View' for consistency & space
//efine DFS_VD "2019-05-28"   // REG: Temporary reg keys may allow up to a year of evaluation time

//efine DFS_VN "16.1"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-05-22"   // APFS, NTFS, HFS: Display 'D' (FAT) attr indicator in DIR display
//efine DFS_VD "2019-05-21"   // APFS: COL command searches filename HASH collisions in a volume
//efine DFS_VD "2019-05-21"   // APFS: Added collision detect/resolve on DIRRECORD filename HASH
//efine DFS_VD "2019-05-18"   // HPFS, NTFS, FAT: Consider all DOT filenames as HIDDEN for BROWSE
//efine DFS_VD "2019-05-17"   // MENU: Added 'Fdlgs, show hidden Dirs/Files'    to the 'SET' menu
//efine DFS_VD "2019-05-16"   // APFS: Show name of first volume as LABEL for a disk or partition
//efine DFS_VD "2019-05-16"   // HFS: Exclude (hard)links if no auto-resolve on recursive recover
//efine DFS_VD "2019-05-15"   // ISO:  Hidden attribute  (or  DOT filenames) filtering for BROWSE
//efine DFS_VD "2019-05-15"   // APFS, HFS, EXTn: Hidden files (DOT f-names) filtering for BROWSE
//efine DFS_VD "2019-05-15"   // HPFS, FAT, EFAT, NTFS:  Added hidden/system filtering for BROWSE
//efine DFS_VD "2019-05-14"   // JFS:  Hidden/System attrib (or DOT f-names) filtering for BROWSE
//efine DFS_VD "2019-05-11"   // UI: Automatically re-open same menu on settings/property toggle
//efine DFS_VD "2019-05-11"   // MENU: Moved Settings/Properties from EDIT menu to new 'SET' menu
//efine DFS_VD "2019-05-10"   // HFS: Support DIR-hardlink/Folder-alias, as needed for TimeMachine
//efine DFS_VD "2019-05-09"   // HFS: Menu toggle option 'FolderAlias Auto Resolve'; Init meta-DIR
//efine DFS_VD "2019-05-07"   // BROWSE: <F11> key toggles between SHOW and HIDE 'hidden' items
//efine DFS_VD "2019-05-07"   // BROWSE: Added HELP item for the BROWSE startup Dialog and fields
//efine DFS_VD "2019-05-07"   // BROWSE: Menu item 'Show hidden Directories/Files' in Edit->DFsee
//efine DFS_VD "2019-05-06"   // HFS: Support hardlinks in Browse, Recover and directory display
//efine DFS_VD "2019-05-05"   // HFS: Menu toggle option 'Hardlinks Auto Resolve'; Init meta-DIR
//efine DFS_VD "2019-05-01"   // PUPPY: Download fixed for macOS; Create from download dir; Close
//efine DFS_VD "2019-04-17"   // APFS: Fixed crash in 'Browse' when selecting empty subdirectory

//efine DFS_VN "16.0"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-04-16"   // APFS: Recovery of a symlink will create a file with the linkname
//efine DFS_VD "2019-04-16"   // APFS: APFS filesystem in a type 0x73 MBR partition is recognized
//efine DFS_VD "2019-04-15"   // APFS: FOLDER command; Auto folder-display on select from snlist
//efine DFS_VD "2019-04-12"   // APFS: FileSaveAs (recovery) implemented for std file data-stream
//efine DFS_VD "2019-04-11"   // APFS: Display log-Address (offset) for FILE_EXTENT fs records
//efine DFS_VD "2019-04-09"   // APFS: Browse functionality implemented for directory-tree browse
//efine DFS_VD "2019-04-07"   // LIST: -f option improved display for non-file records in the list
//efine DFS_VD "2019-04-06"   // BSFIND: Force sector 0 (MBR/Boot) to be 'found' and always listed
//efine DFS_VD "2019-04-06"   // RESTORE: Fixed crash on restore IMZ file smaller than 1024 bytes
//efine DFS_VD "2019-04-05"   // APFS: FINDPATH or '\path' commands will display file information
//efine DFS_VD "2019-04-05"   // APFS: LEAVES/DUMP commands support Inode name wildcard selection
//efine DFS_VD "2019-04-01"   // APFS: Xfield display in FS BtreeNodes, for filesize and filename
//efine DFS_VD "2019-03-30"   // APFS: BtreeNode display: allow -r, -p and -name select with -raw
//efine DFS_VD "2019-03-30"   // OPTIONS: verbosity -q and -v changed to the generic -O:s|q|n|v|m
//efine DFS_VD "2019-03-29"   // APFS: SUBTYPE command shows Btree RECORD types too (DUMP/LEAVES)
//efine DFS_VD "2019-03-27"   // APFS: LEAF command determines fist/next leaf-node ID in a tree
//efine DFS_VD "2019-03-26"   // APFS: LEAVES command displays tree-contents (faster than dump!)
//efine DFS_VD "2019-03-24"   // APFS: DUMP command fine-tuned for a display width of 120 columns
//efine DFS_VD "2019-03-23"   // MENU: Mode=APFS 'DUMP all FS-tree records' and show DIR NameHash
//efine DFS_VD "2019-03-19"   // MENU: Mode=APFS added SpaceManager display and two DUMP variants
//efine DFS_VD "2019-03-19"   // GPT: Use GPT-style on a HYBRID-GPT/MBR with Auto-GPT set to ON
//efine DFS_VD "2019-03-18"   // APFS: DUMP command enhanced with -name:wildcard select DIR/XATRR
//efine DFS_VD "2019-03-18"   // MENU: Mode=Fdisk -> RESTORE partition info: Select disknr or SAME
//efine DFS_VD "2019-03-17"   // GENPART: Default to sector-based size/position; add description
//efine DFS_VD "2019-03-17"   // GENPART: Create correct commands for GPT partitioned disks too
//efine DFS_VD "2019-03-15"   // HEXED: Do NOT go to END of output, popup at current scroll-pos
//efine DFS_VD "2019-03-13"   // APFS: DUMP and Tree/Node display, FS-Tree details and filtering
//efine DFS_VD "2019-03-11"   // OEM: Exclude PM-morping and Clipboard code from the OEM versions
//efine DFS_VD "2019-03-09"   // IMZ: Fix XMZ indexfile creation for truncated/partial IMZ files
//efine DFS_VD "2019-03-09"   // IMZ: for a partitioned-disk IMZ, prompt for partition to browse
//efine DFS_VD "2019-03-08"   // ATTACH: Option -i, Use a better geometry for attached IMZ image
//efine DFS_VD "2019-03-08"   // APFS: ALLOC command to display FS usage (main and fusion tier2)
//efine DFS_VD "2019-03-05"   // APFS: Create bitmap caches for main and (fusion) tier2 devices
//efine DFS_VD "2019-03-04"   // IMAGE/RESTORE: Fix incorrect default size when using -P (dialog)
//efine DFS_VD "2019-03-03"   // OUTPUT: Fixed scroll bug when not at end of scroll buffer(PgUp)
//efine DFS_VD "2019-03-02"   // STARTUP switch -H- for decimal sector/type values, default HEX!
//efine DFS_VD "2019-03-01"   // MENU: New item 'Mode=APFS -> Display SpaceManager info' added
//efine DFS_VD "2019-02-26"   // MENU: Edit 'LVM Info' and 'Partition Tables' use direct submenu
//efine DFS_VD "2019-02-25"   // MENU: Mode=APFS: Select Volume and Refresh Checkpoint added
//efine DFS_VD "2019-02-24"   // APFS: Create a Volume selection list for 'vi' command and menu
//efine DFS_VD "2019-02-24"   // APFS: Support -q and -v verbosity on Init and superblock display
//efine DFS_VD "2019-02-23"   // APFS: VIRT command translates virtual object-ID/Xid to block-nr
//efine DFS_VD "2019-02-20"   // APFS: Display Node fixed-size contents, or var-size offs/length
//efine DFS_VD "2019-02-19"   // APFS: DUMP command enhanced with -x:transactionId filter value
//efine DFS_VD "2019-02-16"   // APFS: New CP command refreshes to latest or given checkpoint
//efine DFS_VD "2019-02-13"   // Display sector: Add 'Block:0x....' to end of identifying line
//efine DFS_VD "2019-02-11"   // DISKLIST: Execute 'media -update' before display of the list
//efine DFS_VD "2019-02-10"   // APFS: Version2/3 updates based on Apple File System Reference
//efine DFS_VD "2019-02-09"   // ISO: Add display of 'path to root' for directory block displays
//efine DFS_VD "2019-02-08"   // ISO: SAVETO command including file copy and recover from BROWSE
//efine DFS_VD "2019-02-07"   // JFS: DIRTY command 'query' parameter sets RC to FS status value
//efine DFS_VD "2019-02-07"   // JFS: DIRTY cmd Improved cmd help, and superblock 'dirty' display
//efine DFS_VD "2019-02-04"   // Windows: Fix dsk identification strings with disk number gaps
//efine DFS_VD "2019-02-04"   // Windows: Attach all physical disks, allowing disk number gaps
//efine DFS_VD "2019-02-04"   // ISO: BROWSE initial list building and navigation implemented
//efine DFS_VD "2019-02-01"   // ISO: FINDPATH or '\some\path\to\file' resolves file information
//efine DFS_VD "2019-01-29"   // ISO: Supply file-info to support 'list -f' and Browse Display
//efine DFS_VD "2019-01-28"   // ISO: Display DIR including Joliet LFN and Rock Rige Posix info
//efine DFS_VD "2019-01-25"   // ISO: Display El Torito (bootable CD) hdr info, link to boot img
//efine DFS_VD "2019-01-19"   // ISO: Display and navigation of directory blocks implemented
//efine DFS_VD "2019-01-19"   // MENU: Mode=ISO -> Select Volume Descriptor (UPCASE,Joliet,Boot)
//efine DFS_VD "2019-01-15"   // MENU: Added Mode=ISO; Initial ISO recognitiond program updates

//efine DFS_VN "15.6"                   // Version used in reporting and regkey checks
//efine DFS_VD "2019-01-09"   // HELP: Updated menu help for PUPPY download and program updates
//efine DFS_VD "2019-01-01"   // DFSGETUP/DFSGETPY script, test/prompt for writable DL directory
//efine DFS_VD "2018-12-27"   // MEDIA/DISKLIST: Use DosSysCtl for config sys info (QSInit-OS/4)
//efine DFS_VD "2018-12-26"   // CONFIGSYS: Show hexdump of config.sys info (OS/2 specific ?)
//efine DFS_VD "2018-12-25"   // MEDIA/DISKLIST: Fix AHCI detection on config.sys syntax variant
//efine DFS_VD "2018-12-24"   // IMAGE DLG: Default single/multi file based on target-FS (LINUX)

//efine DFS_VN "15.5"                   // Version used in reporting and regkey checks
//efine DFS_VD "2018-12-22"   // IMAGE DLG: Auto default for single/multi file based on target-FS
//efine DFS_VD "2018-12-19"   // MEDIA/DISKLIST: Correct Disk-ID string for QSinit PAE RAM-disks
//efine DFS_VD "2018-12-16"   // DISKLIST: Output format now 2 lines, 2nd is indented description
//efine DFS_VD "2018-12-16"   // STARTUP: switch -profile- disables execution of standard profile
//efine DFS_VD "2018-12-16"   // STARTUP: switch -profile:name executes specific profile script
//efine DFS_VD "2018-12-15"   // MEDIA/DISKLIST: Fix Disk-ID string for USB/SCSI multi-partition
//efine DFS_VD "2018-12-15"   // MEDIA: Fixed OS2AHCI$ disk parsing when error-lines are present
//efine DFS_VD "2018-12-13"   // DISKLIST: Added 'diskid/media' disk identification in the list
//efine DFS_VD "2018-12-13"   // MENU: 'Display->Disk information list' executes a DISKLIST cmd
//efine DFS_VD "2018-12-13"   // MENU: 'File->Device..->Display OS ..' OS2AHCI$/IBMS506$ on OS/2
//efine DFS_VD "2018-12-13"   // OS2: Show disk-id string on IDE  DANIS506.ADD  (media/disklist)
//efine DFS_VD "2018-12-12"   // OS2: Show disk-id string on SATA OS2AHCI.ADD   (media/disklist)
//efine DFS_VD "2018-12-10"   // OS2: Show disk-id string on USB  USBMSD.ADD    (media/disklist)
//efine DFS_VD "2018-12-05"   // PRESTORE: Fixed parsing a .PDx disk-number (was broken in 15.4)
//efine DFS_VD "2018-11-28"   // STARTUP: switch -logdate sets logfilename auto DATE postfix ON
//efine DFS_VD "2018-11-28"   // MENU: Edit ->Settings/Properties, DFSee ->Auto log DATE postfix
//efine DFS_VD "2018-11-28"   // SET: 'LOG DATE' sets LOG auto DATE postfix on   (or OFF or NUM)
//efine DFS_VD "2018-11-26"   // DISK SelLists: Show disk ID in description (Linux/Windows/OS2)
//efine DFS_VD "2018-11-23"   // DISKID: Show disk ID like Model/SerialNr   (Linux/Windows only)
//efine DFS_VD "2018-11-19"   // ALLOC: Better progress text: 'Get ALLOCATION info, at Sector:'
//efine DFS_VD "2018-11-19"   // MENU: Partition open/select items explicitly add the -a option
//efine DFS_VD "2018-11-19"   // PART: Do NOT show FS allocation unless '-a' option (saves time)
//efine DFS_VD "2018-11-19"   // CR: Updated help (cr -?) with examples for 'mcs-number' syntax
//efine DFS_VD "2018-11-12"   // PROGRESS: Make sure values up to 99.99% are rounded DOWN not up
//efine DFS_VD "2018-11-11"   // MENU: DOS VERSION, add 'download updates' DISABLED, with reason
//efine DFS_VD "2018-11-08"   // MENU: Add REASON to message about disabled freespace areas (CR)
//efine DFS_VD "2018-11-06"   // EXTn: Avoid segmentation violation when no superblock present

//efine DFS_VN "15.4"                   // Version used in reporting and regkey checks
//efine DFS_VD "2018-10-28"   // MENU->SCRIPTS: Extra separator between bootable and data sticks
//efine DFS_VD "2018-10-26"   // MENU->SCRIPTS: Add 'Fast Analyse disks (support)' DFSFAST script
//efine DFS_VD "2018-10-26"   // DFSFAST: Faster variant of DFSDISK, for EXISTING disk partitions
//efine DFS_VD "2018-10-21"   // DISKSERIAL: Display disk serialnumber info (LINUX IDE/SATA only)
//efine DFS_VD "2018-10-19"   // MENU->SCRIPTS: Add create 64-bit/UEFI Xenialpup64 DFSPUPPY stick
//efine DFS_VD "2018-10-18"   // MENU->HELP: Added download of the 64-bit/UEFI DFSPUP64.IMZ image
//efine DFS_VD "2018-10-16"   // LINUX: List NVME disks before IDE/SATA/SCSI  (probable SSD boot)
//efine DFS_VD "2018-10-16"   // LINKS in rgkey/help explicit .php (resolve in xenial64 terminal)
//efine DFS_VD "2018-10-05"   // MENU->HELP: Item 'Sector Types' help now uses a popup text view
//efine DFS_VD "2018-10-03"   // MENU->HELP: Added submenu for TXScript for syntax, variables etc
//efine DFS_VD "2018-10-03"   // MENU->HELP: Added User-Interface submenu for keyboard, mouse etc
//efine DFS_VD "2018-10-03"   // MENU->HELP: Added help item to document generic command options
//efine DFS_VD "2018-10-02"   // STARTUP: switch -l- is now default, use -l to get logfile dialog
//efine DFS_VD "2018-09-28"   // MENU->HELP: Added GPT symbolic names to the partition-type help
//efine DFS_VD "2018-09-25"   // MENU->HELP: Added separate item for UI-library standard commands
//efine DFS_VD "2018-09-25"   // MENU->HELP: Added separate item for UI-library startup switches
//efine DFS_VD "2018-09-23"   // STARTUP:  Only report INT13 disk limits in pedantic mode (-p:2)
//efine DFS_VD "2018-09-22"   // PRESTORE: Optimized TAB order in selection dialog, from the menu
//efine DFS_VD "2018-09-21"   // PRESTORE: Fixed restore MBR of a GPT disk, using verbose display
//efine DFS_VD "2018-09-18"   // ABOUT: Updated 64-bit macOS compiler version to 10.0.0 (Mojave)
//efine DFS_VD "2018-09-17"   // IMZ: Browse FIRST partition when IMZ is for a partitioned disk
//efine DFS_VD "2018-09-17"   // IMZ: Correctly used specified directory in file-open dialog
//efine DFS_VD "2018-09-17"   // IMZ/VDI: Avoid 'switch to FDISK' popup on the 'attach' command
//efine DFS_VD "2018-09-17"   // STORE: Show filename in one-liner for image files (window-title)
//efine DFS_VD "2018-09-14"   // ABOUT: Fixed duplicate 'Current user' line when using -P- option

//efine DFS_VN "15.3"                   // Version used in reporting and regkey checks
//efine DFS_VD "2018-09-06"   // BROWSE dlg: Fixed bug with 'Reduce list to ...' for FAT/EXTn/HFS
//efine DFS_VD "2018-09-06"   // PART: Reworded WARNING: Partition type 0x35 with missing LVM-BBR
//efine DFS_VD "2018-09-05"   // PART: Recognize Linux 'LUKS' encrypted MBR partition type 0xe8
//efine DFS_VD "2018-09-05"   // PART: Added new undefined/ignored/temporary/backup MBR type 0xd7
//efine DFS_VD "2018-09-05"   // PART: No warnings for MBR-part types 0xd7 and 0xdf (temp/backup)
//efine DFS_VD "2018-09-05"   // PART: Removed warnings for partitions beyond int13 cyl-1023 limit
//efine DFS_VD "2018-09-05"   // PART: Classified all CHS-related warnings as MINOR (use part -w)
//efine DFS_VD "2018-09-02"   // MENU: Grayed several menu-items when no (proper) object opened
//efine DFS_VD "2018-09-02"   // SET MENU: Style: Autodrop, NoDrop or Delayed-drop and Right-Move
//efine DFS_VD "2018-09-01"   // Startup -M:n switch: added value 4 for delayed drop-down style
//efine DFS_VD "2018-08-31"   // MENU: Changed menu activation to use delayed-auto-drop by default
//efine DFS_VD "2018-08-31"   // RESIZE:  Disable resize menu-items for non-supported filesystems
//efine DFS_VD "2018-08-24"   // RESTORE: Open destination RAW image (-I:fname) as R/W (RAW2IMZ)
//efine DFS_VD "2018-08-23"   // CR GPT Dialog: Added 'srv' 'dmcrypt' and 'luks' to gpt-type list
//efine DFS_VD "2018-08-23"   // CR GPT: New 'home', 'srv', 'root32', 'root64', 'dmcrypt', 'luks'
//efine DFS_VD "2018-08-23"   // CR GPT: Added 'raid', '0xfd' and 'fd00' as valid symbolic types
//efine DFS_VD "2018-08-21"   // BROWSE: 'Specify custom file filtering' CHECKED (ON) by default
//efine DFS_VD "2018-08-20"   // FAT: Recover: Contiguous file save after FORMAT, FAT-entries 0
//efine DFS_VD "2018-08-20"   // FATWRIM: made FAT-2 the default to write to, better usage info
//efine DFS_VD "2018-08-19"   // PART/VOL: Write pending (FAT etc) changes before open new object
//efine DFS_VD "2018-08-19"   // FATSET: Manually set a FAT-allocation chain for contiguous range
//efine DFS_VD "2018-08-19"   // FAT:  Allow DIR display from list .NNN, even when FAT says 'free'
//efine DFS_VD "2018-08-18"   // MENU, File, add the 'Change Current Directory' to BASIC mode too
//efine DFS_VD "2018-08-18"   // EDIT -dir: Maintain and use persistent 'last-used-directory-path'
//efine DFS_VD "2018-08-14"   // EFAT: Fixed incorrect 'invalid cluster value' errors on CHECK/SLT
//efine DFS_VD "2018-08-14"   // LIST/SLT: Made the 'info' value 16 bits; display as 4 hex digits
//efine DFS_VD "2018-08-14"   // BROWSE: Include empty files in default selection filter (size 0)
//efine DFS_VD "2018-08-14"   // RECOVER: Fix recover fail from Browse (after 'mod AFTER' change)
//efine DFS_VD "2018-08-13"   // PART: Supress 'No ACTIVE partition' warning if AirBoot is present
//efine DFS_VD "2018-08-12"   // Startup: Show status-prompt when using non-default start command
//efine DFS_VD "2018-08-12"   // IM:   -RAW option forces RAW mode, no decompress/index .IMZ/.VDI
//efine DFS_VD "2018-08-12"   // EDIT:  Explicit -A- to disallow append/delete from (binary) file
//efine DFS_VD "2018-08-12"   // EDIT filename: Allow access to last (partial) sector correctly
//efine DFS_VD "2018-08-12"   // EDIT filename: Force binary mode on opened image using 'im -RAW'
//efine DFS_VD "2018-08-11"   // BROWSE filter: Enhanced selection-dialog with modified AFTER date
//efine DFS_VD "2018-08-11"   // LIST/RECOVER:  Enhanced selection-dialog with modified AFTER date
//efine DFS_VD "2018-08-08"   // EFAT:  Use Dir-entry cache to avoid incorrect size of directories
//efine DFS_VD "2018-08-05"   // EFAT:  Fixed crash with '\path-to-file' file/dir locator command
//efine DFS_VD "2018-08-05"   // FAT:   Added usage hint 't -D' to display deleted DIR entries too
//efine DFS_VD "2018-08-04"   // HEXED: Improved screen-draw performance and cursor visibility

//efine DFS_VN "15.2"                            // Version used in reporting and regkey checks
//efine DFS_VD "2018-07-30"   // MBR: Include version and language for detected Airboot bootmanager
//efine DFS_VD "2018-07-28"   // GPT: 'pid -name:newname' will change the name of a GPT partition
//efine DFS_VD "2018-07-27"   // Updated usage and DOCS on sigint and negated switches like -P-
//efine DFS_VD "2018-07-22"   // Filenames in commands, allow either '/' or '\' path separators
//efine DFS_VD "2018-07-22"   // HEXED, DISASM: Fixed DISTORM bugs when compiled for 64-bit (macOS)
//efine DFS_VD "2018-07-18"   // HEXED, DISASM: Mouse doubleclick will 'jump' to that instruction
//efine DFS_VD "2018-07-18"   // HEXED, DISASM: Use temporary mouse-drag MARK for clipboard copy
//efine DFS_VD "2018-07-17"   // HEXED, DISASM: Highlight current instruction code bytes at top
//efine DFS_VD "2018-07-02"   // Switch -lvmsize forces use of LVM disk size + related warnings
//efine DFS_VD "2018-07-01"   // CV: Fixed layout of the usage help text, added d == <ENTER>
//efine DFS_VD "2018-06-30"   // MsgBox: More descriptive titles on message boxes, and 'about'
//efine DFS_VD "2018-06-28"   // CV: Copy selected value to the clipboard as a (Hex) string
//efine DFS_VD "2018-06-22"   // macOS: Recognize APFS FS in FileSystemOnly (synthesized) disks
//efine DFS_VD "2018-06-22"   // macOS: Probe /dev/rdiskN devices on startup, to see more disks
//efine DFS_VD "2018-06-15"   // macOS: Menu item: 'Show SIP status' (Invisible macOS boot disk)
//efine DFS_VD "2018-06-15"   // NTFS: Menu item: 'Find MFT location, for Fix' doing a FINDMFT
//efine DFS_VD "2018-06-14"   // NTFS: FIXBOOT (non-spare) correct cluster size for FS < 2 GiB
//efine DFS_VD "2018-06-14"   // NTFS: FINDMFT command to locate the MFT area (for fixboot)
//efine DFS_VD "2018-06-14"   // FIND: Automatic dup $ to $$ to avoid (empty) var subst (like $MFT)
//efine DFS_VD "2018-06-13"   // Bootsector: Removed (usualy incorrect) BeFS bootcode detection
//efine DFS_VD "2018-06-13"   // HFS: Better HFS superblock detection (avoid BSFIND false positives)
//efine DFS_VD "2018-06-13"   // macOS:  Changed 'Display OS device/disk info' to show ALL disks
//efine DFS_VD "2018-06-13"   // BSFIND: Changed '-f' start position default mcn-unit to sectors
//efine DFS_VD "2018-06-10"   // macOS/Win/Linux: Update OS terminal/window title on program exit
//efine DFS_VD "2018-06-10"   // macOS startup: 'su'/'disable SIP' hint on inaccessible bootdisk
//efine DFS_VD "2018-06-10"   // PART: Avoid 'no active partition' warning on APM style 1st disk

//efine DFS_VN "15.1"                            // Version used in reporting and regkey checks
//efine DFS_VD "2018-06-08"   // PART: Avoid boot-driveletter warnings on non-OS/2 bootable JFS
//efine DFS_VD "2018-06-07"   // ABOUT: Show the DFSee version info itself with '-c- (for logging)
//efine DFS_VD "2018-06-06"   // HFS: Implemented FileSaveAs() for file recovery functionality
//efine DFS_VD "2018-06-06"   // JFS: Get Part-size from Part-tables when BR is not JFS specific
//efine DFS_VD "2018-06-04"   // JFS: Recognize Linux JFS in type 0x07 with GRUB-like bootrecord
//efine DFS_VD "2018-05-29"   // Mode=FDISK DELETE: added some trace to debug a crash situation
//efine DFS_VD "2018-05-27"   // HELP/TXT: macOS 'wget' install hints; update DFSee URL to https
//efine DFS_VD "2018-05-26"   // ABOUT: TERM info and (sudo) user for Linux/macOS os extra line
//efine DFS_VD "2018-05-23"   // Additional version info for macOS and Windows 10 build variants
//efine DFS_VD "2018-05-14"   // 64bit verification version; Delivery/setup of macOS DFSee.app
//efine DFS_VD "2018-04-30"   // Printf: Corrected many format strings for 32/64 bit compatibility
//efine DFS_VD "2018-04-27"   // REG/IMZ: Fixed compression handle-type for 64-bit environments
//efine DFS_VD "2018-04-20"   // CR: New type 0xAF for creating macOS HFS+ style partitions on MBR
//efine DFS_VD "2018-04-09"   // HFS: SYMLINK display in 'list -f', Browse and Node/Dir displays
//efine DFS_VD "2018-04-05"   // GPT/MBR-type-07: Recognize Bitlocker encryption in a fake FAT32
//efine DFS_VD "2018-04-05"   // HFS: Implement FsMakeBrowseList() as required by the Browse dialog
//efine DFS_VD "2018-03-31"   // HFS: Implement FsFindPath() as required by 'findpath' and Browse
//efine DFS_VD "2018-03-30"   // HFS: Implement FsFileInfo() as required by 'list -f'  and Browse
//efine DFS_VD "2018-03-29"   // HFS: Resolve full-path for CnID or Catalog-node lsn+index combo
//efine DFS_VD "2018-03-29"   // HFS: CATS expanded to allow search Thread-records (no name) too
//efine DFS_VD "2018-03-28"   // HFS: Build parent-CnID and (folder) name cache for all CnID values
//efine DFS_VD "2018-03-27"   // HFS: CATS command searches Catalog for parent/name combinations
//efine DFS_VD "2018-03-26"   // HFS: FOLDER command much faster by using B-tree, not linear search
//efine DFS_VD "2018-03-24"   // HFS: Show 'Hlnk' hard-link and 'Fdrp' Finder-Alias in Leaf-nodes

//efine DFS_VN "15.0"                            // Version used in reporting and regkey checks
//efine DFS_VD "2018-03-23"   // SETT: Trap on changing a partition type (and some other commands)
//efine DFS_VD "2018-03-22"   // MENU: Mode=HFS, add Display Catalog info submenu, directory view
//efine DFS_VD "2018-03-20"   // MENU: Mode=HFS, add Volume-info submenu with Edit/Display Label
//efine DFS_VD "2018-03-20"   // HFS: LABEL command to set new Volume label, up to 255 characters
//efine DFS_VD "2018-03-18"   // PART: Fix devide-by-zero crash on a GRUB boot partition type 0x06
//efine DFS_VD "2018-03-16"   // HFS: FOLDER command to display Catalog contents (DFSee DIR format)
//efine DFS_VD "2018-03-14"   // HFS: NODE command to display Catalog header, index and leaf nodes
//efine DFS_VD "2018-03-11"   // HFS: Formatted display of catalog-file header, leaf and map nodes
//efine DFS_VD "2018-03-10"   // HFS: Display some catalog-file details at filesystem open/init
//efine DFS_VD "2018-03-08"   // MAP: Include the Volume LABEL line in the standard MAP layout
//efine DFS_VD "2018-03-08"   // HFS: Supply label value from catalog-file for table/map display
//efine DFS_VD "2018-03-06"   // MENU: In most Mode=xxFS: new submenu "Set Volume info/status"
//efine DFS_VD "2018-03-06"   // MENU: submenu items: Volume label, Serial-nr, UUID, dirty/clean
//efine DFS_VD "2018-03-05"   // MENU: LABEL edit for HPFS,NTFS,JFS,FAT,EFAT,EXTn,XFS,ReiserFS
//efine DFS_VD "2018-03-04"   // XFS, ReiserFS: Supply label value and UUID for table/map display
//efine DFS_VD "2018-03-04"   // XFS: Display most of the superblock contents, including Inode-use
//efine DFS_VD "2018-03-04"   // LABEL: ReiserFS cmd to display/edit the 16-character volume label
//efine DFS_VD "2018-03-04"   // LABEL: XFS  command to display/edit the 16-character volume label
//efine DFS_VD "2018-03-03"   // LABEL: NTFS command to display/edit the 32-character volume label
//efine DFS_VD "2018-03-02"   // EFAT: Speedup SLT/Parent-cache build, specially on large clusters
//efine DFS_VD "2018-03-02"   // EFAT: Build Parent-cache before Browse, <Esc> aborts building it
//efine DFS_VD "2018-03-02"   // LABEL: EFAT command to display/edit the 11-character volume label
//efine DFS_VD "2018-03-02"   // LABEL: FAT  command to display/edit the 11-character volume label
//efine DFS_VD "2018-03-01"   // LABEL: EXTn command to display/edit the 16-character volume label
//efine DFS_VD "2018-03-01"   // LABEL: JFS  command to display/edit the 11 / 16 char volume label
//efine DFS_VD "2018-02-28"   // LABEL: HPFS command to display/edit the 11-character volume label
//efine DFS_VD "2018-02-26"   // BROWSE: No confirmation-popup but printed message on file recover
//efine DFS_VD "2018-02-24"   // EXT RECOVER/BROWSE: Better path+filename retrieval on damaged FS
//efine DFS_VD "2018-02-23"   // JFS RECOVER/BROWSE: Better path+filename retrieval on damaged FS
//efine DFS_VD "2018-02-20"   // SCAN -w: Windows/macOS: Message possibly LOCKED partition on write
//efine DFS_VD "2018-02-20"   // BROWSE: REDUCE list fixed for mix of Dir/File selected (sorting)
//efine DFS_VD "2018-02-20"   // BROWSE: <F6> restores original list from starup of the browser
//efine DFS_VD "2018-02-18"   // RECOVER: Recurse into subdirectory fix for FAT and EXT filesystems
//efine DFS_VD "2018-02-13"   // DFSDOS: Reduced minimal buffer memory from 50Mb to less than 5Mb
//efine DFS_VD "2018-02-12"   // BROWSE: Fix stack corruption on recovering directories or files
//efine DFS_VD "2018-02-12"   // BROWSE: Automatic minimize (<F12>) on display  of item metadata
//efine DFS_VD "2018-02-12"   // BROWSE: Automatic minimize (<F12>) on recovery of any dir/file
//efine DFS_VD "2018-02-12"   // Find normal files DLG: Do NOT allow path-separator or wildcards!
//efine DFS_VD "2018-02-11"   // FORMAT: Select correct clustersize for non-std BPS like 4096
//efine DFS_VD "2018-02-11"   // ATTACH/VIRT: Use correct geometry/BPS for MEMDISK MiB/TiB sizes
//efine DFS_VD "2018-02-10"   // APFS: Vol-superblock display with formatted date/time incl nsec
//efine DFS_VD "2018-02-07"   // APFS: New DUMP command displays recognized blocks in filesystem
//efine DFS_VD "2018-02-06"   // JFS: No endian-swapping of first 8-bytes in UUID edit and display
//efine DFS_VD "2018-02-05"   // JFS: Specific linux UUID and Volumename displayed with superblock
//efine DFS_VD "2018-02-04"   // LVM: Updated startup warning LVM IGNORED for missing primary info
//efine DFS_VD "2018-02-02"   // SCRIPTS: USB-stick creation, show disklist and less verbose
//efine DFS_VD "2018-02-02"   // SCRIPTS: Menu, start USB-stick creation scripts quieter (-Q)
//efine DFS_VD "2018-01-30"   // REG:  Recognize designated evaluation keys (like PUPPY ones)
//efine DFS_VD "2018-01-29"   // APFS: BL/CL command to translate between blocks and sectors
//efine DFS_VD "2018-01-29"   // APFS: Display all known APFS block types, incl checksum verify
//efine DFS_VD "2018-01-28"   // APFS: Display container superblock with most relevant values
//efine DFS_VD "2018-01-27"   // LIST/RECOVER/BROWSE: Set default minimum filesize to 0 (all files)
//efine DFS_VD "2018-01-27"   // BROWSE: <F4> toggles 'Percentage display' versus 'Fast' list build
//efine DFS_VD "2018-01-26"   // RECOVER: 'Recurse into subdirectories' OFF when not a single DIR
//efine DFS_VD "2018-01-26"   // BROWSE/SAVETO: 'Recurse into subdirectories' option, default is ON
//efine DFS_VD "2018-01-26"   // File recovery: 'Recurse' option recovers directory contents too
//efine DFS_VD "2018-01-26"   // JFS FILEFIND/DELFIND: Continue after (CRC) errors when -E:i used
//efine DFS_VD "2018-01-24"   // APFS: Added Mode=APFS with minimal function (superblock display)
//efine DFS_VD "2018-01-23"   // GPT: Add 'APFS Container' GUID with matching type 0x73 MBR-alias
//efine DFS_VD "2018-01-21"   // MENU and TO/FROM partition lists: Use LVM/GPT name if no FS-label
//efine DFS_VD "2018-01-16"   // PART/LVM: Ignore read errors on BBR, continue with next partition
//efine DFS_VD "2018-01-13"   // RESTORE/IMAGE: -q option reduces screen output to progress only
//efine DFS_VD "2018-01-10"   // RESTORE: No 'It may be required to BOOT' message in OEM engine
//efine DFS_VD "2018-01-10"   // DISKLIST: Show size of displayed disk in GiB units for readability
//efine DFS_VD "2018-01-09"   // SCRIPT: Added $_d_unixdev[DSK] variable to retrieve disk device

//efine DFS_VN "14.12"                           // Version used in reporting and regkey checks
//efine DFS_VD "2018-02-15"   // BROWSE: Fix stack corruption on recovering directories or files

//efine DFS_VN "14.11"                           // Version used in reporting and regkey checks
//efine DFS_VD "2018-01-1 "   // CR: -N option creates an EMPTY MBR when needed (No code, zeroed)
//efine DFS_VD "2018-01-1 "   // MBR2GPT/GPT2MBR: -N option creates an EMPTY MBR, No code
//efine DFS_VD "2017-12-31"   // Menu: Clone -> Disk, BAD-SECTORS' -skipbads / Area-Retry script
//efine DFS_VD "2017-12-31"   // PART: Reverted Bad-sector retry/handling at start (much too slow)
//efine DFS_VD "2017-12-30"   // CLONE: Generate 'retry-bad-areas' script on disk-2-disk -skipbads
//efine DFS_VD "2017-12-29"   // LINUX: Initialize disk-name to device/model info, when available
//efine DFS_VD "2017-12-29"   // LINUX: Detect and report 'Removable' property for disk devices
//efine DFS_VD "2017-12-28"   // DISKLIST: List available disk numbers plus info on screen/stdout
//efine DFS_VD "2017-12-26"   // RECOVER: Add 'Recover x from y' file count in status progress info
//efine DFS_VD "2017-12-23"   // GPT: Reworded warning when GPT tables present without an MBR guard
//efine DFS_VD "2017-12-21"   // MBR2GPT/GPT2MBR: Correctly select disknumber specified as param
//efine DFS_VD "2017-12-20"   // RECOVER/SAVETO: -A- option skips allocation check (will be faster)
//efine DFS_VD "2017-12-17"   // CLONE: Correct area-start in arealist when using -skipbads option
//efine DFS_VD "2017-12-17"   // CR: GPT EFI (ESP) default to 128 MiB only when NO size specified
//efine DFS_VD "2017-12-17"   // CR/SETTYPE: Support 2 or 4 digit HEX value for GPT types, like EF
//efine DFS_VD "2017-12-17"   // CLONE: auto display bad-sector areas skipped when using -skipbads
//efine DFS_VD "2017-12-17"   // PART: Bad-sector retry/handling at start of disk, "BAD" disk style
//efine DFS_VD "2017-12-15"   // CLONE/IMAGE/RESTORE etc; better alignment of read/write error msg
//efine DFS_VD "2017-11-25"   // IMAGE/RESTORE dialogs, layout + more verbose text for readability
//efine DFS_VD "2017-11-24"   // PARTITION select lists, add disk-number for better identification
//efine DFS_VD "2017-11-23"   // BROWSE/NTFS: Correct path in description line for multi hard-link
//efine DFS_VD "2017-11-22"   // ALLOC: Status msg when checking allocation on huge files > 128 MiB
//efine DFS_VD "2017-11-22"   // BROWSE: In recovery mode, show all files (min size/percentage 0)
//efine DFS_VD "2017-11-21"   // BROWSE: <F4> to toggle recovery-mode; speed-up for all filesystems
//efine DFS_VD "2017-11-19"   // BROWSE: Speed up display (on huge files) when not in recovery mode
//efine DFS_VD "2017-11-16"   // BROWSE/NTFS: Correct recover-path for multiple hard-linked files
//efine DFS_VD "2017-11-15"   // NTFS: Better multiple hard-link paths shown in MFT-record display
//efine DFS_VD "2017-11-15"   // SPEED: Fixed divide-by-zero crash on buffersize 512 or larger
//efine DFS_VD "2017-11-13"   // NTFS: Fixed 'u' command after MFT-display (nav.up, LSN parent DIR)
//efine DFS_VD "2017-11-12"   // BROWSE: Display file/dir metadata from popup menu (like MFT-record)
//efine DFS_VD "2017-11-9"    // CDISO: rebuild with cleaned up BOOT.IMG to make DFSDOS.EXE fit again
//efine DFS_VD "2017-11-8"    // Menu: Edit->Search sectors and output->Search for 0x00 EMPTY sectors
//efine DFS_VD "2017-11-8"    // Menu: Edit->Search sectors and output->Search for 0xFE BAD   sectors
//efine DFS_VD "2017-11-8"    // BAD-sectors marked with 0xFE pattern, searchable/shown as type '5'
//efine DFS_VD "2017-11-7"    // IM/IMAGE: Fix name generation XMZ index in multiple-dot filenames

//efine DFS_VN "14.10"                           // Version used in reporting and regkey checks
//efine DFS_VD "2017-11-6"    // SCRIPT: Fix version reprorting above 14.9 = '1490', 14.10 is '14100'
//efine DFS_VD "2017-11-5"    // NTFS/JFS: Fixed recovery/copy of sparse file segments (write zeroes)
//efine DFS_VD "2017-11-3"    // x.DFS: Better message on incorrect DFSee script execution (no 'run')

//efine DFS_VN "14.9'"                           // Version used in reporting and regkey checks
//efine DFS_VD "2017-10-24"   // LINUX: Support DFSPUPPY initial DFSee evaluation registration keys
//efine DFS_VD "2017-10-21"   // LINUX: Do NOT attempt to update window-title for console (no X-term)
//efine DFS_VD "2017-10-20"   // RECOVER/SAVETO: Changed default option to NOT discard path component
//efine DFS_VD "2017-10-20"   // Recover files from List: fixed wildcard handling (broken since 14.0)
//efine DFS_VD "2017-10-18"   // mode=NTFS: Allow abort with <Esc> from infinite related-MFT display
//efine DFS_VD "2017-10-18"   // mode=AUX: Display 'not-implemented' error message for many commands
//efine DFS_VD "2017-10-18"   // NEWMBR: Fixed -f:from-other-disknr option to actually work that way
//efine DFS_VD "2017-10-18"   // EDIT: Default itemsize changed back to clustersize (from 4096 bytes)
//efine DFS_VD "2017-10-17"   // IM:   Set correct base (start - final) for IM opening an IMZ image
//efine DFS_VD "2017-10-17"   // HEXED: Allow navigation when CURR buffer empty (non-existing sector)

//efine DFS_VN "14.9"                           // Version used in reporting and regkey checks
//efine DFS_VD "2017-10-10"   // MBR2GPT: Convert (or recover) MBR-style to GPT-style partitioning
//efine DFS_VD "2017-10-10"   // GPT2MBR: Convert GPT-style to MBR, wipe GPT hdr, optional alternate
//efine DFS_VD "2017-10-09"   // PART: MiB size in std table with 3 fractional digits below 0.95 MiB
//efine DFS_VD "2017-10-08"   // CREATE Dialog: NO-align and MAX-size default if Partial-Cylinder FSP
//efine DFS_VD "2017-10-08"   // CR: Allow creation of a (small!) partition in a Partial-Cylinder FSP
//efine DFS_VD "2017-10-08"   // HELP menu: Pre-load help for most DFSee scripts (for Help->Select)
//efine DFS_VD "2017-10-03"   // LOADHELP: Added -S and -H:sss option for help-sections in Script
//efine DFS_VD "2017-09-30"   // STORE: Improved Last-accessed-LSN/PSN value, added Base-Final PSN
//efine DFS_VD "2017-09-30"   // SCAN:  Fixed bogus errors reported at end of objects (large buffers)
//efine DFS_VD "2017-09-29"   // Limit reading to last physical-disk-sector, when partition selected
//efine DFS_VD "2017-09-28"   // RC: Improved handling and reporting of Read-Only/lock-error issues
//efine DFS_VD "2017-09-28"   // SCAN -w: Fixed crash on Windows/Linux/macOS and default buffer size
//efine DFS_VD "2017-09-27"   // disk-style 'FLP' for LargeFloppy renamed to 'FSO' for FileSystem Only
//efine DFS_VD "2017-09-27"   // FS: Recognition of Linux/MacOS FS if no bootsec (IM, ATTACH, VOL etc)
//efine DFS_VD "2017-09-27"   // EDIT and <F2> key: Made default view HEX/ASCII editor instead of auto
//efine DFS_VD "2017-09-26"   // MENU: File->Attach/Detach/Display disks->Update DFSee disk-list   c-U
//efine DFS_VD "2017-09-26"   // MEDIA: '-update' option updates DFSee disk list (partitionable media)
//efine DFS_VD "2017-09-23"   // HFS: Recognise 'cerd' as last mounted FS, as a valid HFS superblock
//efine DFS_VD "2017-09-22"   // RC: Improved error explanation on compound or multiple commands
//efine DFS_VD "2017-09-22"   // PTEDIT: Extra warning when adding AA55 signature to APM-style disk
//efine DFS_VD "2017-09-21"   // PART/MAP: Support APM style disks, and allow partition selection
//efine DFS_VD "2017-09-20"   // PART: Disk-style 'APM' for Apple-Partition-Map (macOS disk images etc)
//efine DFS_VD "2017-09-19"   // WIPEFREE: Allow any object with a filesystem, not just VOL/PART
//efine DFS_VD "2017-09-19"   // ATTACH/DETACH: Automatic switch to FDISK mode when in another mode
//efine DFS_VD "2017-09-19"   // MENU: Enable wipe-freespace in filesystem, for any valid FS detected
//efine DFS_VD "2017-09-18"   // GPT:  Display GPT-hdr and table contents even if no guard part present
//efine DFS_VD "2017-09-17"   // PART: Force MBR-style disk if GPT and non-guard MBR partition present
//efine DFS_VD "2017-09-17"   // PART: Warnings if GPT-table and MBR partitions present, or no GPT guard

//efine DFS_VN "14.8"                           // Version used in reporting and regkey checks
//efine DFS_VD "2017-09-14"   // EXIT Fix program quit/exit from script called from a DFSee menu item
//efine DFS_VD "2017-09-11"   // HELP Program Updates/Download includes link to OS/2 and WIN 'wget'
//efine DFS_VD "2017-09-10"   // GEO dialog: added another default geometry 240 heads, 32 sect/track
//efine DFS_VD "2017-09-09"   // UNIX/Windows: DFSee version and store contents in console title
//efine DFS_VD "2017-09-08"   // KEY: Fixed incorrect expiration date for certain temporary keys
//efine DFS_VD "2017-09-07"   // WIPE: Changed confirmation text and logic for a wipe starting at 0
//efine DFS_VD "2017-09-07"   // FAT: FIRSTFREE cmd finds first free cluster, write back if FAT32
//efine DFS_VD "2017-09-06"   // PART: Use warning classification major/minor/trivial for disks too
//efine DFS_VD "2017-09-06"   // MENU: Display -> Other partition views -> Non-trivial warnings only
//efine DFS_VD "2017-09-06"   // PART: Do not count trivial warnings in 'minor warnings not shown'
//efine DFS_VD "2017-09-04"   // QUERY: Marker line between different disks, show non-MBR (CRP/FLP)
//efine DFS_VD "2017-09-04"   // MENU: 'Edit->Sector, HEX 16 columns, 32 rows size (Alt-T / Ctrl-F2)
//efine DFS_VD "2017-09-02"   // SET MARGIN sets desirable display-width (MAP, PART, ALLOC, progress)
//efine DFS_VD "2017-09-02"   // MENU: 'Edit->Settings/Properties UI -> Select #colors, Palette (UNIX)
//efine DFS_VD "2017-08-30"   // Switch -C:n force UNIX #colors used to 16 out of 16, 88 or 256
//efine DFS_VD "2017-08-30"   // LVM:  'Edit->LVM information' on GPT partition, msg crash fixed
//efine DFS_VD "2017-08-28"   // MENU: 'Edit->Settings/Properties UI -> UI Test keyboard + Mouse

//efine DFS_VN "14.7"                           // Version used in reporting and regkey checks
//efine DFS_VD "2017-08-25"   // ABOUT: Accept s-F6 as menu key, works from all Unix terminals
//efine DFS_VD "2017-08-24"   // LVMREDO: Explicit skip non 'MBR' style disks to avoid corruption
//efine DFS_VD "2017-08-24"   // XML: New tag diskstyle="str" = "MBR, GPT", "FLP", "CRP" or "UNK"
//efine DFS_VD "2017-08-23"   // DISK: Recognize another MBR variant 'IBM Thinkpad factory preload'
//efine DFS_VD "2017-08-22"   // OUTPUT: Accept shift-arrow keys etc to scroll the output window
//efine DFS_VD "2017-08-20"   // ABOUT: Show DFSee/TxLib build-date to YYYY-MM-DD for consistency
//efine DFS_VD "20-08-2017"   // PART: Default block/clustersize 4096 bytes (when no bootsec value)
//efine DFS_VD "20-08-2017"   // NEWMBR without parameters does CURRENT disk ('.'), not ALL ('*')
//efine DFS_VD "20-08-2017"   // NEWMBR on large-flop or LUKS-crypted fails in batch or OEM-engine
//efine DFS_VD "19-08-2017"   // Linux: Probing for NVMe SSD, HVM virtuals and MMC (SD) devices
//efine DFS_VD "19-08-2017"   // HFS:  Correctly identify HFS SB in 4096 byte sector size disks
//efine DFS_VD "18-08-2017"   // PART: Encrypted GPT partition info, with FileVault header data
//efine DFS_VD "18-08-2017"   // HEXED: Avoid changing item-size (sectors) on using GOTO (Ctrl-G)
//efine DFS_VD "17-08-2017"   // LVM: Fix update LVM with -d:disk, and NO partitions on that disk
//efine DFS_VD "17-08-2017"   // HEXED: Default item size 4KiB (block); Overrule with 'edit -s:n'
//efine DFS_VD "15-08-2017"   // VCU/PCLEAR/FIXCHS: Avoid writing to 'untouchable' disks (FLP/CRP)
//efine DFS_VD "15-08-2017"   // PART: Fixed crash with '-b' or '-n' on large-floppy-format disk
//efine DFS_VD "15-08-2017"   // QUERY:  New 'query DSTyle' diskstyle MBR, GPT, FLP, CRP or UNK
//efine DFS_VD "15-08-2017"   // SCRIPT: New variables $_d_pstyle (string) and $_d_cryptdisk
//efine DFS_VD "13-08-2017"   // Clearly identify/present (free)space for non partitionable disks
//efine DFS_VD "13-08-2017"   // LVM: Work on MBR-style disks only (not on GPT, FLP or CRP style)
//efine DFS_VD "13-08-2017"   // PART: Include Encrypted disk info (LUKS) and wider 'info' column
//efine DFS_VD "12-08-2017"   // MAP/PART: Enhanced 'partitioning style' to: MBR, GPT, FLP or CRP
//efine DFS_VD "12-08-2017"   // NEWMBR on large-flop or LUKS-crypted, extra warning in confirm
//efine DFS_VD "12-08-2017"   // MAP:  Detect LUKS encrypted disks/partitions,  show relevant info
//efine DFS_VD "12-08-2017"   // PART: Include Encrypted partition info, with (LUKS) header data
//efine DFS_VD "12-08-2017"   // LUKS: Recognize 'Linux Unified Key Setup' in sectordata, display
//efine DFS_VD "10-08-2017"   // MAP/ALLOC: Support and use screen widths up to 768 columns wide
//efine DFS_VD "06-08-2017"   // SCRIPT: Updated DFSGETUP/DFSGETPY scripts to report missing 'wget'
//efine DFS_VD "05-08-2017"   // OUTPUT: No command timestamp when echo is suppressed for a command
//efine DFS_VD "05-08-2017"   // VER: New command, show single line of version information
//efine DFS_VD "04-08-2017"   // OS/2: External command enhancements, WGET progress filtering

//efine DFS_VN "14.6"                           // Version used in reporting and regkey checks
//efine DFS_VD "03-08-2017"   // MOUSE: Usage hint menu toggle + text-scroll in output window title
//efine DFS_VD "01-08-2017"   // LINUX: Allow '/mnt/home/dfsee/dfspuppy.imz' path for create stick
//efine DFS_VD "29-07-2017"   // DOS version: Removed Dowload/update items from Help menu
//efine DFS_VD "25-07-2017"   // IMAGE Dialog: Add buffersize option 'Disk geometry track size'
//efine DFS_VD "25-07-2017"   // SWITCH: -dir:path Sets default directory for File Open/Save etc
//efine DFS_VD "24-07-2017"   // MENU: Help -> Program Updates / Downloads with four more items
//efine DFS_VD "22-07-2017"   // NTFS, EFAT, HFS: Keep RC=0 when partition not formatted on init
//efine DFS_VD "22-07-2017"   // Script DFSIFSTD: Don't fail due to 'NTFS auto open' on Linux etc
//efine DFS_VD "22-07-2017"   // MENU: Edit-> Settings/Properties, DFSee-> Show type 0x00 as part
//efine DFS_VD "21-07-2017"   // MENU: File-> Device and Volume management-> Display/Unmount etc
//efine DFS_VD "14-07-2017"   // FAT(32): Fixup directory display; Display 1st cluster-to-be-used
//efine DFS_VD "13-07-2017"   // SET PT0: Set partition-tables to show type 0x00 (deleted/hidden)
//efine DFS_VD "13-07-2017"   // SET SKIPFS: Set FS to skip on match driveletters (FAT32.IFS bug)
//efine DFS_VD "12-07-2017"   // BROWSE JFS: Honnor abort request (<Esc> key) building name-cache
//efine DFS_VD "11-07-2017"   // PATCHKEY: Command to replace keyvalue in current sector by actual
//efine DFS_VD "08-07-2017"   // REGKEY: Inform on start/exit if using evaluation/upgrade temp key
//efine DFS_VD "07-07-2017"   // LINUX: startup, attach /dev/vdX disks (virtio, ParaVirtualisation)
//efine DFS_VD "07-07-2017"   // VirtDisk: in-memory renamed 'Mem-disk', and /dev/MdX now, not vdX
//efine DFS_VD "04-07-2017"   // MENU: Added '[Basic]/[Expert]' mode indicator/button combination
//efine DFS_VD "04-07-2017"   // PROGRESS: Replace clock() by TXTIMER high-res duration/throughput
//efine DFS_VD "04-07-2017"   // TIMING: Replace clock() by TXTIMER, high-res (fixes bugs on UNIX)
//efine DFS_VD "02-07-2017"   // UIKEYS: Show keyboard + Mouse events, with decoding and timestamps
//efine DFS_VD "02-07-2017"   // Linux/Darwin UI: Implement mouse events (xterm 1000 classic mode)
//efine DFS_VD "01-07-2017"   // Linux/Darwin UI: Implement mouse events (xterm 1006, 1015  modes)
//efine DFS_VD "28-06-2017"   // RESTORE: Fix crash when -b:N option specified, smaller than in IMZ
//efine DFS_VD "28-06-2017"   // SCRIPT: New $_dirsep  script variable holding dir/path separator
//efine DFS_VD "28-06-2017"   // SCRIPT: New $_exedir  script variable with executable-path, no sep
//efine DFS_VD "28-06-2017"   // SCRIPT: New $_exename script variable with executable-name, no path
//efine DFS_VD "27-06-2017"   // MBR: Recognize 'Syslinux generic MBR code (ISOHybrid)' (Suse Leap)
//efine DFS_VD "27-06-2017"   // JFS: Recognize Linux formatted FS in none-0x83 type, no bootsector
//efine DFS_VD "24-06-2017"   // MENU: Scripts -> 'Make Puppy-boot (USB) disk' creates bootable USB
//efine DFS_VD "23-06-2017"   // MBR:  Recognize 'Puppy Linux std MBR, DFSee Slacko USB' (dfspuppy)
//efine DFS_VD "21-06-2017"   // GPT:  Allow non-standard ASCII name instead of Unicode (ISOHybrid)
//efine DFS_VD "21-06-2017"   // GPT:  Process GPT even if no valid guard/EFI MBR part  (ISOHybrid)
//efine DFS_VD "21-06-2017"   // PART: Allow primary to start at 0, update ERROR text   (ISOHybrid)
//efine DFS_VD "21-06-2017"   // MENU: File -> Attach RAW disk image, fixed attach command (use -i)
//efine DFS_VD "21-06-2017"   // MENU: File -> Attach physical disk, accept RAW image  (Linux, OSX)
//efine DFS_VD "21-06-2017"   // ATTACH/DETACH: renamed from MOUNT and UNMOUNT, to avoid confusion
//efine DFS_VD "20-06-2017"   // EXT-CMD: Display info: (executed by the operating system)
//efine DFS_VD "20-06-2017"   // DEV/VOL: On Linux, combine 'df' and '/proc/mounts' info for list
//efine DFS_VD "20-06-2017"   // DEV/VOL: On OSX, use 'df -h -l -m' output to list mounted devices

//efine DFS_VN "14.5"                           // Version used in reporting and regkey checks
//efine DFS_VD "20-06-2017" // COMPARE: Fix sectornumber format in mismatch error text (32/64bit)
//efine DFS_VD "20-06-2017" // IMAGE: Do NOT zero unused sectors (full-disk SMART compare errors)
//efine DFS_VD "17-06-2017" // HEXED: Add Ctrl-Z (UNDO) hint in write-confirm popup and footer-text
//efine DFS_VD "17-06-2017" // MENU: New 'Open partition, Browse' in Actions, browse on a partition
//efine DFS_VD "16-06-2017" // EDIT: New '-screen' option maximizes HEX-edit window to full-screen
//efine DFS_VD "16-06-2017" // EDIT: New '-dir' option to present FileDialog with path + wildcard
//efine DFS_VD "15-06-2017" // IMAGE-Dlg: Add BUFFER select in expert mode, remove Append/Excl-LVM
//efine DFS_VD "15-06-2017" // CLONE-Dlg: Add missing [OK] and [Cancel] buttons, for Basic UI mode
//efine DFS_VD "15-06-2017" // CLONE: Hint at 'compare' fail, on partition clone and auto 'fixpbr'
//efine DFS_VD "14-06-2017" // EXTn: Fix AreaInit Bitmap + convert (SMART on whole disk, with EXTn)
//efine DFS_VD "13-06-2017" // EFAT: Fix AreaInit Bitmap location  (SMART on whole disk, with EFAT)
//efine DFS_VD "13-06-2017" // ALLOC: When single-line, output per character (acts as progress bar)
//efine DFS_VD "12-06-2017" // IMAGE: Catch more IMZ compression errors in IMAGE decompress-verify
//efine DFS_VD "10-06-2017" // PTE: Fixed unwanted change from GPT to MBR style after Hex-Edit
//efine DFS_VD "10-06-2017" // PTE: Updated GPT dialog sector first/last fields to accept 64-bit
//efine DFS_VD "09-06-2017" // RC: New cmd to SET a returncode and explain its meaning when known
//efine DFS_VD "09-06-2017" // CR: Symbolic name 'EXT' = 0x83, 'CONT' = 0x05 (extended container)
//efine DFS_VD "07-06-2017" // MENU: Image, verify (and Image dialog): Fixed verify only option
//efine DFS_VD "07-06-2017" // EFAT: Fixed directory listing layout for 64-bit sector numbers
//efine DFS_VD "04-06-2017" // WIPE: Add extra warning when wiping MBR or BOOTSECTOR (start at 0)
//efine DFS_VD "04-06-2017" // NEWMBR: Reread diskinfo before 'newmbr' for up-to-date part count
//efine DFS_VD "03-06-2017" // BROWSE: Mouse CLICK to select, DBLCLK to enter (subdir or menu)
//efine DFS_VD "02-06-2017" // IMAGE: Confirmation dialog on abort using <Esc>, allow continue
//efine DFS_VD "02-06-2017" // ALLOC: Signal Smart-use info not available when aborting display
//efine DFS_VD "01-06-2017" // IMAGE/CLONE: Automatic get Smart-ALLOC info when not there (ETA)
//efine DFS_VD "01-06-2017" // SCAN: Allow larger I/O buffers, and use optimized default size
//efine DFS_VD "31-05-2017" // PROGRESS percentage now based on TIME values, not (sector) counts
//efine DFS_VD "31-05-2017" // Opt -b or -b:track sets tracksize as buffersize, -b:N other values
//efine DFS_VD "31-05-2017" // IMAGE/CLONE: Changed default buffersize to 'optimal-for-current-OS'
//efine DFS_VD "31-05-2017" // IMAGE/CLONE: Fixed 'smart optimize' percentage and skipped size
//efine DFS_VD "30-05-2017" // ALLOC Predict smart-usage for better ETA in later image/clone
//efine DFS_VD "28-05-2017" // CLONE (smart): Better ETA using allocation-info for FS or whole disk
//efine DFS_VD "27-05-2017" // IMAGE (smart): Much better ETA calculation, using allocation-info
//efine DFS_VD "26-05-2017" // MENU: Display, I/O speed, using large buffer (as used for imaging)
//efine DFS_VD "26-05-2017" // SPEED: Progress in seconds, larger buffer, hint when non-optimal
//efine DFS_VD "25-05-2017" // Improved handling of errors in external commands, better messages
//efine DFS_VD "25-05-2017" // UNIX: No quit on failing external command, give error explanation
//efine DFS_VD "24-05-2017" // BROWSE:  Support large (2MiB, DOS 256KiB) buffers in IMZ browsing
//efine DFS_VD "24-05-2017" // RESTORE: Support large (2MiB, DOS 256KiB) buffers in IMZ restore
//efine DFS_VD "24-05-2017" // IMAGE:   Support large (2MiB, DOS 256KiB) buffers for IMZ creat
//efine DFS_VD "24-05-2017" // DARWIN: Use faster 'rdiskN' devices, not 'diskN', unless -raw- switch
//efine DFS_VD "18-05-2017" // Allow external commands on any OS (file-redirect, or pipe on OS/2)
//efine DFS_VD "11-05-2017" // BROWSE/IMAGE new compact index-file formats allowing objects > 2TB
//efine DFS_VD "10-05-2017" // HEXED, update various screen messages for huge sectornumbers (X10)
//efine DFS_VD "06-05-2017" // Image restore/compare/verify: Progress in decimal KBytes imagefile
//efine DFS_VD "28-04-2017" // ALLOC display: show disk/part-ID/Drive being checked in status bar
//efine DFS_VD "28-04-2017" // PART -V -a: Avoid display of allocation twice (slow on large disk)
//efine DFS_VD "26-04-2017" // SLT, check allocation only when using '-a' or '-m' options (CHECK)
//efine DFS_VD "25-04-2017" // Updated ALLOC map displays for variable 64..256 character width
//efine DFS_VD "24-04-2017" // Updated all ALLOC map displays for 64bit sectornumber and sizes
//efine DFS_VD "21-04-2017" // Directory overviews: Display filenames in yellow, to stand out
//efine DFS_VD "21-04-2017" // Directory overviews: Allow up to 99.999 numbered entries (.NNNNN)
//efine DFS_VD "20-04-2017" // Directory overviews: Display filesizes as 13/20 pos 'dotted' value
//efine DFS_VD "18-04-2017" // Prevent 'lvm' command to work on GPT style disks (corrupts PTA)
//efine DFS_VD "11-04-2017" // Updated statusline and default sector displays for 64-bit LSN's
//efine DFS_VD "10-04-2017" // Calculated Geometry (geocalc): Force 64/32 1-MiB geo on GPT disks
//efine DFS_VD "10-04-2017" // Psave/Prestore/Image/Restore updated for 64bit sectornrs and size
//efine DFS_VD "09-04-2017" // Partition displays and option/switch parameter parsing made 64bit
//efine DFS_VD "05-04-2017" // Fixed renaming of directories from BROWSE dialog popup (HPFS/JFS)
//efine DFS_VD "04-04-2017" // Updates to support 64bit sectornumbers and disk/partition sizes

//efine DFS_VN "14.4"                           // Version used in reporting and regkey checks
//efine DFS_VD "26-03-2017" // IMAGE/BROWSE avoid image-file truncate (0 bytes) in DFSDOS version

//efine DFS_VN "14.3"                           // Version used in reporting and regkey checks
//efine DFS_VD "10-03-2017" // DFSDISK: Cancel BSFIND 'abort' condition, so script can continue
//efine DFS_VD "01-03-2017" // MENU Fdisk: 'OS2 LVM and BootManager -> Set LVM-CRC, rem obsolete'
//efine DFS_VD "01-03-2017" // MENU Fdisk: 'OS2 LVM and BootManager -> Wipe LVM sectors MBR area'
//efine DFS_VD "21-02-2017" // PCLEAR: Do NOT clear LVM DLAT sectors in MBR track if not confirmed
//efine DFS_VD "21-02-2017" // PART/DISK: Non-standard tracksize warning only in 'pedantic' mode
//efine DFS_VD "20-02-2017" // RESIZE: Update LVM (size) information after resizing a PRIMARY too
//efine DFS_VD "19-02-2017" // MAP -m Changed 'P-Geo Disk n' terminology to 'BIOS-Geo D n'
//efine DFS_VD "19-02-2017" // QUERY I|B PID|driveletter: Query LVM Installable/On-BM-Menu flag
//efine DFS_VD "19-02-2017" // QUERY Allow driveletter instead of PID for partition selection
//efine DFS_VD "19-02-2017" // PART: Fix selection by driveletter for 1st partition, like 'part D:'
//efine DFS_VD "17-02-2017" // LVM: On create new LVM-info on type 07, set installable flag to ON

//efine DFS_VN "14.2"                           // Version used in reporting and regkey checks
//efine DFS_VD "02-02-2017" // PROGRESS: Show elapsed seconds on status bar if screen wider than 90
//efine DFS_VD "31-01-2017" // FS EFAT: Fixed crash when re-initializing on an EFAT filesystem
//efine DFS_VD "30-01-2017" // DFSCHECK: Support EFAT filesystems, using new DFSEFAT.DFS script
//efine DFS_VD "30-01-2017" // WIPE: Limit area to the size of opened object, avoid error messages
//efine DFS_VD "27-01-2017" // MAP, BROWSE: Strip spaces at logfile end-of-line (avoid PMMail bug)
//efine DFS_VD "24-01-2017" // NTFS, FIXNTLDR -V- option selects XP NTLDR instead of Win-7 BOOTMGR
//efine DFS_VD "24-01-2017" // NTFS, FIXBOOT  -V- option selects XP NTLDR instead of Win-7 BOOTMGR
//efine DFS_VD "16-01-2017" // HEXED: Disassembly and Text views, default window size made larger
//efine DFS_VD "15-01-2017" // HEXED: Disassembly view, new comment column with ASCII instr. bytes
//efine DFS_VD "14-01-2017" // IMZ: Fixed reading from multi-file IMZ for BROWSE or imz-disk-mount
//efine DFS_VD "14-01-2017" // IMAGE: Finish progress BAR on VERIFY/COMPARE before message display
//efine DFS_VD "14-01-2017" // IMAGE: Create sets CRC usage as default again (broken in 14.0/14.1)
//efine DFS_VD "13-01-2017" // IMAGE: Automatic decompress-verify, to catch Decode-stack overflows

//efine DFS_VN "14.1"                           // Version used in reporting and regkey checks
//efine DFS_VD "04-01-2017" // MENU: Edit-> Settings/Properties, UI -> UI cycle colorscheme/lines
//efine DFS_VD "03-01-2017" // MENU: Edit-> Settings/Properties, UI -> UI test Color, Char, Box
//efine DFS_VD "01-01-2017" // New JFS 1.9.7 level boot code (fixboot) including DFSJFLDR image
//efine DFS_VD "21-12-2016" // Updated HEXED 'Initial LSN' description for extended attributes
//efine DFS_VD "21-12-2016" // Fixed program crash (trap) on unmount of a VDI mounted image

//efine DFS_VN "14.0"                           // Version used in reporting and regkey checks
//efine DFS_VD "17-12-2016" // HEXEDIT/Ascii: Clear excess area in last file sector(s) to zeroes
//efine DFS_VD "16-12-2016" // BROWSE: 'View OS/2 EA or Xattr on a File/Dir' in context menu <F10>
//efine DFS_VD "14-12-2016" // SAVEAS: FAT file recovery: Include saving OS/2 EAs (OS/2 version)
//efine DFS_VD "13-12-2016" // SAVEAS: JFS file recovery: Include saving OS/2 EAs (OS/2 version)
//efine DFS_VD "12-12-2016" // EXTn: Support recovery of directories and files with inlined data
//efine DFS_VD "11-12-2016" // BROWSE-Copy: Warning popup on DIR copy, incl. 'do not ask again'
//efine DFS_VD "10-12-2016" // SAVEAS: Discard original path by default on Copy/Recover/Undelete
//efine DFS_VD "10-12-2016" // MENU: 'Browse/Recover Deleted Files' for HPFS, NTFS and JFS (Expert)
//efine DFS_VD "09-12-2016" // UNDELETE: New generic command to find, then BROWSE deleted files
//efine DFS_VD "08-12-2016" // BROWSE/LIST -f: Fix alloc-OK percentage for files over 10Gb size
//efine DFS_VD "08-12-2016" // HEXEDIT/Ascii: Preserve empty lines in pure ASCII files better
//efine DFS_VD "07-12-2016" // MENU: 'Image' menu with operations on IMAGES (from File/Actions)
//efine DFS_VD "06-12-2016" // MENU: Help -> Keyboard usage overviewt; DFSee/TxWindows modules
//efine DFS_VD "06-12-2016" // MENU-FORMAT: No errors/warnings on part-select before the format
//efine DFS_VD "06-12-2016" // CR: Honor '-align-' switch to force PRIMARY start within 1st track
//efine DFS_VD "06-12-2016" // L-Geo: From MBR table: Linear-Offset more important than CHS-end
//efine DFS_VD "04-12-2016" // STARTUP: Reorder commands to show errors/major warnings at the end
//efine DFS_VD "04-12-2016" // PART: Major WARNINGs in yellow, ERRORs in red, make them stand out
//efine DFS_VD "04-12-2016" // HEXEDIT: Support 'sparse' file extents (NTFS, JFS) on file editing
//efine DFS_VD "04-12-2016" // SAVEAS:  Support 'sparse' file extents (NTFS, JFS) on file copying
//efine DFS_VD "03-12-2016" // BROWSE-Copy: Warning-popup if file allocation is not 100% reliable
//efine DFS_VD "02-12-2016" // IMAGE: -x option and Dialog checkbox to generate XMZ INDEX too
//efine DFS_VD "02-12-2016" // IMZ: Automatic generation of .XMZ indexfile for faster browsing
//efine DFS_VD "01-12-2016" // SAVEAS: Statusline progress reporting on COPY of files over 1Mb
//efine DFS_VD "30-11-2016" // BROWSE: 40% faster start on JFS (Build name/parent cache only)
//efine DFS_VD "29-11-2016" // RESTORE/IMZ-index: Better ETA estimation based on fileposition
//efine DFS_VD "29-11-2016" // CLONE/IMAGE: Much better ETA estimation when using SMART logic
//efine DFS_VD "29-11-2016" // CLONE: Improved throughput with SMART (smaller buffer, more ZERO)
//efine DFS_VD "29-11-2016" // CLONE-dialog: changed default modus to 'smart' cloning, faster
//efine DFS_VD "29-11-2016" // IMAGE-dialog: changed default image type to 'smart-compressed'
//efine DFS_VD "27-11-2016" // HELP: Better help-on-help selection in entry-field and menu-bar
//efine DFS_VD "25-11-2016" // BROWSE: Support (same-length) file-rename for JFS and HPFS
//efine DFS_VD "22-11-2016" // CR:/BMGR install: Popup message for missing bmgr-IMG or MBR code
//efine DFS_VD "21-11-2016" // IMZ: Fixed passing of correct accessInfo pointer (broken by VDI)
//efine DFS_VD "20-11-2016" // VDI: Extra confirmation when loading a snapshot without a BASE
//efine DFS_VD "18-11-2016" // VDI: implemented read/write support, updating last VDI in chain
//efine DFS_VD "17-11-2016" // VDI: new command opens Base VDI as disk, or adds snapshot to it
//efine DFS_VD "17-11-2016" // MENU: File->Mount/Unmount/Display disks->VirtualBox disk image
//efine DFS_VD "17-11-2016" // MENU: File->Open a VDI (VBox) diskimage; Open Base/Snapshot VDI
//efine DFS_VD "17-11-2016" // DISK: Changed '-i' option to '-std' for industry-std driveletters
//efine DFS_VD "16-11-2016" // VirtualBox: Support .VDI static/dynamic and snapshot disk images
//efine DFS_VD "11-11-2016" // MENU: Added 'Browse IMZ compressed image' to open+browse an image
//efine DFS_VD "11-11-2016" // IMZ: new command to BROWSE an partition/disk IMZ compressed image
//efine DFS_VD "09-11-2016" // MENU: Added two more 'Edit Sector' variants: HEX and Text/Strings
//efine DFS_VD "09-11-2016" // MENU: Moved 8 DFSee operational settings into an Edit submenu
//efine DFS_VD "08-11-2016" // Switch: -floppy includes diskettes in volumelists (slower startup)
//efine DFS_VD "05-11-2016" // IMAGE: New '-8' option to create DFSee V13.x compatible IMZ images
//efine DFS_VD "05-11-2016" // Added compacter RLE-2 and Smart-2 compression types for IMZ images
//efine DFS_VD "31-10-2016" // Low-level handling for IMZ compressed images as IM or DISK object
//efine DFS_VD "30-10-2016" // MENU, 'Open (partition) imagefile' to basic menu, for image browse
//efine DFS_VD "29-10-2016" // OpenFile dialog + options added to 'im' (open-imagefile) command
//efine DFS_VD "26-10-2016" // BROWSE-Dialog: Ctrl-F/Alt-[ marks all Files, Ctrl-G/Alt-] all Dirs
//efine DFS_VD "25-10-2016" // NTFS: Implemented WriteMetaSpace for resident data (small files)
//efine DFS_VD "24-10-2016" // BROWSE/HEXEDIT: New generic FS-function writing resident/meta data
//efine DFS_VD "22-10-2016" // BROWSE/HEXEDIT: Support edit/view of resident data (like NTFS MFT)
//efine DFS_VD "20-10-2016" // FINDPATH: Add display of filesize from DIR-entry, when available
//efine DFS_VD "20-10-2016" // EDIT: File CONTENTS: support write-back with rsn->lsn translation
//efine DFS_VD "19-10-2016" // EDIT: File CONTENTS: restrict edit-area to exact number of bytes
//efine DFS_VD "19-10-2016" // BROWSE: File-Contents support in: JFS, NTFS, EXT, FAT, EFAT, HPFS
//efine DFS_VD "18-10-2016" // BROWSE (Mode=FDISK): Support optional start PATH for selected PID
//efine DFS_VD "18-10-2016" // EDIT: Default to HEX mode when current sector is an MBR or EBR
//efine DFS_VD "18-10-2016" // EDIT: Restrict min/max sector when editing file CONTENTS (browse)
//efine DFS_VD "17-10-2016" // JFS: Supply file-allocation info for Browse Hex/Ascii/Asm editor
//efine DFS_VD "16-10-2016" // EDIT: -v:view 0=HEX, 1=DISASM, 2=ASCII, 9=AUTO (9 is default now)
//efine DFS_VD "16-10-2016" // HEXEDIT/Ascii: Add filesize and name to title, when available
//efine DFS_VD "16-10-2016" // HEXEDIT/Ascii: <F6> = Minimum length of 'strings' in ascii filter
//efine DFS_VD "16-10-2016" // HEXEDIT/Ascii: <F5> = Style: Rough/Clean and optional split lines
//efine DFS_VD "16-10-2016" // HEXEDIT/Ascii: <F4> = Toggle display of offsets on start of line
//efine DFS_VD "14-10-2016" // HEXEDIT: <F2> = alternate-view: Disassembly, Ascii; auto select
//efine DFS_VD "10-10-2016" // BROWSE-Dialog: <F10> pops up an Actions menu, with edit, copy etc
//efine DFS_VD "09-10-2016" // Mode=FDISK made startup default; Support BROWSE (partitions) cmd
//efine DFS_VD "06-10-2016" // RECOVER: Discard-path, Force-8.3, Unique-name options in dialogs
//efine DFS_VD "04-10-2016" // RECOVER: Cleanup of interfaces, return full recovery-path to caller
//efine DFS_VD "04-10-2016" // JFS: Show Total- versus Volume-Blocks as separate values on open
//efine DFS_VD "03-10-2016" // AL: Low-level display/set individual FS allocation bits (bitmap)
//efine DFS_VD "01-10-2016" // NOBADS: Renamed to BSCLEAR; FIXBS to BSIMPORT, GETBS to BSEXPORT
//efine DFS_VD "30-09-2016" // LIST -r: Show sectorlist in cluster range format (for bad sectors)
//efine DFS_VD "30-09-2016" // LISTSET: Set (range of) sectornumbers in sectorlist, optional clear
//efine DFS_VD "28-09-2016" // BROWSE: Added help-screens for the dialog, and the help-menu
//efine DFS_VD "27-09-2016" // RECOVER: Reduce file 'SaveAs' output to a single line, from BROWSE
//efine DFS_VD "27-09-2016" // BROWSE-Dialog: <F5> Copy/Recover works on multiple (marked) files
//efine DFS_VD "25-09-2016" // BROWSE-Dialog: Ctrl-BACKSLASH changes current list to 'ROOT'
//efine DFS_VD "24-09-2016" // BROWSE-Dialog: multi marking with <SPACE>/<INSERT> + show #marked
//efine DFS_VD "23-09-2016" // BROWSE-Dialog: Selected file/dir available after exit (Enter key)
//efine DFS_VD "23-09-2016" // BROWSE-Dialog: Selected file Copy/Recover from list with <F5>
//efine DFS_VD "22-09-2016" // BROWSE-Dialog: filter-popup, HEX-edit on file-contents or I/Fnode
//efine DFS_VD "22-09-2016" // ACCEL: Changed accelerator keys: F6=Open partition; F9=Browse
//efine DFS_VD "22-09-2016" // PART: -P option to select partition from popup menu, add help/sort
//efine DFS_VD "22-09-2016" // FsFileInfo filter on item-type on HPFS, NTFS, JFS, FAT, EFAT, EXT
//efine DFS_VD "21-09-2016" // BROWSE: Add item-type B/F/D to list/recover/browse select strings
//efine DFS_VD "21-09-2016" // BROWSE: HAS_PARENT sninfo flag on HPFS, NTFS, JFS, FAT, EFAT, EXT
//efine DFS_VD "20-09-2016" // BROWSE: Descr delfind/filefind on HPFS, NTFS, JFS, FAT, EFAT, EXT
//efine DFS_VD "19-09-2016" // BROWSE: Added description for initial browse-contents, BROWSE xxx
//efine DFS_VD "19-09-2016" // BROWSE: Base implementation of the BROWSE dialog works, no actions
//efine DFS_VD "16-09-2016" // SLT:    Fixed formatting issue with JFS/NTFS single line display
//efine DFS_VD "15-09-2016" // BROWSE: Filesize (dotted - 999Tb): JFS, EXTx, HPFS
//efine DFS_VD "14-09-2016" // BROWSE: Modify-time in stringinfo: JFS, EXTx, HPFS, EFAT, FAT, NTFS
//efine DFS_VD "12-09-2016" // LIST -S: Show sectorlist (files) as info-strings needed for BROWSE
//efine DFS_VD "09-09-2016" // BROWSE: Support in FileInfo() to return two file information strings
//efine DFS_VD "02-09-2016" // BROWSE: Filter shortname (8.3) names from NTFS, reverse with -8.3
//efine DFS_VD "01-09-2016" // BROWSE: Add FsMakeBrowseList for: EXTn, JFS, FAT, EFAT, HPFS, NTFS
//efine DFS_VD "31-08-2016" // MENU:   Only enable direct directory-browsing when supported by FS
//efine DFS_VD "30-08-2016" // MENU:   Add BROWSE to Action menu, and to FS-specific recovery menus
//efine DFS_VD "29-08-2016" // BROWSE: Defined generic directory BROWSE command, accelerator <F4>
//efine DFS_VD "28-08-2016" // BROWSE: Automatic add 'dotdot' directory to MakeBrowsList on EFAT
//efine DFS_VD "28-08-2016" // EFAT:   Create Directory-Parent cache on Init (Open) for BROWSE ..

//efine DFS_VN "13.4"       // Version used in reporting and regkey checks
//efine DFS_VD "16-08-2016" // MENU: Error message when trying to add a GPT partition to Bootmanager
//efine DFS_VD "16-08-2016" // ALLOC: Recognize GPT-header+tables as BOOT areas in full-disk ALLOC
//efine DFS_VD "15-08-2016" // EXTn: SLT Provide progress estimate for SLT building progress BAR
//efine DFS_VD "14-08-2016" // DFSCHECK: Fix mis-identification HFS+ as being HPFS, and crashing
//efine DFS_VD "14-08-2016" // DFSDISK: Display the confirmation on completion for single disk too
//efine DFS_VD "13-08-2016" // MENU  EXTn: Mode=EXT2_3 name changed to EXTn, to account for EXT4
//efine DFS_VD "13-08-2016" // MENU: EXTn: Added Inode selection by ino# or one of the special ones
//efine DFS_VD "13-08-2016" // MENU: EXTn: Added File recovery submenu, Filefind, Recover, Hex-edit
//efine DFS_VD "12-08-2016" // DFSDISK/DFSCHECK suppress final message ONLY with option -screen-
//efine DFS_VD "11-08-2016" // FILEFIND, JFS, HPFS, NTFS: added 'search files only' option '-f'
//efine DFS_VD "11-08-2016" // EXTn: FILEFIND, implemented a QUICK search for file/directory Inodes
//efine DFS_VD "08-08-2016" // EXTn: DFSDISK/DFSCHECK Fix crash on superblock; Show Inode with 'd'
//efine DFS_VD "07-08-2016" // EXTn: SLT/INO: Special inode-7 (RESIZE) handling, for display too
//efine DFS_VD "07-08-2016" // EXTn: SLT: Added meta-allocation to SLT and to Inode verbose display
//efine DFS_VD "06-08-2016" // EXTn: DIR: Better handling of empty entries (skip, no abort) SLT too
//efine DFS_VD "05-08-2016" // EXTn: Init: determine DIRTY-status from Groups/Bitmap difference too
//efine DFS_VD "05-08-2016" // EXTn: DFSEXT.dfs script updated for a complete CHECK analysis run
//efine DFS_VD "04-08-2016" // EXTn: FINDPATH or '\path' command implemented, search Inode by path
//efine DFS_VD "03-08-2016" // EXTn: LIST: Show poper File information, path and allocation info
//efine DFS_VD "02-08-2016" // EXTn: INO: Display linkname for small (inlined) symlink Inodes
//efine DFS_VD "01-08-2016" // EXTn: SLT: Add allocation for DIR and FILE Inodes, recursively
//efine DFS_VD "27-07-2016" // EXTn: DIR: Add FileType string (dir/file) and INDEX root/node details
//efine DFS_VD "25-07-2016" // EXTn: DIR: Display directory data, including related inode values
//efine DFS_VD "22-07-2016" // EXTn: INO: Display data allocation, BLOCK-INDIRECT or EXTENT-TREE
//efine DFS_VD "19-07-2016" // EXTn: INO: Detect and show UNKNOWN feature flags (INCOMPATIBLE etc)
//efine DFS_VD "18-07-2016" // EXTn: INO: Show 1st data on <Enter> from BlockIndirect or ExtentTree
//efine DFS_VD "17-07-2016" // EXTn: SUPER: Auto show ROOT Inode on <Enter> from superblock display
//efine DFS_VD "17-07-2016" // EXTn: INO: Auto show same Inode on 't', and show index in Statusline
//efine DFS_VD "15-07-2016" // EXTn: INO: Display of Inode contents complete, except alloc S_SPACE
//efine DFS_VD "13-07-2016" // EXTn: INO: Calculate sector+index for specified Inode-number; display
//efine DFS_VD "11-07-2016" // MENU: EDIT: Update some descriptions for 'Force operation Mode=xxx'
//efine DFS_VD "10-07-2016" // MENU: EXTn: Analyse EXT Filesystem (check) and SLT submenu added
//efine DFS_VD "10-07-2016" // MENU: EXTn: Alloc map, by Blockgroup; Display group aligned ALLOC map
//efine DFS_VD "10-07-2016" // MENU: EXTn: List BACKUP Superblocks;  List all BACKUP groups (super)
//efine DFS_VD "10-07-2016" // MENU: EXTn: Show BlockGroup Summary;  Show flags and alloc for group
//efine DFS_VD "10-07-2016" // PART -v: Added backup-super-BG indicator 'S' for EXTn backup groups
//efine DFS_VD "09-07-2016" // EXTn: SLT: Include all SB, GDT, GDT-reserve, Block- and Inode-bitmaps
//efine DFS_VD "08-07-2016" // CLONE/IMAGE: Enabled SMART for EXT2/3/4, except when META_BG used
//efine DFS_VD "08-07-2016" // EXTn: ALLOC/smart: Handle BLOCK_UNINIT for normal/backup groups
//efine DFS_VD "07-07-2016" // EXTn: BG:  Added GDT/BM/Itable locations + sizes to verbose display
//efine DFS_VD "24-06-2016" // EXTn: BG:  Added backup-super, and UNINIT/ZEROED flag indicators
//efine DFS_VD "24-06-2016" // EXTn: BSL: List backup superblock (+ metadata) groups and sectors
//efine DFS_VD "23-06-2016" // EXTn: ABG: Display allocation with a single blockgroup per line
//efine DFS_VD "22-06-2016" // EXTn: ALLOC: Add BlockGroup# to each line, when exactly 1 BG/line
//efine DFS_VD "22-06-2016" // EXTn: BG: Add display of the flags, like UNINIT block/inode bitmap

//efine DFS_VN "13.3"       // Version used in reporting and regkey checks
//efine DFS_VD "17-06-2016" // CR/CLEANUP: Preserve an ACTIVE extended in MBR (but reset in EBR's)
//efine DFS_VD "17-06-2016" // EXT2/3/4: Implemented BG cmd to display group info and block bitmap
//efine DFS_VD "15-06-2016" // EXT4: Fix Group Descriptor for non-std sector/block sizes, 4096 BPS
//efine DFS_VD "14-06-2016" // EXT4: Smart cloning/imaging and ALLOC supported with BLOCK_UNINIT
//efine DFS_VD "14-06-2016" // EXT4: Discard 'smart' clone/image option if option META_BG (>256Tb)
//efine DFS_VD "13-06-2016" // EXT4: Automatic display of combined bootsector+superblock, 4096 BPS
//efine DFS_VD "12-06-2016" // CLONE: Avoid overwrite manual edited LVM-diskname on dialog tabbing
//efine DFS_VD "11-06-2016" // EXT2/3/4: Fix recognition and calculation for non 512 BPS, 4096 BPS
//efine DFS_VD "08-06-2016" // SETTYPE: Support type change for GPT-style partitions using -t:
//efine DFS_VD "07-06-2016" // MENU: Handle a GPT-style type for 'Change partition type' (settype)
//efine DFS_VD "05-06-2016" // PART: Added short description of bootcode (if any) to 'Related' col
//efine DFS_VD "05-06-2016" // PART: Display ACTIVE indicator on extended container (GRUB stage-1)
//efine DFS_VD "04-06-2016" // PART: Force display of first (outer) extended container, if ACTIVE
//efine DFS_VD "03-06-2016" // ALLOC: Avoid crash on empty NTFS, HFS, RSR or EXT2/3/4 filesystems
//efine DFS_VD "03-06-2016" // NEWMBR: Select disk before allocating sector (fix 4096 BPS crash)
//efine DFS_VD "02-06-2016" // MBR: Added recognition for GRUB2 originated generic MBR bootcode
//efine DFS_VD "01-06-2016" // CR: Make better aligned size-estimate based on -f freespace option
//efine DFS_VD "30-05-2016" // DARWIN: Use an exact 1 MiB cylinder size as default disk geometry
//efine DFS_VD "29-05-2016" // DISK: Allow sectorsize of 512-byte multiples upto 4096, except OS/2
//efine DFS_VD "29-05-2016" // GPT: Added hints to create the GPT-guard, and EFI-system partitions
//efine DFS_VD "29-05-2016" // GPT: Added the 'BIOSBOOT' GPT partition type to type selection list
//efine DFS_VD "27-05-2016" // FIND: Fixed searching in exact MiB boundaries (BSFIND)  on 4096 BPS
//efine DFS_VD "27-05-2016" // CR: Fixed 1-MiB alignment for 1st primary GPT partition on 4096 BPS
//efine DFS_VD "27-05-2016" // RAW2IMZ, IMAGE, CR (partition) fixed size specification on 4096 BPS
//efine DFS_VD "27-05-2016" // EFAT/FAT32 fixed possible brec bootsec buffer overflow  on 4096 BPS
//efine DFS_VD "26-05-2016" // EFAT Fixed bitmap calculations for ALLOC display/Smart  on 4096 BPS
//efine DFS_VD "25-05-2016" // PART: Open, show Clustersize in sectors, not *512 byte  on 4096 BPS
//efine DFS_VD "25-05-2016" // HFS:  Fixed calculations for Blocksize and bits / block on 4096 BPS
//efine DFS_VD "25-05-2016" // NTFS: Fixed bitmap calculations for ALLOC display/Smart on 4096 BPS
//efine DFS_VD "25-05-2016" // NTFS: Fixed calculations for $BadClust resize and reset on 4096 BPS
//efine DFS_VD "24-05-2016" // NTFS: Fixed reading of the logfile flags and logstatus  on 4096 BPS
//efine DFS_VD "22-05-2016" // FAT: Correctly handle .NNN selection from FAT directory on 4096 BPS
//efine DFS_VD "20-05-2016" // SCRIPT: Change $_p_linux... variables to the more generic $_p_unix..
//efine DFS_VD "20-05-2016" // DARWIN: Change 'Linux device ...' strings in output to 'Unix device'
//efine DFS_VD "20-05-2016" // GPT: Validate entry last-PSN against HDR to support 64-bit SN better
//efine DFS_VD "18-05-2016" // LINUX: Show EXT2/3/4 native FS in GPT type LINUX_ROOT_X86_32 or _64
//efine DFS_VD "17-05-2016" // LINUX: Fix physical disk size calculation for disks > 2Tb
//efine DFS_VD "17-05-2016" // MOVE: Fix spurious crash when moving to BEGIN freespace
//efine DFS_VD "21-04-2016" // PART: Added partition type 0xDA for Linux non-FS data (RAID variant)

//efine DFS_VN "13.2"       // Version used in reporting and regkey checks
//efine DFS_VD "05-04-2016" // CR/LVM: Allow -synclvm for driveletter on initial partition creation
//efine DFS_VD "02-04-2016" // CR: Limit CHS values to the maximum values, instead of clipping them
//efine DFS_VD "30-03-2016" // MENU2HTML: Added (to-BASIC/EXPERT-menu) link in navigation menu-bar
//efine DFS_VD "29-03-2016" // GEO: Dialog, new big-SSD 255/248 checkbox and Cyl/Track size display
//efine DFS_VD "24-03-2016" // LVM: Allow the (documented!) -n:diskname option on a single partition

//efine DFS_VN "13.1"       // Version used in reporting and regkey checks
//efine DFS_VD "16-02-2016" // PSAVE: Fix .PDx header signature for PRESTORE (cosmetic bug in 13.0)
//efine DFS_VD "09-02-2016" // PSAVE: Reduced description in header for better text formatting
//efine DFS_VD "05-02-2016" // PRESTORE: restore LVM feature info from *.Fxx IMZ image, when found
//efine DFS_VD "04-02-2016" // PSAVE: Save LVM BBR feature info on type 0x35 to an *.Fxx IMZ image
//efine DFS_VD "04-02-2016" // IMAGE: Include net nr of sectors imaged in the IMZ ascii header info
//efine DFS_VD "03-02-2016" // COPY: Re-introduce the 'Copy Part to freespace area' for Basic UI mode
//efine DFS_VD "29-01-2016" // CLONE: Only show 'Exclude LVM' checkbox in dialog for a type 0x35 part
//efine DFS_VD "29-01-2016" // PART: Fixed formatting error on an LVM Signature missing warning text
//efine DFS_VD "28-01-2016" // MENU: Newmbr ERASE tables: fix -clear option to -c (and a few similar)
//efine DFS_VD "22-01-2016" // CLONE: Update (LVM) diskname on disk-to-disk clone; checkbox in dialog
//efine DFS_VD "01-01-2016" // ABOUT: Update version and copyright info in various places for 2016
//efine DFS_VD "22-12-2015" // ABOUT: Mention 'dfsee.key' instead of just KEY in registration texts
//efine DFS_VD "15-12-2015" // MAP: Unify error reporting on inaccessible disks, reserved USB (Win7)
//efine DFS_VD "09-12-2015" // RESTORE: Show imagefile-read-speed as well as disk-sectors throughput
//efine DFS_VD "09-12-2015" // IMAGE: Show imagefile-write-speed as well as disk-sector throughput

//efine DFS_VN "13.0"       // Version used in reporting and regkey checks
//efine DFS_VD "02-12-2015" // MOVE: Retain original (unique) partition GUID when moving GPT to GPT
//efine DFS_VD "01-12-2015" // MOVE/COPY: Improved clone size and start on MBR to GPT or GPT to MBR
//efine DFS_VD "01-12-2015" // MENU: IMZ2RAW improved handling of source path and sizefield with -S
//efine DFS_VD "28-11-2015" // EXPAND: fixed resizing of the GPT partition entry
//efine DFS_VD "28-11-2015" // MOVE/COPY: fixed handling of GPT partition alignment, and "cr" syntax
//efine DFS_VD "24-11-2015" // EXPAND: Fixed partition type for types larger than 0x10 (HEX-DEC mixup)
//efine DFS_VD "24-11-2015" // EXPAND: Fixed FAT16 bootsector validation for sizes close to the limit
//efine DFS_VD "22-11-2015" // EXPAND: Allow partition expand for unknown filesystems (Part-table only)
//efine DFS_VD "21-11-2015" // MENU: Restore partition info (PRESTORE dialog): include GPT sector types
//efine DFS_VD "20-11-2015" // PSAVE: Add GPT info to ASCII-header and GPT header/table sectors to .PDx
//efine DFS_VD "20-11-2015" // MOVE/COPY: Support for GPT partitions, including MBR to GPT or GPT to MBR
//efine DFS_VD "18-11-2015" // PART: New warning when a GPT partition has a non-unique partition-GUID
//efine DFS_VD "17-11-2015" // MENU: Create and Open freespace, logical/primary lists updated for GPT
//efine DFS_VD "16-11-2015" // CR: Make default size for GPT EFI partition 128 MiB
//efine DFS_VD "16-11-2015" // GPT: Always SORT table-array when before writing, including 'lvm -fix'
//efine DFS_VD "14-11-2015" // GPT: No WARNING if alternate HDR is at end-guard, not end-disk (hybrid)
//efine DFS_VD "14-11-2015" // PL: Supress (OS/2 USB) dummy disks when showing freespace areas (pl f)
//efine DFS_VD "13-11-2015" // GPT: Fix FAT16 filesystem recognition and display for GPT partitions
//efine DFS_VD "11-11-2015" // RESIZE/EXPAND: Added support to resize filesystems in GPT partitions
//efine DFS_VD "10-11-2015" // MENU: Added a convert MBR to GPT, and GPT to MBR items to Mode=FDISK
//efine DFS_VD "10-11-2015" // MENU: Added a 'Fix   GPT header / tables' menu item in Mode=FDISK
//efine DFS_VD "10-11-2015" // GPT: HELP for PTE dialog, fix help for the type-GUID listbox in CR
//efine DFS_VD "06-11-2015" // PTE: Implemented NEXT, PREV, and F2/F5/F8 Hexedit actions for GPT
//efine DFS_VD "04-11-2015" // PTE: Finished handling of field contents for the GPT variant
//efine DFS_VD "03-11-2015" // Don't allow writing outside PSN limits, except for expandable files
//efine DFS_VD "02-11-2015" // PTE: MBR and GPT, changed default sector value to HEXadecimal format
//efine DFS_VD "02-11-2015" // GPT Edit Partition Tables, implemented dialog for single entry edit
//efine DFS_VD "29-10-2015" // CR dialogs, cleaned up maximum-size/offset calculation & alignment
//efine DFS_VD "28-10-2015" // CR: alignment fixes, and update of documentation files
//efine DFS_VD "27-10-2015" // CR: changed '-U' option to '-align-' for consistency (do NOT align)
//efine DFS_VD "27-10-2015" // STARTUP: switch '-align:value to set default alignment on partition CR
//efine DFS_VD "27-10-2015" // SET: 'align' property for CREATE partition, AUTO, CYL, MIB or #sectors
//efine DFS_VD "24-10-2015" // EDIT: Make sure write (back) errors are displayed and show up in the LOG
//efine DFS_VD "23-10-2015" // EDIT: Implemented Fix '-c:N' (nr of byte columns) option in HEX editor
//efine DFS_VD "22-10-2015" // CR: MBR Dialog, added '[x] Do NOT align to CYL boundaries' check box
//efine DFS_VD "22-10-2015" // PART: Supress 'NO-active partition' warnings for GPT style disks
//efine DFS_VD "21-10-2015" // MENU: Changed OSX partition ID from '/dev/disN' to 'diskXsN' identifier
//efine DFS_VD "21-10-2015" // MENU: Updated partition/BMGR selection lists for GPT-style partitions
//efine DFS_VD "20-10-2015" // PART: Check for the HFS+ FS for GPT 'Apple CoreStorage' or 'Apple Boot'
//efine DFS_VD "20-10-2015" // DELETE: Implemented delete of a single GPT partition, or ALL on 1 disk
//efine DFS_VD "18-10-2015" // CR: Force '-U' option when creating a GPT guard partition, type 0xEE
//efine DFS_VD "18-10-2015" // MOUNT/VIRT allow size in sectors larger than C*H*S (partial cylinders)
//efine DFS_VD "18-10-2015" // FAT format, no update of (MBR-style) partition type for a GPT partition
//efine DFS_VD "17-10-2015" // GPT -fix will move an incorrect-placed alternate hdr/PTA, when possible
//efine DFS_VD "16-10-2015" // CR: GPT Dialog, added sub-dialog with check-boxes for attribute flags
//efine DFS_VD "15-10-2015" // CR: GPT Dialog, fixed calculation for aligned/unaligned maximum sizes
//efine DFS_VD "15-10-2015" // CR: GPT Dialog, added '[x] Do NOT align to MiB boundaries' check box
//efine DFS_VD "14-10-2015" // CR: Implemented the actual CreatePartition() fot GPT, writing HDR+PTA
//efine DFS_VD "13-10-2015" // CR: Implemented '-attrib:'hex' option for GPT 64-bit attribute values
//efine DFS_VD "10-10-2015" // PART: Show number of suppressed MINOR warnings when just showing MAJOR ones
//efine DFS_VD "09-10-2015" // PART: Add 'part -w' hint to Linux NOTE if there are unaligned partitions
//efine DFS_VD "07-10-2015" // CR: Fixed alignment for position and size for GPT (0x800, 1 MiB)
//efine DFS_VD "04-10-2015" // CR: Accept symbolic names for GPT partition types (WIN,EFI,LIN, etc)
//efine DFS_VD "30-09-2015" // CR: Supply a default partition name, based on the current type-GUID
//efine DFS_VD "30-09-2015" // CR: Added dedicated [Manual Edit type GUID] button to CR GPT dialog
//efine DFS_VD "26-09-2015" // CR: Implemented GUID/UUID edit dialog, with 5 separate HEX-only fields
//efine DFS_VD "22-09-2015" // CR: Implemented GPT-style partition-create dialog, with type select list
//efine DFS_VD "19-09-2015" // EXPORT: fixed crash when using -d option (as used in DFSDISK procedure)
//efine DFS_VD "17-09-2015" // PART added MBR type 0xEF for an EFI System Partition (ESP) on an MBR disk
//efine DFS_VD "16-09-2015" // New command 'gpt' and 'gpt -fix' to display and fixup (damaged) GPT info
//efine DFS_VD "16-09-2015" // Added '-?' online help to 'H','h','A' and 'a' sector display commands
//efine DFS_VD "15-09-2015" // Better CRC and sanity checks on GPT structures, more specific warnings
//efine DFS_VD "14-09-2015" // Implemented "cr gpt" to create/recover a GPT HDR+PTA structures on a disk
//efine DFS_VD "12-09-2015" // Added warning when GPT guard partition there, but no valid header/array
//efine DFS_VD "11-09-2015" // Fixed creation of PRIMARY with -G:n GAP specified (like GPT 0xEE guard)
//efine DFS_VD "10-09-2015" // Implemented GPT GUID 'time+random' generator and 'uuidgen' test command
//efine DFS_VD "08-09-2015" // Fixed menu ownership to make accelerator keys work from any window/menu
//efine DFS_VD "07-09-2015" // Changed a few key-bindings for better MAC-OSX compatibility (Alt to Ctrl)
//efine DFS_VD "03-09-2015" // Moved all GPT specific code and definitions into DFSUFGPT module

//efine DFS_VN "12.7"       // Version used in reporting and regkey checks
//efine DFS_VD "06-10-2015" // Recompiled with TxLib 2.80, no other functional changes

//efine DFS_VN "12.6"       // Version used in reporting and regkey checks
//efine DFS_VD "19-08-2015" // MENU: added 'Ignore (R/W) errors' selection to 'Edit' menu, with indicator
//efine DFS_VD "19-08-2015" // SET: added 'set error confirm/ignore/quit' to use from scripts (profile.dfs)
//efine DFS_VD "18-08-2015" // IMAGE/RESTORE/CLONE: Avoid defaulting 'confirm' to 'error ignore' in batch
//efine DFS_VD "14-08-2015" // FIX*LDR: Allow spaces in DIR names for FIXNTLDR, FIXHPLDR, FIXJFLDR and VIRT
//efine DFS_VD "03-08-2015" // Updated CLONE and IMAGE dialogs for wider partition lists (UX device)
//efine DFS_VD "03-08-2015" // Added UX devicename to selection text for partitions in lists and menus
//efine DFS_VD "02-08-2015" // Fixed minor allocation/overrun bug for partition selection menus
//efine DFS_VD "02-08-2015" // Moved 'ux' column in 'part' table displays to directly after the 'ID'
//efine DFS_VD "01-08-2015" // Select correct LVM-DLAT for Geometry, when multiple are present
//efine DFS_VD "04-07-2015" // Fixed 'wich' typo in JFS display and some help/usage texts

//efine DFS_VN "12.5"       // Version used in reporting and regkey checks
//efine DFS_VD "02-07-2015" // HELP: Sorted most options alphabetically in *.TXT and '-?' online help
//efine DFS_VD "24-06-2015" // Explicit WARNING if disk LVM geometry has more than 65535 cylinders
//efine DFS_VD "24-06-2015" // Disk warnings GEOMETRY/GEOMETRY_EX: added disk-number (Windows only)
//efine DFS_VD "17-06-2015" // CLONE: Updated help/usage with more complete '-b' option description
//efine DFS_VD "10-06-2015" // LVM: Usage text updated, sorted options, partition versus disk level
//efine DFS_VD "26-05-2015" // MENU: 'mount physical disk' to DFSee list; text changed to 'accessible'
//efine DFS_VD "19-05-2015" // Added leading units/reason short text to -G:0 progress bars display
//efine DFS_VD "06-05-2015" // Updated build process and sources for multiple branded OEM versions
//efine DFS_VD "30-04-2015" // Progress -G:0 switch for BAR only, -G:11 for single line percentage
//efine DFS_VD "23-04-2015" // Minor update to SCRIPT host variable descriptions ($_rc, PRINT)
//efine DFS_VD "18-04-2015" // RUN: status prompt, updated to better reflect SCRIPT return values
//efine DFS_VD "08-04-2015" // FINDPATH support either DOS or UNIX style path separators
//efine DFS_VD "07-04-2015" // File recovery: Create/accept proper path separators for Linux/MAC

//efine DFS_VN "12.4"       // Version used in reporting and regkey checks
//efine DFS_VD "02-04-2015" // EXPAND: Max accepted size automatically reduced for cylinder alignment
//efine DFS_VD "31-03-2015" // GEO: Update total nr of sectors and cylinders on byte-per-sector change
//efine DFS_VD "31-03-2015" // MDISK avoid traps on read/write after changing geometry bytes-per-sector
//efine DFS_VD "29-03-2015" // PART: WARNING for GPT header at WRONG sectorsize (512 byte versus 4 KiB)
//efine DFS_VD "28-03-2015" // LIST: Changed function key <F9> from 'alloc' to list display (list -f)
//efine DFS_VD "28-03-2015" // HPFS: Fixed hang with long-filename display on deleted files/directories
//efine DFS_VD "27-03-2015" // FILEFIND/DELFIND -D option to search for DIRECTORIES only (when possible)
//efine DFS_VD "26-03-2015" // HPFS DELFIND/FILEFIND Create proper FNODE find-SPACE for fast searching
//efine DFS_VD "25-03-2015" // PART table (read/view) Fix handling of size value 0xffffffff (truncate)
//efine DFS_VD "22-03-2015" // HPFS Fnode display and 'list -f': show FULL long-filename and path
//efine DFS_VD "22-03-2015" // HPFS file recovery: use FULL long name (>15) on all path components too
//efine DFS_VD "21-03-2015" // FAT(32) file recovery: use long-filename for recovered file, if present
//efine DFS_VD "20-03-2015" // EFAT   file recovery: fix directory interpretation bug causing failure
//efine DFS_VD "20-03-2015" // EFAT   file recovery: set original file date/time from FILE dir entry
//efine DFS_VD "19-03-2015" // FAT(32) file recovery: set original file date/time, incl create/access
//efine DFS_VD "18-03-2015" // HPFS file recovery: use FULL long filename (>15) when still available
//efine DFS_VD "18-03-2015" // HPFS file recovery: set original file date/time, when still available
//efine DFS_VD "18-03-2015" // File recovery original timestamps on DOS/OS2: fix 'off by 1 month' bug
//efine DFS_VD "11-03-2015" // FDISK/startup: 0-disks/admin-hint in popup requiring user confirmation
//efine DFS_VD "10-03-2015" // WIPE correctly set default size when a start offset specified
//efine DFS_VD "10-03-2015" // IMAGE/RESTORE correctly set default size when a start offset specified
//efine DFS_VD "10-03-2015" // SLT2LIST correctly set default size when a start offset specified
//efine DFS_VD "06-03-2015" // SCAN sn parameter to set the start sector for the scan as MCS-number
//efine DFS_VD "06-03-2015" // ID   '-v-' non-verbose, suppress contents display for the sector
//efine DFS_VD "06-03-2015" // LIST '-t-' or '-t' TEST    option is passed on to cmd given with '-c'
//efine DFS_VD "06-03-2015" // LIST '-v-' or '-v' VERBOSE option is passed on to cmd given with '-c'
//efine DFS_VD "06-03-2015" // LIST '-d-' suppress contents display for the '-c' cmd execution option
//efine DFS_VD "24-02-2015" // HELP (commandline) added the MENU2HTML command to '??' command overview
//efine DFS_VD "23-02-2015" // WINDOWS added hint to reduce security level in User Access Control (UAC)
//efine DFS_VD "18-02-2015" // LOG Display DFSee working directory at startup and start of any logfile
//efine DFS_VD "15-02-2015" // ADJUST filesystem size, respect HPFS 64GiB limit in manual command mode
//efine DFS_VD "12-02-2015" // EXPAND do NOT allow manual override of maximum size in dialog (clip)
//efine DFS_VD "12-02-2015" // EXPAND filesystem/partition, limit size to 64GiB for HPFS

//efine DFS_VN "12.3"       // Version used in reporting and regkey checks
//efine DFS_VD "01-02-2015" // LVM Dialog: Fixed <F1> help to show context sensitive dialog help
//efine DFS_VD "31-01-2015" // EFAT: Implement directory iteration to allow faster (SPACE) searching
//efine DFS_VD "30-01-2015" // FS: Init Filesystem, ignore empty 'FSINIT' cmd after EXPORT/IMPORT list
//efine DFS_VD "29-01-2015" // DELFIND/FILEFIND: on EFAT: Automatic SLT build for fullpath lookup
//efine DFS_VD "29-01-2015" // DELFIND/FILEFIND: on EFAT: '-d-' option: outside DIR space too
//efine DFS_VD "23-01-2015" // DFSDISK (bsfind) recognise JFS superblock on 64/32 (1 MiB) geometries
//efine DFS_VD "21-01-2015" // FINDSPACE command to display filefind/delfind SPACE areas, when known
//efine DFS_VD "21-01-2015" // DELFIND/FILEFIND: Speed up SPACE search with Rsn2Lsn translation cache
//efine DFS_VD "21-01-2015" // DELFIND/FILEFIND: FAT/HPFS, on-demand create FNODE space (not on open)
//efine DFS_VD "20-01-2015" // DELFIND/FILEFIND: on HPFS '-d-' option: outside FNODE space too (slower!)
//efine DFS_VD "17-01-2015" // DELFIND/FILEFIND (QFI) on JFS: Automatic SLT build for fullpath lookup
//efine DFS_VD "17-01-2015" // DELFIND/FILEFIND: Integrated QFI (Quick Find Inodes) for consistency
//efine DFS_VD "17-01-2015" // DELFIND/FILEFIND: on FAT12/16/32: Automatic SLT build for fullpath lookup
//efine DFS_VD "17-01-2015" // MENU: FileFind/DelFind dialog enhanced with persistent search argument
//efine DFS_VD "15-01-2015" // DELFIND/FILEFIND: on NTFS '-d-' option: outside MFT space too (slower!)
//efine DFS_VD "14-01-2015" // MENU: FileFind/DelFind dialog enhanced with checkbox 'outside DIR space'
//efine DFS_VD "14-01-2015" // UI: Allow up to five checkboxes on value-prompt and DIR-selection dialogs
//efine DFS_VD "14-01-2015" // DELFIND/FILEFIND: on FAT12/16/32 '-d-' option: outside DIR space too
//efine DFS_VD "11-01-2015" // FIND: allow search restricted space (ALLDIRS) only, for faster filesearch
//efine DFS_VD "08-01-2015" // CR avoid rounding UP by 1 MiB for 1st primary or a logical (64/32 geometry)

//efine DFS_VN "12.2"       // Version used in reporting and regkey checks
//efine DFS_VD "23-12-2014" // NEWMBR -n and -N option to create MBR without any bootcode/NT-signature
//efine DFS_VD "23-12-2014" // DISPLAY sector identification for empty MBR (just 55AA) to correct type
//efine DFS_VD "19-12-2014" // FIND:  Better EFAT directory entry filtering for finding normal/deleted
//efine DFS_VD "18-12-2014" // FIND:  Progress SN shown from start OBJECT, not start search (experimental)
//efine DFS_VD "18-12-2014" // EFAT: Added search for normal/deleted files to the recovery submenu
//efine DFS_VD "18-12-2014" // EFAT: DELFIND cmd, search deleted or renamed files/dirs by name fragment
//efine DFS_VD "17-12-2014" // EFAT: FILEFIND cmd, search normal files by name fragment (15 chars max)
//efine DFS_VD "17-12-2014" // EFAT: Fix DIR display (list) for FILE/STREAM entries spanning 2 sectors
//efine DFS_VD "16-12-2014" // EFAT: resolve FILE (85) from stream/name (c0/c1) DIR entries (filefind etc)
//efine DFS_VD "08-12-2014" // Update global info after each 'alloc' command, enabling resizing menu items
//efine DFS_VD "07-12-2014" // Made '-a' default on 'part' cmd, alloc info, enabling resizing menu items
//efine DFS_VD "07-12-2014" // Added 'part PID -a' hint on resizing menu items not being available message
//efine DFS_VD "10-10-2014" // SETBOOT -disk:* updates ALL installed bootmanagers, and is now the default
//efine DFS_VD "08-10-2014" // Fixed auto LVM creation from the 'Create partition' dialog (lvm 1 -C ..)
//efine DFS_VD "12-09-2014" // Fixed item count in 'Expert' help menu to again include the 'About' item

//efine DFS_VN "12.1"       // Version used in reporting and regkey checks
//efine DFS_VD "10-09-2014" // Startup, echo the DFSee startup commandline to the screen and logfile
//efine DFS_VD "10-09-2014" // PRESTORE, suppress 'test on virtual disk first' hint when disk IS a virtual
//efine DFS_VD "10-09-2014" // RESTORE, fixed size related bug in restoring multiple-file compressed image
//efine DFS_VD "28-08-2014" // EFAT, completed the Mode=EFAT menus and related help text
//efine DFS_VD "26-08-2014" // EFAT BOOTSYNC cmd: calculate CRC and write to one or both boot areas (sync)
//efine DFS_VD "24-08-2014" // LVM auto create MBR DLAT with prompted disk-name on 1st LVM info for a disk
//efine DFS_VD "20-08-2014" // SLT build, change end-of-disk marker to '***** max *****' no number value
//efine DFS_VD "20-08-2014" // SLT build implemented for the EFAT filesystem, including reserved areas
//efine DFS_VD "13-08-2014" // Binary display current sector (Hex-Dump) keyboard shortcut changed to Ctrl+B
//efine DFS_VD "03-08-2014" // DIALOG 'Partition Table Edit' (PTE), fix PT-entry line to get initial focus
//efine DFS_VD "01-08-2014" // DIALOG 'Set Geometry', automatically set RADIO buttons to match current L-GEO
//efine DFS_VD "31-07-2014" // MENU Mode=Fdisk, LVM, 'Clear BBR on non-LVM partitions' wipes obsolete LVM-sig
//efine DFS_VD "30-07-2014" // LVM -d:x -C' or '-C' option: CLEAR LVM-signature from ALL non-0x35 partitions
//efine DFS_VD "27-07-2014" // LVM 'pid -C' option: CLEAR LVM-signature (BBR) for one non-0x35 type partition
//efine DFS_VD "25-07-2014" // PART WARNING for non LVM (0x35) partitions that DO have an LVM BBR sector
//efine DFS_VD "24-07-2014" // DISK warning about OS/2 non-standard sectors/track fixed for disks > 1 TiB
//efine DFS_VD "23-07-2014" // FAT(32) list -f calculate percentage of correct allocation (recoverability)
//efine DFS_VD "22-07-2014" // EFAT   list -f calculate percentage of correct allocation (recoverability)
//efine DFS_VD "21-07-2014" // EFAT SAVETO implemented for files, directories, and bitmap+upcase sysfiles
//efine DFS_VD "17-07-2014" // FAT-FS display selected dir-entry in statusline next to 'this' sector-nr
//efine DFS_VD "17-07-2014" // SAVETO automatic get FAT directory entry from sector list after .NNN select
//efine DFS_VD "15-07-2014" // PART WARNING if LVM DLAT size or startsector do not match partition table
//efine DFS_VD "09-07-2014" // CREATE keep correct minimum size for first logical (move up to cylinder 1)
//efine DFS_VD "02-07-2014" // EFAT list -f and detailed-directory displays debug and touch-up TZ format
//efine DFS_VD "30-06-2014" // EFAT directory including alloc display and list -f type filename display
//efine DFS_VD "27-06-2014" // PART  changed CHS/LBA-offset mismatch below cyl-1024 from ERROR to WARNING
//efine DFS_VD "25-06-2014" // EFAT added display of boot-area and FAT-area(s) to allocation map display
//efine DFS_VD "24-06-2014" // EFAT implementation of Bitmap caching and ALLOC functionalty using bitmap
//efine DFS_VD "22-06-2014" // EFAT formatted display for bootsector, MAP display based on clusters
//efine DFS_VD "20-06-2014" // EFAT Volume Label recgonition from Root directory in table / part -V
//efine DFS_VD "18-06-2014" // EFAT bootsector recognition in MBR or GPT partitions and Large-Floppy
//efine DFS_VD "15-06-2014" // MENU Edit, display BATCH-mode status, and allow toggle ON or OFF
//efine DFS_VD "15-06-2014" // BATCH command, added '-?' usage help and '?' for batch status display
//efine DFS_VD "15-06-2014" // Buffersize adjust restore IMZ: AUTO in BASIC-mode, confirm once for EXPERT

//efine DFS_VN "12.0"       // Version used in reporting and regkey checks
//efine DFS_VD "08-06-2014" // WARNING, no OS/2 65535 cyl limit warnings if NO OS/2 filesystems present
//efine DFS_VD "08-06-2014" // Calculate OS/2 65535 cyl limit dynamically from geometry, not fixed 255/63
//efine DFS_VD "08-06-2014" // MENU Mode=FDISK MBR area, added selection for 'Wipe LVM sectors MBR-area'
//efine DFS_VD "08-06-2014" // PCLEAR L now includes clearing all LVM DLAT sectors in MBR track (LVMCLEAN)
//efine DFS_VD "08-06-2014" // LVMCLEAN wipes obsoletes LVM DLAT sectors in the MBR track (sect 1 .. 254)
//efine DFS_VD "07-06-2014" // DUMPFS fixed allocation status reported for sectors with the 'ID' command
//efine DFS_VD "03-06-2014" // DUMPFS filesystem support to show OS/2 dump partition contents (DUMPFS.IFS)
//efine DFS_VD "31-05-2014" // HEXED fixed 'IM -A-' option to prevent FILE appending using the INSERT key
//efine DFS_VD "31-05-2014" // No PSN limit check on writing to FILE object, to allow extend (IMZ2RAW)
//efine DFS_VD "31-05-2014" // Suppress '0 sectors per cluster' display in bootsectors (JFS, HPFS etc)
//efine DFS_VD "30-05-2014" // Fixed confusing 'Rgeistred users..' message after 'dfsdisk -?' command
//efine DFS_VD "28-05-2014" // Consolidated help-sections in TXWIn and DFSee, less sections
//efine DFS_VD "27-05-2014" // GREP, SEARCH and '/' commands to search in the output window
//efine DFS_VD "21-05-2014" // HELP, Added lists/searching to HELP command and Help menu, including GREP
//efine DFS_VD "09-05-2014" // Fixed some non-working HELP sections for scripting and registration key
//efine DFS_VD "02-05-2014" // WARNING 'extends beyond end of disk' refined with (for S-Geo) reminder
//efine DFS_VD "02-05-2014" // Fixed formatting issue with Mode=XFS and Mode=SWAP generated menu pages
//efine DFS_VD "22-04-2014" // CLONE, IMAGE, FIND, File-recovery:  'Confirm' to 'Ignore' after an error
//efine DFS_VD "22-04-2014" // WIPE, allow switching from strategy 'Confirm' to 'Ignore' after an error
//efine DFS_VD "22-04-2014" // WIPE, honnor the -E:strategy switch/option to continue after bad sectors
//efine DFS_VD "18-04-2014" // MENU2HTML, make menu doc generator (PHP/HTML) 'BASIC' aware
//efine DFS_VD "17-04-2014" // 'BASIC' aware dialogs for CLONE, IMAGE, RESTORE, RUN, DFSDISK
//efine DFS_VD "17-04-2014" // DFSDISK dialog: default changed to 'Search on Cylinder and MiB boundaries'
//efine DFS_VD "17-04-2014" // IMAGE/CLONE dialog: default for 'smart' changed to FALSE (max reliability)
//efine DFS_VD "17-04-2014" // CREATE dialog: default for 'allow multiple primaries' changed to TRUE
//efine DFS_VD "17-04-2014" // 'BASIC' aware dialogs for set-LVM and CREATE-partition
//efine DFS_VD "15-04-2014" // 'BASIC' menu versions for JFS, Reiser, XFS, HFS, EXT2-3, SWAP and AUX modes
//efine DFS_VD "11-04-2014" // CHECK on NTFS partitions: suppress 'bad fixup structure' message on empty MFT's
//efine DFS_VD "11-04-2014" // 'BASIC' versus 'EXPERT' menu, '-expert' or 'SET EXPert on/off/toggle to switch

//efine DFS_VN "11.7"       // Version used in reporting and regkey checks
//efine DFS_VD "05-03-2014" // PART / ReadDiskInfo, fixed minor BMGR labeling bugt when no LVM info present
//efine DFS_VD "05-03-2014" // SET GEOCALC, reset forced geometries when switching 'geocalc' ON or OFF
//efine DFS_VD "05-03-2014" // GEO (startup) force H64/S32 when partitions seem to be aligned to 1-MiB (0x800)
//efine DFS_VD "04-03-2014" // NTFS NOBADS, set $Bad attribute to default size (avoid third-party bugs!)
//efine DFS_VD "04-03-2014" // RESTORE auto expand buffer if image (IMZ) requires that, with confirmation
//efine DFS_VD "04-03-2014" // VCU (Apply default LVM info): fixed crash when used on an empty disk
//efine DFS_VD "08-01-2014" // SCAN (and others) termination error on OS2 and 255 sectors/track geo, fixed
//efine DFS_VD "08-01-2014" // Removed several other duplicate menu accelerator keys from main and submenus
//efine DFS_VD "07-01-2014" // Removed duplicate 'P' and 'D' accelerator keys from Mode=FDISK menu pulldown
//efine DFS_VD "06-01-2014" // Show opened object details in app-title; show title on a 28-line screen too
//efine DFS_VD "04-01-2014" // Display Geometry+Status in menu, and on F7 function key, 'vol' now a-F7
//efine DFS_VD "28-09-2013" // Fixed opening 'File' menu at startup, just select it, but no actual open
//efine DFS_VD "03-09-2013" // Fixed help reference for new-MBR, ERASE tables menu selection
//efine DFS_VD "16-08-2013" // Display change 'HcSC:' instead of 'CHS' for part-table entry 3-byte combos

//efine DFS_VN "11.6"       // Version used in reporting and regkey checks
//efine DFS_VD "15-07-2013" // Release timestamp, startpoint for evaluation expiration (end of 2013)
//efine DFS_VD "18-06-2013" // Fixed non functioning '-a-' option on SCAN command to suppress auto-ID
//efine DFS_VD "05-05-2013" // Add Windows (NT/XP/W7/W8) lastError description on 'unknown errors' RC 1
//efine DFS_VD "05-05-2013" // Add Windows (NT/XP/W7/W8) lastError description on reading a bad sector
//efine DFS_VD "04-05-2013" // Updated 'Geometry Dn from :' to 'Disk n L-Geo from', with 'PSN' in 8 digits
//efine DFS_VD "11-04-2013" // Fix line-wrap in Help->Exe startup switches; Allow numeric logfilename
//efine DFS_VD "07-04-2013" // Updated usage text on 'lvmshow -?' to document the '0' parameter
//efine DFS_VD "17-02-2013" // Refresh DFSee tables from disk before displaying disk-map from the menu
//efine DFS_VD "07-02-2013" // Avoid driveletter display bug on Windows FAT(32) by ignoring dirty flag
//efine DFS_VD "17-01-2013" // Improved warning messages 'BIOS versus OS size' on OS/2  cyl. > 65535

//efine DFS_VN "11.5"       // Version used in reporting and regkey checks
//efine DFS_VD "01-01-2013" // Setting a primary ACTIVE does no longer hide all other primaries on disk
//efine DFS_VD "29-12-2012" // Specific error/warning when MBR or EBR has no 55AA sig, but valid table
//efine DFS_VD "29-12-2012" // Continue partition analysis when no MBR/EBR 55AA sig, but valid tables
//efine DFS_VD "23-12-2012" // Fixed a (GCC versus Watcom compiler issue?) PSAVE crash on the MAC version
//efine DFS_VD "08-12-2012" // No 'alignext' hint on 'partition overlaps DLAT' for a primary partition.
//efine DFS_VD "06-12-2012" // Confirmation popup after a write-error on cloning (continue/abort)
//efine DFS_VD "06-12-2012" // Log errors to screen/logfile on read while cloning, even when using -E:I
//efine DFS_VD "06-12-2012" // Confirmation popup after a write-error on restore image (continue/abort)
//efine DFS_VD "06-12-2012" // Log read errors to screen/logfile on create image, even when using -E:I
//efine DFS_VD "15-11-2012" // GetLastError text TRACE on failing Create/Write/ReadFile Win32 calls
//efine DFS_VD "13-11-2012" // Improved error code on Windows write errors (rc 1 -> GetLastError())
//efine DFS_VD "13-11-2012" // Fixed alloc info for MBR area in dfsFdskSetNewArea() used for 'Smart'
//efine DFS_VD "28-10-2012" // LIST mention IMPORT command when trying to use an empty sectorlist
//efine DFS_VD "27-10-2012" // NTFS update volume serialnr and display bootsector, use 16 digits
//efine DFS_VD "23-10-2012" // NTFS DIRFIND 'not implemented' error message fixed; Build on W500
//efine DFS_VD "12-10-2012" // NTFS descriptive message if $Volume MFT has no VolumeInfo attrib
//efine DFS_VD "10-10-2012" // Added cylinder-alignment when positioning from END of freespace
//efine DFS_VD "19-09-2012" // HELP #834 fixed spelling error 'AVCTIVE' partition to 'ACTIVE'
//efine DFS_VD "19-09-2012" // PART show LVM diskname even if no partitions are listed in DLAT
//efine DFS_VD "19-09-2012" // ALIGNEXT non-zero RC if no room for alignment or other error

//efine DFS_VN "11.4"       // Version used in reporting and regkey checks
//efine DFS_VD "14-09-2012" // DFSDISK correct full display multiple-FS superblocks from bsfind
//efine DFS_VD "08-09-2012" // PROGRESS BAR fixed 0% at begin for some IMAGE and WIPE operations
//efine DFS_VD "07-09-2012" // MENU SCRIPT added create type 0x07 HPFS/JFS/NTFS USB disk/stick
//efine DFS_VD "07-09-2012" // MENU SCRIPT added create type 0x35 classic JFS   USB disk/stick
//efine DFS_VD "05-09-2012" // EDIT binary-file, fix bogus error popup if 'this' SN too large
//efine DFS_VD "28-08-2012" // No hint to 'restore to virtual disk first' if this IS a virtual
//efine DFS_VD "28-08-2012" // Fixed help-page numbering for 'File->Trace to cyclic' files
//efine DFS_VD "26-08-2012" // MENU Mode=EXT2+3 changed to EXT2_3 for correct menu DOC generation
//efine DFS_VD "23-08-2012" // Static HTML generation with 'menu2html' updated for scripts menu

//efine DFS_VN "11.3"       // Version used in reporting and regkey checks
//efine DFS_VD "22-08-2012" // MENU Mode=FDISK new submenu to open/select a whole disk to work on
//efine DFS_VD "20-08-2012" // MENU Mode=FDISK new submenu to show/set geometry for selected disk
//efine DFS_VD "20-08-2012" // GEO reported size for logical geometry changed (back) to C * H * S
//efine DFS_VD "20-08-2012" // GEO -d:nr option first selects specified disk before acting on GEO
//efine DFS_VD "20-08-2012" // GEO -! option starts dialog to show/set system and logical geometry
//efine DFS_VD "17-08-2012" // DFSUSB32 procedure updated to support 1-partition 32Gb boot sticks
//efine DFS_VD "09-08-2012" // MENU Mode=FDISK new submenu for partition-table cleanup and repair
//efine DFS_VD "09-08-2012" // ALIGNEXT menu-items in FDISK menu, for disk or specific partition
//efine DFS_VD "09-08-2012" // ALIGNEXT command to delete/recreate (first) logical for alignment
//efine DFS_VD "08-08-2012" // NEXT command as alias for 'd' command and 'Ctrl+N' or Enter key
//efine DFS_VD "08-08-2012" // DFSDISK avoid false interpretation of BBR driveinfo as HPFS spare
//efine DFS_VD "06-08-2012" // JFS new 'SET FS' submenu, FS status, version and signature
//efine DFS_VD "05-08-2012" // SBSIG command on JFS, set signature digit to correct value
//efine DFS_VD "05-08-2012" // Accept and warn about JFS superblock with BAD signature digit
//efine DFS_VD "03-08-2012" // WARNING added for EBR-to-logical-BOOTSEC larger than 1 track
//efine DFS_VD "01-08-2012" // DFSDISK allow finding superblocks for multiple filesystems
//efine DFS_VD "01-08-2012" // MENU 'Search partition + FS info' multiple and new filesystems
//efine DFS_VD "31-07-2012" // BSFIND allow finding superblocks for multiple filesystems
//efine DFS_VD "27-07-2012" // RESTORE fix ignored explicit start-sector on RAW/IMZ (since 11.1)
//efine DFS_VD "27-07-2012" // DFSDISK now finds JFS super on GEO with 127/255 sectors/track
//efine DFS_VD "27-07-2012" // SYNCLVM setting (OS2 only) toggle menu item added to Edit menu
//efine DFS_VD "20-07-2012" // IMPORT sector list, include the info byte (FAT DIR entry nr)
//efine DFS_VD "20-07-2012" // EXPORT sector list, include the info byte (FAT DIR entry nr)
//efine DFS_VD "20-07-2012" // DIR displays, optimize list display options for file recovery
//efine DFS_VD "16-07-2012" // JFS/NTFS display alloc extents limit 32, unless verbose (-v)
//efine DFS_VD "16-07-2012" // JFS/NTFS display alloc extents limit 32, unless verbose (-v)
//efine DFS_VD "16-07-2012" // Statusline progress in recovery of large files  (x of y MiB)
//efine DFS_VD "16-07-2012" // JFS/NTFS file recovery on OS/2, use LargeFile API on DosOpen
//efine DFS_VD "13-07-2012" // NTFS file recovery, removed 4Gb filesize limit (64-bit size)
//efine DFS_VD "12-07-2012" // JFS  file recovery, removed 4Gb filesize limit (64-bit size)
//efine DFS_VD "11-07-2012" // PRESTORE allow multiple dots in path+filename (like 11.2 :-)
//efine DFS_VD "11-07-2012" // VIRT allow multiple dots in path+filename for .PDx template
//efine DFS_VD "07-07-2012" // Disk WARNING BIOS versus OS size difference, newline at end

//efine DFS_VN "11.2"       // Version used in reporting and regkey checks
//efine DFS_VD "01-07-2012" // FAT Expand/Resize, completion message declare CHKDSK optional
//efine DFS_VD "29-06-2012" // FAT Expand, improved progress reporting on various stages
//efine DFS_VD "26-06-2012" // FAT32 fixed type display string for 2nd and 3rd bootsectors
//efine DFS_VD "26-06-2012" // FAT32 free-clusters in 2nd bootsector, based on own ALLOC now
//efine DFS_VD "25-06-2012" // FAT32 update free-clusters in 2nd bootsector, new calculation
//efine DFS_VD "22-06-2012" // FAT16 fix DIR cluster identification on zeroed deleted entry
//efine DFS_VD "21-06-2012" // FAT16 fixed spurious garbage in SLT caused by long filenames
//efine DFS_VD "19-06-2012" // FAT16 Resize fixed overwriting ROOT dir with 2nd FAT update
//efine DFS_VD "18-06-2012" // FATSHOW '-c:cluster#' option shows FAT starting from cluster
//efine DFS_VD "17-06-2012" // FAT 16/32 implemented expanding, for same clustersize only
//efine DFS_VD "16-06-2012" // FAT set cluster value; Fixup DIR entries resize;
//efine DFS_VD "15-06-2012" // DIRFIND support -t:type option to find DIRs or files only
//efine DFS_VD "15-06-2012" // FAT DIRFIND fix additional list information (dir entry#)
//efine DFS_VD "15-06-2012" // FAT DIRFIND fix '-l' option to automatically list results
//efine DFS_VD "15-06-2012" // FAT DIRFIND exclude long-filename DIR entries from result
//efine DFS_VD "11-06-2012" // LIST -f, on FAT, shows long-filenames, unless -lfn- option
//efine DFS_VD "11-06-2012" // FAT SLT display, shows long-filenames, unless -lfn- option
//efine DFS_VD "10-06-2012" // FAT DIR view suppress deleted files unless '-D' option used
//efine DFS_VD "10-06-2012" // LIST -f now shows full path+filename on FAT, if SLT available
//efine DFS_VD "10-06-2012" // SLT display, display compacter, more room for file path
//efine DFS_VD "10-06-2012" // FAT SLT display, implement display of the path for file data
//efine DFS_VD "09-06-2012" // MENU 'Edit -> Automatic logfile Numbering' toggles setting
//efine DFS_VD "09-06-2012" // -logauto commandline switch sets LOG auto numbering on/off
//efine DFS_VD "09-06-2012" // SET LOG command,  sets automatic LOG file numbering on/off
//efine DFS_VD "03-06-2012" // Put list DIR entry# in separate byte; lift 64Gb FAT32 limit
//efine DFS_VD "31-05-2012" // WIPESECURE Added better logging/reporting to DoD 5220 wiping
//efine DFS_VD "30-05-2012" // FAT resize,implemented initial relocate of resized FAT-area
//efine DFS_VD "29-05-2012" // Removed obsolete media description from all but MAC version
//efine DFS_VD "28-05-2012" // Set filesystem expand (resize) limits for FAT12/FAT16/FAT32
//efine DFS_VD "20-05-2012" // Add superblock, group-descr and bitmaps to EXT2/3 SLT build
//efine DFS_VD "20-05-2012" // Added superblocks and allocation bitmaps to HFS SLT build
//efine DFS_VD "18-05-2012" // Keep 'map' disk graph as wide as possible for screen width
//efine DFS_VD "18-05-2012" // OS-X explicit hint to UNMOUNT whole disk before writing
//efine DFS_VD "18-05-2012" // Implemented SMART capability in HFS for cloning and imaging
//efine DFS_VD "17-05-2012" // Implemented bitmap block allocation display (ALLOC command)
//efine DFS_VD "17-05-2012" // Implemented bitmap read and alloc-bit determination in HFS
//efine DFS_VD "06-05-2012" // Fix binary incompatibility betwee 11.2 and previous PSAVE
//efine DFS_VD "04-05-2012" // Split EFI-GPT and Windows-LDM handling (incompatible format)
//efine DFS_VD "04-04-2012" // Updated makefile + about-text for UPX 3.08 Windows version
//efine DFS_VD "03-04-2012" // Display of (most of) the HFS superblock; MAP fixup for GPT
//efine DFS_VD "01-04-2012" // Fixup disk naming for linux device; prepare for big-endian
//efine DFS_VD "30-03-2012" // Set MBR style partent type for a GPT for desired map color
//efine DFS_VD "29-03-2012" // Implemented GPT freespace handling
//efine DFS_VD "27-03-2012" // Implemented ReadGptPartitions & partition displays for GPT
//efine DFS_VD "23-03-2012" // Implemented CRC checks on GPT header and PT array
//efine DFS_VD "23-03-2012" // -gptauto commandline switch sets GPT interpretation on/off
//efine DFS_VD "23-03-2012" // SET GPT command,  sets automatic GPT interpretation on/off
//efine DFS_VD "22-03-2012" // Added display of GPT partition table array contents
//efine DFS_VD "21-03-2012" // Start implementing GPT support, display only for now

//efine DFS_VN "11.1"       // Version used in reporting and regkey checks
//efine DFS_VD "21-03-2012" // Fixed '-Q' problem with bare wipe, clone, restore commands
//efine DFS_VD "20-03-2012" // GENPART: allow -b:'basename' option instead of 2nd parameter
//efine DFS_VD "20-03-2012" // Silent target selection on Clone/Comp/Restore/Wipe using -Q
//efine DFS_VD "20-03-2012" // Explicitit mention of L-Geo for OS/2 > 65535 cylinder warning
//efine DFS_VD "20-03-2012" // Non-critical IBM BMGR warnings made minor  (multiple disks)
//efine DFS_VD "20-03-2012" // Non-std cylinder-alignment now MINOR warnings (Win-7/Linux)
//efine DFS_VD "17-03-2012" // Set mode=EXT2 on 0x83 partition without superblocks, not AUX
//efine DFS_VD "17-03-2012" // No 'invalid bootsector' msg on open of Linux or swap partition
//efine DFS_VD "17-03-2012" // Reset pendingAbort before BMGR menu install; to use in batch
//efine DFS_VD "16-03-2012" // Added MiB/Both in find; cslist; dfsdisk; bsfind; dfsdisk dlg
//efine DFS_VD "15-03-2012" // Optimized formatting on message for discarded P-Geo size
//efine DFS_VD "07-03-2012" // Discard P-geo size on OS/2 when more than 1-cylinder difference
//efine DFS_VD "14-02-2012" // Allow abort FAT-CRC loop whith 'fs fat32' on a FAT16 filesystem
//efine DFS_VD "15-01-2012" // PTEDIT up/down keys now navigate between fields and buttons too
//efine DFS_VD "15-01-2012" // PTEDIT dlg sort table on ENTER while a sort button has focus
//efine DFS_VD "09-01-2012" // PTEDIT log disk and partition details on each table display
//efine DFS_VD "09-01-2012" // PTEDIT dlg added help on using SPACE to operate sort buttons
//efine DFS_VD "03-01-2012" // RESTORE/COMPARE show number of files for multi-file image set
//efine DFS_VD "03-01-2012" // RESTORE/COMPARE get correct size for multiple-RAW image files
//efine DFS_VD "02-01-2012" // Updated DFSee signature to '11' in bootrecord for HPFS fixboot
//efine DFS_VD "02-01-2012" // Use GEOMETRY_EX only for XP and up; error fallback to GEOMETRY
//efine DFS_VD "02-01-2012" // Added "run as administrator" hint for Vista and Windows-7 only

//efine DFS_VN "11.0"       // Version used in reporting and regkey checks
//efine DFS_VD "21-12-2011" // Raw disk size enabled for W2K too; Fixed MAC build issues
//efine DFS_VD "19-12-2011" // FDISK menu 'Set base to Freespace area' for easy (edit) access
//efine DFS_VD "18-12-2011" // Disksize shown including partial last cylinder whenever possible
//efine DFS_VD "17-12-2011" // IMPORT automatic FS specific command execute, like IRS for JFS
//efine DFS_VD "17-12-2011" // EXPORT include FS specific command pragma line in export file
//efine DFS_VD "17-12-2011" // GENPART, generate -X and -Y options on all logical partitions
//efine DFS_VD "17-12-2011" // CREATE dlg prefered table entry for partition, MBR and EBR
//efine DFS_VD "17-12-2011" // CR -P or -! presents interactive CREATE partition dialog
//efine DFS_VD "17-12-2011" // CR -Y:n sets prefered entry for new EBR extended containers
//efine DFS_VD "17-12-2011" // CR -X:n sets prefered entry for new MBR extended container
//efine DFS_VD "16-12-2011" // CR default MBR entry 3 (last) slot for new extended container
//efine DFS_VD "07-12-2011" // JFS menu 'Find ANY after FORMAT' find any possible INODES
//efine DFS_VD "07-12-2011" // JFS 'IRS 0' sets inode wildcard, find any possible INODES
//efine DFS_VD "04-12-2011" // FAT sync warning text updated to mention FATSIM+FATWRIM as combo
//efine DFS_VD "04-12-2011" // ERROR active-extended changed to WARNING, and removed fix hint
//efine DFS_VD "04-12-2011" // NTFS automatically recognized in a type 0x12 recovery partition
//efine DFS_VD "04-12-2011" // JFS/HPFS PPB versus LVM driveletter mismatch warning when bootable
//efine DFS_VD "03-12-2011" // File recovery, ignore errors on searching from menu (optional)
//efine DFS_VD "03-12-2011" // Count BAD_STRUCTURE errors as failures on recover from list
//efine DFS_VD "03-12-2011" // JFS/HPFS BPB-letter shown in partition detailed view  (letter/data)
//efine DFS_VD "02-12-2011" // Added MBR recognition for Plop Boot Manager systems
//efine DFS_VD "02-12-2011" // Fix IMAGE cmd  for buffersize > 64Kb with 4096 byte sectors
//efine DFS_VD "01-12-2011" // Updates for MFT recordsize with > 512 byte sectors (fixup etc)
//efine DFS_VD "30-11-2011" // JFS IRS command sets Inode Recovery Signature, after quick format
//efine DFS_VD "26-10-2011" // Better reporting of bad fixup structures on NTFS system structures
//efine DFS_VD "02-10-2011" // make sure DFSDISK/DFSCHECK scripts run in batch mode (no popups)
//efine DFS_VD "01-10-2011" // Added OS-X HFS+ partition type 0xAF to partition type displays
//efine DFS_VD "02-09-2011" // Added MFT-seq nr to a few NTFS related error messages in CHECK
//efine DFS_VD "05-07-2011" // Fixed recalculate cylinders when H/S changes (broken in ver10.9)
//efine DFS_VD "05-07-2011" // Fixed incorrect assigning of IBM BMGR labels (Linux EBR sectors)
//efine DFS_VD "08-06-2011" // OS2 buffer Maximum buffer size phys disk I/O set to 127 (< 64Kb)
//efine DFS_VD "04-06-2011" // GEO source Ignore PT if sect/track larger than 63 (OS/2 huge disk)
//efine DFS_VD "04-06-2011" // GEO forced Always overrule existing geo when forced is set
//efine DFS_VD "30-05-2011" // PART lists Support sorting using Ctrl-F1 .. Ctrl-F9
//efine DFS_VD "26-05-2011" // DFSCHECK   Quit if user aborts the directory selection
//efine DFS_VD "23-05-2011" // File dlgs  Updated for generic sorting and larger sizes

//efine DFS_VN "10.9"       // Version used in reporting and regkey checks
//efine DFS_VD "10-06-2011" // OS2 buffer Maximum buffer size phys disk I/O set to 127 (< 64Kb)
//efine DFS_VD "04-06-2011" // GEO source Ignore PT if sect/track larger than 63 (OS/2 huge disk)
//efine DFS_VD "04-06-2011" // GEO forced Always overrule existing geo when forced is set

//efine DFS_VN "10.8"       // Version used in reporting and regkey checks
//efine DFS_VD "22-05-2011" // FORMAT     Auto refresh partition views to match new format
//efine DFS_VD "22-05-2011" // RUN    dlg Deprecate running .CMD scripts from within DFSee
//efine DFS_VD "18-05-2011" // FIND   dlg Allow double quote characters in search string values
//efine DFS_VD "18-05-2011" // FORMAT dlg Allow single quote characters in filesystem label field
//efine DFS_VD "18-05-2011" // FORMAT     Set bootcode type correctly for FAT32 -o:'9' = Win9x/ME
//efine DFS_VD "16-05-2011" // PART       Recognize large floppy with MSWIN4.1 correctly as FAT16
//efine DFS_VD "09-05-2011" // IMAGE etc  Set RW-RW-RW- file mode to newly created files on Linux and Mac

//efine DFS_VN "10.7"       // Version used in reporting and regkey checks
//efine DFS_VD "25-04-2011" // EDIT  <F2> Reset 'this' start lsn after selecting other object
//efine DFS_VD "25-04-2011" // File / DIR Binary edit Data (file/dir contents)  for a path
//efine DFS_VD "25-04-2011" // File / DIR Binary edit Info (fnode/inode/MFTrec) for a path
//efine DFS_VD "25-04-2011" // File / DIR Find or recover ONE file, now for Mode=FAT too
//efine DFS_VD "25-04-2011" // Mode=xxx   File Recovery menu renamed to "File Find/Recover/HEXedit"
//efine DFS_VD "24-04-2011" // OS/2 limit Warning 65535 cylinders, less frequently shown
//efine DFS_VD "25-04-2011" // FAT16 USB  Script to create a FAT16 data stick/disk; max 2Gb
//efine DFS_VD "24-04-2011" // DISK size  Linux better size/geometry support for disks >
//efine DFS_VD "22-04-2011" // PART       MiB and Cyl columns made wider for huge disks
//efine DFS_VD "06-04-2011" // PSAVE etc  Fixed size display for disks with 4Kb sectors
//efine DFS_VD "04-04-2011" // RESTORE    Support large files on Linux on auto-detect IMZ
//efine DFS_VD "04-04-2011" // IMZINFO    Support large files on Linux for info display
//efine DFS_VD "16-02-2011" // HEX edit   Speed up starting, and fixed spurious trap on start
//efine DFS_VD "16-02-2011" // MBR        Recognize another Linux/GRUB MBR variant
//efine DFS_VD "23-01-2011" // HEX edit   Buffer 2 items before/after current (large screens)
//efine DFS_VD "21-01-2011" // Startup    Add ADMIN hint if no disks are seen at all (WIN7)
//efine DFS_VD "21-01-2011" // BMGR menu  Default to current BMGR timeout on value-prompt
//efine DFS_VD "21-01-2011" // WARNING    Fixed %20.20s garbage text in a particular warning
//efine DFS_VD "19-01-2011" // alloc      Notify user when aborted, reset the Used/Free info
//efine DFS_VD "16-01-2011" // geocalc    Fixed trap when LVM DLAT is in a non-std location

//efine DFS_VN "10.6"       // Version used in reporting and regkey checks
//efine DFS_VD "10-01-2011" // DISK/CHECK menu items in 'SCRIPTS' attach submenu! (re-release)
//efine DFS_VD "08-01-2011" // MENU       Disabled items display 'reason' info on selection
//efine DFS_VD "07-01-2011" // MENU       Added 'Scripts' menu to run (standard) DFSee scripts
//efine DFS_VD "07-01-2011" // DFSF32ST   Script to partition+format a USB-stick using FAT32
//efine DFS_VD "03-01-2011" // SETB       Add -Q- option to suppress automatic-quit from a script
//efine DFS_VD "03-01-2011" // GEOCALC    DLAT for 255, 127, 63 preferred; duplicate warning
//efine DFS_VD "03-01-2011" // MBR        Recognize Lenovo factory preloaded MBR (W500)
//efine DFS_VD "03-01-2011" // MBR        Recognize generic english MBR from Windows-7
//efine DFS_VD "02-01-2011" // PART -fs:x Initialize for specified filesystem, not detected one
//efine DFS_VD "28-12-2010" // NTFS       Fix trap at open partition with corrupt LOGRECORD
//efine DFS_VD "04-12-2010" // SCAN       Reword message on using -b:1; Explain sector list
//efine DFS_VD "18-08-2010" // WARNING    Fix table entry for missing (1st) EBR signature

//efine DFS_VN "10.5"       // Version used in reporting and regkey checks
//efine DFS_VD "27-07-2010" // JFS        Display and edit of UUID value with "uuid" command
//efine DFS_VD "27-07-2010" // ReiserFS   Display and edit of UUID value with "uuid" command
//efine DFS_VD "27-07-2010" // EXT2/3     Display and edit of UUID value with "uuid" command
//efine DFS_VD "24-07-2010" // NTFS CHECK Better ALLOC message if no $Bitmap info available
//efine DFS_VD "22-07-2010" // ReiserFS   Fixed crash on selecting the Mode=Reiser menu
//efine DFS_VD "19-07-2010" // SLT/CHECK  Added lost/link area count/size summary on display
//efine DFS_VD "18-07-2010" // JFS CHECK  More verbose JFS IAG dump when pedantic (-p)
//efine DFS_VD "15-07-2010" // Warning    Volume-serial duplicate, reworded, only once.
//efine DFS_VD "14-07-2010" // Warning    Bootable JFS/HPFS without an LVM driveletter

//efine DFS_VN "10.4"       // Version used in reporting and regkey checks
//efine DFS_VD "23-05-2010" // JFS  LDR   Adjusted size to (now) documented 31 sectors (was 34)
//efine DFS_VD "23-05-2010" // JFS (boot) Display bootsector code updated to eCS 2.0 GA level
//efine DFS_VD "23-05-2010" // JFS (boot) Fixboot bootsector code updated to eCS 2.0 GA level
//efine DFS_VD "17-05-2010" // WARNING if LBA BR-offset smaller than sectors/track (LVM corrupt)
//efine DFS_VD "17-05-2010" // Resize flg in XML only set to YES for DFSee resizable filesystem

//efine DFS_VN "10.3"       // Version used in reporting and regkey checks
//efine DFS_VD "06-05-2010" // FAT open   Report dirty status on open (from Bootrec and FAT)
//efine DFS_VD "06-05-2010" // FAT DIRTY  Added check/update for documented flags in FAT area
//efine DFS_VD "02-05-2010" // FAT open   Dont search 2nd FAT if 1st not found (long delay)
//efine DFS_VD "01-05-2010" // geo        Fixed forcing GEO back to original values
//efine DFS_VD "01-05-2010" // linux      Fix for kernel 2.6.34 stat fail on large disks
//efine DFS_VD "10-04-2010" // setboot    -disk:nr option can force (BMGR) disk to work on
//efine DFS_VD "31-03-2010" // imz2raw    Fixed empty file bug (could not write after EOF)
//efine DFS_VD "31-03-2010" // geo        Retain correct base PSN if a partition was selected

//efine DFS_VN "10.2"       // Version used in reporting and regkey checks
//efine DFS_VD "28-03-2010" // geo        Retain correct base PSN if a partition was selected
//efine DFS_VD "28-03-2010" // MBR code   Recognize another variant of the OS/2 2.x MBR code
//efine DFS_VD "25-02-2010" // Menu       Create bootable USB stick, run DFSee DOS and Linux
//efine DFS_VD "25-02-2010" // Menu       Display -> Show Partition Table Sector, MBR or EBR
//efine DFS_VD "25-02-2010" // Menu       Wipe MBR sector for a disk (FDISK menu)
//efine DFS_VD "25-02-2010" // Menu       Wipe Bootsector for a partition (filesystem menus)
//efine DFS_VD "22-02-2010" // Restore    No 'reboot' popup when only verifying
//efine DFS_VD "20-02-2010" // RUN cmd    Fix problem with quoting (spaces, params)
//efine DFS_VD "20-02-2010" // LVM dialog Indicate 'sync LVM engine' as NOT RECOMMENDED
//efine DFS_VD "20-02-2010" // Menu Wipe  Added comment on removables to final message
//efine DFS_VD "20-02-2010" // Menu Wipe  Start of disk, now wipes 32 MiB instead of 10
//efine DFS_VD "12-01-2010" // Menu BM/LVM removed duplicate shortcut letter 'I'

//efine DFS_VN "10.1"       // Version used in reporting and regkey checks
//efine DFS_VD "12-01-2010" // FDISK/BM   Menu, duplicate selection letter 'I' removed
//efine DFS_VD "01-01-2010" // MENU       Format: avoid find 2nd FAT area (very slow!)
//efine DFS_VD "01-01-2010" // MBR code   Recognize PendriveLinux Multi-ISO boot from USB
//efine DFS_VD "30-12-2009" // MBR NTsig  Changed default to DF5ee100, eye catcher value
//efine DFS_VD "30-12-2009" // AUX mode   Add warning popup if AUX mode is initialized
//efine DFS_VD "27-12-2009" // STORE      Use A/B instead of 1/2 as store identification
//efine DFS_VD "26-12-2009" // FORMAT FAT Fixed system label to contain 10.x (use VLABEL)
//efine DFS_VD "26-12-2009" // SCAN menu  Force '-E:i' to always retry with single sector
//efine DFS_VD "26-12-2009" // SCAN       Fix reported count when error-strategy is 'quit'
//efine DFS_VD "25-12-2009" // WARNING    Size exceeds the normal OS/2 65535 cylr => INFO
//efine DFS_VD "20-11-2009" // FDISK menu Prestore dialog added comment on restore types

//efine DFS_VN "10.0"       // Version used in reporting and regkey checks
//efine DFS_VD "02-11-2009" // QUERY      Fix reported major version as 10 instead of 1
//efine DFS_VD "01-11-2009" // SCAN       Fix progress reporting when not at LSN 0
//efine DFS_VD "14-10-2009" // CR         No size adjust primary, if not at MBR track
//efine DFS_VD "12-10-2009" // CR         Align to cyl-start if prev END is not aligned
//efine DFS_VD "12-10-2009" // PART view  Show decimal size in sectors if no LVM/BMGR
//efine DFS_VD "12-10-2009" // RESIZE and EXPAND added '?' and '-?' help on command
//efine DFS_VD "12-10-2009" // CLONE      Add popup advising to REBOOT after cloning
//efine DFS_VD "09-10-2009" // Warning 0F Made type 0x0F extended a minor warning
//efine DFS_VD "08-09-2009" // Menu       Fdisk -> Wipe (EBR) TRACK-1 reserved sectors
//efine DFS_VD "29-08-2009" // Menu       Edit->Settings->Status prompt after each command
//efine DFS_VD "29-08-2009" // HEX dump   Default size full sector if display >= 40 lines
//efine DFS_VD "28-08-2009" // JFS super  Always warn for superblocks/part size mismatch
//efine DFS_VD "01-08-2009" // 502G disk  OS/2 warning if disk > 502 GiB normal limit
//efine DFS_VD "01-08-2009" // 64K warn   OS/2 or eCS incompatible with > 64K cylinders
//efine DFS_VD "01-08-2009" // CHS warn   No CHS warnings if #sects > 63 (eCS > 500Gb)
//efine DFS_VD "19-06-2009" // KEY        Support major versions over 9 in key checks
//efine DFS_VD "19-06-2009" // CSLIST -s  Add cylinder-aligned sectors to sector-list
//efine DFS_VD "26-06-2009" // A sn size  Fixed multi sector ASCII display output format
//efine DFS_VD "26-06-2009" // FAT        Fixed display bugs with just one FAT area
//efine DFS_VD "12-06-2009" // LIST       Export/Import store/display drive/disk/part
//efine DFS_VD "10-06-2009" // LIST       Export/Import preserves list display format
//efine DFS_VD "06-04-2009" // WARNING    Linux device-nr too large, only for nr > 63
//efine DFS_VD "22-03-2009" // PTE        No 'smart' field updates when type set to 0
//efine DFS_VD "22-03-2009" // PART -xml  Show Linux UUID value for native filesystems
//efine DFS_VD "22-03-2009" // PART -s -u Show Linux UUID value for native filesystems
//efine DFS_VD "22-03-2009" // PART -v    Show Linux UUID value for native filesystems
//efine DFS_VD "22-03-2009" // PART pid   Show Linux UUID value for native filesystems

//efine DFS_VN "9.15"
//efine DFS_VD "21-03-2009" // RESTORE partition info, extra confirmation when no prompts
//efine DFS_VD "21-03-2009" // SAVETO  Warning to use ANOTHER partition as destination
//efine DFS_VD "21-03-2009" // RECOVER Warning to use ANOTHER partition as destination
//efine DFS_VD "21-03-2009" // MENU    File, open object, Freespace area as logical
//efine DFS_VD "16-03-2009" // EDIT    Split display of very long filename on title
//efine DFS_VD "16-03-2009" // EDIT    Allow spaces in path+filename
//efine DFS_VD "16-03-2009" // EDIT    Hex file, used item size dependent on screen
//efine DFS_VD "13-03-2009" // RESTORE Show restored size/offset with -S option
//efine DFS_VD "12-03-2009" // RESTORE Fixed restore of .IMG file with -S option
//efine DFS_VD "12-03-2009" // RESTORE Fixed restore to 'corrupt' (NTFS) partition
//efine DFS_VD "07-03-2009" // FORMAT  Support 2048 byte sectors (FAT filesystems)
//efine DFS_VD "05-03-2009" // FAT     Fix open/format traps with 2048 byte sectors
//efine DFS_VD "14-02-2009" // EDIT    "File in Binary Editor", textual menu change

//efine DFS_VN "9.14"
//efine DFS_VD "07-02-2009" // RESIZE  Fix 'ACTIVE' flag lost on expand (again)
//efine DFS_VD "16-01-2009" // ntsign  Added -query and -v display options
//efine DFS_VD "07-12-2008" // Profile Correctly execute from path with spaces
//efine DFS_VD "31-10-2008" // MBR id  Recognize 'Symantec/Norton Partition Magic'
//efine DFS_VD "19-10-2008" // PART -V Fixed display of HPFS spare sector (0x11)

//efine DFS_VN "9.13"
//efine DFS_VD "11-10-2008" // PART    Fixed freespace formatting for Linux/MAC
//efine DFS_VD "11-10-2008" // HELP    Added Partition Type help chapter
//efine DFS_VD "11-10-2008" // Profile template now 'proftemp.dfs' user: profile.dfs
//efine DFS_VD "11-10-2008" // RESIZE  No change part to HIDDEN (multiple vis prim)
//efine DFS_VD "11-10-2008" // COPY    No change part to HIDDEN (multiple vis prim)
//efine DFS_VD "11-10-2008" // MOVE    No change part to HIDDEN (multiple vis prim)
//efine DFS_VD "11-10-2008" // LVM dlg Updated help for driveletters and 'sync LVM'
//efine DFS_VD "10-09-2008" // MENU    Fixed 'filename with spaces' issues for IM etc
//efine DFS_VD "01-09-2008" // GENPART Use explicit HEX partition-type in the script
//efine DFS_VD "01-09-2008" // MOVE    Make MOVE/COPY commands use explicit HEX type
//efine DFS_VD "01-09-2008" // MOVE    Display overview as a table, not as a 'map'
//efine DFS_VD "01-09-2008" // PART    Partition type 0xBC (acronis-ZS)  recognized
//efine DFS_VD "01-09-2008" // PART    Partition type 0xBF (Solaris ZFS) recognized

//efine DFS_VN "9.12"
//efine DFS_VD "30-08-2008" // SCRIPT  Fix broken function-name parsing in ver 9.11
//efine DFS_VD "29-08-2008" // PART    Make labels (-b-) the default for Linux/MAC
//efine DFS_VD "27-08-2008" // MENU    Make 'change partitiontype' use explicit HEX
//efine DFS_VD "26-08-2008" // DIALOGS image, restore, clone, create; fix HEX numbers
//efine DFS_VD "25-08-2008" // TYPE    Set 'class' of 2nd parameter to be part-type
//efine DFS_VD "24-08-2008" // SERIAL  Changed parameter to be decimal by default
//efine DFS_VD "24-08-2008" // NTSIGN  Changed parameter to be decimal by default

//efine DFS_VN "9.11"
//efine DFS_VD "22-08-2008" // MFT/INO Generate explicit HEX sector numbers as commands
//efine DFS_VD "16-08-2008" // Numbers Allow hex/dec/octal on most parameter values
//efine DFS_VD "14-08-2008" // Numbers Changed default radix for ALL values to DECIMAL
//efine DFS_VD "14-08-2008" // MENU    'Find and Recover ONE file' for HPFS/NTFS/JFS
//efine DFS_VD "13-08-2008" // MENU    Add help on built-in functions and variables
//efine DFS_VD "13-08-2008" // RUN     Help on built-in functions and host variables
//efine DFS_VD "08-08-2008" // MENU    Added/Moved 'Find ONE file/dir' by full path
//efine DFS_VD "02-08-2008" // JFS     Minor textual update in filefind dialog text

//efine DFS_VN "9.10"
//efine DFS_VD "20-07-2008" // FAT FS  Hint to use FORMAT when bootsector is empty
//efine DFS_VD "25-06-2008" // SETBOOT Allow colon on /IBD:C: syntax
//efine DFS_VD "18-06-2008" // MEDIA   Allow upto 24 IDE/SCSI disk on Linux (hdX/sdX)
//efine DFS_VD "02-06-2008" // PART    Added details to 'invalid partition table nr'

//efine DFS_VN "9.09"
//efine DFS_VD "24-05-2008" // CR      Do NOT clear BBR on type 0x35 for 'create NEW'

//efine DFS_VN "9.08"
//efine DFS_VD "18-04-2008" // RESTORE Added informational REBOOT message popup at end
//efine DFS_VD "24-03-2008" // CR      Clear BBR on type 0x35 for 'create NEW mode'
//efine DFS_VD "02-03-2008" // RESIZE  Added 'limitations' to help, supported FS

//efine DFS_VN "9.07"
//efine DFS_VD "22-02-2008" // QUERY   DR/PR option tests for removable disk/partition
//efine DFS_VD "22-02-2008" // QUERY   DY option tests for 'large floppy format' disk
//efine DFS_VD "11-02-2008" // SET VAR command, $var substitution in commands ON/OFF
//efine DFS_VD "11-02-2008" // -$-     EXE switch, $var substitution in commands OFF
//efine DFS_VD "26-01-2008" // PART    Changed 0x12 type description to 'Recovery'
//efine DFS_VD "26-01-2008" // LVMsync Fixed close-all-disks before using LVM engine
//efine DFS_VD "26-01-2008" // SLT dlg Minor textual update to cancel-SLT build popup

//efine DFS_VN "9.06"
//efine DFS_VD "12-01-2008" // warnings Duplicate driveletters, extra text for WIN
//efine DFS_VD "03-01-2008" // debug    Added some more trace in SelDestroy etc (Felix)
//efine DFS_VD "03-01-2008" // Defaults Set bad-sector retries to be -A:1 (was 5)

//efine DFS_VN "9.05"
//efine DFS_VD "01-01-2008" // disk R/W Allow OS2 PhysDisk handle-value 0 (TSHELL)
//efine DFS_VD "28-12-2007" // menu run Allow DFSee quit from script ran from the menu
//efine DFS_VD "27-12-2007" // run      Abort script when parameter prompt is canceled
//efine DFS_VD "23-12-2007" // geocalc  Allow sectors/track upto 255 (DANIS506, 2TiB)
//efine DFS_VD "16-12-2007" // list     Fixed DecimValue for large values non-FAT FS
//efine DFS_VD "14-12-2007" // part     Warnings about 'large floppy' FAT32 on OS/2
//efine DFS_VD "14-12-2007" // format   Warnings about 'large floppy' FAT32 on OS/2
//efine DFS_VD "14-12-2007" // quit     Do not exit with the DFS_QUIT value as rc

//efine DFS_VN "9.04"
//efine DFS_VD "09-12-2007" // geocalc  Ignore deleted (type 00) partitions in MBR tables
//efine DFS_VD "09-12-2007" // CR menu  Fixed enable/disable of CR/BM-install menu items
//efine DFS_VD "08-12-2007" // SET geo  Set 'geocalc' contents based geometry ON or OFF
//efine DFS_VD "07-12-2007" // SCRIPT   Ignore errors, and handle $_rc system variable
//efine DFS_VD "28-11-2007" // LVM  -c  Fix drive-link sequence numbers that are ZERO
//efine DFS_VD "28-11-2007" // PART xml Add specific warning for LVM sequence-nr ZERO
//efine DFS_VD "27-11-2007" // LVM      Set correct drive-link seq-nr (P#1262, Mantis 1572)

//efine DFS_VN "9.03"
//efine DFS_VD "25-11-2007" // expire   Set expiration for unregistred to 55 days
//efine DFS_VD "25-11-2007" // SCRIPT   Do not execute lines resolving to empty string
//efine DFS_VD "20-11-2007" // SCRIPT   Fix empty string variables like $_p_label
//efine DFS_VD "28-10-2007" // CLONE    pri-to-pri, fix automatic FIXPBR 'to' part
//efine DFS_VD "28-10-2007" // MENU JFS fixboot, driveletter prompt for bootable JFS
//efine DFS_VD "27-10-2007" // SCRIPT   Allow direct disk-read using $_b_sector[secnr]
//efine DFS_VD "23-10-2007" // JFS      Fixed minor display bug in Inode allocation
//efine DFS_VD "20-10-2007" // CMDLINE  Allow input of <> when not at start cmdline
//efine DFS_VD "20-10-2007" // CMDLINE  Implemented DFSee host variables $_name
//efine DFS_VD "20-10-2007" // RESIZE   Fixed 'ACTIVE' flag being lost on expand
//efine DFS_VD "19-10-2007" // LIST -c  Fixed incorrect leading '-l-' option
//efine DFS_VD "17-10-2007" // CMDLINE  Support $variable and {expression} evaluation

//efine DFS_VN "9.02"
//efine DFS_VD "10-10-2007" // MENU2HTML -h option generates static HTML, not PHP
//efine DFS_VD "04-10-2007" // PART     -xml added 'beyondenddisk' warning property
//efine DFS_VD "04-10-2007" // OEMSV    Set geoCalc global switch default OFF
//efine DFS_VD "04-10-2007" // MBR      Added Windows Vista MBR recognition
//efine DFS_VD "03-10-2007" // create   Fix type freespace on cr log between prim
//efine DFS_VD "03-10-2007" // wipet1   Fixed size to be wiped (decimal, not hex!)
//efine DFS_VD "01-10-2007" // MENU     Add 'wipe first disk track' (except MBR/LVM)
//efine DFS_VD "01-10-2007" // NTFS     next-lsn preserved on auto-display related MFT
//efine DFS_VD "01-10-2007" // skipfs   startup switch, skips Fs on part listing
//efine DFS_VD "25-09-2007" // fstype   0x27 for IFShidden, like VISTA pre-install
//efine DFS_VD "20-09-2007" // CLEANUP  Fix reset ACTIVE primary, on delete logical
//efine DFS_VD "19-09-2007" // CLEANUP  Add reset ACTIVE for logicals, rework code
//efine DFS_VD "17-09-2007" // FIXBOOT  Fixed bootcode bug for FAT32/Win9x bootcode
//efine DFS_VD "15-09-2007" // OUTPUT   Added separator line between command output
//efine DFS_VD "13-09-2007" // MENU     Disable Bootmanager items if not present
//efine DFS_VD "11-09-2007" // ABOUT    registration key text for temporaries

//efine DFS_VN "9.01"
//efine DFS_VD "09-09-2007" // New 'Bootmanager install' menu item in Mode=FDISK
//efine DFS_VD "07-09-2007" // Improved FAT filerecovery search options handling
//efine DFS_VD "07-09-2007" // Added 'alloc map, F9, to Reiser and EXT2+3 menus
//efine DFS_VD "07-09-2007" // Fix MOVE to begin freespace, fail to clone (smart)
//efine DFS_VD "06-09-2007" // Add 'BJFS' for a bootable JFS partition type 0x07
//efine DFS_VD "03-09-2007" // dont close default store when 'large-floppy' present
//efine DFS_VD "01-09-2007" // avoid 2nd dialog after clone size warning popup
//efine DFS_VD "31-08-2007" // partition selection lists, skip empty disks
//efine DFS_VD "29-08-2007" // unmount   from menu, allow 'dummy' disks too
//efine DFS_VD "27-08-2007" // menu2html command and a few minor text updates

//efine DFS_VN "9.00"
//efine DFS_VD "15-08-2007" // Disasm Push/Pop RET and <F5> code walking

//efine DFS_V "9.00 10-08-2007" // Release  minor script parameter fix ...
//efine DFS_V "9.rc 07-08-2007" // READ     Allow read outside partition (GRUB)
//efine DFS_V "9.b7 07-08-2007" // SWAP     New mode, allows smart disk imaging
//efine DFS_V "9.b7 06-08-2007" // REISER   Implemented alloc and smart imaging
//efine DFS_V "9.b7 05-08-2007" // VIRT     from .PDx, auto restore of .IMx file
//efine DFS_V "9.b7 05-08-2007" // MENU     BMGR to Fdisk -> OS/2 LVM/BMGR ...
//efine DFS_V "9.b7 04-08-2007" // DISASM   Added Jump. Goto, Save, set origin
//efine DFS_V "9.b7 03-08-2007" // DISASM   Built into Hex-Editor on <F2> key
//efine DFS_V "9.b7 31-07-2007" // TRACE    Set cyclic trace to 9 files in menu
//efine DFS_V "9.b7 31-07-2007" // RESTORE  Fix spurious CHS popup in complete
//efine DFS_V "9.b7 31-07-2007" // RESTORE  (verify) updated confirmation text
//efine DFS_V "9.b6 29-07-2007" // APMAP    Show Apple-Part-MAP in first track
//efine DFS_V "9.b5 28-07-2007" // RESIZE   Enable menu for FAT/HPFS/NTFS only
//efine DFS_V "9.b5 28-07-2007" // DIRTY    Update global dirty flag too (menu)
//efine DFS_V "9.b5 27-07-2007" // FAT12    Fix wrong output on large clusters
//efine DFS_V "9.b5 27-07-2007" // DFSCHECK DFSDISK, minor menu / dialog update
//efine DFS_V "9.b5 26-07-2007" // PART -b- Added label info for EXT2/3 +Reiser
//efine DFS_V "9.b5 26-07-2007" // SWAP     Identify Linux type 1/2 version 0/1
//efine DFS_V "9.b5 25-07-2007" // GRUB     Correct partition display stage 1.5
//efine DFS_V "9.b5 24-07-2007" // PART -b  Add 'related' column for Linux ldr
//efine DFS_V "9.b5 24-07-2007" // WARNING  For sda/hda devicenumber too large
//efine DFS_V "9.b4 23-07-2007" // GRUB     Stage 1.5/2 code analysis & display
//efine DFS_V "9.b4 22-07-2007" // FIXBOOT  Driveletter prompt in JFS/HPFS menu
//efine DFS_V "9.b3 18-07-2007" // PART     GRUB summary on -v and -q, if present
//efine DFS_V "9.b3 17-07-2007" // GRUB     Display summary on GRUB MBR sectors
//efine DFS_V "9.b3 17-07-2007" // GRUB     Display details on GRUB bootsectors
//efine DFS_V "9.b2 16-07-2007" // Mode=HFS in menu, recognition in PART display
//efine DFS_V "9.b2 16-07-2007" // Mode=XFS in menu, recognition in PART display
//efine DFS_V "9.b2 14-07-2007" // geocalc  Add LVM DLAT disksize sanity check
//efine DFS_V "9.b2 13-07-2007" // FILEFIND Dialog, add 'search from current'
//efine DFS_V "9.b2 13-07-2007" // GRUB     Identify GRUB/LILO non-MBR sectors
//efine DFS_V "9.b1 12-07-2007" // warnings Suppress disk-warnings too on -w-
//efine DFS_V "9.00 10-07-2007" // geocalc  Contents based geometry determination
//efine DFS_V "9.00 10-07-2007" // OS-cmds  Allow external cmds on DOS/OS2 only
//efine DFS_V "9.00 10-07-2007" // Linux    Recognize JFS FS in 0x83 partition
//efine DFS_V "9.00 09-07-2007" // FIXBOOT  Retain (boot) letter on JFS/HPFS
//efine DFS_V "9.00 09-07-2007" // warnings made aware of DFSee I13X patches
//efine DFS_V "9.00 06-07-2007" // menu     Updated bmfix menu and help text
//efine DFS_V "9.00 05-07-2007" // BMFIX    BMGR, default to NO I13X check
//efine DFS_V "9.00 04-07-2007" // FIXBOOT  HPFS, default to NO I13X check
//efine DFS_V "9.00 28-06-2007" // geocalc  startup switch, calculate geo
//efine DFS_V "9.00 28-06-2007" // PART     Fixed trap on garbage BMP sector
//efine DFS_V "9.00 28-06-2007" // HPFS id  Fixed false 'alloc sector' ident
//efine DFS_V "9.00 27-06-2007" // LinuxLVM Added to CR and change-type lists
//efine DFS_V "9.00 25-06-2007" // WARNING  Toned down 'HiddenSectors' warning
//efine DFS_V "9.00 21-06-2007" // EXT2/3   Area aware alloc logic (smart disk)
//efine DFS_V "9.00 20-06-2007" // EXT2/3   Implemented allocation logic, smart
//efine DFS_V "9.00 20-06-2007" // GEO      Bad si->Sectors causes GEO overflow
//efine DFS_V "9.00 18-06-2007" // EXT2/3   Add group descriptor read & display
//efine DFS_V "9.00 17-06-2007" // SERIAL   Improved batchmode and popup text
//efine DFS_V "9.00 16-06-2007" // EBR show classic IBM Bootmanager menu name
//efine DFS_V "9.00 15-06-2007" // VCU      Fixed for disks with no primaries
//efine DFS_V "9.00 14-06-2007" // PART     Improved rounding MiB size values
//efine DFS_V "9.00 14-06-2007" // LVM -n   Fix trap when no BootDiskId set yet
//efine DFS_V "9.00 14-06-2007" // MENU     Made 'Bootmanager menu Add' generic
//efine DFS_V "9.00 14-06-2007" // JFS      Better sanity check on IAG struct
//efine DFS_V "9.00 12-06-2007" // EXT2     Added info to superblock display
//efine DFS_V "9.00 09-06-2007" // DARWIN   Port for MAC OS X built on GCC 4.x
//efine DFS_V "8.17 07-09-2007" // Fix MOVE to begin freespace, fail to clone
//efine DFS_V "8.16 08-06-2007" // CLONE    Fixed disk-to-disk clone bug on FAT
//efine DFS_V "8.16 08-06-2007" // RESIZE   Expand LOGICAL fail, fix alignment
//efine DFS_V "8.16 13-05-2007" // EDIT hex 32-byte wide startup at 140 columns
//efine DFS_V "8.16 13-05-2007" // SCAN     New -skipbads option, default 1MiB
//efine DFS_V "8.16 12-05-2007" // CR       Fix IBM bmgr LSN strings in EBR's
//efine DFS_V "8.15 04-05-2007" // HEXedit  Fixed initial cursor positioning
//efine DFS_V "8.15 02-05-2007" // PTE dlg  New F2/F5/F8 for direct HEX edit
//efine DFS_V "8.15 02-05-2007" // LVM dlg  New F2/F5/F8 for direct HEX edit
//efine DFS_V "8.15 02-05-2007" // IAG *    Display ALL JFS Inode Alloc Groups
//efine DFS_V "8.15 30-04-2007" // CR -G:n  GAP between p-table and bootsector
//efine DFS_V "8.15 30-04-2007" // PART     Recognize empty GRUB MBR correctly
//efine DFS_V "8.15 25-04-2007" // MENU     Add IAG structure display items
//efine DFS_V "8.15 25-04-2007" // IAG      New command to display IAG info
//efine DFS_V "8.15 24-04-2007" // JFS      Add IAG structure identify/display
//efine DFS_V "8.15 17-04-2007" // JFS open More info on corrupted IAG data
//efine DFS_V "8.15 14-04-2007" // CLEANUP  Fix flag values on logicals too
//efine DFS_V "8.14 12-04-2007" // MENU vol Open volume, warn if also partiton
//efine DFS_V "8.14 12-04-2007" // RESIZE   Fix max size for FAT on expanding
//efine DFS_V "8.14 12-04-2007" // RESIZE   Fix start on non-aligned partition
//efine DFS_V "8.14 12-04-2007" // PART -w  Reworded GPT/EFI warning incl iMAC
//efine DFS_V "8.14 12-04-2007" // PART -w  Add warning I13X BMGR, no I13X MBR
//efine DFS_V "8.14 10-04-2007" // LVMSHOW  fixed for partition on other disks
//efine DFS_V "8.14 08-04-2007" // Filename in dialogs, preserve single-quotes
//efine DFS_V "8.14 03-04-2007" // PART     Warning on primary in EXT container
//efine DFS_V "8.14 30-03-2007" // LVM      Allow setting driveletter '*'
//efine DFS_V "8.14 29-03-2007" // PTE      Custom sort order fields + button
//efine DFS_V "8.14 28-03-2007" // DFSCHECK add Reiser and Ext2/3 filesystems
//efine DFS_V "8.13 25-03-2007" // JFS      Fix crash on garbage superblock
//efine DFS_V "8.13 19-03-2007" // FORMAT   Use 1-sector wipe on quick-format
//efine DFS_V "8.13 19-03-2007" // FIND     Fix matching on FAT filenames
//efine DFS_V "8.13 19-03-2007" // BOOTINI  on FAT, fixed searching as ASCII
//efine DFS_V "8.13 12-03-2007" // MENU     Display -> LVM; show partition(s)
//efine DFS_V "8.13 13-03-2007" // LVMSHOW  fix display for specific partition
//efine DFS_V "8.13 12-03-2007" // MENU     Add specific MBR code save/restore
//efine DFS_V "8.13 12-03-2007" // COPY and MOVE, fix offset for 1st primary
//efine DFS_V "8.13 09-03-2007" // REGKEY   Verbose identification and status
//efine DFS_V "8.13 08-03-2007" // MENU     File -> Open Part/Volume verbose
//efine DFS_V "8.13 08-03-2007" // SUPER 2  JFS, display secondary superblock
//efine DFS_V "8.13 07-03-2007" // CLONE    Reword error msg on open TO store
//efine DFS_V "8.13 05-03-2007" // CR/LVM   No clear BBR area on new type 35
//efine DFS_V "8.13 05-03-2007" // OS2 I/O  Fix Ioctl TrackLayout param size
//efine DFS_V "8.12 04-03-2007" // CHECK    NTFS, fix error on split-tree DIR
//efine DFS_V "8.12 04-03-2007" // RESIZE   NTFS, avoid empty bitmap extent
//efine DFS_V "8.12 04-03-2007" // RESIZE   NTFS, avoid extra bitmap flushing
//efine DFS_V "8.12 03-03-2007" // FORMAT   Use drive locking (on OS2/Win)
//efine DFS_V "8.12 03-03-2007" // STORE    Better store description texts
//efine DFS_V "8.12 02-03-2007" // NTFS     Recognize VISTA NTLDR sectors
//efine DFS_V "8.12 01-03-2007" // MENU     Set Partition -> Not Active
//efine DFS_V "8.12 28-02-2007" // PART -b  Align freespace lines for Linux
//efine DFS_V "8.12 28-02-2007" // CR dlg   Fix size=1 sticking after BMGR
//efine DFS_V "8.12 26-02-2007" // LOCK     Allow lock large floppy by letter
//efine DFS_V "8.12 25-02-2007" // PART     Align and maximize LVM column
//efine DFS_V "8.12 25-02-2007" // LVM dlg  Fixed driveletter with synclvm
//efine DFS_V "8.12 25-02-2007" // MENU     Fixed 'FS-check all partitions'
//efine DFS_V "8.12 24-02-2007" // FORMAT   Verify ZEROED FATs by read back
//efine DFS_V "8.12 24-02-2007" // WIPE -V  All sector verify by read back
//efine DFS_V "8.12 24-02-2007" // RESIZE   Allow '*' for default size in dlg
//efine DFS_V "8.12 20-02-2007" // MAP      Fixed display of driveletter line
//efine DFS_V "8.11 18-02-2007" // BOOTSECT enhanced display, BPB-Geo, JFS
//efine DFS_V "8.11 18-02-2007" // WIPEDIDK Menu, added reboot advise message
//efine DFS_V "8.11 18-02-2007" // MENU FMT OS2LDR.s LargeFlopDx volume label
//efine DFS_V "8.11 17-02-2007" // MENU     Cleaned up Actions FORMAT menus
//efine DFS_V "8.11 17-02-2007" // GEO/DISK Fixed layout of forced geo lines
//efine DFS_V "8.11 16-02-2007" // RESTORE  Add explanation 'next file' .img
//efine DFS_V "8.11 15-02-2007" // MENU     Actions -> Format current object
//efine DFS_V "8.11 14-02-2007" // PART     Set Mode=FS based on P-type too
//efine DFS_V "8.11 14-02-2007" // FORMAT + FIXBOOT with Veit's OS2LDR.SEK
//efine DFS_V "8.11 13-02-2007" // IMAGE    Dialog, fix empty 'start' value
//efine DFS_V "8.11 13-02-2007" // RESTORE  Dialog, fix empty 'start' value
//efine DFS_V "8.11 11-02-2007" // MAP -m   Reworded int13 limit message line
//efine DFS_V "8.11 10-02-2007" // MENU     Remove mode=FDISK duplicate 'D'
//efine DFS_V "8.11 03-02-2007" // RESIZE   Fix (b2) crash in resize FAT32 FS
//efine DFS_V "8.11 03-02-2007" // LVMsync  Change default to NO synchronize!
//efine DFS_V "8.11 02-02-2007" // LVM      Remove -J option from help/usage
//efine DFS_V "8.11 01-02-2007" // LVM      Create Bad Block Feature LVM type
//efine DFS_V "8.11 31-01-2007" // LVM      Create DriveLink Feature LVM type
//efine DFS_V "8.11 31-01-2007" // LVM      Suppress 'BAD' warning on fakeEBR
//efine DFS_V "8.11 31-01-2007" // LVM      Create fakeEBR sector for LVM type
//efine DFS_V "8.11 28-01-2007" // LVM      Create basic LVM signature sector
//efine DFS_V "8.11 23-01-2007" // MENU     No removables on BMGR boot list
//efine DFS_V "8.11 21-01-2007" // PART     Show 'r' for removable large floppy
//efine DFS_V "8.11 21-01-2007" // MAP      Show Large Floppy in green (FAT)
//efine DFS_V "8.11 20-01-2007" // PL lvm   Fix display Bad-Block-feature sec
//efine DFS_V "8.11 19-01-2007" // RESTORE  Fixed display buffersize for .img
//efine DFS_V "8.11 19-01-2007" // LVM dlg  Allow empty fields to mean delete
//efine DFS_V "8.11 18-01-2007" // MAP      Show large floppy, fsform, plabel
//efine DFS_V "8.11 17-01-2007" // PART     Show large floppy, fsform, plabel
//efine DFS_V "8.11 17-01-2007" // PART     Added disk warning 'large floppy'
//efine DFS_V "8.11 16-01-2007" // SETBOOT  Display (LVM) driveletter on -list
//efine DFS_V "8.11 13-01-2007" // PART -n  Fix Linux header  (or part -n -b)
//efine DFS_V "8.10 09-01-2007" // PART     Warn on duplicate letters (clone)
//efine DFS_V "8.10 07-01-2007" // FIXEXT   Fix write buf-addr (corruption!)
//efine DFS_V "8.10 05-01-2007" // FILEFIND Fix trap in mode=FDISK, many cmds
//efine DFS_V "8.10 03-01-2007" // PART     Fix > 512 crash (in Correlate!)
//efine DFS_V "8.10 23-12-2006" // RESTORE  Fix reported size on start != 0
//efine DFS_V "8.10 23-12-2006" // TxAlloc  Function replaces macro in TRACE
//efine DFS_V "8.09 21-12-2006" // RESTORE  -S option uses start from IMZ hdr
//efine DFS_V "8.09 21-12-2006" // LVM MENU Explicit 'Bootmanager menu Delete'
//efine DFS_V "8.09 20-12-2006" // FS MENU  Change volume serial number
//efine DFS_V "8.09 20-12-2006" // FS MENU  Any/all filefind HPFS,NTFS,JFS
//efine DFS_V "8.09 20-12-2006" // FILEFIND -a option, find any/all files
//efine DFS_V "8.09 20-12-2006" // SERIAL   New cmd to set volume serial nr
//efine DFS_V "8.09 19-12-2006" // RBUF etc Made code allow any sectorsize
//efine DFS_V "8.09 17-12-2006" // PART     CRC32 (trace) allow 4Kb sectors
//efine DFS_V "8.09 17-12-2006" // PART     Limit BMGR area for 4Kb sectors
//efine DFS_V "8.09 16-12-2006" // FIXBOOT  JFS, fix label for bootable JFS
//efine DFS_V "8.09 16-12-2006" // S_BOOTR  Dynamic alloc, any sectorsize
//efine DFS_V "8.09 15-12-2006" // PART     BMPI buffer allow any sectorsize
//efine DFS_V "8.09 11-12-2006" // FAT INIT Detect corrupted 'EA DATA .SF'
//efine DFS_V "8.09 09-12-2006" // DFSCHECK Increased imz size to 600 sectors
//efine DFS_V "8.09 07-12-2006" // PART     BSIZE buffers allow 2 4Kb sectors
//efine DFS_V "8.09 15-11-2006" // MENU     JFS text now 'Unmounted & Clean'
//efine DFS_V "8.09 14-11-2006" // PART dr  Fix trap when tracing (Julian)
//efine DFS_V "8.09 14-11-2006" // PART -b  Table with FS and size in blocks
//efine DFS_V "8.08 11-11-2006" // QUERY    PN/DN/DX LVM info on disk/part
//efine DFS_V "8.08 10-11-2006" // LVMREDO  Added to 'known fdisk' commands
//efine DFS_V "8.08 09-11-2006" // PART dr  Allow select for '-c' LVM letter
//efine DFS_V "8.08 08-11-2006" // MENU     FAT, add 'Reset bad sectors'
//efine DFS_V "8.08 08-11-2006" // NOBADS   Reset bad-clusters in FAT1/2
//efine DFS_V "8.08 08-11-2006" // FAT FS   Fix to use FAT1 by default, not 2
//efine DFS_V "8.08 08-11-2006" // MENU     HPFS, add 'Reset bad sectors'
//efine DFS_V "8.08 08-11-2006" // NOBADS   HPFS, reset bad-sector-list
//efine DFS_V "8.08 07-11-2006" // MENU     NTFS, add 'Reset bad sectors'
//efine DFS_V "8.08 06-11-2006" // PTE      'SORT' button sorts on startsect
//efine DFS_V "8.08 04-11-2006" // NOBADS   NTFS, reset $BadClus, to NO bads
//efine DFS_V "8.08 30-10-2006" // IMAGE -P Fix wrong size to do (read error)
//efine DFS_V "8.08 27-10-2006" // FINDROOT NTFS, fixed trap on random data
//efine DFS_V "8.08 21-10-2006" // NTSIGN   Fixed confirmation non-windowed
//efine DFS_V "8.08 21-10-2006" // NTSIGN   Added description and usage on '-?'
//efine DFS_V "8.08 19-10-2006" // PART     Add warnings on EBR BACKWARD/LOOP
//efine DFS_V "8.08 16-10-2006" // PART-xml Add flag1/2 and fixpbr/chs hints
//efine DFS_V "8.08 13-10-2006" // PART-xml Added 'installable' flag value
//efine DFS_V "8.08 22-09-2006" // MENU     Removed 'F9' from 'Disk and Media'
//efine DFS_V "8.07 18-09-2006" // CLONE    Ignore FS-damage on open partition
//efine DFS_V "8.07 10-09-2006" // Screen   7-bit default on Linux (-7-)
//efine DFS_V "8.07 07-09-2006" // RECOVER  JFS/NTFS preserve file timestamps
//efine DFS_V "8.07 06-09-2006" // CHECK    JFS/HPFS added recursion guard
//efine DFS_V "8.07 06-09-2006" // PART-xml Updated for XUL eCS installer
//efine DFS_V "8.07 05-09-2006" // MOVE and COPY, added abort-confirmation
//efine DFS_V "8.07 31-08-2006" // PART-xml Generate XML partition overview
//efine DFS_V "8.07 26-08-2006" // FIXBOOT  NTFS, use default for MFTcopy
//efine DFS_V "8.07 24-08-2006" // EDIT     Fix replacement-edit in FDISK
//efine DFS_V "8.06 19-08-2006" // DFSDISK  Fix BBR drivelink display error
//efine DFS_V "8.06 17-08-2006" // EDIT     Highlight search-result location
//efine DFS_V "8.06 17-08-2006" // MBR/EBR  Highlight P-table in hex-editor
//efine DFS_V "8.06 17-08-2006" // JFS LIST Fix 'list -f' trap on check EA
//efine DFS_V "8.06 16-08-2006" // EDIT fn  Add delete to end-of-file
//efine DFS_V "8.06 16-08-2006" // EDIT fn  Message popup non-existing file
//efine DFS_V "8.06 15-08-2006" // EDIT fn  Confirm file truncation at exit
//efine DFS_V "8.06 13-08-2006" // EDIT fn  Insert/Delete at end of the file
//efine DFS_V "8.06 10-08-2006" // PART     Fix I13X recognition new LVM MBR
//efine DFS_V "8.06 10-08-2006" // MBR crc  Recognize LVM fixlevel July 2006
//efine DFS_V "8.05 10-08-2006" // MOVE     Add 'Smart' checkbox default on
//efine DFS_V "8.05 09-08-2006" // IMZ2RAW  Fixed write-error on IMG expand
//efine DFS_V "8.05 08-08-2006" // PSAVE    Fixed TRAP due to cbp.more abuse
//efine DFS_V "8.04 06-08-2006" // WARNING  On LVM 0x35 with DLAT but no Sig
//efine DFS_V "8.04 06-08-2006" // STARTUP  No 'GETDEVICEPARAMS failed', USB
//efine DFS_V "8.04 04-08-2006" // RESIZE   FAT, fixed maximum size in dialog
//efine DFS_V "8.04 04-08-2006" // FILEFIND FAT, fixed finding ext like '*.c'
//efine DFS_V "8.04 03-08-2006" // FILEFIND menu dialog, 'verbose' checkbox
//efine DFS_V "8.04 03-08-2006" // FIND dlg Add 'Step' field for -i:Speedstep
//efine DFS_V "8.04 03-08-2006" // FS FAT   Fixed trap if bootsector was NTFS
//efine DFS_V "8.04 02-08-2006" // FAT16/32 Detect unmapped clusters (alloc)
//efine DFS_V "8.04 02-08-2006" // FILIFIND NTFS, speedup using speedstep 2
//efine DFS_V "8.04 02-08-2006" // FIND     Speedstep mode using -i:n option
//efine DFS_V "8.04 01-08-2006" // MENU     Added 'reselect disk' to FS menus
//efine DFS_V "8.04 29-07-2006" // CLONE    Added -skipbads option and logic
//efine DFS_V "8.04 24-07-2006" // STORE    Added exact image-size in bytes
//efine DFS_V "8.04 24-07-2006" // MENU     Reworded NEWMBR submenu text
//efine DFS_V "8.04 23-07-2006" // MENU     Added: Edit -> File, Binary edit
//efine DFS_V "8.04 23-07-2006" // EDIT fn  HEX/ASCII edit specified filename
//efine DFS_V "8.04 23-07-2006" // IMAGE    Exact size kept same on writing
//efine DFS_V "8.04 22-07-2006" // FIXPBR   Disallow FIXPBR in FDISK mode
//efine DFS_V "8.04 22-07-2006" // FIXBOOT  FAT, added W = Win-9x on FAT16
//efine DFS_V "8.04 21-07-2006" // PART     Reworded cyl-alignment messages
//efine DFS_V "8.04 21-07-2006" // PSAVE    Include unformatted bootsectors
//efine DFS_V "8.04 14-07-2006" // FIXBOOT  NTFS create record from template
//efine DFS_V "8.04 14-07-2006" // PART     Pick-up FAT32 label from root
//efine DFS_V "8.04 13-07-2006" // STORE    Fixed store-nr display: Store #
//efine DFS_V "8.04 13-07-2006" // CLONE    Show #bad-sectors in progress too
//efine DFS_V "8.04 13-07-2006" // CLONE/IM Progress 0 of 0 done (bad-sect)
//efine DFS_V "8.04 13-07-2006" // CLONE    Reset store on Esc/failure too!
//efine DFS_V "8.04 13-07-2006" // Menu     Edit starts with 1-sector items
//efine DFS_V "8.04 12-07-2006" // SLT      Faster fileinfo on JFS/NTFS/HPFS
//efine DFS_V "8.04 09-07-2006" // EDIT     Add Ctrl-E erase item hex value
//efine DFS_V "8.03 03-07-2006" // EDIT     Zero-base or Center cursor-line
//efine DFS_V "8.03 03-07-2006" // EDIT     FIND dialog using Ctrl-F/Ctrl-A
//efine DFS_V "8.03 30-06-2006" // EDIT     HEX/DEC switch for LSN/PSN too
//efine DFS_V "8.03 29-06-2006" // EDIT     Add GOTO dialog and INIT to CB
//efine DFS_V "8.03 27-06-2006" // PART     Add warnings LVM CRC value BAD
//efine DFS_V "8.03 25-06-2006" // EDIT     Error popups for sector-editor
//efine DFS_V "8.03 23-06-2006" // EDIT     Added interactive sector-editor
//efine DFS_V "8.03 05-06-2006" // JFS      Fix CHECK damaged Inodes (alloc)
//efine DFS_V "8.03 04-06-2006" // JFS      Fix XTP/DTP ident blocksize 512
//efine DFS_V "8.02 01-06-2006" // DFSDISK  Allow display LVMinfo in FS modes
//efine DFS_V "8.02 31-05-2006" // FIXBOOT  Fixed a trap for FAT fixboot
//efine DFS_V "8.02 31-05-2006" // FIXPBR   Geo/HiddenSect warnings clearer
//efine DFS_V "8.02 31-05-2006" // JFS      More error reporting damaged FS
//efine DFS_V "8.02 30-05-2006" // COMPARE  Smart sector support for compare
//efine DFS_V "8.02 30-05-2006" // CLONE    Smart sector support for cloning
//efine DFS_V "8.02 25-05-2006" // ALLOC    Fdisk Area support FAT  and JFS
//efine DFS_V "8.02 24-05-2006" // ALLOC    Fdisk Area support HPFS and NTFS
//efine DFS_V "8.02 23-05-2006" // Smart    Command to test smart disk-alloc
//efine DFS_V "8.02 20-05-2006" // Store    Added AreaSN info for smart-disk
//efine DFS_V "8.02 20-05-2006" // Mode=xxx Menu wording changed for clarity
//efine DFS_V "8.02 14-05-2006" // SHIFTR   Fixed offset bug, 511 bytes off
//efine DFS_V "8.02 12-05-2006" // MENU     File -> Trace to 3 cyclic files
//efine DFS_V "8.02 11-05-2006" // SHIFTR   Shift data in sectors (RIGHT)
//efine DFS_V "8.02 06-05-2006" // SLT2LIST -r option adds 'ref' LSN's only
//efine DFS_V "8.02 06-05-2006" // \path    Fixed compare errors for all FS
//efine DFS_V "8.02 06-05-2006" // \path    Implemented for JFS filesystems
//efine DFS_V "8.02 06-05-2006" // SLT2LIST Add selected SLT sectors to list
//efine DFS_V "8.01 05-05-2006" // FDISK    Hint to FS-mode for DELFIND etc
//efine DFS_V "8.01 04-05-2006" // CR Dlg   Added explicit Bootable JFS 0x07
//efine DFS_V "8.01 04-05-2006" // WARNING  On type 0x44 (GoBack) detected
//efine DFS_V "8.01 04-05-2006" // WARNING  On Linux CHS/alignment problems
//efine DFS_V "8.01 03-05-2006" // CHECK on NTFS, fixed trap on resident data
//efine DFS_V "8.01 03-05-2006" // 'u' cmd  bootsector points to last-sector
//efine DFS_V "8.01 03-05-2006" // FORMAT   Fix internal tables for FS name
//efine DFS_V "8.01 01-05-2006" // LVM dlg  lvmSync logic off for removables
//efine DFS_V "8.01 01-05-2006" // Restore  Dlg, fix listselect after IMZ2RAW
//efine DFS_V "8.01 30-04-2006" // CR Dlg   Re-ordered fields for TAB order
//efine DFS_V "8.01 30-04-2006" // History  Ctrl-D in popup deletes an item
//efine DFS_V "8.01 26-04-2006" // FS FAT   Init sets global Dirty status
//efine DFS_V "8.01 26-04-2006" // PART -x  Adds extra FS-specific columns
//efine DFS_V "8.01 25-04-2006" // DFSCHECK Renamed scripts to 'dfs*.dfs'
//efine DFS_V "8.01 25-04-2006" // Menu     Display -> Other view -> Warning
//efine DFS_V "8.01 25-04-2006" // PART     Added warning for BMGR CHS issue
//efine DFS_V "8.01 24-04-2006" // W2KBM => BMFIX includes CHS check & fix
//efine DFS_V "8.01 21-04-2006" // EXT2/3   Super command display HEX+format
//efine DFS_V "8.01 18-04-2006" // IBM BMGR Show BMGR version in bootsector
//efine DFS_V "8.01 16-04-2006" // JFS INIT Detect invalid Inode extent LSN
//efine DFS_V "8.01 12-04-2006" // JFS      Fix trap display ZERO superblock
//efine DFS_V "8.01 11-04-2006" // MBR code recognize 'OS/2 2.xx German' (AP)
//efine DFS_V "8.01 07-04-2006" // JFS  DIR Fix display for blocksize not 4K
//efine DFS_V "8.01 05-04-2006" // NTFS DIR show noatt/-bad- on MFT errors
//efine DFS_V "8.01 05-04-2006" // CHECK    JFS avoid bogus Inode message -m
//efine DFS_V "8.01 04-04-2006" // WIPEFREE instead of ZEROFREE (still alias)
//efine DFS_V "8.01 04-04-2006" // JFSsuper Allow but warn non-std signature
//efine DFS_V "8.01 04-04-2006" // JFSsuper Show super version-2 as Linux OS
//efine DFS_V "8.00 30-03-2006" // RECOVER  NTFS fixed size bug for resident
//efine DFS_V "8.00 29-03-2006" // PART     Fixed disk-level warning display
//efine DFS_V "8.00 29-03-2006" // MENU HPFS add dump system area to image
//efine DFS_V "8.00 29-03-2006" // MENU JFS add dump of system area to image
//efine DFS_V "8.00 29-03-2006" // MENU JFS add display for specific Inodes
//efine DFS_V "8.00 29-03-2006" // MENU JFS add more filerecovery & magic
//efine DFS_V "8.00 28-03-2006" // QFI cmd  Quick find inodes on JFS
//efine DFS_V "8.00 26-03-2006" // SHIFTL   Shift data in sectors (LEFT)
//efine DFS_V "8.00 26-03-2006" // SPEED    Better progress, warn too small
//efine DFS_V "8.00 24-03-2006" // SLT -x   Aborts SLT build (in background)
//efine DFS_V "8.00 24-03-2006" // JFS DIR  Show EA-size if EA is present
//efine DFS_V "8.00 23-03-2006" // FileInfo works for deleted JFS files too
//efine DFS_V "8.00 22-03-2006" // JFS      Filename cache for recover / SLT
//efine DFS_V "8.b5 21-03-2006" // DFSCHECK script windowed, better progress
//efine DFS_V "8.b5 21-03-2006" // DFSDISK  script windowed, better progress
//efine DFS_V "8.b5 18-03-2006" // PROGRESS improved status line and pro-BAR
//efine DFS_V "8.b5 16-03-2006" // SLT NTFS Error on any ZEROED MFT records
//efine DFS_V "8.b5 15-03-2006" // SLT bld  Show progress as percentage done
//efine DFS_V "8.b5 14-03-2006" // CA / INO Display Inode allocation status
//efine DFS_V "8.b5 13-03-2006" // CLEANUP  Reset nonstd flags for primaries
//efine DFS_V "8.b4 11-03-2006" // MENU     This+1/-1 to Display -> Related
//efine DFS_V "8.b4 11-03-2006" // MENU     Add This+1, This-1 to File menu
//efine DFS_V "8.b4 11-03-2006" // MENU     Add SLT-build and ID to JFS menu
//efine DFS_V "8.b4 11-03-2006" // + - nr   Go forward/backward (GF/GB alias)
//efine DFS_V "8.b4 10-03-2006" // FIND dlg Fix search HEX pairs with ZEROES
//efine DFS_V "8.b4 10-03-2006" // CHECK    for JFS complete now, zero errors
//efine DFS_V "8.b4 10-03-2006" // JFS SLT  Build complete; -L:lsn sets root
//efine DFS_V "8.b4 09-03-2006" // Menutext Use disk-list with mount/unmount
//efine DFS_V "8.b4 05-03-2006" // JFS DIR  Inode/LSN mappings implemented OK
//efine DFS_V "8.b4 02-03-2006" // JFS DIR  Handle Btree internal/leave nodes
//efine DFS_V "8.b4 01-03-2006" // JFS DIR  Display Inode/DirPage directories
//efine DFS_V "8.b4 27-02-2006" // LVM dlg  Strip trailing spaces from names
//efine DFS_V "8.b4 20-02-2006" // JFSINODE Display file/dir/deleted/bad etc
//efine DFS_V "8.b4 18-02-2006" // FIND     Fix loop when at end after a hit
//efine DFS_V "8.b4 17-02-2006" // JFSINODE Identify and display contents
//efine DFS_V "8.b4 16-02-2006" // JFSUPER  Display, minor terminology update
//efine DFS_V "8.b3 10-02-2006" // FIXPBR   Updated help, add message popup
//efine DFS_V "8.b3 10-02-2006" // FIXBOOT  FAT select BOOTCODE using a list
//efine DFS_V "8.b3 09-02-2006" // FIXBOOT  JFS template update Steven Levine
//efine DFS_V "8.b3 07-02-2006" // MENU CR  Minimum size of freespace 1/2 cyl
//efine DFS_V "8.b3 07-02-2006" // LVM      Fix change letter for JFS types
//efine DFS_V "8.b3 06-02-2006" // PART     Display 'r' removable indicator
//efine DFS_V "8.b3 06-02-2006" // MENU     Media management eject/mount etc
//efine DFS_V "8.b3 05-02-2006" // EJECT    New command for removables (USB)
//efine DFS_V "8.b3 26-01-2006" // MEDIA    NonLinux: IDE/SCSI/USB or PCCARD
//efine DFS_V "8.b3 23-01-2006" // MFT-REC  Illegal attribute aborts display
//efine DFS_V "8.b3 18-01-2006" // BOOTREC  Display shows ACTIVE FAT (FAT32)
//efine DFS_V "8.b3 18-01-2006" // FIXBOOT  Serial-nr value sn + timestamp
//efine DFS_V "8.b3 18-01-2006" // FORMAT   Serial-nr value sn + timestamp
//efine DFS_V "8.b3 18-01-2006" // FORMAT   Spare to last sector (LVM-sig!)
//efine DFS_V "8.b2 17-01-2006" // CR dlg   Radio button Recover/Clear mode
//efine DFS_V "8.b2 17-01-2006" // CR  -C   Option also forces LVM -C on -L
//efine DFS_V "8.b2 17-01-2006" // LVM -C   Option to CLEAR old LVM BBR info
//efine DFS_V "8.b1 16-01-2006" // MBR-crc  Added detection of PQ BootMagic
//efine DFS_V "8.b1 12-01-2006" // FORMAT   Make FAT size minimal 1 cluster!
//efine DFS_V "8.b1 11-01-2006" // WARNING  for FAT16 fs in FAT32 type 0b/0c
//efine DFS_V "8.b1 11-01-2006" // WARNING  for FAT32 fs in FAT16 type 06/0e
//efine DFS_V "8.b1 11-01-2006" // Warning  made Windows-0x0F type a minor
//efine DFS_V "8.b1 07-01-2006" // MENU     Add explicit Mode=AUX submenu
//efine DFS_V "8.b1 06-01-2006" // MENU     partition selection now in FORMAT
//efine DFS_V "8.b1 05-01-2006" // FORMAT   winproc uses TXQWP_USER no global
//efine DFS_V "8.b1 01-01-2006" // Version  update for 8.00 and expiry to 52
//efine DFS_V "7.15 31-12-2005" // FORMAT   FAT12/16/32 implementation done
//efine DFS_V "7.15 29-12-2005" // FORMAT   Dialog for FAT12/16/32 finished
//efine DFS_V "7.15 27-12-2005" // part -e:1 display 1st extended info only
//efine DFS_V "7.15 24-12-2005" // CmdEcho  "Executing" indicates reg status
//efine DFS_V "7.15 23-12-2005" // FS MENU  Fixboot/LDR in "Boot area fixes"
//efine DFS_V "7.15 23-12-2005" // JFS/HPFS LDR recovery commands added
//efine DFS_V "7.15 23-12-2005" // JFS      Fixboot bootable/standard select
//efine DFS_V "7.15 21-12-2005" // Query P0 returns MFT-fragmentation on NTFS
//efine DFS_V "7.15 20-12-2005" // NTFS MFT fixed for external attribute data
//efine DFS_V "7.15 19-12-2005" // NTFS  \  and findpath command implemented
//efine DFS_V "7.15 17-12-2005" // NTFS MFT INDX display shows Btree branches
//efine DFS_V "7.15 15-12-2005" // NTFS     Leading \ on recover '123.DIR\fn'
//efine DFS_V "7.15 14-12-2005" // NTFS     Fix alloc extreme fragmented MFT0
//efine DFS_V "7.15 14-12-2005" // Menu     Added NTFS dump first MFT-records
//efine DFS_V "7.15 13-12-2005" // CHSstyle Dialog for FIXCHS, CLEANUP and CR
//efine DFS_V "7.15 13-12-2005" // Menu     Added Wipe-start-of-disk
//efine DFS_V "7.15 12-12-2005" // Menu     Added Update NT-signature in MBR
//efine DFS_V "7.15 12-12-2005" // run -P   Fix filename for path with spaces
//efine DFS_V "7.15 11-12-2005" // cs -v -m New checksum verification options
//efine DFS_V "7.15 08-12-2005" // BmgrList Add driveletter to boot-menu list
//efine DFS_V "7.15 07-12-2005" // DiskOpen Allow OS2 PhysDisk handle-value 0
//efine DFS_V "7.15 03-12-2005" // SLTbuild Dialog, all options; multi-thread
//efine DFS_V "7.15 30-11-2005" // FILELIST Dialog, added Kib/Mib/GiB select
//efine DFS_V "7.15 30-11-2005" // SLT      Cleaned up Dirty/Clean reporting
//efine DFS_V "7.14 07-11-2005" // DIALOGS  Allow spaces for filename fields
//efine DFS_V "7.14 07-11-2005" // RECOVER  Filelist dlg, prompt if no params
//efine DFS_V "7.14 07-11-2005" // LIST     Uses filelist dialog, can abort
//efine DFS_V "7.14 07-11-2005" // FILELIST dialog generates selection string
//efine DFS_V "7.14 07-11-2005" // Fileinfo Select on min/max filesize too
//efine DFS_V "7.14 07-11-2005" // RECOVER  Add min/max size to select string
//efine DFS_V "7.14 03-11-2005" // PSAVE    Dialog enhanced with description
//efine DFS_V "7.14 03-11-2005" // PRESTORE Dialog enhanced with many options
//efine DFS_V "7.14 03-11-2005" // NEWMBR   Windows disk-signature unchanged
//efine DFS_V "7.14 03-11-2005" // CMDLINE  Error on single non-hex char cmds
//efine DFS_V "7.14 01-11-2005" // CRDIALOG Allow mcs-numbers for size/offset
//efine DFS_V "7.14 01-11-2005" // CRDIALOG Add "Offset" from start/end field
//efine DFS_V "7.14 01-11-2005" // CRDIALOG Add "Multiple primaries" checkbox
//efine DFS_V "7.14 31-10-2005" // CRDIALOG Added "set ACTIVE" checkbox
//efine DFS_V "7.14 30-10-2005" // DFSDISK  Fixed TRAP for PATH longer than 80
//efine DFS_V "7.14 27-10-2005" // RECOVER  'ignore errors' checkbox in dialog
//efine DFS_V "7.14 26-10-2005" // Status   Show RC value in GREEN for RC=0
//efine DFS_V "7.14 26-10-2005" // FINDdlg  Added StartOffset field for -f opt
//efine DFS_V "7.14 26-10-2005" // FIND     -f:pos start sector as mcs-number
//efine DFS_V "7.14 25-10-2005" // BSFIND   -f:pos start sector as mcs-number
//efine DFS_V "7.13 28-09-2005" // TXWIN    Updated for interface change (1.00)
//efine DFS_V "7.13 24-09-2005" // NTFS     DIRTY, sync mirror on MFT 0..3 too
//efine DFS_V "7.13 19-09-2005" // NTFS     Avoid related MFT display recursion
//efine DFS_V "7.13 18-09-2005" // NTFS     Improve extreme attr-list handling
//efine DFS_V "7.13 15-09-2005" // LVM/PTE  Cleanup window positioning logic
//efine DFS_V "7.13 11-09-2005" // MAP      Quietly skip unaccessible dummies
//efine DFS_V "7.12 06-09-2005" // DIRTY    dirty/normal cmd for NTFS in menu
//efine DFS_V "7.12 06-09-2005" // DIRTY d  command for NTFS, forces a CHKDSK
//efine DFS_V "7.12 05-09-2005" // SLT -v   Verbose on non-error lines too
//efine DFS_V "7.12 05-09-2005" // SLT      Improved usage and output format
//efine DFS_V "7.12 03-09-2005" // BOOTINI  -2 option forces updating the file
//efine DFS_V "7.12 03-09-2005" // CHECK    Speedup, when cluster > 1 (NTFS)
//efine DFS_V "7.12 02-09-2005" // NTFS     Add EXPAND of $Bitmap for resize
//efine DFS_V "7.12 31-08-2005" // NTFS     Added atname select on functions
//efine DFS_V "7.12 30-08-2005" // DFSDISK  Made EXT2 superblock the default
//efine DFS_V "7.12 30-08-2005" // DFSDISK  Add 'NTLDR sectors' Radio button
//efine DFS_V "7.12 29-08-2005" // RESIZE   Fix size in bootsector/spare-loc
//efine DFS_V "7.12 28-08-2005" // RESIZE   Update $BadClus truncate/expand
//efine DFS_V "7.12 26-08-2005" // CHECK    More accurate alloc error report
//efine DFS_V "7.12 26-08-2005" // RESIZE   Update NTFS $Bitmap for truncate
//efine DFS_V "7.12 25-08-2005" // IMAGE    Dialog default 2047 MiB multiple
//efine DFS_V "7.11 24-08-2005" // LOG Dlg  Allow spaces in path or filename
//efine DFS_V "7.11 24-08-2005" // QUERY PO return the dirty-status for NTFS
//efine DFS_V "7.11 24-08-2005" // NTFS     Display flags/volumeinfo on open
//efine DFS_V "7.11 23-08-2005" // DFSDISK  Fix behaviour without parameters
//efine DFS_V "7.11 23-08-2005" // DFSDISK  Resultfiles unique per platform
//efine DFS_V "7.11 23-08-2005" // DFSCHECK Resultfiles unique per platform
//efine DFS_V "7.11 21-08-2005" // MENU     Edit -> Bootmanager Query config
//efine DFS_V "7.11 19-08-2005" // SETBOOT  -list option shows BM menu items
//efine DFS_V "7.11 16-08-2005" // SETBOOT  Options compatible to new SETBOOT
//efine DFS_V "7.11 15-08-2005" // MAP  -m  OS2 USBMSD.ADD DUMMY disk message
//efine DFS_V "7.11 14-08-2005" // PART -w  better message ACTIVE containers
//efine DFS_V "7.11 14-08-2005" // CLEANUP  reset ACTIVE flag ext-containers
//efine DFS_V "7.11 13-08-2005" // DONTFS   script, add Restart-Area display
//efine DFS_V "7.11 12-08-2005" // NTFS LOG show restart-area, unmounted flag
//efine DFS_V "7.11 12-08-2005" // No Dummy disk in menu/dialog select-lists
//efine DFS_V "7.11 11-08-2005" // No Dummy FIXEXT, GENPART, LVMREDO, NTSIGN
//efine DFS_V "7.11 11-08-2005" // No Dummy PSAVE, PRESTORE, NEWMBR, CLEANUP
//efine DFS_V "7.11 11-08-2005" // No Dummy PART, skip any inaccessible disks
//efine DFS_V "7.11 10-08-2005" // CHECK RC set to resulting number of errors
//efine DFS_V "7.11 10-08-2005" // QUERY -g Output important lines to STDOUT
//efine DFS_V "7.11 10-08-2005" // PART  -g Output important lines to STDOUT
//efine DFS_V "7.11 09-08-2005" // QUERY    Add EK/EM/EG as Expand size limit
//efine DFS_V "7.11 06-08-2005" // DFSCHECK Create DFSCxxx.Iyy imagefile too
//efine DFS_V "7.11 05-08-2005" // MENU     Added search for NTLDR 1st sector
//efine DFS_V "7.11 05-08-2005" // BSFIND s finds NTLDR first sectors on disk
//efine DFS_V "7.11 05-08-2005" // NTFS   s sectortype for NTLDR 1st sector
//efine DFS_V "7.11 05-08-2005" // MFT n -R To show/test attribute runlists
//efine DFS_V "7.11 04-08-2005" // NTFS     Write MFTrec, Bitmap, mkRunList
//efine DFS_V "7.11 03-08-2005" // CHECK    updated for large freespace areas
//efine DFS_V "7.10 02-08-2005" // Execute  timestamp format using YYYY-MM-DD
//efine DFS_V "7.10 01-08-2005" // PART -w  add invalid partition-table-entry
//efine DFS_V "7.10 01-08-2005" // PART -w  add WARNING for DELETED partition
//efine DFS_V "7.10 01-08-2005" // DELETE   default now -c: clear ALL 16 bytes
//efine DFS_V "7.10 29-07-2005" // NTFS MFT display special files in the menu
//efine DFS_V "7.10 28-07-2005" // NTFS slt upd non-res attribute-list alloc
//efine DFS_V "7.10 27-07-2005" // NTFS slt upd multiple non-resident attribs
//efine DFS_V "7.10 26-07-2005" // NTFS slt no false alarms unused MFT records
//efine DFS_V "7.10 26-07-2005" // NTFS mft fix multi-attr display ($BadClus)
//efine DFS_V "7.10 25-07-2005" // RESIZE   Set container size on resize LOG
//efine DFS_V "7.10 25-07-2005" // RESIZE   Fixed possible bug with FAT resize
//efine DFS_V "7.09 22-07-2005" // LOGFILE  Log dialog at startup if not -l-
//efine DFS_V "7.09 22-07-2005" // DISKopen Fixed CR bug after using GEO ? xxx
//efine DFS_V "7.09 21-07-2005" // IMAGE +  RESTORE + WIPE, accept mcs-numbers
//efine DFS_V "7.09 21-07-2005" // IMAGE +  RESTORE, pass size/start to dialog
//efine DFS_V "7.09 21-07-2005" // CLEANUP  EXT, Added to the Mode=FDISK menu
//efine DFS_V "7.09 21-07-2005" // EXT/Log  Freespace when EMPTY EBR container
//efine DFS_V "7.09 21-07-2005" // WARNINGs when empty EBR containers detected
//efine DFS_V "7.09 20-07-2005" // FAT CRC  Fix FALSE alarms on FAT1/FAT2 crc
//efine DFS_V "7.09 19-07-2005" // PART  -w Updated severity for some warnings
//efine DFS_V "7.09 16-07-2005" // Image -z Huge speed improvement, 30 - 50%
//efine DFS_V "7.09 14-07-2005" // ReiserFS display more fields in superblock
//efine DFS_V "7.09 14-07-2005" // IMAGE    -S now implies -z (smart, LZW)
//efine DFS_V "7.09 13-07-2005" // CLONE    Apply start/size values in dialog
//efine DFS_V "7.08 06-07-2005" // PTE/LVM  Dialogs keep pos after move/next
//efine DFS_V "7.08 06-07-2005" // MOVE and COPY menu Add '-a' option (align)
//efine DFS_V "7.08 01-07-2005" // Startup  Fix TRAP on 2048 byte sector media
//efine DFS_V "7.07 28-06-2005" // CLONE    Added bad sector simulation, test
//efine DFS_V "7.07 23-06-2005" // Reg-keys Moved source from tx library
//efine DFS_V "7.07 21-06-2005" // Help     Minor updates to help text
//efine DFS_V "7.07 17-06-2005" // Desktop  TXTS/ENTRY size/move with desktop
//efine DFS_V "7.07 15-06-2005" // Dialogs  Updated layout for resize/moving
//efine DFS_V "7.07 12-06-2005" // LVM/PTE  Added OK/Cancel/Prev/Next buttons
//efine DFS_V "7.07 11-06-2005" // CLONEDLG Added OK/Cancel buttons for mouse
//efine DFS_V "7.07 04-06-2005" // WRIM DLG Ignore size from IMZ if size value
//efine DFS_V "7.06 02-06-2005" // MENU     Updated with NTLDR recovery items
//efine DFS_V "7.06 01-06-2005" // ID -Last -g switch shows filename on STDOUT
//efine DFS_V "7.06 01-06-2005" // DFSNTLDR on NTFS create NTLDR IMZ for fix
//efine DFS_V "7.06 01-06-2005" // FIXNTLDR on NTFS from builtin sector or IMZ
//efine DFS_V "7.06 01-06-2005" // LVMREDO  -C option, and added to LVM menu
//efine DFS_V "7.06 30-05-2005" // NTFS     Green alloc % color resident files
//efine DFS_V "7.06 30-05-2005" // LVMREDO  Revive LVM DLAT sectors (eCS OEM)
//efine DFS_V "7.05 24-05-2005" // JFS open No incorrect geo warnings for PBR
//efine DFS_V "7.05 20-05-2005" // MOUSE    Now supported in windows version
//efine DFS_V "7.05 17-05-2005" // IMGRAB   Fix disk-number final part display
//efine DFS_V "7.05 13-05-2005" // FileDlg  Refresh volumelist unless -V- switch
//efine DFS_V "7.05 11-05-2005" // IMAGE +  RESTORE, use PART if not open yet
//efine DFS_V "7.05 09-05-2005" // DFSDISK  Allow spaces in path+filename
//efine DFS_V "7.04 06-05-2005" // MENU     Added Recover/Init LVM DLAT sector
//efine DFS_V "7.04 05-05-2005" // CLONE    Use -!- option to skip main dialog
//efine DFS_V "7.04 02-05-2005" // MFT etc  Fixed bug after PART -r or RESTORE
//efine DFS_V "7.03 28-04-2005" // DFSDISK  Update menu and help to use dialog
//efine DFS_V "7.03 26-04-2005" // DFSDISK  Added parameter and option dialog
//efine DFS_V "7.03 22-04-2005" // Sizes    Use MiB values upto 10 terabyte
//efine DFS_V "7.03 21-04-2005" // GENPART  Fix incorrect size with -s option
//efine DFS_V "7.03 18-04-2005" // ID -last Identify last-used-sector filename
//efine DFS_V "7.03 18-04-2005" // DFSCHECK added 'part -g' command at start
//efine DFS_V "7.03 17-04-2005" // Progress added 0x prefix to HEX sector value
//efine DFS_V "7.03 16-04-2005" // CLONE    Fixed dialog FROM default selection
//efine DFS_V "7.03 15-04-2005" // HISTORY  Added menu-cmds to history as well
//efine DFS_V "7.03 13-04-2005" // HISTORY  UP/DOWN/F11 do cmdline history now
//efine DFS_V "7.03 12-04-2005" // IBM BMGR No warnings when found on  disk 2
//efine DFS_V "7.03 12-04-2005" // JFS      No warning for wrong HiddenSectors
//efine DFS_V "7.03 11-04-2005" // DFSDISK  Strip file extension from basename
//efine DFS_V "7.03 10-04-2005" // DFSDISK  Changed sup-FS/basename to options
//efine DFS_V "7.03 09-04-2005" // MENU     New add/remove to BootManager menu
//efine DFS_V "7.03 09-04-2005" // DFSDISK  Allow full path with basename ($7)
//efine DFS_V "7.03 08-04-2005" // DFSDISK  Unique names for cyl/all/geo files
//efine DFS_V "7.03 07-04-2005" // GENPART  Create partition-recreate script
//efine DFS_V "7.03 06-04-2005" // FAT32    SetFilePtr kludge allows correlation
//efine DFS_V "7.03 04-04-2005" // FDISK F6 cleared sectors made searchable 6
//efine DFS_V "7.02 28-03-2005" // MAP      Allow over 50 partitions per disk
//efine DFS_V "7.02 28-03-2005" // PART     Allow max 1000 partitions, was 80
//efine DFS_V "7.02 23-03-2005" // MENU-fs  Fixed 'display files from list'
//efine DFS_V "7.02 23-03-2005" // JFS      No warning for incorrect PBR GEO
//efine DFS_V "7.02 23-03-2005" // W2KBM    Warnings for old protection (1c)
//efine DFS_V "7.01 21-03-2005" // IMZ2RAW  Fixed dialog logic from the menu
//efine DFS_V "7.01 20-03-2005" // IMZ2RAW  RAW2IMZ wrapper commands and menu
//efine DFS_V "7.01 20-03-2005" // DFSIBMGR Updated for 0x0F aware versions
//efine DFS_V "7.01 16-03-2005" // RESTORE  '-S' takes size from IMZ header
//efine DFS_V "7.01 16-03-2005" // DFSDISK  Allow filesystem superblock search
//efine DFS_V "7.01 11-03-2005" // bsfind   Added EXT2/REISER superblock search
//efine DFS_V "7.01 11-03-2005" // IMGRAB   Post-processing FIXBPR + BOOTINI
//efine DFS_V "7.01 09-03-2005" // FIXPBR   replaces FIXHS, made more generic
//efine DFS_V "7.01 09-03-2005" // FIXHS    Add -g  option to fix GEO too
//efine DFS_V "7.01 09-03-2005" // IMGRAB   Add -G- and default 255/63 geo
//efine DFS_V "7.01 08-03-2005" // IMAGE    Fixed 'dfs -d- image -V:a' crash
//efine DFS_V "7.01 06-03-2005" // MENU     Move all LVM stuff in a submenu
//efine DFS_V "7.01 06-03-2005" // MENU     Remove LVM information (pclear)
//efine DFS_V "7.01 06-03-2005" // W2KBM    Removed confirm & update when OK
//efine DFS_V "7.01 06-03-2005" // MENU     FDISK, add HPFS/JFS super search
//efine DFS_V "7.01 05-03-2005" // bsfind   Added HPFS/JFS superblock search
//efine DFS_V "7.01 04-03-2005" // MENU     fixed Restore/Compare to Current
//efine DFS_V "7.01 03-03-2005" // Sector   header display, add a CRC value
//efine DFS_V "7.01 03-03-2005" // SIM/WRIM aliases IMAGE and RESTORE added
//efine DFS_V "7.01 03-03-2005" // P/S-Geo  streamlined display like L-Geo
//efine DFS_V "7.01 03-03-2005" // Startup  Auto ReadDiskinfo & open disk 1
//efine DFS_V "7.01 27-02-2005" // WRIM     Fixed COMPARE of Smart images
//efine DFS_V "7.00 22-02-2005" // DISK     Fix limit on read-error (bsfind)
//efine DFS_V "7.00 22-02-2005" // MOUNT    Fixed Linux physical disknr bug
//efine DFS_V "7.00 21-02-2005" // SVGRAB   Automatic log to imgname.log file
//efine DFS_V "7.00 21-02-2005" // SVGRAB   Force grabbed to visible partType
//efine DFS_V "7.00 21-02-2005" // SVGRAB   Changed virt/vre to mount/unmount
//efine DFS_V "7.00 21-02-2005" // UNMOUNT  New -last option, unmount last disk
//efine DFS_V "7.E 20-02-2005" // MOUNT +  UNMOUNT menu-items added
//efine DFS_V "7.D 19-02-2005" // BMGR     selectionlist just for PHYS disks
//efine DFS_V "7.D 19-02-2005" // switch   -d:max = #disks mounted at start
//efine DFS_V "7.D 18-02-2005" // MOUNT    (re)mounts all partitionable media
//efine DFS_V "7.D 18-02-2005" // UNMOUNT  removes partitionable media mapping
//efine DFS_V "7.D 16-02-2005" // WRIM dlg Can do Restore/Verify/Compare now
//efine DFS_V "7.C 15-02-2005" // SIM/WRIM add 32bit CRC values to all types
//efine DFS_V "7.C 15-02-2005" // SIM/WRIM add Verbose, debug mode to dialog
//efine DFS_V "7.C 13-02-2005" // FAT      Display CRC32 and FATs different
//efine DFS_V "7.C 13-02-2005" // CHECK    Made SLT refresh the default
//efine DFS_V "7.C 12-02-2005" // CLONE    Fixed usage-bug when used by MOVE
//efine DFS_V "7.C 10-02-2005" // LVM -DM  No default p-name update SIG area
//efine DFS_V "7.C 10-02-2005" // PTE/LVM  Cleaned up 'no changes' messages
//efine DFS_V "7.C 10-02-2005" // PTE Dlg  Fixed SN/Cylinder text alignment
//efine DFS_V "7.A 08-02-2005" // MENU     Added 6 CLONING items to menu
//efine DFS_V "7.A 08-02-2005" // CLONE    Completed the Clone dialog
//efine DFS_V "7.A 07-02-2005" // Dialogs  PTE, LVM, CR add [] type focus
//efine DFS_V "7.9 07-02-2005" // SUBFIND  's' Find 'subdirs from ROOT'
//efine DFS_V "7.9 06-02-2005" // FAT DIR  Display/list/count deleted files
//efine DFS_V "7.9 06-02-2005" // FAT DIR  Allow damaged FAT area/DIR entry
//efine DFS_V "7.9 06-02-2005" // JFS      Added superblock #sectors check
//efine DFS_V "7.9 05-02-2005" // CLONE    New CloneDialog added
//efine DFS_V "7.9 05-02-2005" // MBR      Recognize V-Comm System Commander
//efine DFS_V "7.8 04-02-2005" // FIND     Honnor -E:i to skip bad-sectors
//efine DFS_V "7.8 04-02-2005" // FIND     Fix line-spacing bugs filefind etc
//efine DFS_V "7.8 03-02-2005" // LVM-BBR  Automatic display of BBR sectors
//efine DFS_V "7.7 02-02-2005" // MENU     New 'Set LVM geometry to L-Geo'
//efine DFS_V "7.7 02-02-2005" // MENU     New 'Delete LVM volume' keep part
//efine DFS_V "7.7 02-02-2005" // Output   More consistent 0x HEX prefix use
//efine DFS_V "7.7 02-02-2005" // LVM -v-  Set BBR to V-deleted = 'available'
//efine DFS_V "7.7 01-02-2005" // HPFS CP  Fixed display of codepage contents
//efine DFS_V "7.7 01-02-2005" // SIM/WRIM Add open options -DPVI, use in Dlg
//efine DFS_V "7.7 31-01-2005" // DIRTY    Status display and SET for FAT(32)
//efine DFS_V "7.7 30-01-2005" // SIM/WRIM Added source select Listbox & HEX
//efine DFS_V "7.7 28-01-2005" // WRIM     Dialog moved to new dfsdgen module
//efine DFS_V "7.7 27-01-2005" // IMP/EXP  Dialog moved to new dfsdgen module
//efine DFS_V "7.7 27-01-2005" // SIM      Dialog moved to new dfsdgen module
//efine DFS_V "7.7 26-01-2005" // FIND     Dialog moved to new dfsdgen module
//efine DFS_V "7.7 25-01-2005" // FIND     Menu dialog enhanced with Widgets
//efine DFS_V "7.7 23-01-2005" // LVM -D   Enhanced recover from LVM-signature
//efine DFS_V "7.7 23-01-2005" // FIND     Added 'AND' argument & throughput
//efine DFS_V "7.7 22-01-2005" // MENU     Added Edit -> Search string (find)
//efine DFS_V "7.6 21-01-2005" // WRIM     Fixed recover from 2 missing bytes
//efine DFS_V "7.5 20-01-2005" // WRIM     Recover from 2 missing bytes P#928
//efine DFS_V "7.5 20-01-2005" // RECOVER  Fix trap on bad resident-size MFT
//efine DFS_V "7.4 19-01-2005" // WRIM     Recover from 'missing byte' P#928
//efine DFS_V "7.00 19-01-2005" // WRIM -v  Verify IMZ decompression (verbose)
//efine DFS_V "7.00 18-01-2005" // WRIM     Better handling of corrupt images
//efine DFS_V "7.00 18-01-2005" // SVGRAB   Auto-ACTIVE and several bug-fixes
//efine DFS_V "7.00 17-01-2005" // SVGRAB   Implemented LVM-sig clone/update
//efine DFS_V "7.00 16-01-2005" // ALLOC    Fix total percentage for > 40 GiB
//efine DFS_V "7.00 15-01-2005" // IMGRAB   Added for the regular 7.xx DFSee
//efine DFS_V "7.00 14-01-2005" // CLONE    -L option excludes signature area
//efine DFS_V "7.00 13-01-2005" // SIM/WRIM -L option excludes signature area
//efine DFS_V "7.00 13-01-2005" // PARTINFO added lvmReserved area size field
//efine DFS_V "7.00 12-01-2005" // CR -M    Allow multiple visible primaries
//efine DFS_V "7.00 12-01-2005" // CR -S:n  Prefered slot-number in part-table
//efine DFS_V "7.00 06-01-2005" // SVGRAB   Added -A option for multi-disk etc
//efine DFS_V "7.00 05-01-2005" // SAVETO + RECOVER updated to support Linux
//efine DFS_V "7.00 04-01-2005" // SVGRAB   Route error messages to GUI stdout
//efine DFS_V "7.00 03-01-2005" // RECOVER  -u works for normal files now too
//efine DFS_V "7.00 02-01-2005" // IM, WRIM Add .hdd/.fdd types to filedialog
//efine DFS_V "7.00 02-01-2005" // SVGRAB   Add an fflush for STDOUT Progress
//efine DFS_V "7.00 01-01-2005" // SVGRAB + SVEXPAND default extension .HDD
//efine DFS_V "7.00 30-12-2004" // SVGRAB   Add progress messages option -m
//efine DFS_V "7.00 28-12-2004" // disknr   no needless reread diskinfo (lvm)
//efine DFS_V "7.00 28-12-2004" // SVGRAB   Suppress progress for MBR-track
//efine DFS_V "7.00 27-12-2004" // SVGRAB   Implemented basic imagefile-writing
//efine DFS_V "7.00 27-12-2004" // PRITEMS  command sets #items todo (progress)
//efine DFS_V "7.00 27-12-2004" // SIM      added no-progress switch -p-
//efine DFS_V "7.00 27-12-2004" // OEMSV    recompile without extra debug/trace
//efine DFS_V "7.00 24-12-2004" // NEWMBR   preserve NT-signature, if built-in
//efine DFS_V "7.00 24-12-2004" // LVM DLAT display, correct display PID value
//efine DFS_V "7.00 23-12-2004" // LVM -n:  Will now set initial disk-name too
//efine DFS_V "7.00 22-12-2004" // NEWMBR   -f:disknr, MBR code from other disk
//efine DFS_V "7.00 22-12-2004" // SVGRAB   Partial implementation in dfsvoem.c
//efine DFS_V "7.00 20-12-2004" // DFSDISK  Use part -V to show FS superblocks
//efine DFS_V "7.00 20-12-2004" // PART -V  Echo executed commands, made generic
//efine DFS_V "6.17 14-12-2004" // PRESTORE * restores to SAME disk-nr as file
//efine DFS_V "6.17 14-12-2004" // MENU     Add BACKUP/RESTORE partition info
//efine DFS_V "6.17 14-12-2004" // MENU     New 'Set partition' submenu in FDISK
//efine DFS_V "6.17 06-12-2004" // MENU     Complete partition view (part -r -s)
//efine DFS_V "6.17 05-12-2004" // MENU     Display Related sectors N/U/X/T/D/A
//efine DFS_V "6.17 05-12-2004" // MENU     WIPE current sector(s) to ZEROES
//efine DFS_V "6.17 05-12-2004" // MENU     HPFS find FNODE for file/directory
//efine DFS_V "6.17 02-12-2004" // OEM exe  Update to use the TXOEM libraries
//efine DFS_V "6.17 01-12-2004" // OEM exe  Autoquit, use -Q- for interactive
//efine DFS_V "6.17 29-11-2004" // CR -at:  Fixed primary -at:3f,s placing bug
//efine DFS_V "6.17 29-11-2004" // MOVE -c  NO auto-install of image (DFSIBMGR)
//efine DFS_V "6.17 29-11-2004" // SVEXPAND -z option is default and auto-quit
//efine DFS_V "6.17 28-11-2004" // Progress to STDIO only with -G switch on EXE
//efine DFS_V "6.17 27-11-2004" // SIM      Fixed default MiB for -m:n option
//efine DFS_V "6.16 24-11-2004" // PATH     NTFS, fixed garbage output & trap
//efine DFS_V "6.16 24-11-2004" // PATH     HPFS command, fixed garbage output
//efine DFS_V "6.16 24-11-2004" // Params   Updated many for mcs-number format
//efine DFS_V "6.16 23-11-2004" // Startup  switch -H:[x] sets HEX/DEC defaults
//efine DFS_V "6.16 23-11-2004" // PART     Improved invalid EBR ERROR messages
//efine DFS_V "6.16 20-11-2004" // MENU     FAT, fixboot, specify bootsec type
//efine DFS_V "6.16 19-11-2004" // MENU     DFSDISK try harder menu, allow GEO
//efine DFS_V "6.16 19-11-2004" // BMGR     part, no reselect disk (sets BASE)
//efine DFS_V "6.16 18-11-2004" // SVEXPAND expand SVISTA image (RAW) prototype
//efine DFS_V "6.16 17-11-2004" // EXE -d-  no physical disks in the devicemap
//efine DFS_V "6.16 15-11-2004" // IM       Set correct image size and geometry
//efine DFS_V "6.16 15-11-2004" // GEO      Added -Sync option and usage on -?
//efine DFS_V "6.16 14-11-2004" // Output   Automatic timestamping when logging
//efine DFS_V "6.16 14-11-2004" // PART     ERROR multiple links/logicals in EBR
//efine DFS_V "6.16 14-11-2004" // LVM / PL Fix BMGR-list empty after <Escape>
//efine DFS_V "6.16 14-11-2004" // LVM 1,r  Support relative partition-numbers
//efine DFS_V "6.16 14-11-2004" // FDISK    auto-set (like LVM), force base 0
//efine DFS_V "6.16 13-11-2004" // VREMOVE  Reset forced geometry (next VIRT)
//efine DFS_V "6.16 09-11-2004" // FIXBOOT  -s, FAT32 force copy (even invalid)
//efine DFS_V "6.16 09-11-2004" // Usage    Updated for many FDISK commands
//efine DFS_V "6.15 05-11-2004" // LVM-sec  Changed name to 'LVM DLAT info sec'
//efine DFS_V "6.15 04-11-2004" // BOOTINI  Added '-2' option for 2nd ARC line
//efine DFS_V "6.15 04-11-2004" // PT pid   Menu: Display -> Sectors for part
//efine DFS_V "6.15 04-11-2004" // PT * *   Allow multi-partition/disk display
//efine DFS_V "6.15 04-11-2004" // PT   -r  Display PBR and LVM sectors as well
//efine DFS_V "6.15 02-11-2004" // PART -w  Fixed multiple-ACTIVE 1 disk ERROR
//efine DFS_V "6.15 02-11-2004" // PART -w  Change ACTIVE extended to an ERROR
//efine DFS_V "6.15 01-11-2004" // WIPESECURE added -f for freespace wipe only
//efine DFS_V "6.15 25-10-2004" // SIM      Added -A for append to image
//efine DFS_V "6.15 22-10-2004" // WALK/0   Fixed PID display for primaries
//efine DFS_V "6.15 21-10-2004" // WALK     Updated PT-entry display layout
//efine DFS_V "6.14 05-10-2004" // DFSDISK  Renamed UNFDISK for consistency
//efine DFS_V "6.14 30-09-2004" // DFSCHECK Run DOxxxx script on one or all parts
//efine DFS_V "6.14 28-09-2004" // LVM      Add display on recover from LVM-sig
//efine DFS_V "6.14 27-09-2004" // VIRT     Removed test on .PDx version 5.06
//efine DFS_V "6.14 16-09-2004" // UNFDISK  Made this an 'autoquit' command
//efine DFS_V "6.14 15-09-2004" // PRESTORE Fix description display from Linux
//efine DFS_V "6.14 13-09-2004" // PART     Treat LinuxRaid (0xfd) like 0x83
//efine DFS_V "6.13 10-09-2004" // MENU     Fixed Missing Exit/Speed-w entries
//efine DFS_V "6.13 10-09-2004" // VOL      Fixed incorrect size for non-Linux
//efine DFS_V "6.13 09-09-2004" // QUERY    Fixed TRAP if zero disks/partitions
//efine DFS_V "6.13 09-09-2004" // PTE/LVM  Fixed inconsistent Mode= after cmd
//efine DFS_V "6.13 08-09-2004" // Linux    DFSee version xxx incorrect (DFS_V)
//efine DFS_V "6.13 08-09-2004" // MAP      Removed extra '/dev/' from top line
//efine DFS_V "6.12 05-09-2004" // DFSee    Fixed 1024-bps slackware problems
//efine DFS_V "6.12 03-09-2004" // DFSee    Cleaned up GEO & sectorsize issues
//efine DFS_V "6.12 02-09-2004" // DFSee    TxAlloc SECTOR buffers (not stack)
//efine DFS_V "6.12 01-09-2004" // DFSECTOR Linux Volume & File IO, BPS ioctl
//efine DFS_V "6.12 31-08-2004" // DEV      Alias for "vol" cmd, show mounts
//efine DFS_V "6.12 30-08-2004" // DFSECTOR Enabled sector-writing for Linux
//efine DFS_V "6.12 27-08-2004" // CRdialog force PRI size 1 for BMGR type 0x0a
//efine DFS_V "6.12 26-08-2004" // PSAVE    change .PDx extension to lowercase
//efine DFS_V "6.12 26-08-2004" // DFSIBMGR create a RAW image, no DFSee header
//efine DFS_V "6.12 26-08-2004" // SIM/WRIM Added Linux-specific open() logic
//efine DFS_V "6.11 25-08-2004" // PTEDIT   Part-description matches current now
//efine DFS_V "6.11 25-08-2004" // RECOVER  Fixed recovery of zero-sized files
//efine DFS_V "6.11 23-08-2004" // DEVMAP   Changed Init/Add logic for devices
//efine DFS_V "6.11 16-08-2004" // RECOVER  Fixed fspec > 260 char problems
//efine DFS_V "6.11 15-08-2004" // RECOVER  Force unique name NTFS damaged MFT
//efine DFS_V "6.11 14-08-2004" // PART     Fix hang for invalid bytes/sect
//efine DFS_V "6.11 13-08-2004" // LINUX    added OpenDisk implementation
//efine DFS_V "6.11 10-08-2004" // DFSDEVS  module added for new Linux stuff
//efine DFS_V "6.11 04-08-2004" // MENUlist add one disabled-item when 'empty'
//efine DFS_V "6.11 02-08-2004" // LINUX    First compilable version :-)
//efine DFS_V "6.10 27-07-2004" // Ptable   display shows PID now, when known
//efine DFS_V "6.10 26-07-2004" // LVM      Recover LVM-info from sig-sector
//efine DFS_V "6.10 26-07-2004" // PT pid   Display Partition-Table for pid
//efine DFS_V "6.10 24-07-2004" // MOVE     Add 'reboot required' message
//efine DFS_V "6.10 24-07-2004" // PL LVMS  Show PID Info, Sign and DriveLink
//efine DFS_V "6.10 23-07-2004" // PL LVMS  fixed display of Fake-EBR values
//efine DFS_V "6.10 22-07-2004" // LVM pid  update did/pid in DriveLink sector
//efine DFS_V "6.10 20-07-2004" // MOVE -b  NO-ABORT warning on overlapped LOG
//efine DFS_V "6.10 19-07-2004" // REG-key  Show systemdate when key seems bad
//efine DFS_V "6.10 19-07-2004" // MOVE -C- Do not COPY contents, Ptable only
//efine DFS_V "6.10 19-07-2004" // PL / LVM Correct use of . or -d disknr
//efine DFS_V "6.10 16-07-2004" // LVM      Dont calc VolumeId with -lvmvid
//efine DFS_V "6.10 13-07-2004" // FIND     Progress from LSN-0 (delfind -c)
//efine DFS_V "6.10 10-07-2004" // PART -q  More compact display, less lines
//efine DFS_V "6.10 10-07-2004" // LVM/MOVE Init LVM-info for moved logical
//efine DFS_V "6.10 08-07-2004" // SBVIEW   F3 in text-window goes to cmd
//efine DFS_V "6.10 08-07-2004" // MOVE -c  mangles LVM names/ids/letter
//efine DFS_V "6.10 08-07-2004" // MOVE -f  -e:* will move to END of fsp
//efine DFS_V "6.10 05-07-2004" // Startup  avoid autoquit on 'dfsxxx virt'
//efine DFS_V "6.10 05-07-2004" // MOVE -A  Do NOT align KiB/MiB values
//efine DFS_V "6.10 04-07-2004" // MENU     Move/Copy to freespace area
//efine DFS_V "6.10 03-07-2004" // CMDLINE  Ctrl-Right/Left now scroll SBuf
//efine DFS_V "6.10 03-07-2004" // MOVE to other freespace area added
//efine DFS_V "6.10 01-07-2004" // MENU Display -> Base, LSN first..last
//efine DFS_V "6.10 01-07-2004" // MENU File -> Open Freespace area (base)
//efine DFS_V "6.10 30-06-2004" // RESIZE   add 'CHKDSK required' msg at end
//efine DFS_V "6.10 30-06-2004" // RESIZE   set HPFS to DIRTY forcing CHKDSK
//efine DFS_V "6.10 30-06-2004" // FI       command to list single sSN value
//efine DFS_V "6.10 30-06-2004" // LIST     fixed 'Unidentified' on non-file
//efine DFS_V "6.10 30-06-2004" // F and B  fixed 'distance' parameter
//efine DFS_V "6.10 29-06-2004" // LVM      Update LVMsign size/psn values
//efine DFS_V "6.10 29-06-2004" // LVM      added lvmpid/vid/did/bid options
//efine DFS_V "6.10 28-06-2004" // MENU     MOVE to end/begin; move submenu
//efine DFS_V "6.10 27-06-2004" // CREATE   added -F option for ACTIVE flag
//efine DFS_V "6.10 26-06-2004" // MOVE cmd parameter handling implemented
//efine DFS_V "6.10 23-06-2004" // H and A  allow .NNN as sector number
//efine DFS_V "6.10 23-06-2004" // hex-num  allow HEX SN without leading 0
//efine DFS_V "6.10 23-06-2004" // VOL -f-  to exclude floppies, -f is default
//efine DFS_V "6.09 14-06-2004" // LIST FAT added '-I -C' combo and '-X' option
//efine DFS_V "6.09 07-06-2004" // ALLOC on HPFS, warning on invalid BM position
//efine DFS_V "6.09 06-06-2004" // ALLOC on HPFS, fix bitmap caching on errors
//efine DFS_V "6.09 05-06-2004" // DFSCHECK etc added to external warning-list
//efine DFS_V "6.08 04-06-2004" // PROFILE  found in EXE-dir or PATH now too
//efine DFS_V "6.08 04-06-2004" // CHECK on FAT, fixed 'exceeds XSIZE' errors
//efine DFS_V "6.08 01-06-2004" // LIST     Added header texts for single line
//efine DFS_V "6.08 31-05-2004" // LIST     HPFS, add location value for Files
//efine DFS_V "6.08 31-05-2004" // LIST     NTFS, add location value for Files
//efine DFS_V "6.08 31-05-2004" // LIST     Fat, add location/EA value/LSN/Clust
//efine DFS_V "6.08 27-05-2004" // WARNINGs for BMGR only when real BMGR present
//efine DFS_V "6.08 27-05-2004" // WALK     Fixed recognition of EBRs with code
//efine DFS_V "6.07 25-05-2004" // FAT-DIR  Correct display of damaged LFN entry
//efine DFS_V "6.07 25-05-2004" // BOOTINI  on FAT16 corrected searching root dir
//efine DFS_V "6.07 25-05-2004" // LVM and  LVMSHOW will not change selected disk
//efine DFS_V "6.07 25-05-2004" // PLIST    will not change selected disk anymore
//efine DFS_V "6.07 24-05-2004" // LVM/CR   -J option allows recover of JFS volume
//efine DFS_V "6.07 23-05-2004" // HPFSinit improved SUP/SPARE bad-sector handling
//efine DFS_V "6.07 23-05-2004" // PART     Improved BOOTREC bad-sector handling
//efine DFS_V "6.07 19-05-2004" // BOOTINI  Fix calculated index for unsorted
//efine DFS_V "6.07 19-05-2004" // BOOTINI  RC not 0 when index is incorrect
//efine DFS_V "6.07 17-05-2004" // FIND     '-n', start search in NEXT sector
//efine DFS_V "6.06 16-05-2004" // FILEFIND for FAT(32) 'name.ext' name syntax
//efine DFS_V "6.06 13-05-2004" // FIND     New M option, multiple-hits/sector
//efine DFS_V "6.06 12-05-2004" // FILEFIND for FAT(32) find files by name/ext
//efine DFS_V "6.06 12-05-2004" // DELFIND  for FAT(32) find deleted files
//efine DFS_V "6.06 12-05-2004" // FAT(32)  much better recognition valid DIRs
//efine DFS_V "6.06 09-05-2004" // BOOTINI  Actual update code implemented
//efine DFS_V "6.06 08-05-2004" // BOOTINI  command-help and menu-items added
//efine DFS_V "6.06 07-05-2004" // BOOTINI  implemented for NTFS and FAT(32) FS
//efine DFS_V "6.06 06-05-2004" // RUN      updated to allow -P wildcard/path
//efine DFS_V "6.06 06-05-2004" // -query   automatically starts logfile now
//efine DFS_V "6.06 06-05-2004" // Switches reorganized wording, more compact
//efine DFS_V "6.06 05-05-2004" // FINDROOT and FIND use std Progress, no dots
//efine DFS_V "6.06 04-05-2004" // PART     Filter labels for non-printables
//efine DFS_V "6.06 24-04-2004" // TEXT-UI  Added color-schemes for windowing
//efine DFS_V "6.06 12-04-2004" // MENU     Changed  submenu and _ focus mark
//efine DFS_V "6.06 08-04-2004" // DFSDOS   Make ANSI probing invisible
//efine DFS_V "6.05 06-04-2004" // LVM -n   Sync BootID too on diskname change
//efine DFS_V "6.05 05-04-2004" // LVM -n   Sync DiskID too on diskname change
//efine DFS_V "6.05 03-04-2004" // RETRIES  on bad-sectors, default 1 now (-A:)
//efine DFS_V "6.05 03-04-2004" // MENU     Text for BMGR timeout 0 corrected
//efine DFS_V "6.04 02-04-2004" // MENU     Added EXT2/3 and REISER to menu
//efine DFS_V "6.04 31-03-2004" // REISER   Added basic recognition module
//efine DFS_V "6.04 30-03-2004" // EXT2/3   Added basic recognition module
//efine DFS_V "6.04 26-03-2004" // MENU     Add 'Read-Only' item in File menu
//efine DFS_V "6.04 26-03-2004" // LVM      Accept '-menu' alias for -m option
//efine DFS_V "6.04 20-03-2004" // MENU     Add Delete & Activate THIS partition
//efine DFS_V "6.04 16-03-2004" // WIPE     Added 'r' param for RANDOM pattern
//efine DFS_V "6.04 16-03-2004" // HPFS     Fixed display bug in Fnode/Alloc
//efine DFS_V "6.04 16-03-2004" // MAP      Fixed line colors used for logicals
//efine DFS_V "6.04 15-03-2004" // CREATE   Dialog, 'clear BS' default OFF
//efine DFS_V "6.04 15-03-2004" // LVM      New 'Change LVM diskname' menu item
//efine DFS_V "6.04 14-03-2004" // PART     Moved 'active' marker to PID column
//efine DFS_V "6.04 10-03-2004" // Compiler WATCOM download license notices
//efine DFS_V "6.04 06-03-2004" // LOG      new -r option, flush on each line
//efine DFS_V "6.04 06-03-2004" // Compiler changed to Watcom 1.30, for Linux
//efine DFS_V "6.04 24-02-2004" // CLONE    Use HEX part-type in store-descr
//efine DFS_V "6.04 17-02-2004" // PART     Updated Linux native types
//efine DFS_V "6.03 13-02-2004" // SETROOT  Fixed cluster/LSN value FAT32 bug
//efine DFS_V "6.03 13-02-2004" // CR/PART  Changed 'part auto' to 'part .'
//efine DFS_V "6.03 06-02-2004" // PART     Cleaned up "-no access" RC messages
//efine DFS_V "6.02 03-02-2004" // CREATE   New -Clear option to wipe bootsec
//efine DFS_V "6.02 03-02-2004" // FAT-FS   Improved bad-FAT error reporting
//efine DFS_V "6.02 03-02-2004" // MENU     Add Change partition type in menu
//efine DFS_V "6.02 30-01-2004" // MENU     Add ChangeDir to UNFDISK selections
//efine DFS_V "6.02 21-01-2004" // MBR      Recognize I13X capability AirBOOT
//efine DFS_V "6.02 17-01-2004" // OS2-EXE  Upgraded to LxLite 1.33 exe-packer
//efine DFS_V "6.01 15-01-2004" // MENU     Minor text and documentation update
//efine DFS_V "6.01 13-01-2004" // NTFS     Fix trap after invalid startup cmd
//efine DFS_V "6.00 12-01-2004" // MENU     Add "Identify sectors in list"
//efine DFS_V "6.00 12-01-2004" // RECOVER  Fix aborting after single-failure
//efine DFS_V "6.00 10-01-2004" // SIM      Fix 'single-track' multi-files bug
//efine DFS_V "6.00 09-01-2004" // CLONE    No internal store-nr on confirmation
//efine DFS_V "6.6 09-01-2004" // SIM/WRIM completed multi-file/media-change
//efine DFS_V "6.6 08-01-2004" // MENU     Add "Display list" to FS; long desc
//efine DFS_V "6.6 05-01-2004" // SPEED    New 'SPEED' command and menu-item
//efine DFS_V "6.6 04-01-2004" // SIM      Added NEXTFILE marker for multi
//efine DFS_V "6.6 01-01-2004" // Autodrop switch -M:2 non-autodrop menustyle
//efine DFS_V "6.6 01-01-2004" // MENU     Added W2KBM command to FDISK menu
//efine DFS_V "6.6 01-01-2004" // WRIM     Added DFSee-header recognition
//efine DFS_V "6.6 31-12-2003" // SIM      Added multi-file logic
//efine DFS_V "6.6 30-12-2003" // SIM      Added RLE compress empty sectors
//efine DFS_V "6.6 25-12-2003" // STORE    Added p-type to descr (for CLONE)
//efine DFS_V "6.6 24-12-2003" // EXPAND   Error-msg when max-size <= current
//efine DFS_V "6.6 24-12-2003" // PART     No FDISK HiddenSectors, no rc=207
//efine DFS_V "6.6 23-12-2003" // SUBMENU  Added drive & Pri/Log to part-menus
//efine DFS_V "6.6 22-12-2003" // DF5EE    Updated binary 'signatures' to 6.00
//efine DFS_V "6.6 21-12-2003" // SIM      Smart-sector imaging with -S option
//efine DFS_V "6.6 20-12-2003" // CR MENU  Fsp list reordered and disknr incl.
//efine DFS_V "6.6 19-12-2003" // PART     No unformatted HiddenSector warning
//efine DFS_V "6.5 18-12-2003" // Volumes  Refresh submenu list after F7 displ
//efine DFS_V "6.5 16-12-2003" // FIXHS    Fix HiddenSectors bootrec field
//efine DFS_V "6.4 15-12-2003" // DIRdisp  Fix trap in FAT/HPFS/NTFS display
//efine DFS_V "6.4 14-12-2003" // MENU     Add -M menu-style for right-arrow
//efine DFS_V "6.4 10-12-2003" // FDIALOG  Strip extensions filenames SaveAs
//efine DFS_V "6.4 09-12-2003" // FDIALOG  Removed default filenames SaveAs
//efine DFS_V "6.4 09-12-2003" // PART     Add HiddenSector mismatch warning
//efine DFS_V "6.4 07-12-2003" // Display  Directory alternate color bright
//efine DFS_V "6.4 04-12-2003" // CLONE    Fixed bug that set partid to 00
//efine DFS_V "6.4 04-12-2003" // CLONE    Disable disk-clone if base not 0
//efine DFS_V "6.4 04-12-2003" // MENU     Fix 'Fix the bootsector' shortcuts
//efine DFS_V "6.4 03-12-2003" // MENU     Add 'recover from list' to Mode=xx
//efine DFS_V "6.4 03-12-2003" // RECOVER  Default saveto-dir . and Escape
//efine DFS_V "6.4 02-12-2003" // MENU     Changed UNFD item text + warning
//efine DFS_V "6.4 30-11-2003" // MENU     Completed code for 'newmbr -c'
//efine DFS_V "6.3 27-11-2003" // CREATE   Fixed EBR size and end-cylinder
//efine DFS_V "6.3 25-11-2003" // PART     Fixed size display .031 MiB value
//efine DFS_V "6.2 23-11-2003" // KEY      Updated intro-date to 23-11-2003
//efine DFS_V "6.2 21-11-2003" // VOL/MENU filedialog, fixed for DOS version
//efine DFS_V "6.1 20-11-2003" // PART     Require '-a' for alloc map on open
//efine DFS_V "6.1 19-11-2003" // EXPAND   Added expand command and menu item
//efine DFS_V "6.1 19-11-2003" // RESIZE   Now from the menu with size prompt
//efine DFS_V "6.1 17-11-2003" // BETA     Beta status to allow limited distro
//efine DFS_V "6.00 14-11-2003" // Startup  Added volume/partition info message
//efine DFS_V "6.00 13-11-2003" // RESIZE   Added auto-ALLOC to part select
//efine DFS_V "6.00 11-11-2003" // RUN      Restore screen on/off after RUN
//efine DFS_V "6.00 10-11-2003" // MENU     Added "Current opened .." store
//efine DFS_V "6.00 09-11-2003" // MENU     Added Win/Menu key accelerators
//efine DFS_V "5.55 06-11-2003" // CREATE   Fixed trap if 1 disabled freespace
//efine DFS_V "5.55 05-11-2003" // PTE      Fixed the non-auto checkboxes
//efine DFS_V "5.55 04-11-2003" // PART     Use 'Disk/Virt' default diskName
//efine DFS_V "5.55 04-11-2003" // MENU     disk/part CLONE enable virtuals
//efine DFS_V "5.55 03-11-2003" // MENU     Added confirmation to CAD reboot
//efine DFS_V "5.55 01-11-2003" // CLONE    Added -Merge option, skip badsect
//efine DFS_V "5.54 31-10-2003" // DIALOG   Get owner-help on drop-down list
//efine DFS_V "5.54 30-10-2003" // CHECK    NTFS Bad-MFT-Fixup recognition
//efine DFS_V "5.54 27-10-2003" // MENU     Added display Raw part info (walk)
//efine DFS_V "5.54 20-10-2003" // QUERY    Added Minimum and Grabable P-size
//efine DFS_V "5.54 20-10-2003" // RECOVER  Use SelDirFileDialog, not prompt
//efine DFS_V "5.54 19-10-2003" // progress indicator xxxx of yyyy (nn.n%)
//efine DFS_V "5.54 18-10-2003" // SAVETO   Fixed cmd-loop on bad sectortype
//efine DFS_V "5.53 17-10-2003" // MENU-RUN Added prompt for parameters
//efine DFS_V "5.53 16-10-2003" // PART     Fixed BM-name assignement for WIN
//efine DFS_V "5.53 15-10-2003" // MENU     Added boot-to-BM-name Bootabl
//efine DFS_V "5.53 14-10-2003" // CREATE   Added descriptions to Fsp-list
//efine DFS_V "5.53 13-10-2003" // CREATE   Added freespace selection-list
//efine DFS_V "5.53 12-10-2003" // m=FDISK  Added interactive & create
//efine DFS_V "5.53 12-10-2003" // MENU     Moved list-actions to submenu
//efine DFS_V "5.53 11-10-2003" // LVM/PTE  Added -P Listbox selection
//efine DFS_V "5.53 10-10-2003" // RECOVER  Added to Action-menu (if list)
//efine DFS_V "5.53 10-10-2003" // RECOVER  Added -P, prompt destin+wildcard
//efine DFS_V "5.53 10-10-2003" // LIST     Added -P option, prompt wildcard
//efine DFS_V "5.53 06-10-2003" // HELP     Fixed trap on empty LISTBOX li=0
//efine DFS_V "5.52 05-10-2003" // HELP     Finished all menu-item help
//efine DFS_V "5.51 03-10-2003" // MENU     New m=HPFS, m=NTFS, m=FAT, m=JFS
//efine DFS_V "5.50 03-10-2003" // MENU     FS-specific menu and "mode -w"
//efine DFS_V "5.50 03-10-2003" // MENU     Added m=FDISK FS-specific menu
//efine DFS_V "5.50 01-10-2003" // MENU     Added UNFDISK processing
//efine DFS_V "5.50 30-09-2003" // MENU     Added SCAN, CLONE, WIPE, VRE etc
//efine DFS_V "5.50 28-09-2003" // PART     Added 'Linux' as EXT2/SWAP creator
//efine DFS_V "5.50 28-09-2003" // DFSUNFD  Fixed disk-selection after ALLOC
//efine DFS_V "5.50 27-09-2003" // MENU     Moved settings, added fs-mode
//efine DFS_V "5.50 20-09-2003" // MENU     Added Import/Export and Sim/Wrim
//efine DFS_V "5.50 19-09-2003" // GEO      Refresh diskinfo, updating f->cSC
//efine DFS_V "5.50 14-09-2003" // PART -w  Better descr DFSDOS 'beyond disk'
//efine DFS_V "5.50 13-09-2003" // MENU     Added file-dialog log/screen/run
//efine DFS_V "5.50 10-09-2003" // SIM WRIM Made -? help text more specific
//efine DFS_V "5.50 10-09-2003" // VOL IM   Added -? help and -f VOL option
//efine DFS_V "5.50 07-09-2003" // DFSmenu  Added Blue background style
//efine DFS_V "5.50 04-09-2003" // DFSmenu  First working main-menu for DFSee
//efine DFS_V "5.50 01-09-2003" // MENU     Recompile with updated TxLib
//efine DFS_V "5.26 01-09-2003" // FIXBOOT  -? help added on HPFS/FAT/JFS/NTFS
//efine DFS_V "5.26 31-08-2003" // FIXBOOT  for HPFS updated to be I13X aware
//efine DFS_V "5.26 31-08-2003" // LVM      Minor textual updates; eval date
//efine DFS_V "5.26 09-08-2003" // MBR      Recognize 2nd Iomega ZIP variant
//efine DFS_V "5.25 08-08-2003" // DFSee    Implemented /HELP + /QUERY switch
//efine DFS_V "5.25 07-08-2003" // PART     -L and -L- opts, actual +prefered
//efine DFS_V "5.25 06-08-2003" // RESIZE   Enhanced 'resulting part' display
//efine DFS_V "5.25 04-08-2003" // PART/FAT Fixed 'empty disk' FAT syndrome
//efine DFS_V "5.25 04-08-2003" // SIM/WRIM WIPE better confirmation text
//efine DFS_V "5.25 03-08-2003" // CLONE    Added src/target size to confirm
//efine DFS_V "5.25 03-08-2003" // PL LVM   Show CHS value for start/end sect
//efine DFS_V "5.25 29-07-2003" // PART/MAP LVM/JFS multiple on type 35 only
//efine DFS_V "5.25 29-07-2003" // PART/MAP WARNING not-formatted not a minor
//efine DFS_V "5.25 26-07-2003" // EXPIRE   set to 33, redundant vars removed
//efine DFS_V "5.24 25-07-2003" // DIRFIND, FILEFIND added -? style help
//efine DFS_V "5.24 24-07-2003" // QUERY    Avoid wrap, extra space and < 68
//efine DFS_V "5.24 23-07-2003" // QUERY    No params, show compact part list
//efine DFS_V "5.24 23-07-2003" // PART -q  Compact (space) separated list
//efine DFS_V "5.24 23-07-2003" // NTxxx    Grouped NT-4 specific commands
//efine DFS_V "5.24 22-07-2003" // LVM      Allow -n without -d or with -d:*
//efine DFS_V "5.24 22-07-2003" // LVM      Restrict dialog to 19 char names
//efine DFS_V "5.24 22-07-2003" // PART     New warnings on several LVM issues
//efine DFS_V "5.24 21-07-2003" // FIXEXT   Added -all option, better confirm
//efine DFS_V "5.24 21-07-2003" // PART/MAP Show BS read-errors but continue
//efine DFS_V "5.24 16-07-2003" // MAP      Fix trap on 0 cyl / narrow screen
//efine DFS_V "5.24 12-07-2003" // PTE      Fix trap on "dfsos2 pte -d:2"
//efine DFS_V "5.24 11-07-2003" // PART/MAP Show INT13 details if -p switch
//efine DFS_V "5.24 08-07-2003" // PTE      Indicate changes and refresh info
//efine DFS_V "5.24 07-07-2003" // BMP  -d  -? help; Fix display, disk param
//efine DFS_V "5.24 04-07-2003" // PART/MAP Minor update to geo, allow S:255=
//efine DFS_V "5.24 03-07-2003" // DISK/MAP Added Windows-NT-4 MBR code
//efine DFS_V "5.24 02-07-2003" // W2KBM    Refresh partition-cache after fix
//efine DFS_V "5.24 28-06-2003" // STORE    Fixed text for part on a virtual
//efine DFS_V "5.24 28-06-2003" // DISK/MAP Added OS/2 2.xx MBR code
//efine DFS_V "5.23 23-06-2003" // PART     I13X-aware LVM or FDISK displayed
//efine DFS_V "5.23 22-06-2003" // PART -w  Warning for BMGR not W2K protected
//efine DFS_V "5.23 22-06-2003" // DFSIBMGR Fixed images for disk other than 1
//efine DFS_V "5.23 21-06-2003" // PART     Warning when MBR/BMGR has no I13X
//efine DFS_V "5.23 21-06-2003" // PART     Types 0x8a/8e/a8/ab/bb/fa/fb/fc/fd
//efine DFS_V "5.23 21-06-2003" // PART     XOSL bmgr 0x78 type recognized now
//efine DFS_V "5.23 19-06-2003" // LVM  -n  Do not update if no LVM-sector yet
//efine DFS_V "5.23 19-06-2003" // LVM  -c  Skip CRC update for non-LVM sectors
//efine DFS_V "5.23 19-06-2003" // PART -s  Added display of (old) BMGR-name
//efine DFS_V "5.23 19-06-2003" // CHECK    Does not set RC to #errors anymore
//efine DFS_V "5.23 19-06-2003" // DISK/MAP Added System Commander MBR code
//efine DFS_V "5.23 19-06-2003" // PART/MAP Display INT13 limit for '-m' option
//efine DFS_V "5.22 16-06-2003" // DELETE   Auto remove DLAT entry unless -L-
//efine DFS_V "5.22 15-06-2003" // LVM  -c  Show/remove obsolete DLAT entries
//efine DFS_V "5.22 15-06-2003" // FIXCHS   Use IBM/PQ/MS styles, updated msgs
//efine DFS_V "5.22 13-06-2003" // PART     Label shows LVM-I13X or FDISK BMGR
//efine DFS_V "5.22 09-06-2003" // WALK     IBM/PQ/MS/BAD CHS style indicator
//efine DFS_V "5.22 06-06-2003" // PTE pid  Fixed selection with high pid value
//efine DFS_V "5.22 06-06-2003" // PART -w  More specific 'NO active' warnings
//efine DFS_V "5.22 05-06-2003" // TxLib    Global rename TxLibrary definitions
//efine DFS_V "5.21 03-06-2003" // PART     Show BMGR bootable 0x05 (installable)
//efine DFS_V "5.21 02-06-2003" // Register rebuild all for evaluation-date bug
//efine DFS_V "5.21 31-05-2003" // LVM/PTE  Updated dialogs for MiB usage
//efine DFS_V "5.21 30-05-2003" // PART -w  Less alarming INT13 related warnings
//efine DFS_V "5.21 30-05-2003" // SIM      Added compressed filesize reporting
//efine DFS_V "5.21 27-05-2003" // Display  Change 4-digit value to float XiB
//efine DFS_V "5.21 26-05-2003" // LVMinfo  Fixed display after read-errors
//efine DFS_V "5.21 26-05-2003" // Display  Kb/Mb as KiB/MiB/GiB (IEEE 1541)
//efine DFS_V "5.21 26-05-2003" // VIRT     Show new disk after prestore/import
//efine DFS_V "5.20 25-05-2003" // Remove APIRET/SPARAM, fix DOS TxRead/TxWrite
//efine DFS_V "5.20 24-05-2003" // BSFIND   Added -? help and usage text
//efine DFS_V "5.20 24-05-2003" // VIRT     Auto IMPORT -d from PRESTORE fname
//efine DFS_V "5.20 24-05-2003" // SCAN     Fixed #bad reporting and error msg
//efine DFS_V "5.20 23-05-2003" // Display  Increased accuracy Mb/Kb numbers
//efine DFS_V "5.20 23-05-2003" // LVMinfo  Display values in decimal too
//efine DFS_V "5.20 23-05-2003" // LVM      PID overrules -p for selection
//efine DFS_V "5.20 23-05-2003" // NEWMBR   -d[:disk] option plus -? usage help
//efine DFS_V "5.19 05-05-2003" // CREATE   -A option "create as" other partition
//efine DFS_V "5.19 05-05-2003" // PTE      Fixed display of almost empty entries
//efine DFS_V "5.19 05-05-2003" // RESIZE   warning about resizing bootable NTFS
//efine DFS_V "5.19 05-05-2003" // ALLOC    Fixed reported minimum size for FAT
//efine DFS_V "5.18 04-05-2003" // TRACE    Less output and fixed SLT trace bug
//efine DFS_V "5.18 03-05-2003" // PART     Support nn,r relative PID
//efine DFS_V "5.18 30-04-2003" // DELETE   Support -d:D and -p:P,r relative PID
//efine DFS_V "5.18 28-04-2003" // PART     Added DELL utility; updated W2K LDM
//efine DFS_V "5.18 26-04-2003" // PART/MAP Fix Linux device-name (wrong order)
//efine DFS_V "5.18 22-04-2003" // MBRcode  Added another GRUB MBR variant
//efine DFS_V "5.18 18-04-2003" // Errors   Added store-descr to many errors
//efine DFS_V "5.18 17-04-2003" // about    Added OS/2 kernel revision (TPLIB)
//efine DFS_V "5.18 16-04-2003" // about    Fine-tuned layout and information
//efine DFS_V "5.18 14-04-2003" // DFSee    New OS-mismatch checks at startup
//efine DFS_V "5.18 13-04-2003" // Watcom   Updated makefiles for AUTODEPEND
//efine DFS_V "5.18 09-04-2003" // display  changed C: to Cyl for readability
//efine DFS_V "5.18 08-04-2003" // Alt-F12  SB color: NORMAL - BRIGHT - INVERT
//efine DFS_V "5.18 06-04-2003" // HELP -?  on commands SET, SETANSI, TRACE
//efine DFS_V "5.18 06-04-2003" // Switch   '-C:2' sets bright FG colors only
//efine DFS_V "5.18 06-04-2003" // SET      'SCREEN BRIGHT' for bright FG color
//efine DFS_V "5.17 02-04-2003" // MAP      Added Linux-device name to MapLine
//efine DFS_V "5.17 02-04-2003" // PART     Moved Linux-device to other column
//efine DFS_V "5.17 31-03-2003" // AUTOBASE Set sane limits when no superblock
//efine DFS_V "5.17 31-03-2003" // MAP      Added Linux-device and disknumbers
//efine DFS_V "5.17 31-03-2003" // FIXSUPER Create/recalculate HPFS superblock
//efine DFS_V "5.17 30-03-2003" // DIRMAP   HPFS allocation percentage fixed
//efine DFS_V "5.17 29-03-2003" // PART     Added Linux /dev/hda1 style id's
//efine DFS_V "5.17 28-03-2003" // HELP -?  DELWIPE, RECOVER, SORT
//efine DFS_V "5.17 28-03-2003" // HELP -?  SCAN, MEM, SAVETO, IMPORT, EXPORT
//efine DFS_V "5.17 28-03-2003" // PSAVE    Fixed clipped registration text
//efine DFS_V "5.17 27-03-2003" // LOG      Add '-7-' for 8-bit ASCII logfile
//efine DFS_V "5.16 24-03-2003" // FDISK    Add '-?' help to several commands
//efine DFS_V "5.16 23-03-2003" // CR       Allow MAC DDM & partition-maps
//efine DFS_V "5.16 22-03-2003" // FDISK    Display MAC DDM & partition-maps
//efine DFS_V "5.16 16-03-2003" // CREATE   No align for exact nnnn,s sizes!
//efine DFS_V "5.16 14-03-2003" // PTE      Fixed dialog & field positioning
//efine DFS_V "5.15 10-03-2003" // Dialogs  Final touch-up and sync with TXLIB
//efine DFS_V "5.15 09-03-2003" // HELP     Rearranged help texts on <F1>
//efine DFS_V "5.15 08-03-2003" // FINDROOT fixed for HPFS (broken since 5.01)
//efine DFS_V "5.15 08-03-2003" // DFSee    Use 32-bit cylinder (CHS) values
//efine DFS_V "5.15 07-03-2003" // VOL      Fixed reading/writing with DFSDOS
//efine DFS_V "5.15 05-03-2003" // FAT      Fixed DIR display at cluster 0
//efine DFS_V "5.15 02-03-2003" // PTE/LVM  Avoid direct recursion
//efine DFS_V "5.15 24-02-2003" // PTEdit   Support SBview scroll + UI fixes
//efine DFS_V "5.14 23-02-2003" // PTEdit   Minor layout fix (obscured text)
//efine DFS_V "5.13 22-02-2003" // PTEdit   Added 'hidden' checkbox to Type
//efine DFS_V "5.13 21-02-2003" // WRIM     Fixed writing to VOLumes on OS/2
//efine DFS_V "5.13 19-02-2003" // PART     Added active and overlap warnings
//efine DFS_V "5.13 18-02-2003" // PTEdit   Added PgUp/PgDn + 'smart update'
//efine DFS_V "5.13 12-02-2003" // PTEdit   Dialog working except for 'smart'
//efine DFS_V "5.13 09-02-2003" // PTEdit   First working dialog for display
//efine DFS_V "5.13 04-02-2003" // BSFIND   Added size ToEnd/Begin final line
//efine DFS_V "5.13 02-02-2003" // ABOUT    Updated with OpenWatcom, in Dialog
//efine DFS_V "5.12 29-01-2003" // DOS32A   Tuned (no msgs, more stack/buffer)
//efine DFS_V "5.12 29-01-2003" // TRACE    -r close/reopen file on each line
//efine DFS_V "5.11 28-01-2003" // WALK     Added -? usage help (DISK/WALK)
//efine DFS_V "5.11 27-01-2003" // PART     All options using standard syntax
//efine DFS_V "5.11 27-01-2003" // BSFIND   Included the FAT32 spare-sectors
//efine DFS_V "5.11 26-01-2003" // PART     Check backward/looping EBR links
//efine DFS_V "5.11 25-01-2003" // PART     Check for invalid ptable entries
//efine DFS_V "5.11 24-01-2003" // TRACE    Added log-only, -s and -t options
//efine DFS_V "5.11 23-01-2003" // WALK     Detect backward or loop EBR links
//efine DFS_V "5.11 23-01-2003" // UI/SLT   Higher memory limits (min 15 Mb)
//efine DFS_V "5.11 21-01-2003" // CR       Current (-d) default, -d- is all
//efine DFS_V "5.11 20-01-2003" // LIST     Make -l- a default option with -d
//efine DFS_V "5.11 19-01-2003" // LIST     Use standard option syntax, as -f
//efine DFS_V "5.11 18-01-2003" // VIRT     Open new created disk unless -o-
//efine DFS_V "5.11 17-01-2003" // CL       Fix CL recognition (FDISK switch)
//efine DFS_V "5.11 16-01-2003" // CREATE   Fixed trap on "100,t" size spec
//efine DFS_V "5.10 14-01-2003" // LVM      Support USB-sticks with CHS x.1.1
//efine DFS_V "5.10 14-01-2003" // Many     Cleanup of . $ .NNN and symbolics
//efine DFS_V "5.10 14-01-2003" // CLONE    Use 0xFE as bad-sector pattern
//efine DFS_V "5.10 13-01-2003" // DFSee    <F12> collapses desktop/scroll
//efine DFS_V "5.10 13-01-2003" // FATSIM   Added -z option for compression
//efine DFS_V "5.10 11-01-2003" // PART     Added FreeBSD/OpenBSD OEM/format
//efine DFS_V "5.10 10-01-2003" // GEO      Fix RC 87 on OS/2 with forced GEO
//efine DFS_V "5.10 08-01-2003" // SETTYPE  Made 4th param optional again
//efine DFS_V "5.10 08-01-2003" // WIPE     New "z" as zero-pattern shortcut
//efine DFS_V "5.10 06-01-2003" // PRESTORE Added more detail to all dialogs
//efine DFS_V "5.10 06-01-2003" // PART/MAP Fix logical/wasted freespace text
//efine DFS_V "5.10 05-01-2003" // VIRT     Allow .PDX files older than 5.06
//efine DFS_V "5.10 03-01-2003" // SETBOOT  Using more detailed dialog texts
//efine DFS_V "5.09 02-01-2003" // LVM      Fixed (delete) add from dialog
//efine DFS_V "5.08 01-01-2003" // Main     RC in range 0..254 (DOS batch)
//efine DFS_V "5.08 31-12-2003" // Startup  Finetune of logo and about text
//efine DFS_V "5.08 30-12-2002" // WALK     Improved bad MBR/EBR detection
//efine DFS_V "5.08 30-12-2002" // Startup  Logo includes about + UPX/LXLITE
//efine DFS_V "5.08 29-12-2002" // SIM/WRIM Speedup compression (almost 2x!)
//efine DFS_V "5.08 29-12-2002" // CR       No 0x00 type, new 0xDF=DFSee-TMP
//efine DFS_V "5.08 28-12-2002" // Many     Giga, Kilo, Heads in mcs-numbers
//efine DFS_V "5.08 27-12-2002" // LVM      Add warning for NEW LVM/JFS type
//efine DFS_V "5.08 26-12-2002" // dialogs  START/SETA/SETTYPE/FAT2OS/PCLEAR
//efine DFS_V "5.08 25-12-2002" // DELETE   Better info in confirm dialog
//efine DFS_V "5.08 24-12-2002" // PART     Fixed disknr display > 10 disks
//efine DFS_V "5.08 18-12-2002" // PART     Changed freespace naming for MAP
//efine DFS_V "5.08 17-12-2002" // PART     added lvm diskname to PART & MAP
//efine DFS_V "5.08 15-12-2002" // FDISK    cleared 0xF6 sectors recognized
//efine DFS_V "5.07 12-12-2002" // LVM      Get unique PartitId with basePsn
//efine DFS_V "5.07 11-12-2002" // PART     Type 0x44 GoBack/Restore (Win-ME)
//efine DFS_V "5.07 09-12-2002" // DFSUNFD  Fixed abort on no-key; use script
//efine DFS_V "5.06 05-12-2002" // PART     -c option or "++c" performs check
//efine DFS_V "5.06 05-12-2002" // LVM      -D option will delete existing
//efine DFS_V "5.06 04-12-2002" // FIND     Fixed UNICODE search with -u opt
//efine DFS_V "5.06 04-12-2002" // LVM      Renamed from LVMSET + cleanup
//efine DFS_V "5.06 03-12-2002" // VCU      Clear + generate default LVM info
//efine DFS_V "5.06 03-12-2002" // SETTYPE  Use smart FAT sector-type assign
//efine DFS_V "5.06 02-12-2002" // LVMSET   JFS signature-sectors now updated
//efine DFS_V "5.06 02-12-2002" // LVMSET   -d:disknr works with more options
//efine DFS_V "5.06 02-12-2002" // LVMSET   speedup of single-partition work
//efine DFS_V "5.06 01-12-2002" // LVMSET   *  will operate on ALL partitions
//efine DFS_V "5.06 30-11-2002" // Commands -Q option suppresses all output
//efine DFS_V "5.06 29-11-2002" // MAP      Display warning if MBR unreadable
//efine DFS_V "5.06 29-11-2002" // CREATE   -L option for automatic LVMSET
//efine DFS_V "5.06 28-11-2002" // LVMSET   -c -d -n option: CRC and diskname
//efine DFS_V "5.06 28-11-2002" // LVMSET   -V option, default new volumename
//efine DFS_V "5.06 26-11-2002" // FDISK    modeless, works from all FS modes
//efine DFS_V "5.06 25-11-2002" // NTFS     fixed Init bug with MFT structure
//efine DFS_V "5.06 25-11-2002" // LVMSET   activated by the F8 function-key
//efine DFS_V "5.06 25-11-2002" // ALLOC    show partition-MAP for FDISK mode
//efine DFS_V "5.06 24-11-2002" // LVMSET   Added 'sync start/size' to dialog
//efine DFS_V "5.06 21-11-2002" // TRANS    WARNING on illegal head/sect nrs
//efine DFS_V "5.06 20-11-2002" // LVMSET   -P option/switch forces dialogs
//efine DFS_V "5.06 19-11-2002" // LVMSET   Added specific dialog for update
//efine DFS_V "5.06 17-11-2002" // DFSREAD  Clear buffer to zeroes on errors
//efine DFS_V "5.06 16-11-2002" // VIRTUAL  fixed trap for bad .PDx geometry
//efine DFS_V "5.06 15-11-2002" // Commands restructured for dialogs/menus
//efine DFS_V "5.06 14-11-2002" // Startup  Run profile.dfs when present
//efine DFS_V "5.06 14-11-2002" // CLONE    Reduced amount of screen output
//efine DFS_V "5.06 13-11-2002" // MODE     Set display size and windowing
//efine DFS_V "5.06 12-11-2002" // RESIZE   Automatic LVMSET after resize
//efine DFS_V "5.06 12-11-2002" // DISK     Add 2nd German Warp-4 to MBR list
//efine DFS_V "5.05 11-11-2002" // RESIZE   Allow resize UNKNOWN filesystems
//efine DFS_V "5.05 11-11-2002" // FAT2OS   FIXBOOT fixed OEM for OS/2 on FAT
//efine DFS_V "5.05 11-11-2002" // EDIT     Activate with F2 and Alt-E/A/U/H
//efine DFS_V "5.05 10-11-2002" // EDIT     write back (prompted) unless -w-
//efine DFS_V "5.05 10-11-2002" // WRITE    new confirm and -a option/prompt
//efine DFS_V "5.05 08-11-2002" // HPFS     "boot code area" to "micro-FSD"
//efine DFS_V "5.05 07-11-2002" // CLONE    Fixed order to/from in confirm
//efine DFS_V "5.05 03-11-2002" // NTFS     Support part/file size of 2048 Gb
//efine DFS_V "5.05 03-11-2002" // NTFS     Fix IMG extent-display (no boot)
//efine DFS_V "5.05 02-11-2002" // DFSee    Added HUGE size display (> 4Gb)
//efine DFS_V "5.05 01-11-2002" // NTFS     Accept partial corrupted MFT rec
//efine DFS_V "5.05 01-11-2002" // SIM/WRIM -first and -size option
//efine DFS_V "5.05 01-11-2002" // WIPE     -first, -size and -Interact option
//efine DFS_V "5.05 31-10-2002" // FILEFIND Find dir-entry for file(s) on FAT
//efine DFS_V "5.05 30-10-2002" // SUBFIND  Find subdirectories (..) on FAT
//efine DFS_V "5.05 30-10-2002" // DFSee    Removed all DOS16 specific code
//efine DFS_V "5.04 30-10-2002" // Read:  -A: switch, number of read-attempts
//efine DFS_V "5.04 29-10-2002" // DFsee  -E: Error and -O Output switches
//efine DFS_V "5.04 29-10-2002" // CLONE  -E: option, ignore/quit read errors
//efine DFS_V "5.04 29-10-2002" // SIM:   -E: option, ignore/quit read errors
//efine DFS_V "5.04 28-10-2002" // DISK:  Windows-98 added to MBR list
//efine DFS_V "5.04 27-10-2002" // EXPORT/IMPORT -data option, saves contents
//efine DFS_V "5.04 26-10-2002" // DISK:  VPC,DRDOS,MSDOS-NL,XP in MBR list
//efine DFS_V "5.04 21-10-2002" // CA:    Fixed MFT/FNODE allocation display
//efine DFS_V "5.04 13-10-2002" // VIRT:  automatic .PDx template extension
//efine DFS_V "5.04 13-10-2002" // DISK:  GRUB boot loader in MBR list
//efine DFS_V "5.03 01-10-2002" // DISK:  Warp 4 English/German in MBR list
//efine DFS_V "5.03 27-09-2002" // CHECK: Allow check on volumes too
//efine DFS_V "5.03 25-09-2002" // VOL:   Minor updates, analyse FAT32 trap
//efine DFS_V "5.02 22-09-2002" // DISK:  Added AirBOOT to recognized MBR's
//efine DFS_V "5.02 22-09-2002" // CHECK: fine tuning of alloc progress-bar
//efine DFS_V "5.02 22-09-2002" // NEWMBR -I option for MBR bootcode image
//efine DFS_V "5.02 22-09-2002" // CREATE -I option for initialization image
//efine DFS_V "5.02 22-09-2002" // PART:  Support -t- option, suppress table
//efine DFS_V "5.02 22-09-2002" // PART:  Display MBR descriptions with '-m'
//efine DFS_V "5.02 21-09-2002" // NEWMBR code now I13X capable, txt messages
//efine DFS_V "5.02 20-09-2002" // PART:  Mark partitions without LVM info
//efine DFS_V "5.02 20-09-2002" // VMAKE: fixed GEO bug on VRE/VMA iteration
//efine DFS_V "5.02 17-09-2002" // VMAKE: use VIRTUAL as a readable synonym
//efine DFS_V "5.02 17-09-2002" // VMAKE: automatic PRESTORE using .PDx file
//efine DFS_V "5.02 17-09-2002" // PREST: no sector confirmation, when "-c-"
//efine DFS_V "5.02 17-09-2002" // FINDCP: stop search after 1st, unless "-A"
//efine DFS_V "5.01 10-09-2002" // LVM 'bootable' indicator on partitions
//efine DFS_V "5.01 09-09-2002" // Auto 'show' on SETBOOT change, fix warning
//efine DFS_V "5.01 05-09-2002" // Add warning on multiple extended container
//efine DFS_V "5.01 05-09-2002" // Add warning on sectors/track >= 64
//efine DFS_V "5.01 05-09-2002" // Fix CHS warnings for log outside container
//efine DFS_V "5.01 05-09-2002" // Fixed CHS for sectors >= 64 on CREATE
//efine DFS_V "5.01 31-08-2002" // Fixed map -g to show geometry again
//efine DFS_V "5.01 29-08-2002" // Fixed WRIM write bufsize on compressed data
//efine DFS_V "5.01 28-08-2002" // Force extended Int13 use on GEO cyl >= 1024
//efine DFS_V "5.01 24-08-2002" // Display 'deleted' partentry too (type == 0)
//efine DFS_V "5.01 23-08-2002" // ext-int13 data to EDD 3.0 spec and -I- sw
//efine DFS_V "5.01 21-08-2002" // Non-windowed, no status on last cmd and -Q
//efine DFS_V "5.01 14-08-2002" // Fixed FAT alloc display trap on empty
//efine DFS_V "5.00 05-08-2002" // Fixed FAT FIXBOOT for OS2 bootsector
//efine DFS_V "5.0 02-08-2002" // Fixed DIRFIND for FAT32 partitions
//efine DFS_V "5.0 02-08-2002" // Added and tuned Mb-todo in SLT alloc check
//efine DFS_V "5.0 01-08-2002" // FAT added obscure valid-chars, for CHECK
//efine DFS_V "5.0 31-07-2002" // FAT FIXBOOT not seen by DOS/XP (Jump ..)
//efine DFS_V "5.0 31-07-2002" // SLT progress-bar color; <Esc> \path\file
//efine DFS_V "5.0 29-07-2002" // Investigate DIRFIND bug on WATCOM
//efine DFS_V "5.0 28-07-2002" // Fixed trap on 'list' without parameters
//efine DFS_V "5.0 28-07-2002" // Finished COMPARE command including list
//efine DFS_V "5.0 27-07-2002" // Statusline progress for all ... commands
//efine DFS_V "5.0 27-07-2002" // Added statusline progress to DIRFIND
//efine DFS_V "5.0 26-07-2002" // Added statusline progress to FIND command
//efine DFS_V "5.0 26-07-2002" // Fixed XBUFS buf for WIPE, and used -b now
//efine DFS_V "5.0 24-07-2002" // Unified -b for buffer size SCAN/SIM/WRIM
//efine DFS_V "5.0 23-07-2002" // Improved SCAN speed and progress display
//efine DFS_V "5.0 22-07-2002" // Fixed FAT SLT/CHECK trap and other bugs
//efine DFS_V "5.0 21-07-2002" // Fixed HPFS codepage bug on SLT/CHECK
//efine DFS_V "5.0 21-07-2002" // SLT sizing, DOS32 600.000 files / 300 Gb
//efine DFS_V "5.0 20-07-2002" // No delay on unregistered 'query RV'
//efine DFS_V "5.0 18-07-2002" // Added CMD/CONFIRM to generic help
//efine DFS_V "5.0 17-07-2002" // Changed to default windowing in TRACE
//efine DFS_V "5.0 17-07-2002" // Fixed CLONE buffer usage for DOS32
//efine DFS_V "5.0 16-07-2002" // Fixed HPFS SLT-build trap (hpfs-> size)
//efine DFS_V "5.0 15-07-2002" // Fixed rbuf clobbering, use 16Kb xbuf now
//efine DFS_V "5.0 13-07-2002" // Fixed logfile-format on FILEFIND/DELFIND
//efine DFS_V "5.0 13-07-2002" // Fixed trap on 'vol 14' in DOS version
//efine DFS_V "5.0 12-07-2002" // Added message on allocation error in main
//efine DFS_V "5.0 12-07-2002" // Allow specific fs modes like 'fs fat16'
//efine DFS_V "5.0 12-07-2002" // Fixed FAT16 detection and trap on RESIZED
//efine DFS_V "5.0 11-07-2002" // Fixed 'query fv/fp/fl'; support logresume
//efine DFS_V "5.0 10-07-2002" // Progress DOS SLT; allow volume on check
//efine DFS_V "5.0 09-07-2002" // Added extra TxCancelAbort() in MultiCmd
//efine DFS_V "5.0 08-07-2002" // Last recompile with 4.28 updates
//efine DFS_V "5.0 03-07-2002" // Fixed rbuf R/W for rbuf+offset operands
//efine DFS_V "5.0 02-07-2002" // New dfsmkreg + check for 5.xx (dfsee.key)
//efine DFS_V "5.0 02-07-2002" // Fixed OpenLarge _System calling on WATCOM
//efine DFS_V "5.0 01-07-2002" // Unit tests updates, structure packing
//efine DFS_V "5.0 25-06-2002" // Made rbuf/brec DPMI compatible memory

// definitions and version info for the now obsolete 4.xx version
//efine DFS_INTROD     20010718L  // introduction date (oldest possible key)
//efine DFS_EXPIRE     20021001L  // expiry date for unregistered versions

//efine DFS_V "4.29 20-07-2002" // No delay on unregistered 'query RV'
//efine DFS_V "     12-07-2002" // Added message on allocation error in main
//efine DFS_V "4.28 08-07-2002" // CREATE auto add of -d:n to autoshow -r
//efine DFS_V "     08-07-2002" // LVMSET easy navigation using 'd' and 'x'
//efine DFS_V "     06-07-2002" // PART   new'-d:disknr' restricts output
//efine DFS_V "     04-07-2002" // LVMSET LVMSHOW alias and show size in Mb
//efine DFS_V "     01-07-2002" // LVMSET added -s option to sync size & LSN
//efine DFS_V "     27-06-2002" // RESIZE textual updates; fixed -max limit
//efine DFS_V "     26-06-2002" // LVMSET allow -v- and -p- delete vol/part
//efine DFS_V "     25-06-2002" // WATCOM updates for testing
//efine DFS_V "4.27 24-06-2002" // CREATE -o option for automatic open part
//efine DFS_V "     24-06-2002" // DIRFIND add -l:wildcard option to list files
//efine DFS_V "     24-06-2002" // VOL    better BASE size determination (OS/2)
//efine DFS_V "     24-06-2002" // WRIM   better warning on imagefile too short
//efine DFS_V "     23-06-2002" // RESIZE synonym for TRUNC; added -max option
//efine DFS_V "     22-06-2002" // DIRFIND fixed parsing for path parameter
//efine DFS_V "     21-06-2002" // FINDBASE HPFS, set correct base END value
//efine DFS_V "     21-06-2002" // PART   added new XPLDM type; use brec/rbuf
//efine DFS_V "     20-06-2002" // TRUNC  to LARGER size; default wipe zeroes
//efine DFS_V "     17-06-2002" // source updates for WATCOM; "map -r -g"
//efine DFS_V "4.26 09-06-2002" // SETLET etc, explicit warning on Win2000/XP
//efine DFS_V "     05-06-2002" // TYPE   fixed trap for range of types
//efine DFS_V "     03-06-2002" // reset  pending 'abort' for non-windowed
//efine DFS_V "     03-06-2002" // BATCH  command reintroduced for non-DOS
//efine DFS_V "     03-06-2002" // MAP    fixed traps on more than 54 partitions
//efine DFS_V "     02-06-2002" // MAP    fixed trap after CR and no refresh
//efine DFS_V "4.25 31-05-2002" // CR     fixed false-BM-name creation for NT
//efine DFS_V "     31-05-2002" // CLONE  issue size warning only when needed
//efine DFS_V "     30-05-2002" // START  fdisk startable, new 'Clear' option
//efine DFS_V "     30-05-2002" // PART   changed color of freespace to cyan
//efine DFS_V "     30-05-2002" // MAP    -d:nr & -d or '.' = (current) disk
//efine DFS_V "     30-05-2002" // CR     Don't change current disk on CR PRI
//efine DFS_V "4.24 28-05-2002" // PL     Auto display of LVM/JFS fake EBR's
//efine DFS_V "     25-05-2002" // CLONE  no size-warning if no parameters
//efine DFS_V "     24-05-2002" // CR    '-d' or '-d:0' will use current disk
//efine DFS_V "     24-05-2002" // VMA   '-o' option, making it current disk
//efine DFS_V "4.23 23-05-2002" // CLONE  fix limit for destination size too
//efine DFS_V "     23-05-2002" // CR     improved confirmation dialog text
//efine DFS_V "     23-05-2002" // CR     fix numeric values for '-t:' option
//efine DFS_V "     22-05-2002" // FIXCHS new command to match CHS to LBA/geo
//efine DFS_V "     22-05-2002" // LIST   new '+gs' option for 'Sys' geometry
//efine DFS_V "     20-05-2002" // Use 'Sys' geometry when using OS r/w API's
//efine DFS_V "     15-05-2002" // FILEFIND, new cmd to find HPFS/NTFS files
//efine DFS_V "     15-05-2002" // Allow trailing '\' on SAVEAS/RECOVER path
//efine DFS_V "     14-05-2002" // Report correct '# recovered' after RECOVER
//efine DFS_V "4.22 12-05-2002" // Don't use SectorIO on HPFS > 4Gb (trap)
//efine DFS_V "     08-05-2002" // New -h, -a and -u option on delwipe
//efine DFS_V "     06-05-2002" // New -h, -a and -u option on find and wipe
//efine DFS_V "     05-05-2002" // PART    Allow '-warnings' as option
//efine DFS_V "     03-05-2002" // DFSDOS  Fixed read/write to a volume
//efine DFS_V "     03-05-2002" // DFSDOS  Fixed large-disk errors
//efine DFS_V "     30-04-2002" // SIM:    -b:nn + show compress/buffersize
//efine DFS_V "     30-04-2002" // WRIM:   limit -b:nn buffer upto 63
//efine DFS_V "     29-04-2002" // SIM:    added confirmation dialog
//efine DFS_V "     29-04-2002" // WRIM:   auto select .imz or .img image
//efine DFS_V "     29-04-2002" // WRIM:   fixed imaging to/from floppy
//efine DFS_V "     29-04-2002" // GEO:    new name, get volume geometry
//efine DFS_V "4.21 19-04-2002" // WRIM:   Fixed bug with compressed data
//efine DFS_V "     19-04-2002" // Updated evaluation period, expiry date
//efine DFS_V "     19-04-2002" // EDIT:   allow batch mode (no prompting)
//efine DFS_V "     19-04-2002" // Improved handling of MBR without bootcode
//efine DFS_V "     19-04-2002" // WRIM:   speedup and better progress report
//efine DFS_V "     18-04-2002" // CREATE: changed dummy-CHS value to standard
//efine DFS_V "     18-04-2002" // EDIT:   fixed data garbling for -h: option
//efine DFS_V "     17-04-2002" // PART:   new warnings for non-std dummy-CHS
//efine DFS_V "     17-04-2002" // CREATE: fixed cylinder alignment for -x:
//efine DFS_V "     17-04-2002" // WRIM:   Added -test option (no real write)
//efine DFS_V "4.20 16-04-2002" // Fixed wrong size on 1st of a multi-JFS
//efine DFS_V "     16-04-2002" // Fixed CREATE bug with multiple free areas
//efine DFS_V "     16-04-2002" // Fixed DFSUNFD parser bug (possible trap)
//efine DFS_V "     15-04-2002" // Confirmation for external (unknown) cmds
//efine DFS_V "     15-04-2002" // Added error and verbose control to recover
//efine DFS_V "     15-04-2002" // Fixed passing of options to FDISK module
//efine DFS_V "     15-04-2002" // Numeric find types and default repeated;
//efine DFS_V "4.19 03-04-2002" // Allow 01-01 system date; use reg in exe-dir
//efine DFS_V "4.18 18-03-2002" // Added edit parameter prompting
//efine DFS_V "     14-03-2002" // Added JFS and NTFS Volumename to displays
//efine DFS_V "     09-03-2002" // Minor help update
//efine DFS_V "4.17 06-03-2002" // Updated FAT32 bootsector recovery
//efine DFS_V "     04-03-2002" // Use script basename for $0, not full name
//efine DFS_V "     04-03-2002" // zerofree '-test' option and real wipe
//efine DFS_V "     02-03-2002" // zerofree fixed for freespace at end
//efine DFS_V "     01-03-2002" // 'wipe -f' and 'zerofree' command, 1st test
//efine DFS_V "     28-02-2002" // Large-file support on SIM and WRIM   (OS2)
//efine DFS_V "     27-02-2002" // Large-file support on IM and VOL cmd (OS2)
//efine DFS_V "     25-02-2002" // TRUNCATE implemented for HPFS
//efine DFS_V "     24-02-2002" // Window-collapse to title with <F12>
//efine DFS_V "4.16 22-02-2002" // RUN with arguments and single-step
//efine DFS_V "     18-02-2002" // MsgBox in UR corner, scroll with Alt+<>
//efine DFS_V "     17-02-2002" // Added say/sleep/autoshow to DFSMDOS
//efine DFS_V "     16-02-2002" // Fixed size-calculation bug in DiskGeo etc
//efine DFS_V "     14-02-2002" // Replaced win/nowin by -w+ and -w- switch
//efine DFS_V "     13-02-2002" // Support HPFS386 style deleted FNODE's
//efine DFS_V "     12-02-2002" // RUN command for native TXS scripts beta
//efine DFS_V "     11-02-2002" // ignore-lock default; removed 'batch' cmd
//efine DFS_V "     10-02-2002" // Comment using ';' on commands is ignored
//efine DFS_V "4.15 07-02-2002" // Removed external cmds in shell mode '-S'
//efine DFS_V "     06-02-2002" // Improved CLONE confirmation dialog
//efine DFS_V "     06-02-2002" // Keep max-LSN when new base specified
//efine DFS_V "     05-02-2002" // Added 'non-disk to disk' clone warning
//efine DFS_V "     04-02-2002" // Added '-7' switch; fixed NTFS SLT bug!
//efine DFS_V "     03-02-2002" // Larger scroll buffer, 4000 to 9000 lines
//efine DFS_V "     31-01-2002" // Fixed off-by-1 error on find result offset
//efine DFS_V "4.14 29-01-2002" // Larger rbuf (126 sect) for fast sim/wrim
//efine DFS_V "     27-01-2002" // Added multi-sector R/W for DOS & OS/2
//efine DFS_V "     26-01-2002" // Removed DEF16 code; '-S' for shell mode
//efine DFS_V "     24-01-2002" // LVMSET command, beta released to Alain
//efine DFS_V "4.13 22-01-2002" // CLONE command for disk, part and vol
//efine DFS_V "     16-01-2002" // NTFS ALLATTRS allocation for SLT
//efine DFS_V "     16-01-2002" // Added 'part -a' and 'part ++a' displays
//efine DFS_V "     16-01-2002" // Added display of HPFS bootdrive in Bootrec
//efine DFS_V "     15-01-2002" // Better NTFS SLT; Check sets RC to #errors
//efine DFS_V "     14-01-2002" // NTFS supporting sparse/compressed files
//efine DFS_V "     13-01-2002" // Created DFSLDOS running in 310Kb (FDISK)
//efine DFS_V "     11-01-2002" // Added SLT build for NTFS, MFT + bootsecs
//efine DFS_V "     10-01-2002" // Generic LsnIterator function (Ntfs: MFT)
//efine DFS_V "4.12 08-01-2002" // Made DOS version run in 600Kb (no HELP!)
//efine DFS_V "     05-01-2002" // Give 'trunc' usage even when no partition
//efine DFS_V "     03-01-2002" // Made Cl2Lsn generic; Added NTFS truncation
//efine DFS_V "     01-01-2002" // Fix FAT alloc display bug (nonClust size)
//efine DFS_V "     30-12-2001" // Added ALLOC display to NTFS and HPFS
//efine DFS_V "4.11 26-12-2001" // Added ".xx" check for key and (c) 2002
//efine DFS_V "     26-12-2001" // Fixed truncate size bug and 'part' RO bug
//efine DFS_V "     22-12-2001" // Help update and DFSTRUNC script
//efine DFS_V "     21-12-2001" // GEO display in base; DIRTY in HpfsInit
//efine DFS_V "     20-12-2001" // Enhanced 'base' cmd with several options
//efine DFS_V "     19-12-2001" // Added TRUNC usage;
//efine DFS_V "     18-12-2001" // Added -f and -f:space option to truncate
//efine DFS_V "     18-12-2001" // Changed 'vw' option PRESTORE to -v -list
//efine DFS_V "     17-12-2001" // Added update of Ptable to truncate
//efine DFS_V "     15-12-2001" // Fixed bug in VerboseShow (wrong base)
//efine DFS_V "     14-12-2001" // TRUNCATE; several display fixes
//efine DFS_V "     13-12-2001" // Generic ALLOC and TRUNC; fixboot -spare
//efine DFS_V "     12-12-2001" // EBR warning display; fix nested str bug
//efine DFS_V "     06-12-2001" // Fat 'trunc' command; analysis only
//efine DFS_V "     04-12-2001" // Simpler freespace names; allow store -R-
//efine DFS_V "4.10 30-11-2001" // Fixed several non-512 byte sector problems
//efine DFS_V "     29-11-2001" // Fixed several traps on bad HPFS sectors
//efine DFS_V "     29-11-2001" // Fixed trap-D with CDROM present (2048 bug)
//efine DFS_V "     29-11-2001" // ReadOnly in status, and detect RO img
//efine DFS_V "     29-11-2001" // Added -R switch/option forcing read-only
//efine DFS_V "     28-11-2001" // Added -I switch forcing std Int13 < 1024
//efine DFS_V "     25-11-2001" // Minor fix in msg for SETA visible on BMGR
//efine DFS_V "     23-11-2001" // Fixed CHECK/SLT command, added -r option
//efine DFS_V "     22-11-2001" // Updated CR and SETBOOT for new parsers
//efine DFS_V "     20-11-2001" // Updated all cmd-parsers; DFSMDOS 380 Kb
//efine DFS_V "     19-11-2001" // -? = help on commandline switches
//efine DFS_V "     18-11-2001" // -t = auto timestamp (also on -q and -l)
//efine DFS_V "     16-11-2001" // Fixed autoshow; allow multi-command too
//efine DFS_V "     15-11-2001" // Add Intel EFI spec GPT_DISK type (Win-XP)
//efine DFS_V "     14-11-2001" // Add "-r" and "-a" to "part" replacing !
//efine DFS_V "     11-11-2001" // Add "-e" option to settype and fixext
//efine DFS_V "     09-11-2001" // First parser usage in FIND / DELFIND
//efine DFS_V "4.09 05-11-2001" // Fixed garbage paint bug (VIO 64Kb segment)
//efine DFS_V "     04-11-2001" // Ctrl-arrows; one word forward or backward
//efine DFS_V "     04-11-2001" // Ctrl-B: clear-begin; ESC/ctrl-BS: clear all
//efine DFS_V "4.08 30-10-2001" // Automatic scroll to end before each cmd
//efine DFS_V "     29-10-2001" // Finished FAT32 FINDROOT (for FIXBOOT)
//efine DFS_V "     28-10-2001" // Added copy spare for FAT32 FIXBOOT
//efine DFS_V "     25-10-2001" // Added extra warning for create type 00
//efine DFS_V "     25-10-2001" // Use MftCopy in NtfsInit if MftClus is bad
//efine DFS_V "     25-10-2001" // FAT dir display update so 'cl 0' is 'Root'
//efine DFS_V "     24-10-2001" // Search 1st and 2nd FAT if bootsec damaged
//efine DFS_V "     23-10-2001" // Fixed FAT label display in part-table
//efine DFS_V "     22-10-2001" // Added FAT32 rootdir to bootsector display
//efine DFS_V "     21-10-2001" // Changed SWAP/EXT2 naming for type 82/83
//efine DFS_V "4.07 18-10-2001" // Added detection for EBR-loop (limit 100)
//efine DFS_V "     18-10-2001" // Store update; multiple-disk bug fixed
//efine DFS_V "     17-10-2001" // FIXBOOT for FAT and FAT32 (beta only)
//efine DFS_V "     17-10-2001" // DIR imagefiles when parameter ends in '\'
//efine DFS_V "4.06 15-10-2001" // Added FAT32 2nd/3rd bootsector display
//efine DFS_V "     12-10-2001" // Made 'nonstd type 0f' non-critical warning
//efine DFS_V "     11-10-2001" // Show all critical warnings on PART display
//efine DFS_V "     10-10-2001" // Fixed extended-int13 usage for Thinkpads
//efine DFS_V "4.05 10-10-2001" // Store cmd improved; User can switch now
//efine DFS_V "     07-10-2001" // Switch "-a" on DFS switch ANSI output OFF
//efine DFS_V "     07-10-2001" // Fixed cmd-parser bug ('vma 1000 02' part 2)
//efine DFS_V "     06-10-2001" // Updated status line with 'Store' and partid
//efine DFS_V "     04-10-2001" // Updated 'part -' to 'part ,' and 'part ,*'
//efine DFS_V "     04-10-2001" // Automatic re-read of diskinfo on FIXBOOT
//efine DFS_V "     03-10-2001" // Included bright/blink fix from TXLIB 155
//efine DFS_V "     02-10-2001" // Added LVM part-name and heading to 'part -'
//efine DFS_V "4.04 01-10-2001" // Freed up 60Kb in DFSMDOS (no windowing)
//efine DFS_V "     30-09-2001" // Added reporting last accessed PSN on errors
//efine DFS_V "     29-09-2001" // Fixed trap in HPFS 'check' bad CPINF sector
//efine DFS_V "     28-09-2001" // Updated registration code (tplib)
//efine DFS_V "4.03 20-09-2001" // Added Confirm dialogs with help
//efine DFS_V "     18-09-2001" // Fixed "More .." bug with autoquit & batch
//efine DFS_V "     15-09-2001" // Better windowing; Fix parse-trap part ++)
//efine DFS_V "     19-08-2001" // Nicer window frame > 80x25
//efine DFS_V "4.02 17-08-2001" // New argv/option parser used (list -u -8.3)
//efine DFS_V "     15-08-2001" // better scaling in FAT alloc; show last-used
//efine DFS_V "     13-08-2001" // Fixed find-free BMPRIMARY entry at create
//efine DFS_V "     10-08-2001" // Fixed HPFS 'fixboot' with wrong superblock
//efine DFS_V "     10-08-2001" // Fixed NTFS 'findroot' when start is no MFT
//efine DFS_V "     08-08-2001" // Read-failure msg on OpenDisk (error 31)
//efine DFS_V "     07-08-2001" // Added registration fragment to PSAVE data
//efine DFS_V "     04-08-2001" // Fixed HPFS delfind for invalid parent
//efine DFS_V "4.01 01-08-2001" // bsfind * all; query DV/PV/FV to validate #
//efine DFS_V "     31-07-2001" // fix trap on FAT32 when type is 0x06
//efine DFS_V "     26-07-2001" // query registration and version details
//efine DFS_V "4.00 18-07-2001" // Added registration checks; LVM BB update
//efine DFS_V "3.43 11-07-2001" // Added <Ctrl>-arrow help;
//efine DFS_V "3.42 09-07-2001" // Changed 'list +s' to show sector type
//efine DFS_V "3.41 07-07-2001" // Fixed trap on illegal NTFS date (win2000)
//efine DFS_V "     07-07-2001" // comment on cmds, use sep ; (delshow == %)
//efine DFS_V "     06-07-2001" // Fixed "(inserted)"; HPFS hotfix display
//efine DFS_V "     05-07-2001" // Added code for LVM feature display DLF/BBF
//efine DFS_V "     02-07-2001" // Add JFS as LVM type; Improved "walk" output
//efine DFS_V "     20-06-2001" // Updated DFSVER dependancy in makefile.32b
//efine DFS_V "     26-04-2001" // Reworded locking message
//efine DFS_V "3.40 25-04-2001" // More JFS SP display & FIXBOOT; minor fixes
//efine DFS_V "3.39 20-04-2001" // Added JFS specific modules
//efine DFS_V "     17-04-2001" // Sector override on 'H' command
//efine DFS_V "3.38 16-04-2001" // "part d:" on multi (JFS) vol; 2Gb warning
//efine DFS_V "     12-04-2001" // New hpfs 'FINDCP' and 'FIXSPARE' commands
//efine DFS_V "     11-04-2001" // BSFIND start at 0; version in help
//efine DFS_V "     09-04-2001" // LVM sign in IteratePlvm, BSFIND, PSAVE
//efine DFS_V "3.37 06-04-2001" // Added LVM signature-sector; types on CR
//efine DFS_V "     05-04-2001" // Added LVM sector CRC calculation; part !
//efine DFS_V "     29-03-2001" // More LVM-bmgr updates; LVM info sector
//efine DFS_V "3.36 22-03-2001" // Extended W2KBM to avoid CHKDSK screen
//efine DFS_V "     21-03-2001" // Made 64 bytes the fixed boundary for h,H
//efine DFS_V "     08-03-2001" // HPFS DIRTY command
//efine DFS_V "     06-03-2001" // No DOS wrng; No NT reboot; Fix NT partlist
//efine DFS_V "3.35 28-02-2001" // Added MakePath on DOS version (8.3 forced)
//efine DFS_V "     26-02-2001" // Retry or force 8.3 path on saveto/delsave
//efine DFS_V "     22-02-2001" // NT native reboot & TOUPPER macro
//efine DFS_V "3.34 26-11-2000" // Never use LVM-info in Win-NT environment
//efine DFS_V "3.33 08-11-2000" // no more exit on WIN32CON errors
//efine DFS_V "3.32 23-07-2000" // Split off dfsCfdsk; DFS stores, dfsMdisk
//efine DFS_V "3.31 22-06-2000" // fixboot more forgiving on found bootsect
//efine DFS_V "3.30 19-06-2000" // NtfsInit more robust on bad bootsectors
//efine DFS_V "3.29 18-06-2000" // BOOTR display update; PRESTORE command
//efine DFS_V "3.28 28-05-2000" // Cleanup 'list' cmd; Better EBR recognition
//efine DFS_V "3.27 23-05-2000" // Fix DOS 'list +s'; added 'list +b'
//efine DFS_V "3.26 21-05-2000" // Del obsolete; diskgeo bsfind/disk; list +s
//efine DFS_V "3.25 01-05-2000" // Added SETLET, NTMAP, CDR and NTDEV cmds
//efine DFS_V "3.24 04-04-2000" // Fixed traps in HPFS CodePage & BMGR names
//efine DFS_V "3.23 26-03-2000" // Fixed find/undelete very long filenames
//efine DFS_V "3.22 21-03-2000" // reboot using external-program fixed
//efine DFS_V "3.21 14-03-2000" // Minor AUX cleanup; Several small fixes
//efine DFS_V "3.20 12-03-2000" // VRAID support; -q and -b startup options
//efine DFS_V "3.19 05-03-2000" // NT signature 'DF5EE319' in NEWMBR + NTSIG
//efine DFS_V "3.18 28-02-2000" // Minor fixes; F4=SCRFILE; fixed CR LOG bug!
//efine DFS_V "3.17 11-02-2000" // PSAVE 3rd shot; PART -; Csize in Geo
//efine DFS_V "3.16 31-01-2000" // Offset in edit hex-dump; Fixed screen-on
//efine DFS_V "3.15 26-01-2000" // NT FDISK map; PCLEAR cmd; Find Unicode
//efine DFS_V "3.14 06-01-2000" // Fix FAT check bug; Fix trap on NTFS alloc
//efine DFS_V "3.13 02-01-2000" // Fixed command-history corruption (DFSDOS)
//efine DFS_V "3.12 01-01-2000" // HPFS B-tree display fix; query; history
//efine DFS_V "3.11 29-12-99" // Ext-I13 > 1023; generic FAT2OS; QUERY cmd
//efine DFS_V "3.10 27-10-99" // Cleanup PC-LINT; SspaceSaveTo (FAT + NTFS)
//efine DFS_V "3.09 19-10-99" // No optimize (FAT); NTFS MFT-0 fix; NTFS +f~
//efine DFS_V "3.08 26-09-99" // NTFS MFT fix; offset in part-table hex-dump
//efine DFS_V "3.07 14-09-99" // Added DIR LSN ref to HPFS check msg 2000
//efine DFS_V "3.06 05-09-99" // LVM sector via nav.xtra; version in prompt
//efine DFS_V "3.05 30-08-99" // NTFS MFT base/cont recs; in-use field fix
//efine DFS_V "3.04 15-08-99" // Aurora GEO; NTFS runlist; disp + Find speed
//efine DFS_V "3.03 04-08-99" // ANSI on/off cleanup; part $* large cylinders
//efine DFS_V "3.02 27-07-99" // Ext-Int13 conditional, only on disks > 8Gb
//efine DFS_V "3.01 25-07-99" // SB alloc + Ext-Int13; cmd-recall; #q; LVM
//efine DFS_V "3.00 10-07-99" // win/nowin cmd; Logo; dirfind fixed
//efine DFS_V "3.00 8-07-99" // Trace bug; SLT DFSDOS; bsfind
//efine DFS_V "3.00 7-07-99" // DFSWIN UI; Fix EBR base 0 bug; DOS tuning
//efine DFS_V "2.99 28-06-99" // Beta version introducing DFSWIN windowing
//efine DFS_V "2.98 17-06-99" // Added ext-type 15; fixed %s in WARNING text
//efine DFS_V "2.97 13-06-99" // Fixed "EXT2" recognition in "create"
//efine DFS_V "2.96 11-06-99" // Fixed HPFS DELFIND cmd handling;
//efine DFS_V "2.95 21-04-99" // Minor LVM display fix;
//efine DFS_V "2.94 20-04-99" // LVM and JFS display updates; plist LVM
//efine DFS_V "2.93 07-04-99" // reboot internal for DOS/OS2; geo at start
//efine DFS_V "2.92 31-03-99" // 'type' update; minor fixes DOS2OS and DELETE
//efine DFS_V "2.91 28-03-99" // NTFS MIR cmd; .NNN, BM-name and CLEANUP fixes
//efine DFS_V "2.90 25-03-99" // FDISK del,newmbr,seta,setb,setn,sett,sta,cr,pl
//efine DFS_V "2.89 16-02-99" // Huge-file Fnode update; DFSDOS ANSI detect
//efine DFS_V "2.88 15-02-99" // Final touch MAP; dfsquick/dfsbw.bat dos/NT
//efine DFS_V "2.87 14-02-99" // minor display updates; No auto read diskinfo
//efine DFS_V "2.86 07-02-99" // freespace type; map cmd; BASE fix; trans cmd
//efine DFS_V "2.85 25-01-99" // NT admin warning; Small FAT bugfix;
//efine DFS_V "2.84 24-01-99" // Calc CHS; FreeSpace info; fixext/setptype cmd
//efine DFS_V "2.83 12-01-99" // Ext type 0f; NTFS MftSize&DirSize; fix trap
//efine DFS_V "2.82 01-01-99" // NTFS fixroot; recognize BeOS filesystem
//efine DFS_V "2.82 29-12-98" // Set exit RC; Cyl size; auto CPinfo; Int13Ext
//efine DFS_V "2.81 16-12-98" // Allow diskgeo on images; some small fixes
//efine DFS_V "2.80 13-12-98" // DOS Cyl fix; TZDFSEE dates; RunList; list +d
//efine DFS_V "2.79 29-11-98" // NTFS structure fixup; FAT dir bug; NTFS DIR
//efine DFS_V "2.78 21-11-98" // Fixed WRIM for DFSDOS; Fixed WIPE trap
//efine DFS_V "2.77 17-11-98" // NTFS run-list display; fixed autobase trap
//efine DFS_V "2.76 08-11-98" // Changed default 'check' mask to 0xffffffff
//efine DFS_V "2.75 21-10-98" // No default SLT generation on "part" and "vol"
//efine DFS_V "2.74 01-09-98" // Fixed trap in WRIM command (no compression)
//efine DFS_V "2.73 03-08-98" // Temporary fix 'vol x' trap on HPFS volumes
//efine DFS_V "2.72 30-07-98" // New $ option to 'part' for size-info table
//efine DFS_V "2.71 29-07-98" // Fix reporting large cyl-nrs + extra partinfo
//efine DFS_V "2.70 28-07-98" // Fixed time_t compiler change on HPFS dates
//efine DFS_V "2.69 24-07-98" // Fixed (CD-Rom) not-ready trap; LAN warning
//efine DFS_V "2.68 07-06-98" // Fixed LZW memory leak and hang on WRIM
//efine DFS_V "2.67 04-06-98" // Optional LZW compression on SIM and WRIM
//efine DFS_V "2.66 16-05-98" // FAT32 fix max-FAT value 0x0fffffff;
//efine DFS_V "2.65 10-05-98" // Added FAT32 bootsector recognition; SIM fix
//efine DFS_V "2.64 04-05-98" // Added async start cmd and SIM to LPT-pipe
//efine DFS_V "2.63 19-04-98" // Fixed DFSDOS WRIM and IM commands (file I/O)
//efine DFS_V "2.62 30-03-98" // Usage update; NTFS MFT record display update
//efine DFS_V "2.61 29-03-98" // xxx.DIR orphans; RBUF fix; DispHex; NTFS-MFT
//efine DFS_V "2.60 08-03-98" // Single snlist; recover/saveto; dirfind, wipe
//efine DFS_V "2.59 24-02-98" // Fine tuning; Fixed auto-detect on "id" cmd
//efine DFS_V "2.58 22-02-98" // Fixed More... bugs; Fixed FAT EA & label bug
//efine DFS_V "2.57 15-02-98" // VFAT ShowDetails; FAT Os2Ea; "find" cleanup
//efine DFS_V "2.56 05-02-98" // VFAT + EA details; bugfix HPFS major version
//efine DFS_V "2.55 25-01-98" // Clean-up; DOS version; diskgeo; FAT find \..
//efine DFS_V "2.54 28-12-97" // Esc alloc; profile; Most FAT support; MBR
//efine DFS_V "2.53 14-12-97" // FAT map; More ...; Fixed find & delfind BUG
//efine DFS_V "2.52 07-12-97" // HPFS check; spare/super; BPB disp; FAT+NTFS
//efine DFS_V "2.51 30-11-97" // DFSNT sync; fix cs super; fix freespace/walk
//efine DFS_V "2.50 24-11-97" // HPFS checksums; Auto lock on write; edit cmd
//efine DFS_V "2.49 16-11-97" // Fixed idle-time SLT "hang"; 1023-limit fixbs
//efine DFS_V "2.48 12-11-97" // added 'sep' cmd; 1023 limit removed on getbs
//efine DFS_V "2.47 11-11-97" // Fixed double-SLT bug; check default: +fd
//efine DFS_V "2.46 10-11-97" // +/- cmd; build-SLT + param on check
//efine DFS_V "2.45 09-11-97" // albit cmd; need-EA bug fixed; check cmd
//efine DFS_V "2.44 01-11-97" // Hybernate type; space cmd; fixed SLT bug
//efine DFS_V "2.43 28-10-97" // Combined BADSEC/FNDSEC list; SaveTo DIR
//efine DFS_V "2.42 18-10-97" // Added EA support on saveto and undelete
//efine DFS_V "2.41 12-10-97" // Added delfind/delshow/delsave wrapper cmds
//efine DFS_V "2.40 06-09-97" // Added import/export for lists;
//efine DFS_V "2.39 01-09-97" // Fixed size in FileInfo for erronous files;
//efine DFS_V "2.38 25-08-97" // Fixed undelete for 0-byte files;
//efine DFS_V "2.37 24-08-97" // Short-path selection on 'list' fnode display
//efine DFS_V "2.36 20-08-97" // Path display on find Fnode;
//efine DFS_V "2.35 18-08-97" // Path display on Fnode; fixes in short-name
//efine DFS_V "2.34 28-07-97" // Larger bad-sector scan table; Esc from 'list'
//efine DFS_V "2.33 28-07-97" // Fnode display update (alloc); minor fixes
//efine DFS_V "2.32 20-07-97" // Reporting & ALBLK fixes to saveto; "ca" cmd
//efine DFS_V "2.31 13-07-97" // Fixed case-insensitive find; dirmap % error
//efine DFS_V "2.30 06-07-97" // Changed 'f' syntax; fixed _beginthread trap
//efine DFS_V "2.29 29-06-97" // Fixed BMGR clustersize; Deleted Fnode support
//efine DFS_V "2.28 21-06-97" // HPFS autobase cmd; Base in prompt
//efine DFS_V "2.27 19-06-97" // Fixed bug in HPFS "saveto" (dir/file mixed)
//efine DFS_V "2.26 16-06-97" // Support nested locking;
//efine DFS_V "2.25 15-06-97" // WRIM cmd: write sectors; improved locking
//efine DFS_V "2.24 10-06-97" // Multi type search; autoid on scan; SaveImage
//efine DFS_V "2.23 04-06-97" // Dirblock display using color-highlight
//efine DFS_V "2.22 28-05-97" // Updated EA and CP display; Date/Time in Dir
//efine DFS_V "2.21 27-05-97" // SLT moved to DFSTABLE; Sector-type per FS
//efine DFS_V "2.20 19-05-97" // 5 prio levels; renamed files; split-off cmds
//efine DFS_V "2.19 05-05-97" // Fixed SLT abort; speed-up find; new prio cmd
//efine DFS_V "2.18 04-05-97" // Fixed "open" bugs, set sector/cluster size
//efine DFS_V "2.17 02-05-97" // First WIN32 port; compiles OK, works partly
//efine DFS_V "2.16 26-04-97" // Added FAT32 and BIOS-extended part types (cT)
//efine DFS_V "2.15 19-04-97" // Recompiled and linked for WIN-ported TXLIB
//efine DFS_V "2.13 10-04-97" // Added freespace reporting between partitions
//efine DFS_V "2.12 06-04-97" // Added volume acces
//efine DFS_V "2.11 04-04-97" // Updated partition detail display
//efine DFS_V "2.10 02-04-97" // Freespace / attached filesystem one 1 line
//efine DFS_V "2.09 31-03-97" // Updated for 16-bit compatibility / freespace
//efine DFS_V "2.08 25-03-97" // Added cluster/bpsector for partitions
//efine DFS_V "2.07 19-03-97" // Added basic LINUX recognition (not tested)
//efine DFS_V "2.06 16-03-97" // Added FsType to part-display; surface-scan
//efine DFS_V "2.05 26-02-97" // Updated cd command
//efine DFS_V "2.04 19-02-97" // ACL/UserId display from Fnodes
//efine DFS_V "2.03 16-02-97" // TxPrintHook; More part info
//efine DFS_V "2.02 08-02-97" // quit RC => 909; Logical limits
//efine DFS_V "2.01 06-02-97" // Added CopyOutput cmd; as OS2BVEN freeware
//efine DFS_V "2.00 03-02-97" // Fixed removables (NEWDASD); lsn's in stem
//efine DFS_V "1.99 01-02-97" // part D: and "D:" cmd; fixed MBR/EBR walk
//efine DFS_V "1.98 30-01-97" // Added "Inv" primary indicator; Rexx to TXlib
//efine DFS_V "1.97 29-01-97" // Added Rexx-exit to TxPrint; fixed hidden Pri
//efine DFS_V "1.96 28-01-97" // Fixed DosLoadModule ext;
//efine DFS_V "1.95 27-01-97" // Dynamic loading of REXX functionality
//efine DFS_V "1.94 24-01-97" // Fixed trap after multi_command from REXX
//efine DFS_V "1.93 21-01-97" // Fixed size-display on 'part' messages
//efine DFS_V "1.92 21-01-97" // Fixed multi-command for REXX scripts
//efine DFS_V "1.91 21-01-97" // "fixcp" (write Spare!);
//efine DFS_V "1.90 20-01-97" // "fixroot" (write SB!); "saveto" for files
//efine DFS_V "1.89 20-01-97" // Fixed trap in 'i' cmd when no SLT allocated
//efine DFS_V "1.88 20-01-97" // SLT thread only on PART n SLT;
//efine DFS_V "1.87 19-01-97" // Auto "disks" on part cmd;
//efine DFS_V "1.86 18-01-97" // Update search-progress and abort; BM-labels
//efine DFS_V "1.85 15-01-97" // Use RBA in EBR walk;
//efine DFS_V "1.84 14-01-97" // Bad-bootrecord flag added (unformatted)
//efine DFS_V "1.83 13-01-97" // MBR/EBR walk;
//efine DFS_V "1.82 12-01-97" // Split-off DFSAHPFS; PSN/CHS in every display
//efine DFS_V "1.81 10-01-97" // Added BM-active label and part/sect on disks
//efine DFS_V "1.80 09-01-97" // Added max INT-13 (bootable) area warning
//efine DFS_V "1.79 09-01-97" // Added copyright statement to startup-screen
//efine DFS_V "1.78 08-01-97" // Sizes in Mb; fixed primary drive-letters
//efine DFS_V "1.77 07-01-97" // Fixed EBR-chain walk for geometry > 1023 Cyl
//efine DFS_V "1.76 05-01-97" // Added partition-manager; removed DosRead
//efine DFS_V "1.75 01-01-97" // Added PSN command and CHS translation
//efine DFS_V "1.74 29-12-96" // Rename to DFS; fix 'M' sizes; first PhysDisk

//efine DHPFS_V "1.73 26-12-96" // Fixed minor output bugs; use TXLIB exec_cmd
//efine DHPFS_V "1.72 25-12-96" // Changed \n style; Fixed SLT thread bug
//efine DHPFS_V "1.71 22-12-96" // Use ANSILOG library
//efine DHPFS_V "1.70 14-12-96" // 3rd HPFS-internals ColoradOS/2 1996
//efine DHPFS_V "1.69 24-06-96" // Fixed trap in ident-sector (open FAT, Enter)
//efine DHPFS_V "1.68 01-11-95" // Cleanup and change directory structure
//efine DHPFS_V "1.67 20-10-95" // Use LSN in identify-sector; selective 386
//efine DHPFS_V "1.66 19-10-95" // EA iterate fix
//efine DHPFS_V "1.65 17-10-95" // BMI size-fix;
//efine DHPFS_V "1.64 16-10-95" // 2nd HPFS-internals; for ColoradOS/2 CDROM
//efine DHPFS_V "1.63 15-10-95" // Fnode/Dir size check; EA-type 'alloc'
//efine DHPFS_V "1.62 13-10-95" // Added Fnode/Dir size definitions
//efine DHPFS_V "1.61 12-10-95" // Added separate Internal-EA's to SLT
//efine DHPFS_V "1.60 11-10-95" // Free-space and allocation errors in SLT
//efine DHPFS_V "1.59 10-10-95" // Error info in SLT; allow missing DirFlag
//efine DHPFS_V "1.58 07-10-95" // Rexx variables; Other FStypes;
//efine DHPFS_V "1.57 28-09-95" // Improved error handling; FS-attach test
//efine DHPFS_V "1.56 26-09-95" // Fixed Traps when no drive open;
//efine DHPFS_V "1.55 25-09-95" // RUN cmd, start REXX program; Subcommand exec
//efine DHPFS_V "1.54 23-09-95" // Menu-cleanup + ext-cmd; SLT dump + autosize
//efine DHPFS_V "1.53 20-09-95" // 16-bit compatiblity
//efine DHPFS_V "1.52 13-09-95" // new / cmd as shortcut for searching
//efine DHPFS_V "1.51 12-09-95" // Fix parameter-with-spaces bug for 'f' cmds
//efine DHPFS_V "1.50 09-09-95" // CP in LST; I-sync LST, +/- index; stype dump
//efine DHPFS_V "1.49 08-09-95" // Generic LSN-list SLT function;
//efine DHPFS_V "1.48 06-09-95" // Bitmaps, SpareDirs, HotFixes in SLT;
//efine DHPFS_V "1.47 05-09-95" // UserId, DirBand in SLT; SLT thread IDLE prio
//efine DHPFS_V "1.46 03-09-95" // Minor improvements, defaults and textual
//efine DHPFS_V "1.45 18-08-95" // HPFSFH structure for IO; SLT-create thread
//efine DHPFS_V "1.44 13-08-95" // Alternative LSN-id fill; recurse FNODE/DIRBL
//efine DHPFS_V "1.43 12-08-95" // Alternative LSN-id fill; recurse ALLOC
//efine DHPFS_V "1.42 11-08-95" // Linear-best-fit search LSN-id; remove stack
//efine DHPFS_V "1.41 23-07-95" // Split-off ANSILOG and DHPFSERV; cleanup
//efine DHPFS_V "1.40 21-07-95" // LSN-id array
//efine DHPFS_V "1.39 20-07-95" // 32-bit port; resize LSN array; bug-fixes
//efine DHPFS_V "1.38 09-07-95" // Ascii/Hex search string on f/b cmd
//efine DHPFS_V "1.37 06-07-95" // Compact display of alloc-sectors
//efine DHPFS_V "1.36 02-07-95" // Filter x1B of hexdump; text "known ..."
//efine DHPFS_V "1.35 29-06-95" // Compact alloc display; dynamic debug-level
//efine DHPFS_V "1.34 26-06-95" // Faster bitmap by using S/D chars, no color
//efine DHPFS_V "1.33 25-06-95" // Dynamic alloc buffers; Color sys/dir in map
//efine DHPFS_V "1.32 20-06-95" // Fixed trap-D on hex-disp > 03ff bytes
//efine DHPFS_V "1.31 19-06-95" // Use fnode->DirFlag for directories!
//efine DHPFS_V "1.30 17-06-95" // HPFS/ANSI .h files; DIR signal; stype
//efine DHPFS_V "1.29 18-04-95" // Default detail-level for bitmap to COMPACT
//efine DHPFS_V "1.28 17-04-95" // <Enter> = next on Unid; n = next signature
//efine DHPFS_V "1.27 11-03-95" // No ANSI to log-file
//efine DHPFS_V "1.26 06-03-95" // Use ANSI cursor-movement in display
//efine DHPFS_V "1.25 05-03-95" // Use ANSI controlled colors in display
//efine DHPFS_V "1.24 01-03-95" // Search forward and remember Root LSN
//efine DHPFS_V "1.23 28-02-95" // Detect seek/read errors; @cmd finds Root dir
//efine DHPFS_V "1.22 24-02-95" // Added userid-table display
//efine DHPFS_V "1.21 12-02-95" // Fix Fnode name display
//efine DHPFS_V "1.20 09-02-95" // Alloc-seg cleanup; startup change
//efine DHPFS_V "1.19 06-02-95" // \path command, to find a directory or file
//efine DHPFS_V "1.18 05-02-95" // 'This' as EA;
//efine DHPFS_V "1.17 29-01-95" // Ext. EA's and ACL's;
//efine DHPFS_V "1.16 17-01-95" // Extended attribute display
//efine DHPFS_V "1.15 15-01-95" // show_text; More info text-display
//efine DHPFS_V "1.14 11-01-95" // m <-> M cmd; Alloc sector
//efine DHPFS_V "1.13 02-01-95" // t-cmd; ascii format dump
//efine DHPFS_V "1.12 29-12-94" // TxPrint logging; Bitmap dump, alloc & dir;
//efine DHPFS_V "1.11 23-12-94" // Allow multi-sector hex-dumps
//efine DHPFS_V "1.10 21-12-94" // Fixed help-layout and added some help
//efine DHPFS_V "1.09 16-12-94" // More navigation and corrected help info
//efine DHPFS_V "1.08 06-12-94" // Added navigation-stack and cmd-line
//efine DHPFS_V "1.07 06-12-94" // Added attribute display
//efine DHPFS_V "1.06 05-12-94" // Display Btree DownPointers & full Dirblock
//efine DHPFS_V "1.05 04-12-94" // Added more detail to sector display
//efine DHPFS_V "1.04 02-12-94" // Analysis and automatic sector display
//efine DHPFS_V "1.03 01-12-94" // Bootsector info; More formatting
//efine DHPFS_V "1.02 29-11-94" // Fmt Flag; swapped drive,cmd; allow ByteIO
//efine DHPFS_V "1.01 28-11-94" // hex dump any LSN, formatted super+spare
//efine DHPFS_V "1.00 27-11-94" // initial version, hex dump super+spare


#if   defined (WIN32)
   #define DFS_NO "Win32"
   #define DFS_X  "DFSWIN"
#elif defined (DOS32)
   #define DFS_NO "Dos32"
   #define DFS_X  "DFSDOS"
#elif defined (LINUX)
   #define DFS_NO "Linux"
   #define DFS_X  "dfsee"
#elif defined (DARWIN)
   #define DFS_NO "macOS"
   #define DFS_X  "dfsee"
#else
   #define DFS_NO "OS/2 "
   #define DFS_X  "DFSOS2"
#endif

#define DFS_NP  "DFSee"
#define DFS_N   DFS_NP " " DFS_NO

#define DFS_V   DFS_VN DFS_BT DFS_VD

#define DFS_C "(c) 1994-2022: Jan van Wijk"

#endif
