//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// XFS utility functions
//
// Author: J. van Wijk
//
// JvW  15-07-2007 Initial version, derived from XFS
//
#ifndef    DFSUXFS
   #define DFSUXFS

#include <dfsxfs.h>                             // XFS structure definitions

#define DFS_FS_XFS1        ((ULONG)   1)        // FsIdentify XFS classic

// Identify if FS structures for XFS are present, set fsform and label
ULONG dfsXfsFsIdentify
(
   S_BOOTR            *boot,                    // IN    Bootsector ref or NULL
   DFSPARTINFO        *p                        // INOUT partition info
);


// Translate Block-nr to LSN
ULN64 dfsXfsBlock2LSN                           // RET   LSN for this block
(
   ULONG               block                    // IN    block number
);

// Translate LSN to Block-nr
ULONG dfsXfsLSN2Block                           // RET   block for this LSN
(
   ULN64               lsn                      // IN    LSN
);

// Write cached superblock to superblock location on disk
ULONG dfsXfsWriteSuperBlocks
(
   void
);

#endif
