//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee UTF-8 (and related Unicode) string handling
//
// Author: J. van Wijk
//
// JvW  20-03-2019 Initial version, loosely derived from apfs-fuse
//
#ifndef    DFSUTF8_H
   #define DFSUTF8_H


// Compare two UTF8 strings in a strcmp compatible way
int dfsUtf8Cmp                                  // RET   0 = EQ  1 = 1st larger
(                                               //              -1 = 1st smaller
   BYTE               *str1,                    // IN    UTF-8  coded string
   BYTE               *str2,                    // IN    UTF-8  coded string
   BOOL                caseInsensitive          // IN    Case-insensitive
);

// Convert UTF-8 string to UTF-32 string (standard Unicode codepoints)
ULONG dfsUtf8ToUtf32                            // RET   #UTF-32 chars or 0
(
   BYTE               *utf8,                    // IN    UTF-8  coded string
   ULONG               size32,                  // IN    Size of UTF-32 array
   ULONG               utf32[]                  // OUT   UTF-32 coded string
);

// Normalize and optional case-fold and UTF32 string, returning #chars
ULONG dfsUtfNormCaseFoldStr                     // RET   Length of output string
(
   BOOL                caseInsensitive,         // IN    Case-insensitive
   ULONG               length,                  // IN    length of input string
   ULONG               utf32[],                 // IN    UTF-32 input string
   ULONG              *nfOut[]                  // OUT   normalized/folded string
);                                              //       (allocated) or NULL

#endif
