//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// REISER utility functions
//
// Author: J. van Wijk
//
// JvW  30-03-2004 Initial version
//
#ifndef    DFSURSR
   #define DFSURSR

#include <dfsrsr.h>                             // RSR structure definitions

// Identify if FS structures for REISER are present, set fsform and label
ULONG dfsRsrFsIdentify
(
   S_BOOTR            *boot,                    // IN    Bootsector ref or NULL
   DFSPARTINFO        *p                        // INOUT partition info
);


#define dfsRsrBlock2Lsn(bl) (ULN64) dfsRsrCl2Lsn((bl),0,NULL,NULL)
// Translate Block-nr to LSN, generic interface
ULN64 dfsRsrCl2Lsn                              // RET   LSN for this block
(
   ULN64               block,                   // IN    block number
   ULN64               d2,                      // IN    dummy
   char               *p1,                      // IN    dummy
   void               *p2                       // IN    dummy
);


#define dfsRsrLsn2Block(sn) dfsRsrLsn2Cl((ULN64)(sn),0,NULL, NULL)
// Translate LSN to Block-nr, generic interface
ULN64 dfsRsrLsn2Cl                              // RET   block for this LSN
(
   ULN64               lsn,                     // IN    LSN
   ULN64               d2,                      // IN    dummy
   char               *p1,                      // IN    dummy
   void               *p2                       // IN    dummy
);


// Determine allocation-bit for specified LSN, ALLOCATED beyond last block!
ULONG dfsRsrAllocated                           // RET   LSN is allocated
(
   ULN64               lsn,                     // IN    LSN
   ULN64               d2,                      // IN    dummy
   char               *dc,                      // IN    dummy
   void               *data                     // INOUT dummy
);

// Align R/W cache to position for block, and get current allocation-bit
// Note: Area aware to allow usage from FDISK mode too
BOOL dfsRsrBitmapCache                          // RET   block is allocated
(
   ULONG               bl,                      // IN    Block number
   ULONG              *cp                       // OUT   position in cache
);                                              //       or L64_NULL if invalid

// Create Reiser Bitmap cache structures and initialize the BitMap cache
// Note: Area aware to allow usage from FDISK mode too
ULONG dfsRsrBitMapInit                          // RET   rc = 0 if type match
(
   void
);

// Flush BitMap cache when Dirty, and optional free its resources
ULONG dfsRsrBitmapFlush                         // RET   rc
(
   BOOL                terminate                // IN    terminate cache too
);

// Write cached superblock to superblock location on disk
ULONG dfsRsrWriteSuperBlocks
(
   void
);

#endif
