//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// DFSee data compression functions, based on hashed-LZW algorithm
//

#ifndef    DFSULZW
   #define DFSULZW

#define DFSUL_SIG_LEN     6
#define DFSUL_FILESIG  "Tpack#"                 // file compression header
                                                // followed by 2 byte bufsize and
                                                // 2 + 2 byte method/size per CU

#define DFSUL_FILEBIG  "Tpk32#"                 // big-file compression header
                                                // followed by 4 byte bufsize and
                                                // 2 + 4 byte method/size per CU



#define DFSUL_APP_BIT  0x10                     // reserved bit in method value
                                                // for application use (ZERO!)
#define DFSUL_METHOD(v) ((v) & ~DFSUL_APP_BIT)  // method with cleared APP bit
#define DFSUL_SETAPP(v) ((v) |  DFSUL_APP_BIT)  // method with set     APP bit

// LZW class method values
#define DFSUL_MLZW_10  0x0a                     // LZW 10 bits
#define DFSUL_MLZW_11  0x0b
#define DFSUL_MLZW_12  0x0c
#define DFSUL_MLZW_13  0x0d
#define DFSUL_MLZW_14  0x0e                     // LZW 14 bits

#define DFSUL_MLZWMAX  0x0f                     // maximum LZW method value

// define handle as a pointer, so it converts automatically between 32/64 bit targets
typedef void *DFSUL_HANDLE;

// Register a new instance of the dfsUl abstract-data-type
ULONG dfsUlRegister                             // RET   result code
(
   DFSUL_HANDLE       *ulh                      // OUT   dfsUl handle
);

// Terminate use of an instance of the dfsUl abstract-data-type
void dfsUlTerminate
(
   DFSUL_HANDLE        ulh                      // IN    dfsUl handle
);


// Buffer Compression routine
ULONG dfsUlBufCompress
(
   DFSUL_HANDLE        ulh,                     // IN    dfsUl handle
   ULONG               method,                  // IN    compression method
   BYTE               *ibuf,                    // IN    input buffer
   ULONG               ilen,                    // IN    input buffer length
   BYTE               *obuf,                    // OUT   output buffer
   ULONG               olen,                    // IN    output buffer length
   ULONG              *size                     // OUT   compressed size
);

// Buffer Un-compress routine
ULONG dfsUlBufUncompress
(
   DFSUL_HANDLE        ulh,                     // IN    dfsUl handle
   ULONG               method,                  // IN    compression method
   BYTE               *ibuf,                    // IN    input buffer
   ULONG               ilen,                    // IN    input buffer length
   BYTE               *obuf,                    // OUT   output buffer
   ULONG               olen,                    // IN    output buffer length
   ULONG              *size                     // OUT   un-compressed size
);

#endif
