//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// ISO utility functions
//
// Author: J. van Wijk
//
// JvW  10-01-2019 Initial version, derived from HFS
//
#ifndef    DFSUISO
   #define DFSUISO

#include <dfsiso.h>                             // ISO structure definitions



// Build cache with (sub) directoryblock to full-path from ROOT
ULONG dfsIsoBuildDirPathCache
(
   void
);

// Free cache with (sub) directoryblock to full-path information
void dfsIsoFreeDirPathCache
(
   void
);

// Find Leaf-Node LSN+Index for specified path, starting at the root-directory
ULONG dfsIsoFindPath
(
   ULN64               loud,                    // IN    Show progress
   ULN64               d2,                      // IN    dummy
   char               *path,                    // IN    path specification
   void               *vp                       // OUT   found dir/file NODE+index
);

// Allocate ISO volumedesc, and read it from byte-offset calculated from vdi
// Note: Area aware to allow usage from FDISK mode too
S_ISO_VOLUMEDESC *dfsIsoGetVolumeDesc           // RET    TxAlloc'ed volumedesc
(
   ULONG               vdi                      // IN    Volume Descriptor Index
);


// Identify if FS structures for ISO are present
ULONG dfsIsoFsIdentify
(
   S_BOOTR            *boot,                    // IN    Bootsector ref or NULL
   DFSPARTINFO        *p                        // INOUT partition info
);


// Display file allocation and path info for LSN + index
ULONG dfsIsoFileInfo                            // RET   LSN is valid NODE
(
   ULN64               dirLsn,                  // IN    DirBlock sectornumber
   ULN64               fileIdx,                 // IN    File dir-record index
   char               *select,                  // IN    file selection string
   void               *param                    // INOUT leading text / path
);

// Replace sn-list by contents of a single Directory (InoLsn, InoIdx pairs)
ULONG dfsIsoMakeBrowseList                      // RET   LSN is valid INODE
(
   ULN64               dirLsn,                  // IN    DirBlock sectornumber
   ULN64               fileIdx,                 // IN    File dir-record index
   char               *str,                     // IN    unused
   void               *param                    // INOUT unused
);

// starting from a given directory entry, or for ROOT (when info valie is 0)
ULONG dfsIsoGetAllocSpace
(
   ULN64               lsn,                     // IN    Directory LSN   or 0
   ULN64               info,                    // IN    directory entry or 0
   char               *str,                     // IN    unused
   void               *param                    // INOUT Integrated SPACE
);

// Create S_SPACE structure for an ISO allocation chain, supporting interleave
// Note: fileUnitSize and interleaveGap should be ZERO for directories!
ULONG dfsIsoAllocChain
(
   ULONG               block,                   // IN    starting block nr
   ULONG               maxsize,                 // IN    file-size
   BYTE                fileUnitSize,            // IN    #contiguous blocks, or 0
   BYTE                interleaveGap,           // IN    #blocks between FU, or 0
   ULONG              *chunks,                  // OUT   nr of space entries
   S_SPACE           **space                    // OUT   space allocation
);

// Find full PATH to Root-directory, starting at some Node LSN and index info
ULONG dfsIsoLsnInfo2Path                        // RET   result
(
   ULN64               lsn,                     // IN    Directory LSN
   ULONG               info,                    // IN    dir entry, 0 for ROOT
   char               *path                     // OUT   combined path string
);

// Determine allocation-bit for specified LSN, ALLOCATED beyond last block!
ULONG dfsIsoAllocated                           // RET   LSN is allocated
(
   ULN64               lsn,                     // IN    LSN
   ULN64               d2,                      // IN    dummy
   char               *dc,                      // IN    dummy
   void               *data                     // INOUT dummy
);

// Convert ISO Vol-Descriptor DATE/TIME to DFS standard date/time string (19)
char *dfsIsoVtime2str                           // RET   string value
(
   S_ISO_VTIME        *vtm,                     // IN    ISO time value
   char               *dtime                    // INOUT ptr to string buffer
);

// Convert ISO File DATE/TIME (binary struct) to standard C time_t value
time_t dfsIsoFileTime2t                         // RET   time_t representation
(
   S_ISO_FTIME        *ftm                      // IN    ISO file time value
);

// Translate ISO directory Index to a directory entry pointer
S_ISO_DIRENTRY *dfsIsoDirIndex2Entry
(
   BYTE               *block,                   // IN    One directory block
   ULONG               index                    // IN    Index for wanted entry
);

// Display all available info about an ISO directory entry
ULONG dfsIsoShowDirectoryEntry
(
   ULN64               dirBlock,                // IN    lsn of ISO dir block
   ULONG               entry                    // IN    index of dir entry
);

// ISO filesystem, display DIR header/footer
void dfsIsoDirHeader
(
   char               *lead,                    // IN    lead text-string
   ULONG               items                    // IN    DIR-lines shown (0 = TOP)
);

// Display ISO directory entry on a single line (optional 2nd for Posix LFN)
void dfsIsoShowDirEntry
(
   S_ISO_DIRENTRY     *entry,                   // IN    ISO directory entry
   BYTE                bg                       // IN    current background
);

// Format ISO file/directory attribute bits into a 6 character string
void dfstrIsoAttrib
(
   char               *str,                     // INOUT text string
   BYTE                data                     // IN    data
);

#endif
