//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// FDISK utility functions, REBOOT section
//
// Author: J. van Wijk
//
// JvW  19-08-2005   Initial version, splitt off from DFSUFDSK.C
//

#include <txlib.h>                              // ANSI controls and logging

#include <dfsdisk.h>                            // FS disk structure defs
#include <dfspart.h>                            // FS partition info manager
#include <dfstore.h>                            // Store and sector I/O
#include <dfs.h>                                // DFS navigation and defs
#include <dfsspace.h>                           // DFS  file-space interface
#include <dfsantfs.h>                           // NTFS  interface (bootRec)
#include <dfsupart.h>                           // FDISK partition functions

#include <dfsafdsk.h>                           // FDISK analysis functions
#include <dfsufdsk.h>                           // FDISK utility functions

#if   defined (WIN32)
   #define  DFSFDSK_RBEXE    "dfsntx.exe"       // DFS external reboot NT
#elif defined (DOS32)
   #define  DFSFDSK_RBEXE    "dfsdosx.exe"      // DFS external reboot win9x
#elif defined (LINUX)
   #define  DFSFDSK_RBEXE    "dfslinx"          // DFS external reboot Linux
#elif defined (DARWIN)
   #define  DFSFDSK_RBEXE    "dfsmacx"          // DFS external reboot Darwin
#else
   #define  DFSFDSK_RBEXE    "dfsos2x.exe"      // DFS external reboot OS2
#endif


/*****************************************************************************/
// Reboot the system, using external and/or internal means
/*****************************************************************************/
BOOL dfsRebootSystem
(
   BOOL                flush                    // IN    Flush FS/buffers
)
{
   BOOL                rc = TRUE;               // function return
   TXLN                fname;
   FILE               *fp;

   ENTER();

   strcpy( fname, DFSFDSK_RBEXE);
   if ((fp = fopen( fname, "rb")) == NULL)      // not present here
   {
      if (TxFindByPath( DFSFDSK_RBEXE, "PATH", fname) != NULL)
      {
         fp = fopen( fname, "rb");
      }
   }
   if (fp != NULL)                              // present
   {
      fclose( fp);
      TxPrint("\nRebooting the system using: %s ...\n", fname);
      strcat( fname, " reboot");                // parameter needed for NT
      (void) system( fname);                    // execute the external reboot
   }
   else
   {                                            // flush will inhibbit the PM
      TxReboot( flush);                         // based popup for OS/2, but
   }                                            // is a bit safer ...
   BRETURN (rc);
}                                               // end 'dfsRebootSystem'
/*---------------------------------------------------------------------------*/
