//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS Sector Lookup Table and Name-lookup preparation
//
// Author: J. van Wijk
//
// JvW  21-05-97   Initial version, derived from DFSHPFS
//
#ifndef    DFSTABLE
   #define DFSTABLE

#define DFS_EHK_SLTBUILD        TXHK_EVENT_1    // eventhook ID for SLT status
                                                // to update a UI dialog :-)

#define EF_LINK_NO_ALLOC        0x00000001      // link but not in alloc-admin
#define EF_ALLOC_NO_LINK        0x00000002      // allocation set, no link
#define EF_FS_DIRTYMOUNT        0x80000000      // FS marked dirty/mounted

typedef enum slt_status
{
   SLT_READY         = NO_ERROR,                // ready and stable
   SLT_UPDATE,                                  // SLT being updated
   SLT_OVERFLOW,                                // SLT full and overflowed
   SLT_STOPPING,                                // SLT thread aborting
   SLT_EMPTY         = DFS_PENDING              // empty, usable with DFSFN
} SLT_STATUS;                                   // end of enum "lsn_status"



//========== SLT querying functions ==========================================

// return SLT status information
SLT_STATUS dfsSlTableStatus
(
   ULONG              *entries                  // OUT   nr of entries
);                                              //       or NULL


// Show SLT array status, max 20 chars
char *dfsSlTableStatusString                    // RET   output string
(
   char               *txt                      // OUT   SLT status string
);

// verbose status of SLT array, for any Filesystem, max 66 characters
char *dfsGetSltStatusString                     // RET   output string
(
   char               *txt,                     // OUT   SLT status string
   char               *message                  // IN    Message for index == 0
);                                              //       or NULL (max 16 chars)

// Show all info in  SLT array
ULONG dfsSlTableDisplay                         // RET   next index in array
(
   ULONG               start,                   // IN    start-index for dump
   ULONG               size,                    // IN    Nr of entries to dump
   BYTE                stype,                   // IN    type of sector(s)
   ULONG               ef_mask,                 // IN    error selection mask
   BOOL                verbose,                 // IN    verbose, add file-info
   BOOL                oneliner,                // IN    verbose on same line
   ULONG              *errorcount               // OUT   detected errors
);

// Find Fnode in SLT array
BOOL dfsSlTableFind
(
   ULN64               snr,                     // IN    sectornumber to find
   ULN64              *fns,                     // OUT   reference LSN  or NULL
   USHORT             *info,                    // OUT   info, FATentry or NULL
   BYTE               *stp,                     // OUT   type of sector or NULL
   ULONG              *slh                      // OUT   SLT handle
);

// Search for free disk-space in the SLT, using a 'best-fit' algorithm
BOOL dfsSlTableSearchFree                       // RET   requested space found
(
   ULN64               size,                    // IN    number of sectors
   ULN64               clsize,                  // IN    minimal extent size
   ULONG               maxext,                  // IN    maximal nr of extents
   ULONG              *extents,                 // OUT   nr of extents
   S_SPACE            *space                    // OUT   extent array
);

// Allocate specified free disk-space in the SLT and FS allocation-structure
void dfsSlTableAllocate                         // RET   requested space found
(
   ULN64               size,                    // IN    number of sectors
   ULN64               clsize,                  // IN    minimal extent size
   ULONG               extents,                 // IN    nr of extents
   BYTE                type,                    // IN    type of sectors
   ULN64               ref,                     // IN    reference LSN for SLT
   USHORT              info,                    // IN    related INFO (FAT)
   S_SPACE            *space                    // IN    extent array
);

// Add list of 32bit sector-numbers plus info to SLT array
void dfsSlTableListSn32
(
   ULONG              *list,                    // IN    ptr to list of LSN's
   ULONG               items,                   // IN    #LSN's in list
   ULONG               sects,                   // IN    #sectors per LSN
   BYTE                stype,                   // IN    type of sectors
   ULONG               ref,                     // IN    referencing LSN
   USHORT              info,                    // IN    related INFO (FAT)
   ULONG               flags                    // IN    ERROR signal flags
);


//========== SLT building functions ==========================================


// Prepare filesystem for name-lookup, using SLT build, Name-cache or nothing
ULONG dfsSltPrepareNameLookup                   // ABORTED when <Esc> used
(
   void
);

// Create sector-lookup-table, calling File-system specific functions
void dfsSlTableCreate
(
   void               *param                    // IN    parameter to pass on
);

// Reset sector-lookup-table to empty state
void dfsSlTableReset
(
   void
);

// Intialize SLT building for FS-specific phase (progress etc)
ULONG dfsSlTableFsInit                          // RET   SLT allocated size
(
   ULN64               todo                     // IN    approx sectors todo
);

// Add info-entry to  SLT array
ULONG dfsSlTableAdd
(
   ULN64               start,                   // IN    start LSN of area
   ULN64               size,                    // IN    nr of sectors in area
   BYTE                type,                    // IN    sector-type
   ULN64               ref,                     // IN    related LSN (fnode)
   USHORT              info,                    // IN    related INFO (FAT)
   ULONG               flags                    // IN    ERROR signal flags
);

// Add info-entries for S_SPACE structure to SLT array
ULONG dfsSlTableSpaceAdd
(
   ULONG               chunks,                  // IN    nr of S_SPACE chunks
   S_SPACE            *space,                   // IN    space structure array
   BYTE                type,                    // IN    sector-type
   ULN64               ref,                     // IN    related LSN (fnode)
   USHORT              info,                    // IN    related INFO (FAT)
   ULONG               flags                    // IN    ERROR signal flags
);

// Add selected sectors from SLT areas to the sector list
ULONG dfsSltRange2List                          // RET   result
(
   ULN64               asize,                   // IN    #sectors per area
   ULN64               start,                   // IN    start sector
   ULN64               rsize,                   // IN    size of the range
   ULONG               mask,                    // IN    error selection mask
   BOOL                refsect,                 // IN    add reference sectors
   BYTE                stype                    // IN    type selection
);

#endif
