//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// Sub-command / script variable handling
//
// 21-10-2007 JvW Moved from dfs, new GetVar for scripting  (DFSee 9.03)

#ifndef    DFSSCVAR
   #define DFSSCVAR

#define DFS_RX_ENV   ((PSZ) "DFS")              // name of DFS REXX env

// Get host (dfsee) value for named variable and optional (array) index
ULONG dfsGetVariable
(
   char               *name,                    // IN    variable name
   ULONG               ord,                     // IN    index or TXSNOINDEX
   TXSVALUE           *v                        // INOUT new variable value
);                                              //       initialized to ZERO


#if defined (DEV32)
// Execute a DFSee command as REXX Subcommand handler
ULONG _System dfs_subcom
(
   PRXSTRING          cmd,                      /* command string (input)    */
   PUSHORT            err_flag,                 /* ERROR/FAILURE  (output)   */
   PRXSTRING          rv                        /* string retcode (output)   */
);
#endif

#endif
