//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// REISER disk structure definitions
// Based on information from "Unix  filesystems" by Steve D Pate
//                           "Linux filesystems" by Moshe Bar
// other Internet info, and a lot of reverse-engineering with DFSee
//
// Author: J. van Wijk
//
// JvW  31-03-2004   Initial version
//
#ifndef    DFSREIS_H
   #define DFSREIS_H

#define RSR_LSNSUP1        ((ULN64)  0x10)      // superblock old versions
#define RSR_LSNSUP2        ((ULN64)  0x80)      // new superblock location

#define SG_RSRSUP  6                            // "ReIsEr"
#define SV_RSRSUP  (char)0x52,(char)0x65,(char)0x49,(char)0x73,(char)0x45,(char)0x72

#define RSR_FS_CLEAN               1
#define RSR_FS_DIRTY               2

#define RSR_HASH_NO                0            // no hash type set
#define RSR_HASH_TEA               1
#define RSR_HASH_YURA              2
#define RSR_HASH_R5                3

#define RSR_LEN_UUID             FS_UUID_LENGTH
#define RSR_LEN_LBL              16

typedef struct s_rsr_super
{
   ULONG               Blocks;                  // #blocks
   ULONG               FreeBlocks;              // free blocks count
   ULONG               RootBlock;               // root block number
   ULONG               Jrn1stBlock;             // 1st block on journal device
   ULONG               JrnDevice;               // journal device
   ULONG               JrnSize;                 // size of the journal
   ULONG               JrnMaxBlocksTrans;       // max blocks 1 transaction
   ULONG               JrnSignature;            // unique signature this jrn
   ULONG               JrnMaxBlocksBatch;       // max blocks to batch
   ULONG               Jrn_max_commit_age;      // max age, async updates (sec)
   ULONG               Jrn_max_trans_age;       // max age, transactions  (sec)
   USHORT              BlockSize;               // block size
   USHORT              OidMaximumSize;          // max size of object-id array
   USHORT              OidCurrentSize;          // current size object-id array
   USHORT              State;                   // 1=unmounted clean 2=dirty
   BYTE                Signature[10];           // fs ident string        @x034
   USHORT              FsckPhase;               // FSCK phase for fs      @x03e
   ULONG               HashAlgorithm;           // hash function used     @x040
   USHORT              TreeHeight;              // height of disk tree    @x044
   USHORT              BitmapBlocks;            // #bitmap blocks needed  @x046
   USHORT              Version;                 // non-std jrn version    @x048
   USHORT              JrnReservedBlocks;       // non-std jrn #blocks    @x04a
   ULONG               InodeGeneration;         // #generations inode     @x04c
   ULONG               Flags;                   // for inode-attributes   @0x50
   BYTE                Uuid[RSR_LEN_UUID];      // FS identifier          @0x54
   char                VolumeName[RSR_LEN_LBL]; // FS volume label        @0x64
   BYTE                Filler[396];             // to be refined
} S_RSR_SUPER;                                  // seems to conttinue in 2nd sector


typedef struct s_rsr_dirv1                      // classic 32-byte Dir entry
{
   USHORT              Mode;                    // file type, permissions
   USHORT              Links;                   // number of hard links
   USHORT              Uid;                     // owner
   USHORT              Gid;                     // group
   ULONG               Size;                    // file size
   ULONG               Atime;                   // time last access
   ULONG               Mtime;                   // time last file data change
   ULONG               Ctime;                   // time last inode change
   ULONG               Blocks;                  // number of blocks file uses
   ULONG               DataOffset;              // offset to direct-data, or
} S_RSR_DIRV1;                                  // 1=symlink 0xffffffff=no item


#define RSR_FL_SECRM             0x00000001     // Secure deletion
#define RSR_FL_UNRM              0x00000002     // Undelete
#define RSR_FL_COMPR             0x00000004     // Compress file
#define RSR_FL_SYNC              0x00000008     // Synchronous updates
#define RSR_FL_IMMUTABLE         0x00000010     // Immutable file
#define RSR_FL_NODUMP            0x00000040     // do not dump file
#define RSR_FL_NOATIME           0x00000080     // do not update atime
#define RSR_FL_NOTAIL            0x00008000     // no tail data


typedef struct s_rsr_dir                        // New 44-byte Dir entry
{
   USHORT              Mode;                    // file type, permissions
   USHORT              Attrs;                   // persistent inode flags
   ULONG               Links;                   // number of hard links
   ULN64               Size;                    // file size
   ULONG               Uid;                     // owner
   ULONG               Gid;                     // group
   ULONG               Atime;                   // time last access
   ULONG               Mtime;                   // time last file data changed
   ULONG               Ctime;                   // time last inode change
   ULONG               Blocks;
   ULONG               Generation;
} S_RSR_DIR;

#endif
