//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// DFSee registration functions
//
// 23-06-2005 JvW Moved to DFSee to allow 'open' txlib      (DFSee 7.07)

#ifndef    DFSRGKEY
   #define DFSRGKEY

#if defined (OEMSV)
   #undef  REGISTRATION
#elif defined (OEMAN)
   #undef  REGISTRATION
#elif defined (NEED_REG)
   #define REGISTRATION
#else
#endif

typedef enum dfsrg
{
   DFSRG_WHEN_NOT_REGISTRED,
   DFSRG_DISPLAY_ONLY,
   DFSRG_DISPLAY_CONFIRM,
   DFSRG_CONFIRM_ONLY
} DFSRG;                                        // end of enum "dfsrg"

#define DFSRG_EXT      "key"

// Get registration name text in a string, length TXMAXTM
char *dfsRegistrationString
(
   char               *string                   // OUT   registration id string
);

// Get registration status text in a string, length TXMAXTM
char *dfsRegistrationStatus
(
   char               *status                   // OUT   registration status
);

// Print registration info to the screen and request confirmation
void dfsRegistrationInfo
(
   DFSRG               mode,                    // IN    display/confirm mode
   char               *major,                   // IN    major version
   BOOL                confirm                  // IN    confirmation required
);

// Check registration availability and acceptance, and evaluation expiration
BOOL dfsRegistrationTest                        // RET   not expired/cracked
(
   char               *product,                 // IN    name product/regfile
   char               *regfile,                 // IN    regfile if non-std
   char               *major,                   // IN    major version
   long                introduction,            // IN    introduction date
   char               *ccDATEcc,                // IN    compile date __DATE__
   long                expiredays               // IN    expiration date offset
);                                              //       days from compile date

// Get registration status and description
BOOL dfsRegistrationValid                       // RET   registration valid
(
   char               *regstr,                  // OUT   registration id string
   char               *status                   // OUT   registration status
);

// Patch DFSee RAW registration key into current sector, replace existing key
ULONG dfsRegistrationPatch                      // RET   keyvalue replaced OK
(
   void
);

#endif
