//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// POSIX related utility functions (mainly for Linux related FS)
//
// Author: J. van Wijk
//
// JvW  16-07-2017 Initial version, derived from DFSUJFS
//
#ifndef    DFSPOSIX
   #define DFSPOSIX


//- to be refined for DARWIN
#if !defined (_S_IFLNK)
   #define _S_IFLNK 0120000
#endif


// Convert Posix mode integer to 10 character string
char *dfsPosixMode2String                       // RET   posix mode string
(
   ULONG               mode,                    // IN    filemode
   int                 length,                  // IN    max string length
   char               *str                      // OUT   mode string
);


// Display Posix UID+GID to 1-line txprint output, HEX + symbolic or decimal
void dfsPosixUidGidPrint
(
   ULONG               uid,                     // IN    uid value
   ULONG               gid                      // IN    gid value
);

#endif
