//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee utility & display services
//
// Author: J. van Wijk
//
// JvW  08-01-2006 Initial version, derived from TXOSAPI
//
#ifndef    DFSOSAPI
   #define DFSOSAPI


// Test if LVM Engine Sync is wanted for disk partition specified
// based on global setting, local option, and removable status
BOOL dfsLvmSyncDesired                          // RET   Sync desired for part
(
   DFSPARTINFO        *p                        // IN    partition info or NULL
);


// Test if LVM Engine support is available by trying to load/attach the LVM DLL
BOOL dfsLvmEnginePresent                        // RET   LVM Engine API present
(
   void
);


// Set driveletter for an LVM volume, or hide it; using the real LVM engine
// Note: DFSee should not have any disks opened (locked) so close all stores
// Empty volumename will execute just a RediscoverPRMs (Refresh removables)
ULONG dfsLvmEngineExecute
(
   BOOL                verbose,                 // IN    display LVM command
   char               *volume,                  // IN    LVM volume name or ""
   char                letter                   // IN    new letter      or 0
);


#endif
