//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// DFSee OS/2 EA utility functions
//
// Author: J. van Wijk
//
// JvW  2006-03-27   Initial version, split off from DFSUHPFS/DFSUDIS2
//
#ifndef    DFSOS2EA
   #define DFSOS2EA


#define  EA_BIGBUF_SIZE  0x1FF00                // almost 128 KB

// Display extended attributes from a memory-buffer
void dfsEaBlockDisplay
(
   char              *text,                     // IN    leading text
   S_EABLK           *first,                    // IN    first EA block
   ULONG              size                      // IN    size of EA area
);


// Get specified single EA value from an EA-block in a memory-buffer
ULONG dfsEaBlockGetValue
(
   char               *name,                    // IN    EA name wanted
   S_EABLK            *first,                   // IN    first EA block
   ULONG               size,                    // IN    (max) size of EA area
   ULONG              *len,                     // OUT   EA data length
   void              **eaData                   // OUT   EA data (allocated)
);

// Following functions for ALL platform versions, to read EA's from disk

// Add external-EA sector(s) info to std FEA2-list structure
ULONG dfsOs2EaReadExtern
(
   ULN64               sn,                      // IN    first ext-EA LSN
   ULONG               offset,                  // IN    EABLK position
   ULONG               asize,                   // IN    ea area size
   S_FEA2LIST         *feal                     // INOUT list of FEA2's
);                                              //       alloc by caller

// Add extended attributes area std FEA2-list structure
ULONG dfsOs2EaReadArea
(
   S_EABLK            *first,                   // IN    first EA block
   ULONG               size,                    // IN    size of EA area
   S_FEA2LIST         *feal                     // INOUT list of FEA2's
);

// Add extended attribute to std FEA2-list structure
ULONG dfsOs2EaReadSingle
(
   S_EABLK            *data,                    // IN    data
   USHORT             *read,                    // OUT   read size of data
   S_FEA2LIST         *feal                     // INOUT list of FEA2's
);

// Add allocation-sector EA info to std FEA2-list structure (recursive)
ULONG dfsOs2EaReadAlloc
(
   ULN64               sn,                      // IN    Alloc-sector LSN
   ULONG              *size,                    // INOUT size left todo
   char              **dest                     // INOUT destination ptr
);

// Add EA data from sector(s) to std FEA2-list structure
ULONG dfsOs2EaReadData
(
   ULN64               sn,                      // IN    first ext-EA LSN
   ULONG               size,                    // IN    ea data size
   void               *dest                     // OUT   FEA2 data area
);

#endif
