//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// NT registry disk-key structure definitions and interfaces
//
// Author: J. van Wijk
//
// JvW  2018-11-21   Added NtGetDiskMfgFwSerial() using CCS->disk->enum reg key
// JvW  1998-04-09   Initial version, display only; based on registry analysis
//
#ifndef    DFSNTREG_H
   #define DFSNTREG_H


// Get DISK device-ID string (like manufacturer/model/) from REG CCS\disk\enum
char *dfsNtGetDiskDeviceId                      // RET    Disk info, or NULL
(                                               //        (must be freed after use)
   USHORT              diskNr                   // IN     DFSee disknr (1 based)
);


// Correlate current NT DosDevice map with found partitions, merge as prefered
ULONG dfsMergeDosDeviceMapping                  // RET nr of merged drives
(
   void
);

// Create diskkey registry key and synchronize DosDevice mappings
ULONG ntregSyncDevMapDiskKey
(
   void
);


// Get the DISK\Information value from the registry
BOOL ntregDiskKeyFromReg
(
   void
);


// Save the registry value
BOOL ntregDiskKeyToReg
(
   void
);


// Build the DiskKey registry value from current disk/partition info
BOOL ntregDiskKeyFromDisk
(
   void
);


// Set specific drive-letter to use for a CDROM device
void ntregSetCdromLetter
(
   USHORT              cdnr,                    // IN    CDROM number
   char               *drive                    // IN    CDROM drive letter
);


// Get current drive-letter used for a CDROM device
BOOL ntregGetCdromLetter
(
   USHORT              cdnr,                    // IN    CDROM number
   char               *drive                    // OUT   drive letter
);


// Delete registry entry for specified CDROM device
void ntregDelCdromKey
(
   USHORT              cdnr
);


// Update DosDevice mappings for NT partitions
BOOL ntregSetDevPartitions
(
   void
);


// Modify CDROM driveletter assignment in registry and DosDevice tree
ULONG ntregModifyCDRomLetter
(
   USHORT              cdnr,                    // IN    CDROM number
   char               *letter                   // IN    drive letter or '-'
);


// Display complete registry DiskKey contents
ULONG ntregShowDiskkey
(
   void
);


// Show table of assigned partition driveletters
ULONG ntregShowDriveLetters
(
   void
);

// Show present DosDevices, or mapping for a specified DosDevice
void ntregShowDosDevice
(
   char               *dev,                     // IN    DosDevice wildcard
   char               *map                      // IN    dev mapping wildcard
);

// Free a driveletter by removing the defined DosDevice for it
BOOL ntregFreeDriveLetter
(
   char               *drive                    // IN    drive letter
);

// Free DosDevice mapping(s) for specified DFS partition, when different
BOOL ntregFreeWhenDifferent                     // RET   (re)assign required
(
   USHORT              disk,                    // IN    disk number
   USHORT              part,                    // IN    rel partition number
   char               *letter                   // IN    wanted driveletter
);

// Assign DosDevice mapping for specified CDROM number and drive letter
BOOL ntregAssignPartition
(
   USHORT              disk,                    // IN    disk number
   USHORT              part,                    // IN    rel partition number
   char               *drive                    // IN    CDROM drive letter
);

// Free DosDevice mapping(s) for specified CDROM number
BOOL ntregFreeCdrom
(
   USHORT              cdnr                     // IN    CDROM number
);

// Assign DosDevice mapping for specified CDROM number and drive letter
BOOL ntregAssignCdrom
(
   USHORT              cdnr,                    // IN    CDROM number
   char               *drive                    // IN    CDROM drive letter
);

#endif
