//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS STORE memory disk interface (previously called virtual disk)
//
// Author: J. van Wijk
//
// JvW  05-07-2000   Initial version, derived from DFSUFDSK
// JvW  04-04-2017   Updated for 64bit sectornumbers and size
// JvW  07-07-2017   Updated for renaming VirtDisk to Mem-disk (and /dev/vdX to /dev/MdX)
//
#ifndef    DFSMDISK
   #define DFSMDISK

// Return number of partitionable memory disks
USHORT dfsGetMemoryDisks                        // RET   nr of memory disks
(
   void
);

// Make a new memory disk, with an empty (0x00) first MBR sector
ULONG dfsMakeMemoryDisk
(
   ULN64               size,                    // IN    Size in sectors, or 0
   ULONG               cyl,                     // IN    Geo cylinders
   ULONG               hds,                     // IN    Geo heads
   ULONG               spt,                     // IN    Geo sectors
   USHORT              bps,                     // IN    Bytes per sector
   USHORT             *mdisk                    // OUT   mdisk number (or NULL)
);

// Remove specified memory disk and free all resources
ULONG dfsRemoveMemoryDisk
(
   USHORT              mdisk                    // IN    memory disk number
);

// Get geometry specified on creation of a memory disk
ULONG dfsGetMdiskGeometry
(
   USHORT              mdisk,                   // IN    memory disk number
   ULN64              *size,                    // OUT   Size in sectors
   ULONG              *cyl,                     // OUT   Geo cylinders
   ULONG              *hds,                     // OUT   Geo heads
   ULONG              *spt,                     // OUT   Geo sectors
   USHORT             *bps                      // OUT   Bytes per sector
);

// Read one sector from the specified memory disk (empty when not present)
ULONG dfsReadMdiskSector
(
   USHORT              mdisk,                   // IN    memory disk number
   ULN64               psn,                     // IN    wanted psn
   ULONG               bps,                     // IN    bytes per sector (buffer)
   BYTE               *data                     // OUT   sector data
);

// Write one sector to specified memory disk
ULONG dfsWriteMdiskSector
(
   USHORT              mdisk,                   // IN    memory disk number
   ULN64               psn,                     // IN    wanted psn
   ULONG               bps,                     // IN    bytes per sector (buffer)
   BYTE               *data                     // IN    sector data
);

// Show status and statistics for all memory disks
void dfsShowMdiskStatus
(
   USHORT              select                   // IN    Mdisk number, 0=ALL
);

#endif
