//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// HPFS display and analysis, Sector Lookup Table
//
// Author: J. van Wijk
//
// JvW  14-08-95   Initial version
//
#ifndef    DFSLHPFS
   #define DFSLHPFS

#define EF_NAME_FN_N_DIR        0x00000004
#define EF_DIRFL_NOT_SET        0x00000008
#define EF_SIZE_FN_G_DIR        0x00000010
#define EF_SIZE_DIR_G_FN        0x00000020
#define EF_SIZE_FN_G_ALL        0x00000040
#define EF_SIZE_ALL_G_FN        0x00000080
#define EF_BAD_CHECK_SUM        0x00000100
#define EF_BAD_DIRBL_LSN        0x00001000
#define EF_BAD_FNODE_LSN        0x00002000
#define EF_BAD_ALLOC_LSN        0x00004000
#define EF_BAD_RANGE_LSN        0x00008000
#define EF_BAD_CPINF_LSN        0x00010000
#define EF_BAD_CPDAT_LSN        0x00020000
#define EF_BAD_RECURSION        0x00040000


// Add info to sector-lookup-table, fnode processing recursive from root
ULONG dfsHpfsSltBuild
(
   ULN64               dummy1,                  // IN    not used
   ULN64               d2,                      // IN    dummy
   char               *dummy2,                  // IN    not used
   void               *param                    // IN    pointer parameter
);


// Display one line of error description for each bit in error-flag
ULONG dfsHpfsDispError
(
   ULN64               flags,                   // IN    error flag
   ULN64               d2,                      // IN    dummy
   char               *dummy2,                  // IN    not used
   void               *param                    // IN    pointer parameter
);

#endif
