//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// APFS (container) dump & display Analysis functions
//
// Author: J. van Wijk
//
// JvW  24-01-2018 Initial version, derived from High Performance File System
//

#include <txlib.h>                              // ANSI controls and logging

#include <dfsdisk.h>                            // FS disk structure defs
#include <dfspart.h>                            // FS partition info manager
#include <dfstore.h>                            // Store and sector I/O
#include <dfs.h>                                // DFS navigation and defs
#include <dfsutil.h>                            // DFS utility functions
#include <dfsspace.h>                           // DFS file-space interface
#include <dfstable.h>                           // SLT utility functions
#include <dfsaapfs.h>                           // APFS analysis definitions

#include <dfslapfs.h>                           // APFS sector lookup


/*****************************************************************************/
// Add info to sector-lookup-table, fnode processing recursive from root
/*****************************************************************************/
ULONG dfsApfsSltBuild
(
   ULN64               dummy1,                  // IN    not used
   ULN64               d2,                      // IN    dummy
   char               *dummy2,                  // IN    not used
   void               *param                    // IN    pointer parameter
)
{
   ULONG               rc  = DFS_BAD_STRUCTURE;
   DFSAAPFS           *fsi = (DFSAAPFS *) param; // IN    APFS info structure
   ULONG               ef  = 0;

   ENTER();

   TRHEXS( 70,  fsi,  sizeof(DFSAAPFS), "apfs global info");
   if (fsi->sup != NULL)                        // superblock present
   {
      /*
      dfsSlTableAdd(   fsi->sup->TotalSec, DFS64MAX, ST_FINAL, LSN_C_SUPER, 0, 0);

                                                // Approximate sectors todo:
      dfsSlTableFsInit( (ULN64) fsi->sup->TotalSec - // RAW size of FS
                        dfsa->FsUnallocated);   // minus known freespace

      dfsSlTableAdd(   LSN_BOOTR +1,           0x0f, ST_BOOTA, L64_NULL,  0, 0);

      ef = 0;
      if (fsi->spr->SuChecksum != dfsCheckSum((BYTE *) fsi->sup))
      {
         ef |= EF_BAD_CHECK_SUM;                // Checksum error on super
      }
      */

      dfsSlTableAdd(   LSN_C_SUPER,           0x01, ST_C_SUP, L64_NULL,  0, ef);
   }
   RETURN (rc);
}                                               // end 'dfsApfsSltBuild'
/*---------------------------------------------------------------------------*/


/*****************************************************************************/
// Display one line of error description for each bit in error-flag
/*****************************************************************************/
ULONG dfsApfsDispError
(
   ULN64               flags,                   // IN    error flag
   ULN64               d2,                      // IN    dummy
   char               *lead,                    // IN    leading string
   void               *param                    // IN    pointer parameter
)
{
   ENTER();

   if (flags & EF_BAD_CHECK_SUM)
   {
      TxPrint("%sIncorrect checksum value in container superblock header\n", lead);
   }
   RETURN (NO_ERROR);
}                                               // end 'dfsApfsDispError'
/*---------------------------------------------------------------------------*/


