//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS IMZ image data cache and indexing
//
// Implements creating and using data structures to access DFSee compressed
// image files (IMZ) with an INDEX that maps LSN-areas to file-offsets and
// and a data-cache that holds one or more recently accessed areas.
//
// The INDEX, cache and read/write functions support multiple file images
// transparently. The initial IMZ is opened outside the module, while the
// follow-ups (.I02, I03 etc) will be opened/closed on demand
//
// Author: J. van Wijk
//
// JvW  31-10-2016   Initial version, derived from DFSMDISK
//
#ifndef    DFSIMZCI
   #define DFSIMZCI


// Generate an index file for the specified IMZ imagefile
ULONG dfsImzGenerateIndex
(
   char               *fname,                   // IN    path+name of the IMZ
   BOOL                verbose,                 // IN    show index file written
   BOOL                force                    // IN    delete existing index
);


// Initialize Cache and Indexing structures to access (opened) IMZ image
ULONG dfsImzInitCacheIndex
(
   TXHFILE             fh,                      // IN    handle to opened IMZ
   char               *fname,                   // IN    path+name, for .I02 etc
   BOOL                verbose,                 // IN    show info to screen/log
   void              **ppImz                    // OUT   anonymised access data
);


// Free Cache and Indexing structures associated with an IMZ image
ULONG dfsImzFreeCacheIndex
(
   void              **pImz                     // INOUT anonymised access data
);


// Read ONE sector from an IMZ image file, using supplied access data
ULONG dfsImzReadSector
(
   ULN64               sn,                      // IN    wanted sector number
   ULONG               bps,                     // IN    bytes per sector (buffer)
   void               *pImz,                    // INOUT anonymised access data
   BYTE               *data                     // OUT   sector data
);

#endif
