//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee major functions: imaging
//
// Author: J. van Wijk
//
// JvW  27-07-2006   Initial version, split off from DFSMAJOR.H
//
#ifndef    DFSIMAGE
   #define DFSIMAGE


// Low level compression definitions, needed to interpret an IMZ type file
#define DFSIMZ_HDRSIZE       512                // fixed size of an IMZ header

#define DFSIM_NOCOMPR     0x0000                // no compression used
#define DFSIM_SMARTBUF    0xeeee                // smart buffer, no crc
#define DFSIM_SMARTCRC    0xeefc                // smart buffer, with CRC
#define DFSIM_SMARTFB     0xeefb                // FB smart, no length, no CRC
#define DFSIM_SMART       0xee00                // FB smart, no length, no CRC
#define DFSIM_FULLBUF     0xfb00                // FB xx, no length, no CRC
#define DFSIM_NEXTFILE    0xefef                // RLE end-file indicator
#define DFSIM_RLEBCRC     0xfc00                // RLE coded area, with CRC
#define DFSIM_RLEBYTE     0xff00                // RLE coded area, no crc
#define DFSIM_RLEDATA     0x00ff                // RLE types, data value mask
#define DFSIM_CRCUSED     DFSUL_APP_BIT         // CRC 32-bit used after length

#define DFSIM_LZW_CRC   (DFSUL_MLZW_12 | DFSIM_CRCUSED)
#define DFSIM_NON_CRC   (DFSIM_NOCOMPR | DFSIM_CRCUSED)

// Translate IMAGE/RESTORE image block-codes to short description string
char *dfsImageCode2String                       // RET   description string
(
   USHORT              code                     // IN    block code
);

// end Low level definitions




// High level IMAGE and RESTORE command logic
ULONG dfsImageRestoreCommand
(
   int                 cc,                      // IN    number of parameters
   char               *c1,                      // IN    parameter string 1
   char               *c2,                      // IN    parameter string 2
   char               *c3,                      // IN    parameter string 3
   BOOL                create                   // IN    action is create img
);


// Get type of image (IMZ/RAW) and optional #files, start, size, bufsize & bps
BOOL dfsImageTypeIsImz                          // RET   Image is an IMZ type
(
   char               *fname,                   // IN    Image filename
   BOOL                ssFromFile,              // IN    get start/size from files
   ULN64              *fSize,                   // OUT   Total filesize in bytes
   ULONG              *files,                   // OUT   Nr of files when multiple
   ULN64              *imStart,                 // OUT   start sector
   ULN64              *imSize,                  // OUT   Image size in sectors
   ULONG              *imzBuf,                  // OUT   IMZ buffersize (spt * bps)
   ULONG              *imzBps,                  // OUT   IMZ bytes per sector
   BYTE               *sType                    // OUT   type first sector (MBR...)
);


// Get image (IMZ/RAW) type and optional information, from OPEN filehandle
BOOL dfsGetImzImageInfo                         // RET   Image is an IMZ type
(
   char               *fname,                   // IN    Image filename
   TXHFILE             fhandle,                 // IN    Handle to OPEN Image file
   BOOL                ssFromFile,              // IN    get start/size from files
   ULN64              *fSize,                   // OUT   Total filesize in bytes
   ULONG              *files,                   // OUT   Nr of files when multiple
   ULN64              *imStart,                 // OUT   start sector
   ULN64              *imSize,                  // OUT   Image size in sectors
   ULONG              *imzBuf,                  // OUT   IMZ buffersize (spt * bps)
   ULONG              *imzBps,                  // OUT   IMZ bytes per sector
   BYTE               *sType                    // OUT   type first sector (MBR...)
);

// Show available information for an imagefile (IMZ/IMG)
ULONG dfsImageInfoDisplay
(
   char               *fname                    // IN    Image filename
);

// Get number of files in a set of image files, and return total size in bytes
ULONG dfsMultipleImgInfo                        // RET   Nr of files in image set
(
   char               *fname,                   // IN    filename image file
   TXHFILE             fhandle,                 // IN    open handle first file
   ULN64              *size                     // OUT   filesize or NULL (for IMZ!)
);

// DFS write sectors to disk-file(s) with optional compression
ULONG dfsCreateImage                            // RET   result code
(
   ULN64               fn,                      // IN    start LSN
   ULN64               size,                    // IN    nr of sectors to save
   char               *fspec,                   // IN    destination filespec
   ULONG               flags,                   // IN    compress, smart etc
   ULN64               limit                    // IN    max filesize in bytes
);

#define  DFSW_IMZ_SIZE  0x0100                  // take size from IMZ header
// DFS write sectors to volume/partition from saved imagefile(s)
ULONG dfsRestoreImage
(
   ULN64               fn,                      // IN    start LSN
   ULN64               size,                    // IN    nr of sectors to write
   ULONG               flags,                   // IN    imaging options
   char               *fspec,                   // IN    source filespec
   ULONG               fileCount                // IN    #files, same as last file#
);


#endif
