//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee HEX (sector) EDITOR, ASCII-viewer and disassembler view, implementation
//
// Author: J. van Wijk
//
// JvW  21-06-2006 Initial version
// JvW  11-10-2016 Added multiple view selections
//
#ifndef    DFSHEXED
   #define DFSHEXED

//- DFSee available views
#define  DFSH_HEX_VIEW                  0       // basic HEX-edit view
#define  DFSH_1ST_VIEW                  1       // always the first one
#define  DFSH_DIS_VIEW                  1       // disassembler view
#define  DFSH_ASC_VIEW                  2       // Plain ASCII view
#define  DFSH_MAX_VIEW                  2       // always the last one
#define  DFSH_AUTOVIEW                  9       // Determine view from 1st data


typedef struct dfshexedinfo                     // additional data descriptions
{
   TXTM                name;                    // filename
   DFSISPACE           al;                      // file allocation, and bytesize
} DFSHEXEDINFO;                                 // end of struct "dfshexedinfo"


// HEX sector editor, working on current DFSee object (store)
ULONG dfsHexObjectEditor
(
   ULN64               lsn,                     // IN    starting LSN
   ULN64               size,                    // IN    item size in sectors
   ULONG               mstart,                  // IN    initial mark start
   ULONG               msize,                   // IN    initial mark size or 0
   DFSHEXEDINFO       *info,                    // IN    additional object info
   USHORT              startView,               // IN    start in specified view
   USHORT              pos,                     // IN    start pos in 1st item
   USHORT              rows,                    // IN    nr of rows or 0
   USHORT              cols                     // IN    nr of cols or 0
);

#endif
