//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee major functions: searching
//
// Author: J. van Wijk
//
// JvW  27-07-2006   Initial version, split off from DFSMAJOR.H
//
#ifndef    DFSFIND
   #define DFSFIND


// High level FIND command logic, iterating for multiple search ...
ULONG dfsFindSectorData
(
   char               *rawcmd,                  // IN    unparsed commandline
   char               *repeat                   // IN    default repeat 1 or *
);

// Insert all cylinder-aligned special sectornumbers into the sectorlist
ULONG dfsCylinderSectorList
(
   void
);

// Find next sector of specified type with specified contents
// Caller must use ProgressInit to setup proper progress reporting!
BOOL dfsFindTypeContaining                      // OUT   type/contents found
(
   char               *options,                 // IN    search options
   ULN64               start,                   // IN    starting sector     (RSN!)
   ULONG               step,                    // IN    nr of sectors to step
   char               *types,                   // IN    sector types wanted
                                                // OUT   sector type found [0]
   USHORT              mlen,                    // IN    match string length
   char               *mstr,                    // IN    match string
   USHORT              mlen2,                   // IN    match string-2 length
   char               *mstr2,                   // IN    match string-2 (AND)
   ULN64               limit,                   // IN    limit sector nr     (RSN!)
   ULN64              *lsn,                     // OUT   found sector number (LSN!)
   BYTE               *fst,                     // OUT   found sector type
   ULONG              *pos                      // INOUT found position in sect
);                                              //   sector-size starts at next

#endif
