//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// FAT Format functions and definitions
//
// Author: J. van Wijk
//
// JvW  28-12-2005 Initial version
//
#ifndef    DFSFFAT
   #define DFSFFAT

typedef struct fat_fmt_info
{
   ULONG               sectors;                 // object size in sectors
   USHORT              allowedBits;             // FatBits allowed 12/16/32
   USHORT              desiredBits;             // FatBits desired/preferred
   USHORT              minimumCs_12;            // minimum cluster size F12 in 512 byte units!
   USHORT              minimumCs_16;            // minimum cluster size F16 in 512 byte units!
   USHORT              minimumCs_32;            // minimum cluster size F32 in 512 byte units!
   USHORT              defaultCsize;            // default cluster size F32 in 512 byte units!
   USHORT              desiredCsize;            // desired cluster size
   USHORT              desiredRsize;            // desired ROOT DIR size
   ULONG               serial;                  // serial number default
   ULONG               reservedSect;            // FAT-1 offset from bootrec
   BOOL                longFormat;              // long format wanted
   TXTS                label;                   // label default
   TXTS                os;                      // desired bootcode OS
} FAT_FMT_INFO;                                 // end of struct "fat_fmt_info"


// Format current volume/partition using specified parameters
ULONG dfsFatFormat
(
   FAT_FMT_INFO       *ffi                      // IN    FAT format information
);


// Calculate optimum clustersize based on Bits & other selections
USHORT dfsFatFmtClusterSize
(
   FAT_FMT_INFO       *ffi                      // IN    FAT format information
);

#endif
