//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// FAT disk structure definitions
//
// Author: J. van Wijk
//
// JvW  04-12-97   Initial version, derived from DFSHPFS
//
#ifndef    DFSFAT_H
   #define DFSFAT_H

//- Note fff0..fff6 are officially 'reserved' but data seen up to fff5

#define FAT_FREECLUS   ((ULONG) 0x00000000)     // free cluster indicator
#define FAT_MAXCLUST   ((ULONG) 0x0ffffff5)     // found max for FAT32
#define FAT_BADCLUST   ((ULONG) 0x0ffffff7)     // bad cluster indicator
#define FAT_MINEOFCL   ((ULONG) 0x0ffffff8)     // first EOF indicator
#define FAT_MAXEOFCL   ((ULONG) 0x0fffffff)     // (0x0fffffff used most)

#define FAT_MAXCLF16   (FAT_MAXCLUST & 0xffff)  // maximum data cluster FAT16

// filesystem size limit in sectors: data-area (clusters) + FATs + ROOT
#define FAT12_LIMIT    ((((FAT_MAXCLUST & 0xfff)  -2) *  8) +  24  + 1)
#define FAT16_LIMIT    ((((FAT_MAXCLUST & 0xffff) -2) * 64) + 512  + 1)

// FAT32 filesystem size limit in sectors for various cluster size in sectors
// Expressed in standard-size sectors of 512 bytes (SECTORSIZE)
#define FAT32_01LIM    0x0020000                //  64 MiB  512 b
#define FAT32_02LIM    0x0040000                // 128 MiB  1 KiB
#define FAT32_04LIM    0x0080000                // 256 MiB  2 KiB
#define FAT32_08LIM    0x1000000                //   8 GiB  4 KiB
#define FAT32_16LIM    0x2000000                //  16 GiB  8 KiB
#define FAT32_32LIM    0x4000000                //  32 GiB 16 KiB


#define SG_FAT12       2
#define SV_FAT12       (char)0xff,(char)0xff
typedef struct s_fat12                         // FAT disk structure 12-bit
{
   BYTE                 MediaType;
   char                 Signature[SG_FAT12];
   BYTE                 FatValue[509];          // note: 12 bit values!
} S_FAT12;                                      // end of struct "s_fat12"

#define SG_FAT16       3
#define SV_FAT16       (char)0xff,(char)0xff,(char)0xff
typedef struct s_fat16                         // FAT disk structure 16-bit
{
   BYTE                 MediaType;
   char                 Signature[SG_FAT16];
   USHORT               FatValue[254];          // first will be for cluster 2
} S_FAT16;                                      // end of struct "s_fat16"


#define LSN_FAT32SPARE 6
#define SG_FAT32       7
#define SV_FAT32       (char)0xff,(char)0xff,(char)0x0f, \
                       (char)0xff,(char)0xff,(char)0xff,(char)0xff
typedef struct s_fat32                         // FAT disk structure 32-bit
{
   BYTE                 MediaType;
   char                 Signature[SG_FAT32];
   ULONG                FatValue[126];          // first will be for cluster 2
} S_FAT32;                                      // end of struct "s_fat32"


#define FAT_DIRFREE    ((char) 0x00)            // Fat dir free entry
#define FAT_DIRDEL     ((char) 0xe5)            // Fat dir deleted entry
#define FAT_DIRDOT     ((char) 0x2e)            // Fat dir . or .. entry
#define FAT_NSIZE      8
#define FAT_ESIZE      3
#define FAT_N          11                       // FAT total name length
typedef struct s_fatdir
{
   char                Name[ FAT_NSIZE];        // 00 Name part 8.3
   char                Ext[ FAT_ESIZE];         // 08 Ext. part 8.3
   BYTE                FatAttrib;               // 0B FAT attribute bits
   BYTE                Vlcase;                  // 0C VFAT lowercase flag
   BYTE                Vctime10ms;              // 0D VFAT creation time (10 ms)
   S_DATIM             Vctime;                  // 0E VFAT creation time
   S_DATIM             Vcdate;                  // 20 VFAT creation date
   S_DATIM             Vadate;                  // 22 VFAT last-access date
   union
   {
      USHORT           OS2EA;                   // 24 OS/2 EA index in EA DATA
      USHORT           clustHi;                 // 24 High word of 32-bit cluster
   };
   S_DATIM             time;                    // 26 Last modification time
   S_DATIM             date;                    // 28 Last modification date
   USHORT              clust;                   // 2A First cluster number
   ULONG               fsize;                   // 2C File size
} S_FATDIR;                                     // end of struct "s_fatdir"

#define VFAT_ATTRIB    0x0f                     // fixed attrib  value lfn's
#define VFAT_CLUSTR    0x00                     // fixed cluster value lfn's
#define VFAT_SLOT_1    0x40                     // bit-mask for 1st lfn slot
typedef struct s_vfslot
{
   BYTE                SlotId;                  //
   USHORT              lfn5[5];                 // 1st group unicode chars lfn
   BYTE                FatAttrib;               // FAT attribute bits
   BYTE                Vzero;                   // reserved, must be zero
   BYTE                Vcheck;                  // VFAT 8.3 alias checksum
   USHORT              lfn6[6];                 // 2nd group unicode chars lfn
   USHORT              clust;                   // First cluster number (zero!)
   USHORT              lfn2[2];                 // 3rd group unicode chars lfn
} S_VFSLOT;                                     // end of struct "s_vfslot"


typedef union s_vfat
{
   S_FATDIR            d;                       // FAT directory entry
   S_VFSLOT            v;                       // VFAT lsn entry
} S_VFAT;                                       // end of union "s_vfat"

/*
                <preceeding files...>
                <slot #3, id = 0x43, characters = "h is long">
                <slot #2, id = 0x02, characters = "xtension whic">
                <slot #1, id = 0x01, characters = "My Big File.E">
                <directory entry, name = "MYBIGFIL.EXT">
*/

#define SV_EACLUST   ((USHORT) 0x4145)          // EA signature
#define FAT_EAOFFS   ((USHORT) 30)              // offset to 1st eadata
typedef struct s_eaclust
{
   USHORT              signature;               // signature 'EA' = 0x4145
   USHORT              index;                   // EA-index, matching OS2EA
   ULONG               reserv1;                 // unknown, assume 0 for now
   char                fname[12];               // null-terminated filename
   BYTE                reserv2[6];              // unknown
   USHORT              ealength;                // total length of EA data
   BYTE                reserv3[2];              // unknown
   S_EABLK             eadata[1];               // first of EA-data sequence
} S_EACLUST;                                    // end of struct "s_eaclust"

/*
   Note: The eadata[1] field actualy is a repeating, variable length
         structure for each EA belonging to the file.
*/

#define SV_EAINDEX   ((USHORT) 0x4445)
#define EAI_SIZE       240
typedef struct s_eaindex
{
   USHORT              signature;               // signature 'ED' = 0x4445
   BYTE                reserv1[30];             // unknown, seems to be 0
   USHORT              base[EAI_SIZE];          // Base values for Map
   USHORT              mapsector[1];            // First of Map sectors
} S_EAINDEX;                                    // end of struct "s_eaclust"

/*
   Note: above EAINDEX structure is defined here at it's minimum size being
         two sectors like seen on 1 sector/cluster volumes (diskettes)
         On a harddisk it is usualy 1 cluster, depending on the number of
         EA's actualy present.
*/

#endif
