//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS STORE and sector-IO, private interface
//
// Author: J. van Wijk
//
// JvW  27-07-2006 Initial version, derived from DFSECTOR
//

#ifndef    DFSECTIO_H
   #define DFSECTIO_H

#if defined (DOS32)
   typedef ULONG       PDHANDLE;
#elif defined (UNIX)
   typedef int         PDHANDLE;
#else
   typedef TXHFILE     PDHANDLE;
#endif

#define PDHNULL      ((PDHANDLE) -1)

typedef struct dfstoredisk                      // phys-disk specific store info
{
   ULONG               useCount;                // disk-handle open count
   PDHANDLE            pdHandle;                // physical disk handle
} DFSTOREDISK;                                  // end of struct "dfstoredisk"


typedef struct dfstoreinfo                      // info on any DFS STORE type
{
   DFSTORETYPE         Type;                    // type of this store
   DFS_GEO             Geo;                     // DPB possibly forced geometry
   DFS_GEO             Sys;                     // DPB system (OS) geometry
   USHORT              DiskId;                  // DFSee disk-id for this disk
   DFSTOREDISK        *di;                      // disk info
   USHORT              SpClu;                   // sectors per cluster
   ULN64               Start;                   // start PSN logical limit
   ULN64               Final;                   // final PSN logical limit
   ULN64               AreaStart;               // Area start PSN logical limit
   ULN64               AreaFinal;               // Area final PSN logical limit
   ULN64               LastPSN;                 // Last PSN accessed
   ULN64               Sectors;                 // sectors on open store
   TXHFILE             vfHandle;                // Volume or (image) File handle
   void               *accessInfo;              // access data (IMZ index etc)
   BOOL                SectorIO;                // IFS sector-based IO
   BOOL                Extended13;              // Extended Int-13 in use
   BOOL                ReadOnly;                // No writes allowed on store
   ULONG               Retries;                 // nr of sector read retries
   TXHFILE             LogLock;                 // logical volume lock-handle
   ULONG               LockCnt;                 // device lock-counter
   BOOL                LockIgn;                 // Ignore failure, no-prompt
   ULN64               ByteSize;                // size in bytes (images)
   TXLN                Name;                    // File or volume name
   DFSISTORE           is;                      // current info store dependend
#if defined (DEV32)
   ULONG               tlSize;                  // track layout size
   TRACKLAYOUT        *TrackLayout;             // OS/2 Ioctl track info
#endif
} DFSTOREINFO;                                  // end of struct "dfstoreinfo"


//- shorthand macro to access diskinfo structure for current store si
#define DI            si->di
#define DFST_MAXOPEN  3                         // max simultanious open stores

extern  DFSTOREDISK  PhysDisk[DFS_MAX_DISK +1]; // info bound to each disk
extern  DFSTOREINFO  sti[ DFST_MAXOPEN];        // global store administration

// Initialize a single STORE structure
void dfstInitSingleStore
(
   DFST_HANDLE         store                    // IN    DFS store to be used
);

// Translate Physical sect-nr (PSN) to Head-Cylinder-Sector, use Original Geo
ULONG dfstPsn2Sys
(
   DFST_HANDLE         store,                   // IN    DFS store to be used
   ULN64               psn,                     // IN    physical sector nr
   ULONG              *cylinder,                // OUT   cylinder number
   ULONG              *head,                    // OUT   head number
   ULONG              *sector                   // OUT   first sector number
);

// Make system Geo equal to (forced) Geo
void dfstGeo2Sys
(
   DFSTOREINFO        *si                       // IN    DFS storeinfo pointer
);


#endif

