//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// Generic Dialog functions, called from the menu and generic commands
//
// Author: J. van Wijk
//
// JvW  26-01-2005 Initial version
//
#ifndef    DFSDGEN
   #define DFSDGEN


// Present FIND options dialog and execute resulting command
ULONG dfsFindDialog
(
   BOOL                single,                  // IN    allow single-shot only
   BOOL                quiet,                   // IN    no result sector display
   BOOL                again,                   // IN    skip dialog if valid args
   ULN64               start,                   // IN    starting LSN or L64_NULL
   ULONG               spos                     // IN    start offset or 0
);


// Present Run-script file-dialog with options and execute resulting command
ULONG dfsRunScriptDialog
(
   char               *firstParam,              // IN    path/scriptname, or empty
   char               *scriptInfo               // OUT   scriptname + parameters
);


// Present Import options dialog and execute resulting command
ULONG dfsImportDialog
(
   void
);


// Present Export options dialog and execute resulting command
ULONG dfsExportDialog
(
   void
);


// Present IMAGE options dialog and execute resulting command
ULONG dfsImageDialog
(
   DFSOBJECT           source,                  // IN    Source for the image
   char               *image,                   // IN    filename, "" or NULL
   BOOL                media,                   // IN    set media-change
   ULONG               mfsize,                  // IN    max filesize or 0
   ULN64               tsector,                 // IN    To   sector number
   ULN64               sizetodo                 // IN    Size to image (0 = all)
);


// Present RESTORE options dialog and execute resulting command
ULONG dfsRestoreDialog
(
   DFSOBJECT           destination,             // IN    Destination for image
   char               *image,                   // IN    filename, "" or NULL
   BOOL                verify,                  // IN    verify only
   ULN64               tsector,                 // IN    To   sector number
   ULN64               sizetodo                 // IN    Size to restore (0 = all)
);


// Present CLONE options dialog and execute resulting command
ULONG dfsCloneDialog
(
   BOOL                clone,                   // IN    Clone, not VERIFY
   DFSOBJECT           fobject,                 // IN    From object reference
   ULN64               fsector,                 // IN    From sector number
   DFSOBJECT           tobject,                 // IN    To   object reference
   ULN64               tsector,                 // IN    To   sector number
   ULN64               sizetodo,                // IN    Size to clone (0 = all)
   ULONG               skipbads                 // IN    sectors to skip on BADS
);


// Present GENPART options dialog and execute resulting command
ULONG dfsGenPartDialog
(
   USHORT              disk,                    // IN    disk number string
   char               *base,                    // IN    base filename
   char               *descr,                   // IN    description string
   TXSETVALUE          sectors,                 // IN    use sector values
   TXSETVALUE          dofree                   // IN    no freespace
);


// Present DFSDISK options dialog and execute resulting command
ULONG dfsDfsDiskDialog
(
   USHORT              disk,                    // IN    disk number string
   char               *base                     // IN    base filename
);


// Present DFSFAST options dialog and execute resulting command
ULONG dfsDfsFastDialog
(
   USHORT              disk,                    // IN    disk number string
   char               *base                     // IN    base filename
);


// Present LOG options dialog and execute resulting command
ULONG dfsLogDialog
(
   char               *logname,                 // IN    default name or NULL
   ULONG               helpid,                  // IN    specific help-id
   BOOL                reopen,                  // IN    reopen logfile
   char               *message                  // IN    extra message or NULL
);


// Present HELP load-section from file dialog and execute resulting command
ULONG dfsLoadHelpDialog
(
   void
);


// Present File-open dialog for images, and execute resulting IM/IMZ command to open it
ULONG dfsImageSelectDialog
(
   char               *spec,                    // IN    dir or wildcard specification
   DFSMEDIATYPE        mtype,                   // IN    mediatype (determines cmd to execute)
   char               *ext                      // IN    default file extension wanted
);


// Present PRESTORE options dialog and execute resulting command
ULONG dfsPrestoreDialog
(
   USHORT              disknr                   // IN    disknr or 0
);


// Present PSAVE options dialog and execute resulting command
ULONG dfsPsaveDialog
(
   USHORT              disknr                   // IN    disknr or 0
);


// Present LIST/RECOVER file selection dialog and return compound selection string
ULONG dfsFileListDialog                         // RET   result
(
   char               *title,                   // IN    dialog title
   ULONG               count,                   // IN    listed files, info only
   BOOL                browse,                  // IN    Browse, unless overruled
   TXTM                select                   // INOUT file selection string
);


// Present SLT display option dialog and execute resulting SLT command
ULONG dfsSltDisplayDialog                       // RET   result
(
   void
);


// Present CHS style selection dialog and return the selected value, default dfsa->chsStyle
ULONG dfsChsStyleDialog                         // RET   result
(
   BOOL                reset,                   // IN    Reset default style
   ULONG              *style                    // INOUT CHS style value
);


// Present PromptBox for a string value, preceeded by 1 to 5 option checkboxes
ULONG dfsPromptOptDialog                        // RET   result
(
   char               *title,                   // IN    dialog title
   char               *message,                 // IN    prompt message
   ULONG               helpid,                  // IN    dialog help
   short               length,                  // IN    entryfield length
   char               *field,                   // INOUT entryfield string
   BOOL               *opt0val,                 // INOUT Option-0 value
   char               *opt0txt,                 // IN    Option-0 text
   BOOL               *opt1val,                 // INOUT Option-1 value or NULL
   char               *opt1txt,                 // IN    Option-1 text  or NULL
   BOOL               *opt2val,                 // INOUT Option-2 value or NULL
   char               *opt2txt,                 // IN    Option-2 text  or NULL
   BOOL               *opt3val,                 // INOUT Option-3 value or NULL
   char               *opt3txt,                 // IN    Option-3 text  or NULL
   BOOL               *opt4val,                 // INOUT Option-4 value or NULL
   char               *opt4txt                  // IN    Option-4 text  or NULL
);


// Present Confirmation dialog with fixed text, preceeded by 1 to 5 option checkboxes
BOOL dfsConfirmOptDialog                        // RET   confirmed
(
   ULONG               helpid,                  // IN    dialog help
   char               *message,                 // IN    prompt message
   BOOL               *opt0val,                 // INOUT Option-0 value
   char               *opt0txt,                 // IN    Option-0 text
   BOOL               *opt1val,                 // INOUT Option-1 value or NULL
   char               *opt1txt,                 // IN    Option-1 text  or NULL
   BOOL               *opt2val,                 // INOUT Option-2 value or NULL
   char               *opt2txt,                 // IN    Option-2 text  or NULL
   BOOL               *opt3val,                 // INOUT Option-3 value or NULL
   char               *opt3txt,                 // IN    Option-3 text  or NULL
   BOOL               *opt4val,                 // INOUT Option-4 value or NULL
   char               *opt4txt                  // IN    Option-4 text  or NULL
);


// Present Directory select dialog, with one to seven optional Checkboxes
BOOL dfsDirSelectDialog
(
   char               *dlgTitle,                // IN    dialog title
   ULONG               helpid,                  // IN    dialog help
   char               *dirPath,                 // INOUT dir path to select
   BOOL               *opt0val,                 // INOUT Option-0 value
   char               *opt0txt,                 // IN    Option-0 text
   BOOL               *opt1val,                 // INOUT Option-1 value or NULL
   char               *opt1txt,                 // IN    Option-1 text  or NULL
   BOOL               *opt2val,                 // INOUT Option-2 value or NULL
   char               *opt2txt,                 // IN    Option-2 text  or NULL
   BOOL               *opt3val,                 // INOUT Option-3 value or NULL
   char               *opt3txt,                 // IN    Option-3 text  or NULL
   BOOL               *opt4val,                 // INOUT Option-4 value or NULL
   char               *opt4txt,                 // IN    Option-4 text  or NULL
   BOOL               *opt5val,                 // INOUT Option-5 value or NULL
   char               *opt5txt,                 // IN    Option-5 text  or NULL
   BOOL               *opt6val,                 // INOUT Option-6 value or NULL
   char               *opt6txt                  // IN    Option-6 text  or NULL
);


// Present set GEOmetry options dialog and execute resulting command(s) until done
void dfsGeoDialog
(
   void
);


// Present dialog to specify or Edit a GUID/UUID STRING value in 5 separate hex fields
ULONG dfsGuidUuidDialog
(
   char               *title,                   // IN    Dialog title, UID purpose
   char               *okText,                  // IN    OK button text (max 10 chars)
   USHORT              genId,                   // IN    ID for cr unique (PID/DSK-nr)
   ULONG               helpid,                  // IN    Generic (caller) help on help
   char               *uidStr                   // INOUT Guid/Uuid string {...}
);


// Dialog to Edit a binary GUID/UUID value in 5 separate hex fields, update in-place, or string IN
ULONG dfsGuidUuidEditor
(
   char               *title,                   // IN    Dialog title, UID purpose
   char               *okText,                  // IN    OK button text (max 10 chars)
   USHORT              genId,                   // IN    ID for cr unique (PID/DSK-nr)
   ULONG               helpid,                  // IN    Generic (caller) help on help
   char               *uidStr,                  // IN    Optional begin value for UID
   BOOL                swap,                    // IN    perform endian swaps
   DFS_GUID            uidBin                   // INOUT 16 Byte binary GUID/UUID value
);

#endif
