//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// FDISK MBR Dialog and windowing functions
//
// Author: J. van Wijk
//
// JvW  21-09-2015 Initial version, splitt off from DFSDFDSK
//
#ifndef    DFSDFMBR
   #define DFSDFMBR

// Initialize help system for Create MBR-part Dialog (accessible from startup)
void dfsCreateMbrInitHelp
(
   void
);

// Present a Create-Partition Dialog, with freespace info as input
BOOL txwCreateMbrPartDialog
(
   DFSPARTINFO        *f,                       // IN    freespace information
   char               *create                   // OUT   Create command
);

#define   DFS_PTYPE_AUTOFAT   ((ULONG) 0x106)   // automatic FAT type

// Prompt for (new) MBR-style partition type using custom prompt string
BOOL dfsPromptMbrPartitionType
(
   char               *prompt,                  // IN    specific prompt string
   ULONG               helpid,                  // IN    specific help-id
   ULONG              *ptype                    // OUT   type code 00..ff or
);                                              //       DFS_PTYPE_AUTOFAT

#endif
