//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// FDISK Dialog and windowing functions
//
// Author: J. van Wijk
//
// JvW  21-09-2015 Split up, seperate CR-MBR and CR-GPT modules
// JvW  18-11-2002 Initial version, derived from TPWSTDLG and DFSCFDSK
//
#ifndef    DFSDFDSK
   #define DFSDFDSK

#define DFSD_NONE    0
#define DFSD_NEXT    101
#define DFSD_PREV    102
#define DFSD_EDIT    TXk_F2
#define DFSD_REQ5    TXk_F5
#define DFSD_REQ6    TXk_F6
#define DFSD_REQ7    TXk_F7
#define DFSD_REQ8    TXk_F8

// Display LVMSET dialog with default values and allow changes
ULONG dfsFdskLvmSetDialog                       // RET   dialog result
(
   FDSK_CB_INFO       *cbp,                     // INOUT LVMSET parameters
   S_LVINF            *lvm,                     // LVM sector
   S_LVPART           *lp                       // LVM part info
);


// Display PTEDIT dialog with default values and allow changes
ULONG dfsFdskPteditDialog                       // RET   dialog result
(
   FDSK_CB_INFO       *cbp,                     // IN    operation info
   S_BOOTR            *br                       // INOUT sectors with PTABLE
);

#endif
