//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee major functions: cloning
//
// Author: J. van Wijk
//
// JvW  27-07-2006   Initial version, split off from DFSMAJOR.H
//
#ifndef    DFSCLONE
   #define DFSCLONE

// High level CLONE and COMP command logic
ULONG dfsCloneCompCommand
(
   int                 cc,                      // IN    number of parameters
   char               *c1,                      // IN    parameter string 1
   char               *c2,                      // IN    parameter string 2
   BOOL                clone                    // IN    action is CLONE
);

// Clone area of sectors from the CURRENT store (FROM) to another one (TO)
ULONG dfsCloneStoreArea
(
   ULN64               start,                   // IN    start sector
   ULN64               sectors,                 // IN    sectors to copy
   DFST_HANDLE         from,                    // IN    from store
   DFST_HANDLE         to,                      // IN    to   store
   ULN64               fstart,                  // IN    from start-sector
   ULONG               flags,                   // IN    cloning options
   ULN64               badskip,                 // IN    size to skip on bads
   BOOL                progress,                // IN    display progress
   char               *oldLvmName,              // IN    old LVM disk name
   char               *newLvmName               // IN    new LVM disk name
);

// Compare area of sectors from (other) store to current
ULONG dfsCompareStoreArea
(
   ULN64               start,                   // IN    start sector
   ULN64               sectors,                 // IN    sectors to copy
   DFST_HANDLE         from,                    // IN    from store
   DFST_HANDLE         to,                      // IN    to   store
   ULN64               fstart,                  // IN    from start-sector
   ULONG               flags,                   // IN    compare options
   BOOL                progress,                // IN    display progress
   char               *oldLvmName,              // IN    old LVM disk name
   char               *newLvmName               // IN    new LVM disk name
);

// Move/copy current partition to same/other FSP-area; update Ptables and LVM
ULONG dfsMovePartition
(
   char               *param                    // IN    help param or NULL
);


#endif
