//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// FDISK GPT related utility functions
//
// Author: J. van Wijk
//
// JvW  12-10-2015   Initial version, split from DFSUFGPT
//
#ifndef    DFSCFGPT
   #define DFSCFGPT


// Execute the 'gpt' command to display or FIX the GPT structures for one disk
ULONG dfsGptExcecute
(
   USHORT              disknr,                  // IN    disk to work on
   BOOL                fixup                    // IN    fix GPT by write back
);

// Create a new GPT style partition in the existing GPT partition array
ULONG dfsGptCreatePartition
(
   FDSK_CB_INFO       *cbd                      // IN    call-back-data, params
);


// Delete a single GPT partition from specified disk
ULONG dfsGptDeletePartition
(
   DFSPARTINFO        *p,                       // IN    partition to work on
   USHORT              disknr                   // IN    verify disknr, or 0
);

// Delete ALL GPT partitions from specified disk
ULONG dfsGptDeleteAll
(
   DFSDISKINFO        *d                        // IN    info on disk to work on
);

#endif
