//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// FDISK callback-functions and command implementations
//
// Author: J. van Wijk
//
// JvW  29-06-2000 Initial version, split-off from DFSAFDSK
//
#ifndef    DFSCFDSK
   #define DFSCFDSK

//- Define callback/key codes for the NEXT/PREV type of dialogs (LVM, PTE)
#define DFSDLG_NONE    0
#define DFSDLG_NEXT    101
#define DFSDLG_PREV    102
#define DFSDLG_EDIT    TXk_F2
#define DFSDLG_REQ5    TXk_F5
#define DFSDLG_REQ6    TXk_F6
#define DFSDLG_REQ7    TXk_F7
#define DFSDLG_REQ8    TXk_F8


// Implement the 'Create' callback operation for a new partition
ULONG dfsFdskCreate                             // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    option:zero full entry
);

// Cleanup EBR-chain on a disk, removing 'empty' EBR's and lead/tail space
ULONG dfsCleanupExtChain
(
   USHORT              disknr,                  // IN    disknr to work on
   BOOL                confirmed                // IN    already confirmed
);

// Implement the 'WriteExtChain' callback operation on a partition-table entry
ULONG dfsFdskWriteExtChain                      // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    option:zero full entry
);

// Implement the 'Cleanup Active' callback operation on a partition-table entry
ULONG dfsFdskCleanupAct                         // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    option:zero full entry
);

// Update bootmanager BOOTSECTOR for W2K CHKDSK immunity and CHS value issues
ULONG dfsFdskBmgrFixBootSec
(
   USHORT              disknr,                  // IN    disk with a BM part
   BOOL                confirmed                // IN    skip confirm prompt
);

// Set the bootmanager-name for a primary partition (using ExecOn and callback)
// Note: Empty name "" will clear the name, and place the basePsn info there
// Note: No name, NULL will clear the name, and zero the whole info entry
ULONG dfsFdskSetPriBm
(
   DFSPARTINFO        *p,                       // IN    partition info
   char                *name,                   // IN    BM name, NULL or ""
   BOOL                confirmed                // IN    already confirmed
);

// Set the bootmanager-name for a logical partition
ULONG dfsFdskSetLogBm
(
   DFSPARTINFO        *p,                       // IN    partition info
   char               *name,                    // IN    BM name, NULL or ""
   BOOL                confirmed                // IN    already confirmed
);

// Implement the 'Delete' callback operation on a partition-table entry
ULONG dfsFdskDelete                             // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    option:zero full entry
);

// Implement the 'SetType' callback operation on a partition-table entry
ULONG dfsFdskSetType                            // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    option:zero full entry
);

// Implement the 'SetStatus' callback operation on a partition-table entry
ULONG dfsFdskSetStatus                          // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    callback parameters
);

// Save partition info for specified disk to a file
ULONG dfsSavePartInfo                           // RET   function result
(
   USHORT              disk,                    // IN    disk number
   char               *filebase,                // IN    dest file basename
   char               *comment                  // IN    user comment on save
);

// Fix type of extended partitions for specified disk-nr from 'old' to 'new'
ULONG dfsFixExtType                             // RET   function result
(
   USHORT              disk,                    // IN    disk number
   BYTE                old,                     // IN    old, verify type or 0
   BYTE                new                      // IN    new  system type
);

// Align the extended-container (first logical) for a disk to track boundaries
ULONG dfsAlignDiskContainer                     // RET   function result
(
   USHORT              disk                     // IN    disk number
);

// Align the extended-container (EBR) for specified logical to track boundaries
ULONG dfsAlignPartContainer                     // RET   function result
(
   DFSPARTINFO        *p                        // IN    partition info
);

// Implement a callback to display a PARTINFO structure
ULONG dfsFdskListPinfo                          // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT freespace info
   S_BOOTR            *br,                      // IN    dummy
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbi                      // IN    callback info
);

// Implement PTEDIT callback, interface between R/W and update dialog
ULONG dfsFdskPtEditMbr                          // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   BYTE               *sec,                     // INOUT sectors with Ptables
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    operation info
);

// Implement PTEDIT callback, interface between R/W and update dialog GPT style
ULONG dfsFdskPtEditGpt
(
   FDSK_CB_INFO       *cbp                      // IN    operation info
);

// Implement GPT setname, interface between R/W and actual name update
ULONG dfsFdskGptSetName
(
   FDSK_CB_INFO       *cbp                      // INOUT operation info
);

// Implement the 'Clear' callback operation on partition boot records
ULONG dfsFdskClearBoot                          // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // IN    p-info (unused)
   S_BOOTR            *sec,                     // INOUT partition boot record
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    callback parameters
);

// Implement the 'Clear' callback operation on part-table and/or LVM-sector
ULONG dfsFdskClearSect                          // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   BYTE               *sec,                     // INOUT sectors with BM info
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    callback parameters
);

// Implement the 'FixChs' callback operation on part-table entries
ULONG dfsFdskFixChs                             // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   BYTE               *sec,                     // INOUT a MBR/EBR/LVM/BR sect
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    callback parameters
);

// Check and update I13 limited (dummy) CHS values for PSN, style and geometry
BOOL dfsFixChsI13Changed                        // RET   CHS value was changed
(
   char               *verbose,                 // IN    msg lead text or NULL
   BOOL                update,                  // IN    update fields
   ULONG               psn,                     // IN    absolute sector (LBA)
   USHORT             *chsSecCyl,               // INOUT Sector+cylinder (CHS)
   BYTE               *chsHead                  // INOUT Head value      (CHS)
);

// Restore partition info from specified file to a disk
ULONG dfsRestorePartInfo                        // RET   function result
(
   USHORT              disk,                    // IN    disk number
   char               *filebase,                // IN    source file basename
   char               *types                    // IN    types to restore
);

// Implement the 'Truncate' callback operation on an MBR partition-table entry
ULONG dfsFdskTruncateMbr                        // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp
);

// Implement RESIZE callback, interface between R/W and resize logic GPT style
ULONG dfsFdskResizeGptEntry
(
   FDSK_CB_INFO       *cbp                      // INOUT operation info
);

#endif
