//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// Implement file BROWSING based on contents of the DFSee sector list
// Usually initiated by a 'browse' command or filefind/delfind + browse .
//
// Gets information about the listed file using the FileInformation()
// Creates new (parent/subdir) list contents with a FsMakeBrowseList()
//
// Author: J. van Wijk
//
// JvW  16-09-2016 Initial version, derived from TXLIB txtree/txwstdlg code
//

#ifndef    DFSBROWS_H
   #define DFSBROWS_H

//- Browse dialog flag values
#define DFSBR_RETAIN_LIST       0x0001          // keep last list on exit
#define DFSBR_MOVEABLE          0x0010          // dialog is movable
#define DFSBR_RECOVERY          0x0100          // start in recovery mode

//- Sort order values
#define DFSBR_SORT_PERC         TXS_SORT_3
#define DFSBR_SORT_DATE         TXS_SORT_4
#define DFSBR_SORT_SIZE         TXS_SORT_5
#define DFSBR_SORT_PATH         TXS_SORT_6
#define DFSBR_SORT_FEXT         TXS_SORT_7


// Initialize help system for file/directory BROWSING (accessible from startup)
void dfsBrowseInitHelp
(
   void
);


// BROWSE files/directories in sectorlist, execute actions on selected file(s)
ULONG dfsBrowseSectorList
(
   char               *filter,                  // IN    Initial filter string
   ULONG               flags,                   // IN    Dialog behaviour flags
   USHORT              initialSort              // IN    Initial sort order
);

#endif
