//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// FAT bootsector format/fixboot related functions
//
// Author: J. van Wijk
//
// JvW  29-06-2000 Initial version, split-off from DFSAFDSK
//
#ifndef    DFSBFAT
   #define DFSBFAT


// Implement the 'Fat2Boot' callback operation on a partition-table entry
ULONG dfsFdskFat2Boot                           // RET PENDING  => call again
(                                               //     NO_ERROR => all done
   DFSPARTINFO        *p,                       // INOUT partition info
   S_BOOTR            *br,                      // INOUT sector with Ptable
   FDSK_CB_PHASE       phase,                   // IN    callback phase
   FDSK_CB_INFO       *cbp                      // IN    string: OS name
);


// Insert bootcode for specified OS in the supplied bootsector
BOOL dfsInsertFatBootCode                       // RET   code replaced
(
   char                os,                      // IN    OS: I P M N O 9
   S_BOOTR            *br                       // INOUT boot sector
);

// Get operating system description for specified os
ULONG dfsMakeFatOsString
(
   char                os,                      // IN    OS: I P M N O 9
   char               *string                   // OUT   OS descr (max 15 char)
);

#endif
