//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// DFS display and analysis, XFS specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  15-07-2007 Initial version, derived from EXT
//
// Author: J. van Wijk

#ifndef    DFSAXFS_H
   #define DFSAXFS_H

#include <dfsxfs.h>                             // XFS  structure defs

// XFS specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_XFSSUP  's'                          //     XFS  super-block


typedef struct dfsaxfs                          // XFS analysis information
{
   ULN64               Sect;                    // Number of sectors
   ULN64               Block;                   // Number of blocks
   ULONG               SectorsPerBlock;         // sectors per block
   S_XFS_SUPER        *sup;                     // ptr to superblock
} DFSAXFS;                                      // end of struct "dfsaxfs"

extern DFSAXFS        *xfs;

// Initialize XFS filesystem analysis
ULONG dfsXfsInit
(
   char               *fs                       // forced filesystem type
);

// XFS filesystem, identify specified sector as a valid superblock
BOOL dfsXfsIsSuperBlock                         // RET   sector is a valid sb
(
   BYTE               *sec                      // IN    sector contents
);

// XFS filesystem, display sector constents as a superblock
void dfsXfsDisplaySuperBlock
(
   BYTE               *sec                      // IN    sector contents
);

// XFS filesystem, identify specified sector
ULONG dfsXfsIdent
(
   ULN64               di,                      // IN    LSN for sector
   ULN64               d2,                      // IN    dummy
   char               *dc,                      // OUT   sector type
   void               *data                     // IN    sector contents
);


#endif
