//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// DFS display and analysis, REISER specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  31-03-2004 Initial version, derived from EXT
//
// Author: J. van Wijk

#ifndef    DFSARSR_H
   #define DFSARSR_H

#include <dfsrsr.h>                             // RSR  structure defs

// RSR specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_RSRSUP  's'                          //     RSR  super-block

#define DFSRSR_NOGROUP ((ULONG) 0xffffffff)

typedef struct S_RSR_BMCACHE                    // bitmap cache structure
{
   BOOL                Dirty;                   // cache contents modified
   ULONG               Group;                   // Group nr 0 .. Groups -1
   BYTE               *Cache;                   // bitmap itself
} S_RSR_BMCACHE;                                // end of struct "S_RSR_BMCACHE"


typedef struct dfsarsr                          // RSR analysis information
{
   ULONG               Sect;                    // Number of sectors
   ULONG               Block;                   // Number of blocks
   ULONG               SectorsPerBlock;         // sectors per block
   ULONG               BlocksPerGroup;          // Group size in blocks
   S_RSR_SUPER        *sup;                     // ptr to superblock
   S_RSR_BMCACHE       Bm;                      // Block bitmap cache
} DFSARSR;                                      // end of struct "dfsarsr"

extern DFSARSR        *rsr;

// Initialize RSR filesystem analysis
ULONG dfsRsrInit
(
   char               *fs                       // forced filesystem type
);

// Initialize Reiser filesystem analysis for Area (FS info in FDISK mode)
ULONG dfsRsrAreaInit
(
   void
);

// RSR  filesystem, identify specified sector as a valid superblock
BOOL dfsRsrIsSuperBlock                         // RET   sector is a valid sb
(
   BYTE               *sec                      // IN    sector contents
);

// REISER filesystem, display sector constents as a superblock
void dfsRsrDisplaySuperBlock
(
   BYTE               *sec                      // IN    sector contents
);

// RSR filesystem, identify specified sector
ULONG dfsRsrIdent
(
   ULN64               di,                      // IN    LSN for sector
   ULN64               d2,                      // IN    dummy
   char               *dc,                      // OUT   sector type
   void               *data                     // IN    sector contents
);


#endif
