//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFSee utility services, Arealist
//
// Author: J. van Wijk
//
// JvW  26-08-2005 Initial version
//
#ifndef    DFSALIST
   #define DFSALIST


// Allocate a new Sector-Area list with description, empty
S_AREALIST *dfsNewAreaList                      // RET   new list or NULL
(
   char               *desc                     // IN    new list description
);

// Free area list and attched elements
void dfsFreeAreaList
(
   S_AREALIST        **listAddress              // IN    address of list
);

// Add new area, append to last element for adjacent, else create a new one
S_AREAELEM *dfsAddListArea                      // RET   result element or NULL
(
   S_AREALIST         *list,                    // IN    area list
   ULN64               start,                   // IN    start of new area
   ULN64               size                     // IN    size area in sectors
);

// Display contents of a sector-area list
void dfsDisplayAreaList
(
   S_AREALIST         *list                     // IN    area list
);

#endif
