//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS display and analysis, HPFS specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  12-01-97   Initial version, split off from dfs.c
//
#ifndef    DFSAHPFS_H
   #define DFSAHPFS_H

#include <dfshpfs.h>                            // HPFS structure defs

// HPFS specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_EDATA  ('E' + ST__INFO)              //     EA data
#define ST_ADATA  ('A' + ST__INFO)              //     ACL data
#define ST_BOOTA  ('B' + ST__INFO)              //  I  Boot code (micro-FSD)
#define ST_SUPER   's'                          //     HPFS super-block
#define ST_SPARE   'p'                          //     HPFS spare-block
#define ST_HOTFT  ('U' + ST__INFO)              //  I  Hotfix table sector
#define ST_HOTFD  ('u' + ST__INFO)              //  I  Hotfix data sector
#define ST_SPDIR  ('S' + ST__INFO)              //  I  Spare dirblocks
#define ST_BADSL  ('x' + ST__INFO)              //  I  Bad sector-list
#define ST_FNODE   'f'                          // S   Fnode, file
#define ST_FNDIR   'D'                          // S   Fnode, directory
#define ST_FNDDI   'y'                          // S   Fnode, deleted directory
#define ST_FNDEL   'z'                          // S   Fnode, deleted file
#define ST_ALLOC   'a'                          // S   Allocation sector
#define ST_ALDEL   'Z'                          // S   Alloc sector, deleted
#define ST_DIRBL   'd'                          // S   Directory block
#define ST_DBAND  ('P' + ST__INFO)              //  I  Pre-allocated Dir-Band
#define ST_DBMAP  ('Q' + ST__INFO)              //  I  Dir-Band bitmap sector
#define ST_CPINF   'c'                          // S   Codepage info
#define ST_CPDAT   'C'                          // S   Codepage data table
#define ST_UITAB  ('i' + ST__INFO)              //     UserId table (HPFS-386)
#define ST_BMAPI   'm'                          //     Bitmap indirect sector
#define ST_BMAPD  ('M' + ST__INFO)              //  I  Bitmap data sector

typedef struct dfsahpfs                         // HPFS analysis information
{
   ULONG              root;                     // LSN of RootDir
   ULONG              cpinf;                    // LSN of CodePage info
   ULONG              cpages;                   // nr of codepages
   S_SUPER           *sup;                      // ptr to superblock
   S_SPARE           *spr;                      // ptr to spareblock
   ULONG             *bmt;                      // bitmap indirection table
   BYTE              *bmc;                      // bitmap cache
   USHORT             cpg[S_MAX_CPIB +1];       // codepage values
} DFSAHPFS;                                     // end of struct "dfsahpfs"


extern DFSAHPFS      *hpfs;

// Initialize HPFS filesystem analysis
ULONG dfsHpfsInit
(
   char               *fs                       // forced filesystem type
);

// Initialize HPFS filesystem analysis for Area (FS info in FDISK mode)
ULONG dfsHpfsAreaInit
(
   void
);

// Format HPFS directory entry flag attributes, append to string
void dfstrHpfsAttrib
(
   char               *str,                     // INOUT resulting string
   BYTE                data                     // IN    data
);

// HPFS filesystem, identify specified sector as a valid superblock
BOOL dfsHpfsIsSuperBlock                        // RET   sector is a valid sb
(
   BYTE               *sec                      // IN    sector contents
);

// HPFS filesystem, display sector constents as a superblock
void dfsHpfsDisplaySuperBlock
(
   BYTE               *sec                      // IN    sector contents
);

#endif
