//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS display and analysis, FDISK specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  21-02-99   Initial version, cloned from DFSANTFS
//
#ifndef    DFSAFDSK_H
   #define DFSAFDSK_H

#define  FDSK_SINGLE_SHOW " -Only!"

// FDISK specific sector types
                                                // S   used on searching
                                                //  I  identification only
//- none sofar (most need to be in generic Identify, to work from any mode!)

#define DFSFDSK_BMGRIMG "dfsibmgr.img"          // FDISK auto-install BMGR
#define DFSFDSK_BMGRLVM  0x1c                   // BMGR, 1st LVM version, 2.8
#define DFSFDSK_BMGROLD  0x1c                   // BMGR, size before ver 7.01
#define DFSFDSK_BMGRSEC  0x1e                   // BMGR, relevant nr of sect
                                                // updated for 0x0F aware one

#define DFS_LVM_CRC_MAX_INDEX  255

typedef struct dfsafdsk                         // FDISK analysis information
{
   ULONG              *crcTable;                // ptr to CRC ULONG array
   BOOL                AutoLog;                 // autolog indicator
   BOOL                AutoShow;                // change indicator for show
   BOOL                InAutoShow;              // executing AutoShow
   TXTM                ShowCmd;                 // default cmd after changes
} DFSAFDSK;                                     // end of struct "dfsafdsk"

extern DFSAFDSK       *fdsk;


// Initialize FDISK filesystem analysis
ULONG dfsFdskInit
(
   void
);


// Test for commands that should cause an automatic mode-change to FDISK mode
BOOL dfsFdskIsFdskCmd
(
   char               *cmd,                     // IN    command to test
   BOOL                autoquit                 // IN    autoquit, not switch
);


// Interpret and execute specific FDISK command;
ULONG dfsFdskCommand
(
   ULN64               di,                      // IN    dummy
   ULN64               d2,                      // IN    dummy
   char               *none,                    // IN    dummy
   void               *data                     // INOUT dummy
);


// FDISK filesystem, identify specified sector
ULONG dfsFdskIdent
(
   ULN64               di,                      // IN    LSN for sector
   ULN64               d2,                      // IN    dummy
   char               *dc,                      // OUT   sector type
   void               *data                     // IN    sector contents
);


// Display MAC driver-descriptor-record, in MBR sector, can be combined!
ULONG dfsFdskMacDDM
(
   BYTE               *sector                   // IN    Sector data
);

// Display possible MAC DPM sectors in first track
ULONG dfsFdskMacPartMap                         // RET   result
(
   BOOL                verbose                  // IN    output style
);

// Display MAC disk-partition-map sector, usually at sector 1 .. #partitions
ULONG dfsFdskMacDPM
(
   BYTE               *sector                   // IN    Sector data
);



// Set next autoshow command to use specified disk only
void dfsFdskSingleAutoShow
(
   USHORT              disknr                   // IN    single disk to show
);


#endif
