//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS display and analysis, FAT specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  21-05-97   Initial version, derived from DFSHPFS
//
#ifndef    DFSAFAT_H
   #define DFSAFAT_H

#include <dfsfat.h>                             // FAT  structure defs

// FAT specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_FAT_1  ('1' + ST__INFO)              //  I  1st FAT area
#define ST_FAT_2  ('2' + ST__INFO)              //  I  2nd FAT area
#define ST_FAT12   '3'                          //  I  FAT 12 1st sector
#define ST_FAT16   '4'                          //  I  FAT 16 1st sector
#define ST_FAT32   '8'                          //  I  FAT 32 1st sector
#define ST_ROOTD  ('\\'+ ST__INFO)              //  I  Root directory area
#define ST_SUBDR   'd'                          //     Sub-directory, non-ROOT
#define ST_SUBRT   's'                          //     Sub-directory from ROOT
#define ST_DIREC   'D'                          //     directory area
#define ST_FATEA   'E'                          //     FAT EAdata cluster
#define ST_EADAT   'A'                          //     FAT EAdata header

#define DFSFAT_CACHE   4096

//- Invalid clusternumber, but adding cache-size will NOT make it wrap yet...
#define FAT_NO_CLUST   ((ULONG) (0xffffffff - DFSFAT_CACHE))

typedef struct dfsfatea
{
   ULONG               Chunks;                  // Nr of chunks in EAdata sf
   S_SPACE            *Space;                   // allocation for EAdata
   USHORT              Sectors;                 // Nr of sectors in EA header
   S_EAINDEX          *Index;                   // Index sector of header
   USHORT             *Map;                     // Array  index->cluster map
   USHORT              MapSize;                 // Sizeof index->cluster map
} DFSFATEA;                                     // end of struct "dfsfatea"

typedef struct dfsfatcache                      // FAT cache of fixed size
{
   ULONG               First;                   // First cluster in cache
   ULONG              *Value;                   // Array of FAT values
   ULONG               Stamp;                   // Relative age of last cache R/W
   BOOL                Dirty;                   // Values have changed if true
   char                Id;                      // ID character 'A' or 'B'
} DFSFATCACHE;                                  // end of struct "dfsfatcache"

typedef struct dfsafat                          // FAT analysis information
{
   ULN64               Fat1;                    // LSN of 1st Fat
   ULN64               Fat2;                    // LSN of 2nd Fat
   ULN64               FatResize;               // LSN Temp.  Fat area in resize
   ULN64               ClTwo;                   // LSN of cluster-2
   ULN64               Root;                    // LSN of Root directory
   ULONG               Roots;                   // nr of sectors in Root dir
   USHORT              NrOfFats;                // nr of FATs (usually 2)
   ULONG               FatSectors;              // Nr of sectors per FAT
   ULONG               Sect;                    // Number of sectors
   ULONG               RawClust;                // #clusters, from #sectors
   ULONG               MapClust;                // #clusters, from #fatSectors
   ULONG               TruncCluster;            // First free cluster, trunc-point
   ULONG               FreeClusters;            // Nr of clusters still free
   USHORT              ClustSize;               // valid cluster size
   ULONG               ExpandSize;              // Maximum size for expand, resize
   ULONG               MappedSize;              // Maximum size for current FAT area
   USHORT              FatBits;                 // Size of each FAT entry
   BOOL                Fat32Spare;              // FAT32 spare sect 6&7 used
   BOOL                FatFaked;                // FAT values faked, no bootsec
   ULONG               CachedClAlloc;           // allocation cached cluster
   ULONG               CachedClNumber;          // cached cluster number
   ULN64               FatInUse;                // LSN of active cached Fat
   DFSFATCACHE         CacheA;                  // 1st of two cached FAT areas
   DFSFATCACHE         CacheB;                  // 2nd of two cached FAT areas
   DFSFATEA            EaData;                  // EA data admin and cache
} DFSAFAT;                                      // end of struct "dfsafat"

extern DFSAFAT        *fat;

extern char            sg_fat12[];
extern char            sg_fat16[];
extern char            sg_fat32[];

// Initialize FAT filesystem analysis
ULONG dfsFatInit
(
   char               *fs                       // forced filesystem type
);

// Initialize FAT filesystem analysis for Area (FS info in FDISK mode)
ULONG dfsFatAreaInit
(
   void
);

// (Re)Initialize EA data information and caching information
ULONG dfsFatEaInit
(
   DFSFATEA           *EaData                   // INOUT EA data info structure
);

// Terminate EA data information and caching information
void dfsFatEaTerminate
(
   DFSFATEA           *EaData                   // INOUT EA data info structure
);

// Display FAT directory-block
ULONG dfsFatDirectory                           // RET   nr of entries
(
   ULONG               chunks,                  // IN    nr of space entries
   S_SPACE            *space                    // IN    space allocation
);

#endif
