//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS display and analysis, EXFAT specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  19-06-2014   Initial version, derived from DFSAFAT
//
#ifndef    DFSAEXFT_H
   #define DFSAEXFT_H

#include <dfsexft.h>                            // EXFAT  structure defs

// EXFAT specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_FAT_1  ('1' + ST__INFO)              //  I  1st FAT area
#define ST_FAT_2  ('2' + ST__INFO)              //  I  2nd FAT area
#define ST_EXFAT   '8'                          //  I  FAT 32 1st sector
#define ST_ROOTD  ('\\'+ ST__INFO)              //  I  Root directory area
#define ST_DIREC   'D'                          //     directory area

#define DFSEXFT_CACHE   4096

//- Invalid clusternumber, but adding cache-size will NOT make it wrap yet...
#define EXFT_NO_CLUST   ((ULONG) (0xffffffff - DFSEXFT_CACHE))

typedef struct dfsexftcache                     // FAT cache of fixed size
{
   ULONG               First;                   // First cluster in cache
   ULONG              *Value;                   // Array of FAT values
   ULONG               Stamp;                   // Relative age of last cache R/W
   BOOL                Dirty;                   // Values have changed if true
   char                Id;                      // ID character 'A' or 'B'
} DFSEXFTCACHE;                                 // end of struct "dfsexftcache"


typedef struct dfsexftbmcache                   // Cluster bitmap cache
{
   ULONG               Extents;                 // nr of space entries for file
   S_SPACE            *Space;                   // space allocation for file
   ULONG               LimitLsn;                // largest LSN inside bitmap
   ULONG               First;                   // first cached rsn
   ULONG               Size;                    // cache size in sectors
   BOOL                Dirty;                   // cache contents modified
   BYTE               *Buffer;
} DFSEXFTBMCACHE;                               // end of struct "dfsntfsbmcache"


#define DFSEXFT_DP_CACHE_SIZE
typedef struct dfsexftdpcache                   // Directory-Parent cache
{
   ULONG               Cluster;                 // A cluster, part of PARENT dir
   ULONG               ParentLsn;               // Sector containing entry to PARENT
   BYTE                ParentIdx;               // Entry index for PARENT in sector
                                                // with SNINFO, or 0 for the ROOT
} DFSEXFTDPCACHE;                               // end of struct "dfsexftdpcache"


typedef struct dfsaexft                         // EXFAT analysis information
{
   LSN                 Fat1;                    // LSN of 1st Fat
   LSN                 Fat2;                    // LSN of 2nd Fat
   LSN                 ClHeap;                  // LSN of cluster-heap (data)
   LSN                 Root;                    // LSN of Root directory
   ULONG               Roots;                   // Nr  of sectors in Root dir
   USHORT              NrOfFats;                // Nr  of FATs (usually 2)
   ULONG               FatOffset;               // Offset to first FAT
   ULONG               FatSectors;              // Nr  of sectors per FAT
   LLONG               Sect;                    // Number of sectors
   ULONG               RawClust;                // #clusters, from #sectors
   ULONG               MapClust;                // #clusters, from #fatSectors
   ULONG               TruncCluster;            // First free cluster, trunc-point
   ULONG               FreeClusters;            // Nr of clusters still free
   ULONG               ClustSize;               // valid cluster size
   ULONG               MappedSize;              // Maximum size for current FAT area
   BOOL                ExftFaked;               // EXFT values faked, no bootsec
   ULONG               CachedClAlloc;           // allocation cached cluster
   ULONG               CachedClNumber;          // cached cluster number
   LSN                 FatInUse;                // LSN of active cached Fat
   DFSEXFTCACHE        CacheA;                  // 1st of two cached FAT areas
   DFSEXFTCACHE        CacheB;                  // 2nd of two cached FAT areas
   DFSEXFTBMCACHE      Bm;                      // BitMap file cache
   ULONG               BmCluster;               // Cluster for active bitmap
   ULONG               BmByteSize;              // Size in bytes for bitmap
   ULONG               dpCacheAlloc;            // Total entries in DP cache
   ULONG               dpCacheSize;             // Used  entries in DP cache
   DFSEXFTDPCACHE     *Dp;                      // Directory Parent cache
} DFSAEXFT;                                     // end of struct "dfsaexft"

extern DFSAEXFT        *exft;

extern char            sg_exfat[];

// Initialize FAT filesystem analysis
ULONG dfsExftInit
(
   char               *fs                       // forced filesystem type
);

// Initialize FAT filesystem analysis for Area (FS info in FDISK mode)
ULONG dfsExftAreaInit
(
   void
);

// Display EXFAT directory-block
ULONG dfsExftDirectory                          // RET   nr of entries
(
   ULONG               chunks,                  // IN    nr of space entries
   S_SPACE            *space                    // IN    space allocation
);

#endif
