//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
// DFS display and analysis, EFAT specific functions and definitions
//
// Author: J. van Wijk
//
// JvW  19-06-2014   Initial version, derived from DFSAFAT
//
#ifndef    DFSAEFAT_H
   #define DFSAEFAT_H

#include <dfsefat.h>                            // EFAT  structure defs

// EFAT specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_FAT_1  ('1' + ST__INFO)              //  I  1st FAT area
#define ST_FAT_2  ('2' + ST__INFO)              //  I  2nd FAT area
#define ST_EFAT    '8'                          //  I  FAT 32 1st sector
#define ST_ROOTD  ('\\'+ ST__INFO)              //  I  Root directory area
#define ST_DIREC   'D'                          //     directory area

#define DFSEFAT_CACHE   4096

//- Invalid clusternumber, but adding cache-size will NOT make it wrap yet...
#define EFAT_NO_CLUST   ((ULONG) (0xffffffff - DFSEFAT_CACHE))

typedef struct dfsefatcache                     // FAT cache of fixed size
{
   ULONG               First;                   // First cluster in cache
   ULONG              *Value;                   // Array of FAT values
   ULONG               Stamp;                   // Relative age of last cache R/W
   BOOL                Dirty;                   // Values have changed if true
   char                Id;                      // ID character 'A' or 'B'
} DFSEFATCACHE;                                 // end of struct "dfsefatcache"


typedef struct dfsefatbmcache                   // Cluster bitmap cache
{
   ULONG               Extents;                 // nr of space entries for file
   S_SPACE            *Space;                   // space allocation for file
   ULONG               LimitLsn;                // largest LSN inside bitmap
   ULONG               First;                   // first cached rsn
   ULONG               Size;                    // cache size in sectors
   BOOL                Dirty;                   // cache contents modified
   BYTE               *Buffer;
} DFSEFATBMCACHE;                               // end of struct "dfsntfsbmcache"


#define DFSEFAT_DP_CACHE_SIZE
typedef struct dfsefatdpcache                   // Directory-Parent cache
{
   ULONG               Cluster;                 // A cluster, part of PARENT dir
   ULONG               ParentLsn;               // Sector containing entry to PARENT
   BYTE                ParentIdx;               // Entry index for PARENT in sector
                                                // with SNINFO, or 0 for the ROOT
} DFSEFATDPCACHE;                               // end of struct "dfsefatdpcache"


typedef struct dfsaefat                         // EFAT analysis information
{
   ULN64               Fat1;                    // LSN of 1st Fat
   ULN64               Fat2;                    // LSN of 2nd Fat
   ULN64               ClHeap;                  // LSN of cluster-heap (data)
   ULN64               Root;                    // LSN of Root directory
   ULONG               Roots;                   // Nr  of sectors in Root dir
   USHORT              NrOfFats;                // Nr  of FATs (usually 2)
   ULONG               FatOffset;               // Offset to first FAT
   ULONG               FatSectors;              // Nr  of sectors per FAT
   ULN64               Sect;                    // Number of sectors
   ULONG               RawClust;                // #clusters, from #sectors
   ULONG               MapClust;                // #clusters, from #fatSectors
   ULONG               TruncCluster;            // First free cluster, trunc-point
   ULONG               FreeClusters;            // Nr of clusters still free
   ULONG               ClustSize;               // valid cluster size
   ULN64               MappedSize;              // Maximum size for current FAT area
   BOOL                EfatFaked;               // EFAT values faked, no bootsec
   ULN64               FatInUse;                // LSN of active cached Fat
   DFSEFATCACHE        CacheA;                  // 1st of two cached FAT areas
   DFSEFATCACHE        CacheB;                  // 2nd of two cached FAT areas
   DFSEFATBMCACHE      Bm;                      // BitMap file cache
   ULONG               BmCluster;               // Cluster for active bitmap
   ULN64               BmByteSize;              // Size in bytes for bitmap
   ULONG               dpCacheAlloc;            // Total entries in DP cache
   ULONG               dpCacheSize;             // Used  entries in DP cache
   DFSEFATDPCACHE     *Dp;                      // Directory Parent cache
   S_EFATDIR           CachedDirEntry;          // single DIR entry cache
} DFSAEFAT;                                     // end of struct "dfsaefat"

extern DFSAEFAT        *efat;

extern char            sg_efat[];

// Initialize FAT filesystem analysis
ULONG dfsEfatInit
(
   char               *fs                       // forced filesystem type
);

// Initialize FAT filesystem analysis for Area (FS info in FDISK mode)
ULONG dfsEfatAreaInit
(
   void
);

// Display EFAT directory-block
ULONG dfsEfatDirectory                          // RET   nr of entries
(
   ULONG               chunks,                  // IN    nr of space entries
   S_SPACE            *space                    // IN    space allocation
);

#endif
