//
//                     DFSee, Disk and Filesystem utility
//
//   Original code Copyright (c) 1994-2025 Fsys Software and Jan van Wijk
//
// ==========================================================================
//
//   DFSee, released under MIT License
//
//   Copyright (c) 1994-2025  Fsys Software and Jan Van Wijk
//
//   Permission is hereby granted, free of charge, to any person obtaining a copy
//   of this software and associated documentation files (the "Software"), to deal
//   in the Software without restriction, including without limitation the rights
//   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//   copies of the Software, and to permit persons to whom the Software is
//   furnished to do so, subject to the following conditions:
//
//   The above copyright notice and this permission notice shall be included in all
//   copies or substantial portions of the Software.
//
//   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//   SOFTWARE.
//
//
//   Questions on DFSee licensing can be directed to: jvw@dfsee.com
//
// ==========================================================================
//
//
// OS/2 DUMPFS dump & display Analysis functions
//
// Author: J. van Wijk
//
// JvW  03-06-2014 Initial version, derived from SWAP

#ifndef    DFSADUMP_H
   #define DFSADUMP_H

// DUMP specific sector types
                                                // S   used on searching
                                                //  I  identification only
#define ST_DUMPFS  's'                          //     DUMP super-block (boot)


typedef struct dfsadumpfs                       // DUMPFS analysis information
{
   DUMPFSINFO         *header;                  // DUMPFS header sector(s)
   ULONG               filesectors;             // sectors in filesize
} DFSADUMPFS;                                   // end of struct "dfsadumpfs"

// Check if passed sector is a valid DUMPFS info sector, optional label return
BOOL dfsBootsecIsDumpFS                         // RET   bootsector is DUMPFS
(
   BYTE               *brec,                    // IN    bootsector contents
   char               *label                    // OUT   buffer for label, or NULL
);

// Initialize DUMP filesystem analysis
ULONG dfsDumpInit
(
   char               *fs                       // forced filesystem type
);

// Initialize DUMP filesystem analysis for Area (FS info in FDISK mode)
ULONG dfsDumpAreaInit
(
   void
);

#endif
