@echo off
rem
rem Deliver PART-1:
rem Create OEM-deliverable ZIP when requested, or
rem Create DFSee standard distribution in @ARCHIVE
rem Create DFSee standard ZIP file
rem
REM updated for 16.8 Added DISTORM disassembler sources AND binaries to source-ZIP deliverable
REM updated for 16.7 Fixed zipping up the TXLIB sourcefiles to the DFSRC archive!
REM updated for 16.2 Added copy of the DOS icon(s) for consistency with other platforms
REM updated for 16.2 Make compatible with 4OS2 (define proper BATCHDEL command)
REM updated for 16.2 Improved logging using 'echo on' and REM instead of echo
REM updated for 16.2 Removed remaining TRACE stuff; WTOUCH deliverables BEFORE ZIP, not AFTER
REM updated for 15.1 Deliver UPX 3.94 compressed executables for Linux/macOS-64bit too
REM updated for 15.1 Add DFSee.app.zip to install ZIP; Deliver 64 and 32 bit executable
REM updated for 15.0 Remove dfsee_update.zip duplicate, and no more TGZ archives
REM updated for 14.11 Include the WINdows, MACos and LINux version of the OEM engine
REM updated for 14.11 Do not set an explicit 'release timestamp' on the archives
REM updated for 14.9 Create additional dfsee_update.info, with rename instructions
REM updated for 14.8 Added dfsee_install.zip as unified naming deliverable
REM updated for 14.7 Added 4th param 'R' for release mode, no confirmation at start
REM updated for 14.7 Generate dfsee_update.info file with single line of version info
REM updated for 14.6 New dfsee_update.zip to update a DFSee install, slacko and others
REM updated for 14.3 Added DFSISOARCH and DFSREGSUPS for H: and J: (network) locations
REM updated for 14.3 Changed DFSBUILDENV to indicate ROOT of DFSee-server (macmerlin)
REM updated for 13.4 Move dfs*.bat to script/windos and dfs*.cmd to script/os2
REM updated for 13.4 Updated to support Windows DFSRUNAS.EXE (auto 'run as admin')
REM updated for 12.5 Updated to support multiple OEM versions, OEMSV/OEMAN
REM updated for 12.2 Updated to respect the DFSBUILDENV=MACVBOX for macBook+Vbox
REM updated for 11.8 Could be 12.0 instead: Moved all sample scripts to 'samples'
REM updated for 11.7 Renamed OS2 directory to BIN, added dfswpobj/setlnea/sendmsg
REM updated for 10.7 Create source archive using ZIP instead of PKZIP (which failed)
REM updated for 10.6 Changed TAR options, since the .tgz was not compressed anymore
REM updated for 10.0 Changing major/minor designation to mm.x instead of m.xx
REM updated for 8.07 Added the DFSWPOBJ.CMD REXX script and .BMP file for OS2
REM updated for 8.00 No seperate 'no-usb' anymore. Deliver WITH drivers
REM updated for 7.11 and SETBOOT 1.00, deliver setboot stuff as oemxyysb.zip
REM updated for 7.03 WARPIN, HOBBES, @DFSee\docs and diskettes to DELIVER2
REM updated for 7.00 With seperate ZIP for the _oemsv_ executables
REM updated for 6.17 DFSee deliverables in _dfsee_ subdir (and in _oemsv_)
REM updated for 6.16 add seperate small ZIP's per platform for dial-up
REM updated for 6.15 adding new DFSee related presentations in .PDF to DOC
REM updated for 6.14 adding some LINUX scripts and cleanup DFSDISK/DFSCHECK
REM updated for 6.12 adding first LINUX version (executable + DFS scripts)
REM updated for 6.06 adding KEYB and ZIP to the DOS version
REM updated for 6.04 use ZIP, with subdirectories and non-lib tracing
REM updated for 6.xx and newer delivery, WATCOM versions only
REM uses watcom wtouch when available or f.exe otherwise to set timestamps
REM added a -X switch to ZIP commands to exclude al EA's from the archive


if "%2"=="" goto usage

SETLOCAL
SET PROMPT=RC:$r [Deliver1] $p -$g
echo on

if "%DFSISOARCH%"=="" set DFSISOARCH=H:
if "%DFSREGSUPS%"=="" set DFSREGSUPS=J:
if "%DFSLTRARCH%"=="" set DFSLTRARCH=H:

set mmv=%1%2
set mnr=x
set verfile=vers_??.*

REM Deliver phase 1 for %mmv% using %DFSISOARCH% and %DFSREGSUPS% on %DFSLTRARCH% buildenv: %DFSBUILDENV%

rem define proper batch-delete command for CMD.EXE versus 4OS2
if "%CMDLINE%"=="" goto cmdexe
set batchdel=del /Y
goto cmd4os2set
:cmdexe
set batchdel=del /N
:cmd4os2set

if "%4"=="" goto standard
set TZ=
REM Deliver OEM %4 executables for version %1.%2, %3 %4 in %DFSISOARCH%\@archive\%3%mmv%%4.zip
if "%4"=="sb" goto setboot
if "%4"=="SB" goto setboot
if "%4"=="an" goto oeman
if "%4"=="AN" goto oeman

:oemec
%BATCHDEL% _oemsv_\deliver\*
cd _oemsv_\deliver
copy ..\dfsos2r.exe             dfsvos2.exe
copy ..\dfsee-%4*.pdf           .
copy ..\oem-what*.txt           .
goto oemzip

:oeman
REM oem-whatsnew / PDF DOC updated, WIN UPX compressed, and MAC executables done ?
pause
if "%DFSBUILDENV%"=="" goto noservoemcopy
set rtd=r
REM copy (UPX compressed Win + macOS) executables from the server location
copy %DFSBUILDENV%\c\dfs\_oeman_\dfswin%rtd%.exe _oeman_\
copy %DFSBUILDENV%\c\dfs\_oeman_\dfsm64%rtd%     _oeman_\
:noservoemcopy

%BATCHDEL% _oeman_\deliver\*
cd _oeman_\deliver
copy ..\dfsos2r.exe             dfsanos2.exe
copy ..\dfswinr.exe             dfsanwin.exe
copy ..\dfslinr.exe             dfsanlinux
copy ..\dfsm64r                 dfsanmacos
copy ..\..\script\dfs*.dfs      .
del dfsgetup.dfs
del dfsgetpy.dfs
del dfspuppy.dfs
del dfsinstl.dfs
copy ..\..\imgz\*.i*            .
copy ..\dfsee-%4*.pdf           .
copy ..\oem-what*.txt           .
goto oemzip

:setboot
REM deliver the SETBOOT sources to specific SRC*.ZIP file
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\setboot.txt \c\openwatc.cmd \c\buildsub.cmd
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\bb.cmd \c\dfs\build.cmd \c\dfs\makesetb.mif
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\_oemsb_\os2r\makefile \c\dfs\_oemsb_\dosr\makefile
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\_oemsb_\winr\makefile \c\dfs\_oemsb_\linr\makefile
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\_oemsb_\os2d\makefile \c\dfs\_oemsb_\dosd\makefile
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\_oemsb_\wind\makefile \c\dfs\_oemsb_\lind\makefile
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\setb.c \c\dfs\dfsetbt.c \c\dfs\dfsetbt.h
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\dfs.h  \c\dfs\dfsdisk.h \c\dfs\dfspart.h
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\dfsmedia.h \c\dfs\dfsector.h \c\dfs\dfsutil.h
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\dfsupart.h \c\dfs\dfsafdsk.h \c\dfs\dfsufdsk.h
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\dfspart.c \c\dfs\dfsupart.c \c\dfs\dfsector.c
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\dfs\dfsmedia.c \c\dfs\dfsutil.c \c\dfs\dfsudisp.c \c\dfs\dfsufdsk.c
zip %DFSISOARCH%\@archive\src%mmv%%4.zip \c\txlib\include\*.h \c\txlib\_txoem_\lib\*

%BATCHDEL% _oemsb_\deliver\*
cd _oemsb_\deliver
copy ..\setbos2r.exe            setbos2.exe
copy ..\setbwinr.exe            setbwin.exe
copy ..\setbdosr.exe            setbdos.exe
copy ..\setblinr.exe            setblin
copy ..\setb*.pdf               .

:oemzip
zip -X %DFSISOARCH%\@archive\%3%mmv%%4.zip *
goto end

:standard
if "%3"=="debug" goto usedebug
if "%3"=="DEBUG" goto usedebug
if "%3"=="d"     goto usedebug
if "%3"=="D"     goto usedebug
if "%3"=="R"     goto release
if "%3"=="r"     goto release


if "%3"=="" goto nodate
set optdate=-d %3
goto dateok
:nodate
set optdate=
:dateok

set rtd=r
REM deliver the RETAIL versions (trace, but not in TXLIB)
goto rtdok
:usedebug
set rtd=d
REM deliver the DEBUG  versions (debug info for wd)

:rtdok
REM to %DFSISOARCH%\@archive\

REM file_id.diz/dfshist.txt updated, WIN UPX compressed, and MAC executables done ?
pause


:release
set rtd=r
REM RELEASE! Deliver the RETAIL versions (trace, but not in TXLIB)
REM to %DFSISOARCH%\@archive\   while the current dir is now:
cd


if "%DFSBUILDENV%"=="" goto noservercopy
REM copy (UPX compressed Dos/Win/Linux/macOS) executables from the server location
copy %DFSBUILDENV%\c\dfs\_dfsee_\dfswin%rtd%.exe _dfsee_\
copy %DFSBUILDENV%\c\dfs\_dfsee_\dfsdos%rtd%.exe _dfsee_\
copy %DFSBUILDENV%\c\dfs\_dfsee_\dfslin%rtd%.exe _dfsee_\
copy %DFSBUILDENV%\c\dfs\_dfsee_\dfsm64%rtd%     _dfsee_\
:noservercopy

set TZ=
cd deliver
%BATCHDEL% %verfile%
echo DFSee version %1.%2 > vers_%1.%2

REM Start copy for DOS
%BATCHDEL% dos\*
copy %verfile%                        dos\
REM copy ..\_dfsee_\dfsdos%rtd%.exe  dos\dfsdos.exe
copy ..\_dfsee_\dfsdos%rtd%.exe       dos\dfsdos.exe
copy ..\_oemsb_\setbdos%rtd%.exe      dos\setboot.exe
copy ..\dfsboot9.exe                  dos\
copy ..\script\*.dfs                  dos\
copy ..\ico\dos\*                     dos\
copy ..\imgz\*.im?                    dos\
copy ..\script\windos\dfs*.bat        dos\
del                                   dos\dfsee.bat
copy ..\diskette\base\keyb.exe        dos\
copy ..\diskette\base\key\*.kl        dos\key\

REM Start copy for OS2
%BATCHDEL% bin\*
copy %verfile%                        bin\
REM copy ..\_dfsee_\dfsos2%rtd%.exe  bin\dfsos2.exe
copy ..\_dfsee_\dfsos2%rtd%.exe       bin\dfsos2.exe
copy ..\_oemsb_\setbos2%rtd%.exe      bin\setboot.exe
copy ..\script\*.dfs                  bin\
copy ..\script\rexx\dfswpobj.cmd      bin\
copy ..\script\rexx\setlnea.cmd       bin\
copy ..\script\rexx\sendmsg.exe       bin\
copy ..\ico\os2\*.*                   bin\
copy ..\ico\*.bmp                     bin\
copy ..\imgz\*.im?                    bin\
copy ..\script\os2\dfs*.cmd           bin\
copy ..\dfs*.inp                      bin\

REM Start copy for WIN
%BATCHDEL% win\*
copy %verfile%                        win\
REM copy ..\_dfsee_\dfswin%rtd%.exe  win\dfswin.exe
copy ..\_dfsee_\dfswin%rtd%.exe       win\dfswin.exe
copy ..\_oemsb_\setbwin%rtd%.exe      win\setboot.exe
copy ..\script\*.dfs                  win\
copy ..\ico\win\*.*                   win\
copy ..\imgz\*.im?                    win\
copy ..\script\windos\dfs*.bat        win\
copy ..\tools\win\*                   win\


REM Start copy for LINUX
%BATCHDEL% linux\*
copy %verfile%                        linux\
REM copy ..\_dfsee_\dfslin%rtd%.exe  linux\dfsee
copy ..\_dfsee_\dfslin%rtd%.exe       linux\dfsee
copy ..\_oemsb_\setblin%rtd%.exe      linux\setboot
copy ..\script\*.dfs                  linux\
copy ..\script\linux\*                linux\
copy ..\ico\lin\*.png                 linux\
copy ..\imgz\*.im?                    linux\

REM Start copy for MAC
%BATCHDEL% mac\*
copy %verfile%                        mac\
REM copy ..\_dfsee_\dfsm64%rtd%      mac\
copy ..\_dfsee_\dfsm64%rtd%           mac\
copy ..\script\*.dfs                  mac\
copy ..\script\mac\*                  mac\
copy ..\ico\mac\*                     mac\
copy ..\imgz\*.im?                    mac\
REM Copy DFSee.app native ZIP
copy ..\macapp\*                      mac\

REM Start copy for DOC
%BATCHDEL% doc\*
copy ..\dfs*.txt                      doc\
copy ..\dfseehow.pdf                  doc\
copy ..\present\dfseenew.pdf          doc\
copy ..\present\dfseecon.pdf          doc\
copy ..\present\pcpartit.pdf          doc\
copy ..\present\fsystems.pdf          doc\
copy ..\present\txscript.pdf          doc\

REM Start copy/move for SAMPLES
%BATCHDEL% samples\*
copy ..\script\samples\*              samples\

REM Start copy for TXT
%BATCHDEL% .\*
copy ..\readme.txt
copy ..\liesmich.txt
copy ..\leesmij.txt
copy ..\file_id.diz
copy ..\dfshist.txt


if "%rtd%"=="d" goto notouch
REM WTOUCH all files in the archive\%mmv% directory with version specific timestamps
wtouch %optdate% -t %1:%2:00 *
wtouch %optdate% -t %1:%2:10 doc\*.txt
wtouch %optdate% -t %1:%2:30 doc\*.pdf
wtouch %optdate% -t %1:%2:00 samples\*
wtouch %optdate% -t %1:%2:00 dos\*.*
wtouch %optdate% -t %1:%2:20 dos\*.bat
wtouch %optdate% -t %1:%2:30 dos\*.dfs
wtouch %optdate% -t %1:%2:35 dos\dfsc*.*
wtouch %optdate% -t %1:%2:40 dos\dfsdisk.*
wtouch %optdate% -t %1:%2:50 dos\dfsdos.exe
wtouch %optdate% -t %1:%2:00 bin\*
wtouch %optdate% -t %1:%2:20 bin\*.cmd
wtouch %optdate% -t %1:%2:30 bin\*.dfs
wtouch %optdate% -t %1:%2:35 bin\dfsc*.*
wtouch %optdate% -t %1:%2:40 bin\dfsdisk.*
wtouch %optdate% -t %1:%2:50 bin\dfsos2.exe
wtouch %optdate% -t %1:%2:00 win\*
wtouch %optdate% -t %1:%2:20 win\*.bat
wtouch %optdate% -t %1:%2:30 win\*.dfs
wtouch %optdate% -t %1:%2:35 win\dfsc*.*
wtouch %optdate% -t %1:%2:40 win\dfsdisk.*
wtouch %optdate% -t %1:%2:50 win\dfswin.exe
wtouch %optdate% -t %1:%2:00 linux\*
wtouch %optdate% -t %1:%2:20 linux\dfstart
wtouch %optdate% -t %1:%2:20 linux\dfsdisk
wtouch %optdate% -t %1:%2:20 linux\dfscheck
wtouch %optdate% -t %1:%2:20 linux\dfsquick
wtouch %optdate% -t %1:%2:20 linux\dfsquery
wtouch %optdate% -t %1:%2:30 linux\*.dfs
wtouch %optdate% -t %1:%2:50 linux\dfsee
wtouch %optdate% -t %1:%2:50 linux\setboot
wtouch %optdate% -t %1:%2:55 linux\setup
wtouch %optdate% -t %1:%2:00 mac\*
wtouch %optdate% -t %1:%2:20 mac\dfstart
wtouch %optdate% -t %1:%2:20 mac\dfsdisk
wtouch %optdate% -t %1:%2:20 mac\dfscheck
wtouch %optdate% -t %1:%2:20 mac\dfsquick
wtouch %optdate% -t %1:%2:20 mac\dfsquery
wtouch %optdate% -t %1:%2:30 mac\*.dfs
wtouch %optdate% -t %1:%2:50 mac\dfsm64r
wtouch %optdate% -t %1:%2:55 mac\setup
:notouch

REM Start ZIP for main deliverable, discard EAs
zip -r -X %DFSISOARCH%\@archive\dfsee%mmv%.zip *
cd ..

cd ..
REM Start ZIP for DFSee/TxLib/DiStorm sources
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip dfs\*.c dfs\*.h dfs\*.hlp dfs\make* dfs\*.def dfs\build.cmd dfs\deliver*.cmd
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip txlib\*.c txlib\*.h txlib\make* txlib\build.cmd txlib\include\*.h
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip dfs\_dfsee_\dosr\makefile dfs\_dfsee_\dosd\makefile
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip dfs\_dfsee_\os2r\makefile dfs\_dfsee_\os2d\makefile
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip dfs\_dfsee_\winr\makefile dfs\_dfsee_\wind\makefile
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip dfs\_dfsee_\linr\makefile dfs\_dfsee_\lind\makefile
zip %DFSISOARCH%\@archive\dfsrc%mmv%.zip dfs\_dfsee_\m64r\makefile dfs\_dfsee_\m64d\makefile
zip -r %DFSISOARCH%\@archive\dfsrc%mmv%.zip distorm\*


%DFSLTRARCH%
REM Start UNZIP main deliverable into the archive\%mmv% directory
cd  %DFSISOARCH%\@archive
rd! %mmv%
md  %mmv%
cd  %mmv%
unzip -o ..\dfsee%mmv%

rem Set current time as ZIP date/time (defaults to most recent enclosed file, equals version)
REM WTOUCH resulting main deliverable
wtouch ..\dfsee%mmv%.zip

REM Duplicate ZIP to dfsee_install and create version info file (use _dfsee_ exe, for its valid key)
copy ..\dfsee%mmv%.zip ..\dfsee_install.zip
h:\c\dfs\_dfsee_\dfsos2r.exe -Q -q -g ver -update -lines > ..\dfsee_install.info


:end
ENDLOCAL
echo.
goto done


:usage
echo.
if "%watcom%"=="" goto classic
echo Usage: %0 major minor [mm-dd-yyyy ^| R ^| debug] ^| [oem  EC^|AN^|SV^|SB]
goto end
:classic
echo Usage: %0 major minor [R ^| debug]


:done
